/*
 * Decompiled with CFR 0.152.
 */
package jsonij.io;

import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class LittleEndianInputStream
extends InputStream
implements DataInput {
    private final DataInputStream dataInputStream;
    private final InputStream inputStream;
    private final byte[] byteBuffer;

    public LittleEndianInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
        this.dataInputStream = new DataInputStream(this.inputStream);
        this.byteBuffer = new byte[8];
    }

    @Override
    public int available() throws IOException {
        return this.dataInputStream.available();
    }

    @Override
    public final int read(byte[] refBuffer, int offset, int readLen) throws IOException {
        return this.inputStream.read(refBuffer, offset, readLen);
    }

    @Override
    public int read() throws IOException {
        return this.inputStream.read();
    }

    @Override
    public final int readUnsignedByte() throws IOException {
        return this.dataInputStream.readUnsignedByte();
    }

    @Override
    @Deprecated
    public final String readLine() throws IOException {
        return this.dataInputStream.readLine();
    }

    @Override
    public final String readUTF() throws IOException {
        return this.dataInputStream.readUTF();
    }

    @Override
    public final void close() throws IOException {
        this.dataInputStream.close();
    }

    @Override
    public final void readFully(byte[] refBuffer) throws IOException {
        this.dataInputStream.readFully(refBuffer, 0, refBuffer.length);
    }

    @Override
    public final void readFully(byte[] refBuffer, int offset, int readLen) throws IOException {
        this.dataInputStream.readFully(refBuffer, offset, readLen);
    }

    @Override
    public final int skipBytes(int n) throws IOException {
        return this.dataInputStream.skipBytes(n);
    }

    @Override
    public final boolean readBoolean() throws IOException {
        return this.dataInputStream.readBoolean();
    }

    @Override
    public final byte readByte() throws IOException {
        return this.dataInputStream.readByte();
    }

    @Override
    public final float readFloat() throws IOException {
        return Float.intBitsToFloat(this.readInt());
    }

    @Override
    public final double readDouble() throws IOException {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public final short readShort() throws IOException {
        return this.dataInputStream.readShort();
    }

    @Override
    public final int readUnsignedShort() throws IOException {
        return this.dataInputStream.readUnsignedShort();
    }

    @Override
    public final long readLong() throws IOException {
        return this.dataInputStream.readLong();
    }

    @Override
    public final char readChar() throws IOException {
        return this.dataInputStream.readChar();
    }

    @Override
    public final int readInt() throws IOException {
        return this.dataInputStream.readInt();
    }

    public final float readLittleFloat() throws IOException {
        return Float.intBitsToFloat(this.readLittleInt());
    }

    public final double readLittleDouble() throws IOException {
        return Double.longBitsToDouble(this.readLittleLong());
    }

    public final short readLittleShort() throws IOException {
        this.dataInputStream.readFully(this.byteBuffer, 0, 2);
        return (short)((this.byteBuffer[1] & 0xFF) << 8 | this.byteBuffer[0] & 0xFF);
    }

    public final char readLittleChar() throws IOException {
        this.dataInputStream.readFully(this.byteBuffer, 0, 2);
        return (char)((this.byteBuffer[1] & 0xFF) << 8 | this.byteBuffer[0] & 0xFF);
    }

    public final int readLittleInt() throws IOException {
        this.dataInputStream.readFully(this.byteBuffer, 0, 4);
        return this.byteBuffer[3] << 24 | (this.byteBuffer[2] & 0xFF) << 16 | (this.byteBuffer[1] & 0xFF) << 8 | this.byteBuffer[0] & 0xFF;
    }

    public final long readLittleLong() throws IOException {
        this.dataInputStream.readFully(this.byteBuffer, 0, 8);
        return (long)this.byteBuffer[7] << 56 | (long)(this.byteBuffer[6] & 0xFF) << 48 | (long)(this.byteBuffer[5] & 0xFF) << 40 | (long)(this.byteBuffer[4] & 0xFF) << 32 | (long)(this.byteBuffer[3] & 0xFF) << 24 | (long)(this.byteBuffer[2] & 0xFF) << 16 | (long)(this.byteBuffer[1] & 0xFF) << 8 | (long)(this.byteBuffer[0] & 0xFF);
    }

    public final int readLittleUnsignedShort() throws IOException {
        this.dataInputStream.readFully(this.byteBuffer, 0, 2);
        return (this.byteBuffer[1] & 0xFF) << 8 | this.byteBuffer[0] & 0xFF;
    }
}

