/*
 * Decompiled with CFR 0.152.
 */
package jsonij;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import jsonij.DoubleInternalNumber;
import jsonij.InternalNumber;
import jsonij.LongInternalNumber;
import jsonij.NumberInternalNumber;
import jsonij.Value;
import jsonij.ValueType;

public class NumericImp
extends Value
implements Serializable {
    private static final long serialVersionUID = 7016727603513295556L;
    public final int LONG = 1;
    public final int FLOAT = 2;
    public final int DOUBLE = 3;
    public final int STRING = 4;
    public final int NUMERIC = 5;
    private final int type;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private InternalNumber internalNumberData;
    private String value;

    public NumericImp(int value) {
        this.longValue = value;
        this.type = 1;
    }

    public NumericImp(long value) {
        this.longValue = value;
        this.type = 1;
    }

    public NumericImp(float value) {
        this.floatValue = value;
        this.type = 2;
    }

    public NumericImp(double value) {
        this.doubleValue = value;
        this.type = 3;
    }

    public NumericImp(String value) {
        this.value = value;
        this.internalNumberData = null;
        this.type = 4;
    }

    public NumericImp(Number numberValue) {
        if (numberValue == null) {
            this.internalNumberData = new LongInternalNumber(0L);
        }
        this.internalNumberData = new NumberInternalNumber(numberValue);
        this.type = 5;
    }

    @Override
    public ValueType internalType() {
        return ValueType.NUMERIC;
    }

    public byte byteValue() {
        if (this.type == 1) {
            return (byte)this.longValue;
        }
        if (this.type == 2) {
            return (byte)this.floatValue;
        }
        if (this.type == 3) {
            return (byte)this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber().byteValue();
    }

    public double doubleValue() {
        if (this.type == 1) {
            return this.longValue;
        }
        if (this.type == 2) {
            return this.floatValue;
        }
        if (this.type == 3) {
            return this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber().doubleValue();
    }

    public float floatValue() {
        if (this.type == 1) {
            return this.longValue;
        }
        if (this.type == 2) {
            return this.floatValue;
        }
        if (this.type == 3) {
            return (float)this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber().floatValue();
    }

    public int intValue() {
        if (this.type == 1) {
            return (int)this.longValue;
        }
        if (this.type == 2) {
            return (int)this.floatValue;
        }
        if (this.type == 3) {
            return (int)this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber().intValue();
    }

    public long longValue() {
        if (this.type == 1) {
            return this.longValue;
        }
        if (this.type == 2) {
            return (long)this.floatValue;
        }
        if (this.type == 3) {
            return (long)this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber().longValue();
    }

    public short shortValue() {
        if (this.type == 1) {
            return (short)this.longValue;
        }
        if (this.type == 2) {
            return (short)this.floatValue;
        }
        if (this.type == 3) {
            return (short)this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber().shortValue();
    }

    public void parseInternalValue() {
        boolean exponetFlag;
        int s = this.value.length();
        boolean decimalFlag = this.value.contains(".");
        boolean bl = exponetFlag = this.value.contains("e") || this.value.contains("E");
        this.internalNumberData = !decimalFlag && !exponetFlag ? (Number)(s < 10 ? new LongInternalNumber(Integer.parseInt(this.value)) : (s < 18 ? new LongInternalNumber(Long.parseLong(this.value)) : new NumberInternalNumber(new BigInteger(this.value)))) : (Number)(s < 10 ? new DoubleInternalNumber(Float.parseFloat(this.value)) : (s < 16 ? new DoubleInternalNumber(Float.parseFloat(this.value)) : new NumberInternalNumber(new BigDecimal(this.value))));
    }

    @Override
    public Number getNumber() {
        if (this.type == 1) {
            return this.longValue;
        }
        if (this.type == 2) {
            return Float.valueOf(this.floatValue);
        }
        if (this.type == 3) {
            return this.doubleValue;
        }
        if (this.type == 4 && this.internalNumberData == null) {
            this.parseInternalValue();
        }
        return this.internalNumberData.getNumber();
    }

    @Override
    public int nestedSize() {
        return 0;
    }

    @Override
    public String toJSON() {
        if (this.type == 1) {
            return "" + this.longValue;
        }
        if (this.type == 2) {
            return "" + this.floatValue;
        }
        if (this.type == 3) {
            return "" + this.doubleValue;
        }
        return this.internalNumberData != null ? this.internalNumberData.toJSON() : this.value;
    }

    @Override
    public ByteBuffer toBSON(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public ByteBuffer toUniversalBinaryJSON(ByteBuffer buffer) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NumericImp other = (NumericImp)obj;
        return this.compareTo(other) == 0;
    }

    @Override
    public int hashCode() {
        int hash = 7;
        hash = 11 * hash + (this.type == 1 ? (int)this.longValue : 0);
        hash = 11 * hash + (this.type == 2 ? (int)this.floatValue : 0);
        hash = 11 * hash + (this.type == 3 ? (int)this.doubleValue : 0);
        hash = 23 * hash + (this.internalNumberData != null ? this.internalNumberData.hashCode() : 0);
        hash = 31 * hash + (this.value != null ? this.value.hashCode() : 0);
        return hash;
    }
}

