/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal;

import cc.plural.jsonij.JSON;
import cc.plural.jsonij.Value;
import cc.plural.jsonij.marshal.JSONMarshaler;
import cc.plural.jsonij.marshal.JSONMarshalerException;
import cc.plural.jsonij.marshal.codec.JSONValueCodecStore;
import cc.plural.jsonij.parser.ParserException;
import cc.plural.jsonij.reflect.ClassProperty;
import cc.plural.jsonij.reflect.Inspection;
import cc.plural.jsonij.reflect.ReflectType;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONDocumentMarshaler {
    public Object marshalJSONDocument(JSON json, Class<?> objectClass) throws JSONMarshalerException {
        Object resultObject = null;
        Value jsonRoot = json.getRoot();
        if (jsonRoot.type() == Value.TYPE.OBJECT) {
            JSON.Object jsonObjectRoot = (JSON.Object)jsonRoot;
            resultObject = this.marshalJSONDocumentObject(jsonObjectRoot, objectClass);
        } else if (jsonRoot.type() == Value.TYPE.ARRAY) {
            JSON.Array jsonArrayRoot = (JSON.Array)jsonRoot;
            resultObject = this.marshalJSONDocumentArray(jsonArrayRoot, objectClass);
        } else {
            throw new RuntimeException("Not an Object or Array Type.");
        }
        return resultObject;
    }

    public Object marshalJSONDocument(Value value, Class<?> objectClass) throws JSONMarshalerException {
        Object resultObject = null;
        ReflectType type = ReflectType.inspectObjectType(objectClass);
        switch (type) {
            case OBJECT: {
                if (value.type() != Value.TYPE.OBJECT) break;
                JSON.Object jsonObjectRoot = (JSON.Object)value;
                resultObject = this.marshalJSONDocumentObject(jsonObjectRoot, objectClass);
                break;
            }
            case ARRAY: 
            case ARRAY_BOOLEAN: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_INTEGER: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_ENUM: {
                if (value.type() != Value.TYPE.ARRAY) break;
                JSON.Array jsonArrayRoot = (JSON.Array)value;
                resultObject = this.marshalJSONDocumentArray(jsonArrayRoot, objectClass);
                break;
            }
            case STRING: {
                if (value.type() != Value.TYPE.STRING) break;
                return value.toString();
            }
            case BOOLEAN: {
                if (value.type() == Value.TYPE.TRUE) {
                    return true;
                }
                if (value.type() != Value.TYPE.FALSE) break;
                return false;
            }
            case BYTE: {
                if (value.type() != Value.TYPE.NUMERIC) break;
                return value.getNumber().byteValue();
            }
            case SHORT: {
                if (value.type() != Value.TYPE.NUMERIC) break;
                return value.getNumber().shortValue();
            }
            case INTEGER: {
                if (objectClass == BigInteger.class) {
                    return new BigInteger(value.getString());
                }
                if (value.type() != Value.TYPE.NUMERIC) break;
                return value.getNumber().intValue();
            }
            case DOUBLE: {
                if (objectClass == BigDecimal.class) {
                    return new BigDecimal(value.getString());
                }
                if (value.type() != Value.TYPE.NUMERIC) break;
                return value.getNumber().doubleValue();
            }
            case FLOAT: {
                if (value.type() != Value.TYPE.NUMERIC) break;
                return Float.valueOf(value.getNumber().floatValue());
            }
            case LONG: {
                if (value.type() != Value.TYPE.NUMERIC) break;
                return value.getNumber().longValue();
            }
            case CLASS: {
                if (value.type() == Value.TYPE.STRING) {
                    try {
                        return Class.forName(value.toString());
                    }
                    catch (ClassNotFoundException ex) {
                        // empty catch block
                    }
                }
            }
            default: {
                System.out.println("Unknown Type:" + (Object)((Object)type) + " " + value);
                throw new RuntimeException("Unhandled Type " + (Object)((Object)type) + " " + value);
            }
        }
        return resultObject;
    }

    public Object marshalJSONDocument(InputStream stream, Class<?> objectClass) throws JSONMarshalerException {
        JSON json;
        try {
            json = JSON.parse(stream);
        }
        catch (ParserException ex) {
            throw new JSONMarshalerException("", new Object[]{ex});
        }
        catch (IOException ex) {
            throw new JSONMarshalerException("", new Object[]{ex});
        }
        return this.marshalJSONDocument(json, objectClass);
    }

    public Object marshalJSONDocument(String jsonString, Class<?> objectClass) throws JSONMarshalerException {
        JSON json;
        try {
            json = JSON.parse(jsonString);
        }
        catch (ParserException ex) {
            throw new JSONMarshalerException("", new Object[]{ex});
        }
        catch (IOException ex) {
            throw new JSONMarshalerException("", new Object[]{ex});
        }
        return this.marshalJSONDocument(json, objectClass);
    }

    public Object marshalJSONDocumentObject(JSON.Object<CharSequence, Value> jsonObject, Class<?> objectClass) throws JSONMarshalerException {
        Object object = null;
        if (JSONMarshaler.hasCodec(objectClass)) {
            JSONValueCodecStore.JSONValueCodecHelper codecHelper = JSONMarshaler.getCodecHelper(objectClass);
            try {
                object = codecHelper.decode(jsonObject, objectClass);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
        } else {
            try {
                object = objectClass.newInstance();
            }
            catch (InstantiationException ex) {
                Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                throw new JSONMarshalerException("newInstance", new Object[0]);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                throw new JSONMarshalerException("illegalAccess", new Object[0]);
            }
            ReflectType type = ReflectType.inspectObjectType(objectClass);
            Inspection inspection = ReflectType.getInspection(objectClass);
            boolean hasCollector = inspection.hasCollectors();
            HashMap collector = null;
            HashMap innerObjectCollector = null;
            ArrayList innerArrayCollector = null;
            if (hasCollector) {
                collector = new HashMap();
            }
            if (inspection.hasInnerMap()) {
                innerObjectCollector = new HashMap();
            }
            if (inspection.hasInnerList()) {
                innerArrayCollector = new ArrayList();
            }
            for (Map.Entry documentPropertyEntry : jsonObject.entrySet()) {
                CharSequence key = (CharSequence)documentPropertyEntry.getKey();
                if (inspection.hasProperty(key.toString())) {
                    ClassProperty inspectorProperty = inspection.getProperty(key.toString());
                    Value documentValue = (Value)documentPropertyEntry.getValue();
                    try {
                        this.marshalJSONValue(documentValue, object, inspectorProperty);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    continue;
                }
                if (hasCollector) {
                    collector.put(key, documentPropertyEntry.getValue());
                }
                if (inspection.hasInnerMap()) {
                    innerObjectCollector.put(key, documentPropertyEntry.getValue());
                }
                if (!inspection.hasInnerList()) continue;
                innerArrayCollector.add(documentPropertyEntry.getValue());
            }
            if (hasCollector) {
                for (ClassProperty collectorProperty : inspection.getCollectors()) {
                    try {
                        collectorProperty.getMutator().fire(object, collector);
                    }
                    catch (IllegalAccessException ex) {
                        Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (IllegalArgumentException ex) {
                        Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                    catch (InvocationTargetException ex) {
                        Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
                    }
                }
            }
            if (inspection.hasInnerMap()) {
                // empty if block
            }
            if (inspection.hasInnerList()) {
                // empty if block
            }
        }
        return object;
    }

    public Object marshalJSONDocumentArray(JSON.Array<Value> jsonArray, Class<?> objectClass) throws JSONMarshalerException {
        int size = jsonArray.size();
        ReflectType type = ReflectType.inspectObjectType(objectClass);
        if (type == ReflectType.OBJECT) {
            return this.marshalJSONDocumentList(jsonArray, objectClass);
        }
        Class<?> componentClass = objectClass.getComponentType();
        ReflectType componentType = ReflectType.inspectObjectType(componentClass);
        Object array = Array.newInstance(componentClass, size);
        for (int i = 0; i < size; ++i) {
            Object value = jsonArray.get(i);
            if (((Value)value).getValueType() == Value.TYPE.OBJECT) {
                Array.set(array, i, this.marshalJSONDocumentObject((JSON.Object)value, componentClass));
                continue;
            }
            if (((Value)value).getValueType() == Value.TYPE.ARRAY) {
                Array.set(array, i, this.marshalJSONDocumentArray((JSON.Array)value, componentClass));
                continue;
            }
            if (componentType == ReflectType.INTEGER) {
                Array.set(array, i, ((Value)jsonArray.get(i)).getNumber().intValue());
                continue;
            }
            if (componentType == ReflectType.FLOAT) {
                Array.set(array, i, Float.valueOf(((Value)jsonArray.get(i)).getNumber().floatValue()));
                continue;
            }
            if (componentType == ReflectType.DOUBLE) {
                Array.set(array, i, ((Value)jsonArray.get(i)).getNumber().doubleValue());
                continue;
            }
            if (componentType == ReflectType.BYTE) {
                Array.set(array, i, ((Value)jsonArray.get(i)).getNumber().byteValue());
                continue;
            }
            if (componentType == ReflectType.BOOLEAN) {
                Array.set(array, i, ((Value)jsonArray.get(i)).getBoolean());
                continue;
            }
            if (componentType != ReflectType.STRING) continue;
            Array.set(array, i, ((Value)jsonArray.get(i)).getString());
        }
        return array;
    }

    public List<?> marshalJSONDocumentList(JSON.Array<Value> jsonArray, Class<?> objectClass) throws JSONMarshalerException {
        return null;
    }

    public Map<?, ?> marshalJSONDocumentMap(JSON.Object<CharSequence, Value> jsonMap, Type type) throws JSONMarshalerException {
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Type[] parameterTypeArray = parameterizedType.getActualTypeArguments();
            if (parameterTypeArray != null && parameterTypeArray.length == 2) {
                Class keyClass = null;
                if (parameterTypeArray[0] instanceof Class) {
                    keyClass = (Class)parameterTypeArray[0];
                }
                Class valueClass = null;
                if (parameterTypeArray[1] instanceof Class) {
                    valueClass = (Class)parameterTypeArray[1];
                } else if (parameterTypeArray[1] instanceof ParameterizedType) {
                    ParameterizedType valueType = (ParameterizedType)parameterTypeArray[1];
                    valueClass = (Class)valueType.getRawType();
                }
                HashMap<CharSequence, Object> returnMap = new HashMap<CharSequence, Object>();
                for (CharSequence keyValue : jsonMap.keySet()) {
                    Value value = jsonMap.get(keyValue);
                    Object o = this.marshalJSONDocument(value, valueClass);
                    returnMap.put(keyValue, o);
                }
                return returnMap;
            }
            throw new RuntimeException("Beef this up");
        }
        System.out.println(jsonMap);
        for (CharSequence key : jsonMap.keySet()) {
            Value v = jsonMap.get(key);
        }
        return null;
    }

    private void marshalJSONValue(Value value, Object object, ClassProperty inspectorProperty) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, JSONMarshalerException {
        ClassProperty.ClassPropertyMutator mutator = inspectorProperty.getMutator();
        ReflectType type = ReflectType.inspectObjectType(mutator.getType());
        switch (type) {
            case BOOLEAN: {
                mutator.fire(object, value.getBoolean());
                return;
            }
            case BYTE: {
                mutator.fire(object, value.getNumber().byteValue());
                return;
            }
            case SHORT: {
                mutator.fire(object, value.getNumber().shortValue());
                return;
            }
            case INTEGER: {
                mutator.fire(object, value.getNumber().intValue());
                return;
            }
            case FLOAT: {
                mutator.fire(object, value.getNumber().floatValue());
                return;
            }
            case LONG: {
                mutator.fire(object, value.getNumber().longValue());
                return;
            }
            case STRING: {
                mutator.fire(object, value.getString());
                return;
            }
            case ARRAY: 
            case ARRAY_BOOLEAN: 
            case ARRAY_BYTE: 
            case ARRAY_SHORT: 
            case ARRAY_INTEGER: 
            case ARRAY_FLOAT: 
            case ARRAY_DOUBLE: 
            case ARRAY_LONG: 
            case ARRAY_STRING: 
            case ARRAY_ENUM: {
                mutator.fire(object, this.marshalJSONDocumentArray((JSON.Array)value, mutator.getType()));
                return;
            }
            case OBJECT: {
                Object propertyObject = this.marshalJSONDocument(value, mutator.getType());
                mutator.fire(object, propertyObject);
                return;
            }
            case MAP: {
                Map<?, ?> propertyMap = this.marshalJSONDocumentMap((JSON.Object)value, mutator.getGenericType());
                mutator.fire(object, propertyMap);
                return;
            }
            case UNKOWN: {
                Object propertyUnknown = this.marshalJSONDocument(value, mutator.getType());
                mutator.fire(object, propertyUnknown);
            }
        }
        System.out.println("Unknown Type:" + (Object)((Object)type) + " " + value);
        throw new RuntimeException("Unhandled Type " + (Object)((Object)type) + " " + value);
    }
}

