/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij;

import cc.plural.jsonij.ConstantUtility;
import cc.plural.jsonij.JSONReader;
import cc.plural.jsonij.parser.ParserException;
import cc.plural.jsonij.parser.Position;
import cc.plural.jsonij.parser.ReaderParser;

public class StringJSONReader
extends JSONReader {
    protected final String jsonString;
    protected int index;
    protected final int length;
    protected final StringJSONStringReader stringReader;

    public StringJSONReader(String jsonString) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.stringReader = new StringJSONStringReader();
        this.index = 0;
    }

    public StringJSONReader(String jsonString, int index) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.stringReader = new StringJSONStringReader();
        this.index = index;
        this.position.setPostionNumber(index);
    }

    public int readNext() throws ParserException {
        int r = -1;
        while (this.index < this.length) {
            r = this.jsonString.charAt(this.index++);
            this.position.movePosition();
            do {
                if (ConstantUtility.isReturn(r)) {
                    this.handleNewLine();
                    if (this.index >= this.length) break;
                    if (!ConstantUtility.isNewLine(r = (int)this.jsonString.charAt(this.index++))) continue;
                    continue;
                }
                if (!ConstantUtility.isNewLine(r)) continue;
                this.handleNewLine();
                if (this.index >= this.length) break;
                if (!ConstantUtility.isReturn(r = (int)this.jsonString.charAt(this.index++))) continue;
            } while (ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r));
            if (ConstantUtility.isWhiteSpace(r)) continue;
            break;
        }
        return r;
    }

    public int getIndex() {
        return this.index;
    }

    public ReaderParser getStringReader() {
        this.stringReader.setActive(true);
        return this.stringReader;
    }

    protected class StringJSONStringReader
    implements ReaderParser {
        public boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        public int peek() throws ParserException {
            if (!StringJSONReader.this.hasPeeked) {
                if (!this.active) {
                    return -1;
                }
                StringJSONReader.this.peekValue = this.readNext();
                StringJSONReader.this.hasPeeked = true;
            }
            return StringJSONReader.this.peekValue;
        }

        public int read() throws ParserException {
            if (!this.active) {
                return -1;
            }
            if (StringJSONReader.this.hasPeeked) {
                StringJSONReader.this.hasPeeked = false;
                return StringJSONReader.this.peekValue;
            }
            return this.readNext();
        }

        public void close() {
            this.active = false;
        }

        protected int readNext() throws ParserException {
            int r;
            if (StringJSONReader.this.index < StringJSONReader.this.length) {
                r = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++);
                StringJSONReader.this.position.movePosition();
            } else {
                r = -1;
            }
            return r;
        }

        public Position getPosition() {
            return StringJSONReader.this.getPosition();
        }

        public boolean isHasPeeked() {
            return StringJSONReader.this.isHasPeeked();
        }

        public boolean hasPeeked() {
            return StringJSONReader.this.hasPeeked();
        }

        public void setHasPeeked(boolean hasPeeked) {
            StringJSONReader.this.setHasPeeked(hasPeeked);
        }

        public int getLineNumber() {
            return StringJSONReader.this.getLineNumber();
        }

        public int getPositionNumber() {
            return StringJSONReader.this.getPositionNumber();
        }
    }
}

