/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.select;

import cc.plural.jsonij.ConstantUtility;
import cc.plural.jsonij.parser.BaseReaderParser;
import cc.plural.jsonij.parser.ParserException;
import cc.plural.jsonij.parser.ReaderParser;
import cc.plural.jsonij.select.ClassSelector;
import cc.plural.jsonij.select.SelectConstantUtility;
import cc.plural.jsonij.select.SelectParserException;
import cc.plural.jsonij.select.Selector;
import java.io.IOException;

public class SelectParser {
    private StringBuilder selectorBuilder = null;

    public void parse(String select) throws IOException, ParserException {
        SelectReader target = new SelectReader(select);
    }

    public void parse(SelectReader target) throws IOException, ParserException {
        while (target.peek() != -1) {
            Selector selector = null;
            if (SelectConstantUtility.isStartOfType(target.peek())) {
                selector = this.parseType(target);
                continue;
            }
            if (target.peek() == 46) {
                selector = this.parseUniversal(target);
                continue;
            }
            if (target.peek() == 46) {
                selector = this.parseClass(target);
                continue;
            }
            if (target.peek() != 58) continue;
            Selector selector2 = this.parsePseudo(target);
        }
    }

    private Selector parseType(SelectReader target) throws IOException, ParserException {
        Selector selector;
        int c = target.peek();
        if (c == 111) {
            selector = this.parseTypeObject(target);
        } else if (c == 97) {
            selector = this.parseTypeArray(target);
        } else if (c == 110) {
            selector = this.parseTypeNumberOrNull(target);
        } else if (c == 115) {
            selector = this.parseTypeString(target);
        } else if (c == 98) {
            selector = this.parseTypeBoolean(target);
        } else {
            throw new SelectParserException("typeerror", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
        }
        return selector;
    }

    private Selector parseTypeObject(SelectReader target) throws IOException, ParserException {
        for (int i = 0; i < "object".length(); ++i) {
            if (target.peek() != "object".charAt(i)) continue;
            target.read();
        }
        return Selector.OBJECT_SELECTOR;
    }

    private Selector parseTypeArray(SelectReader target) throws IOException, ParserException {
        for (int i = 0; i < "array".length(); ++i) {
            if (target.peek() != "array".charAt(i)) continue;
            target.read();
        }
        return Selector.ARRAY_SELECTOR;
    }

    private Selector parseTypeNumberOrNull(SelectReader target) throws IOException, ParserException {
        if (target.peek() == 110) {
            target.read();
        }
        if (target.peek() == 117) {
            target.read();
        }
        if (target.peek() == 109) {
            target.read();
            for (int i = 3; i < "number".length(); ++i) {
                if (target.peek() != "number".charAt(i)) continue;
                target.read();
            }
            return Selector.NUMBER_SELECTOR;
        }
        if (target.peek() == 108) {
            for (int i = 3; i < "null".length(); ++i) {
                if (target.peek() != "null".charAt(i)) continue;
                target.read();
            }
            return Selector.NULL_SELECTOR;
        }
        return null;
    }

    private Selector parseTypeString(SelectReader target) throws IOException, ParserException {
        for (int i = 0; i < "object".length(); ++i) {
            if (target.peek() != "object".charAt(i)) continue;
            target.read();
        }
        return Selector.OBJECT_SELECTOR;
    }

    private Selector parseTypeBoolean(SelectReader target) throws IOException, ParserException {
        for (int i = 0; i < "object".length(); ++i) {
            if (target.peek() != "object".charAt(i)) continue;
            target.read();
        }
        return Selector.OBJECT_SELECTOR;
    }

    private Selector parseUniversal(SelectReader target) throws IOException, ParserException {
        return null;
    }

    private Selector parseClass(SelectReader target) throws IOException, ParserException {
        target.read();
        this.selectorBuilder = new StringBuilder();
        while (!ConstantUtility.isWhiteSpace(target.peek())) {
            this.selectorBuilder.append(target.read());
        }
        return new ClassSelector(this.selectorBuilder.toString());
    }

    private Selector parsePseudo(SelectReader target) throws IOException, ParserException {
        return null;
    }

    public static class SelectReader
    extends BaseReaderParser
    implements ReaderParser {
        String selectString;
        int index;

        public SelectReader(String selectString) {
            this.selectString = selectString;
            this.index = 0;
        }

        public String getSelect() {
            return this.selectString;
        }

        public int readNext() throws IOException, ParserException {
            if (this.index < this.selectString.length()) {
                return this.selectString.charAt(this.index++);
            }
            return -1;
        }

        public void skipWhitepace() throws IOException, ParserException {
            while (ConstantUtility.isWhiteSpace(this.peek())) {
                this.read();
            }
        }

        public void skipWhitepace(StringBuilder appender) throws IOException, ParserException {
            while (ConstantUtility.isWhiteSpace(this.peek())) {
                appender.append((char)this.read());
            }
        }
    }
}

