/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.reflect;

import cc.plural.jsonij.Value;
import cc.plural.jsonij.marshal.JSONMarshaler;
import cc.plural.jsonij.reflect.ClassProperty;
import cc.plural.jsonij.reflect.Inspection;
import cc.plural.jsonij.reflect.InspectionFactory;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ReflectType {
    BOOLEAN,
    BYTE,
    SHORT,
    INTEGER,
    FLOAT,
    DOUBLE,
    LONG,
    STRING,
    LIST,
    OBJECT,
    MAP,
    ENUM,
    ARRAY,
    ARRAY_BOOLEAN,
    ARRAY_BYTE,
    ARRAY_SHORT,
    ARRAY_INTEGER,
    ARRAY_FLOAT,
    ARRAY_DOUBLE,
    ARRAY_LONG,
    ARRAY_STRING,
    ARRAY_ENUM,
    ARRAY_LIST,
    ARRAY_MAP,
    ARRAY_ARRAY,
    CLASS,
    JSON_VALUE,
    UNKOWN;

    boolean primitive = true;
    JavaArrayType arrayType;
    protected static final InspectionFactory inspectionFactory;
    protected static final Map<Class<?>, Inspection> inspectedClasses;

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public static ReflectType inspectObjectType(Class<?> c) {
        ReflectType type = null;
        if (c == Boolean.TYPE) {
            type = BOOLEAN;
            type.setPrimitive(true);
            return type;
        }
        if (c == Boolean.class) {
            type = BOOLEAN;
            type.setPrimitive(false);
            return type;
        }
        if (c == Integer.TYPE) {
            type = INTEGER;
            type.setPrimitive(true);
            return type;
        }
        if (c == Integer.class) {
            type = INTEGER;
            type.setPrimitive(false);
            return type;
        }
        if (c == BigInteger.class) {
            type = INTEGER;
            type.setPrimitive(false);
            return type;
        }
        if (c == Double.TYPE) {
            type = DOUBLE;
            type.setPrimitive(true);
            return type;
        }
        if (c == Double.class) {
            type = DOUBLE;
            type.setPrimitive(false);
            return type;
        }
        if (c == BigDecimal.class) {
            type = DOUBLE;
            type.setPrimitive(false);
            return type;
        }
        if (c == Float.TYPE) {
            type = FLOAT;
            type.setPrimitive(true);
            return type;
        }
        if (c == Float.class) {
            type = FLOAT;
            type.setPrimitive(false);
            return type;
        }
        if (c == Long.TYPE) {
            type = LONG;
            type.setPrimitive(true);
            return type;
        }
        if (c == Long.class) {
            type = LONG;
            type.setPrimitive(false);
            return type;
        }
        if (c == Short.TYPE) {
            type = SHORT;
            type.setPrimitive(true);
            return type;
        }
        if (c == Short.class) {
            type = SHORT;
            type.setPrimitive(false);
            return type;
        }
        if (c == Byte.TYPE) {
            type = BYTE;
            type.setPrimitive(true);
            return type;
        }
        if (c == Byte.class) {
            type = BYTE;
            type.setPrimitive(false);
            return type;
        }
        if (c.isEnum()) {
            type = ENUM;
            type.setPrimitive(false);
            return type;
        }
        if (c == String.class || c == CharSequence.class || c == Character.TYPE || c == Character.class) {
            type = STRING;
            type.setPrimitive(false);
            return type;
        }
        if (c.isArray()) {
            type = ReflectType.getArrayType(c);
            return type;
        }
        if (c == Class.class) {
            return CLASS;
        }
        if (c == List.class) {
            return LIST;
        }
        if (c == Map.class) {
            return MAP;
        }
        Class<?> currentClass = c;
        block0: do {
            if (currentClass == Value.class) {
                type = JSON_VALUE;
                break;
            }
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < Array.getLength(interfaces); ++i) {
                if (interfaces[i] == List.class) {
                    type = LIST;
                    continue block0;
                }
                if (interfaces[i] == Map.class) {
                    type = MAP;
                    continue block0;
                }
                if (interfaces[i] == CharSequence.class) {
                    type = STRING;
                    continue block0;
                }
                if (interfaces[i] != Value.class) continue;
                type = JSON_VALUE;
                continue block0;
            }
        } while ((currentClass = currentClass.getSuperclass()) != null);
        if (JSONMarshaler.ALWAYS_USE_INNER_PROPERTY && type != null || ReflectType.isObjectType(c)) {
            type = OBJECT;
            type.setPrimitive(false);
            return type;
        }
        if (c == Object.class) {
            type = OBJECT;
            return type;
        }
        if (c.getComponentType() == Class.class) {
            type = OBJECT;
            return type;
        }
        if (type != null) {
            return type;
        }
        return UNKOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Inspection getInspection(Class<?> objectClass) {
        Inspection inspection = null;
        Map<Class<?>, Inspection> map = inspectedClasses;
        synchronized (map) {
            if (inspectedClasses.containsKey(objectClass)) {
                inspection = inspectedClasses.get(objectClass);
            } else {
                inspection = inspectionFactory.inspect(objectClass);
                inspectedClasses.put(objectClass, inspection);
            }
        }
        return inspection;
    }

    public static boolean isObjectType(Class<?> objectClass) {
        Inspection inspection = ReflectType.getInspection(objectClass);
        List<ClassProperty> properties = inspection.getProperties();
        return properties != null && !properties.isEmpty();
    }

    public static ReflectType getArrayType(Class<?> objectClass) {
        ReflectType resultType = null;
        Class<?> objectComponentType = objectClass.getComponentType();
        if (!objectComponentType.isArray()) {
            ReflectType componentType = ReflectType.inspectObjectType(objectComponentType);
            switch (componentType) {
                case BOOLEAN: {
                    resultType = ARRAY_BOOLEAN;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case BYTE: {
                    resultType = ARRAY_BYTE;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case INTEGER: {
                    resultType = ARRAY_INTEGER;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case SHORT: {
                    resultType = ARRAY_SHORT;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case FLOAT: {
                    resultType = ARRAY_FLOAT;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case LONG: {
                    resultType = ARRAY_LONG;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case DOUBLE: {
                    resultType = ARRAY_DOUBLE;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case STRING: {
                    resultType = ARRAY_STRING;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case ENUM: {
                    resultType = ARRAY_ENUM;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case MAP: {
                    resultType = ARRAY_MAP;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case LIST: {
                    resultType = ARRAY_LIST;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case OBJECT: {
                    resultType = ARRAY;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                default: {
                    System.out.println("Unknown Type!!");
                    Thread.dumpStack();
                    throw new RuntimeException("Unhandled Type " + (Object)((Object)componentType));
                }
            }
        } else {
            resultType = ARRAY_ARRAY;
            resultType.setPrimitive(false);
        }
        if (resultType != null) {
            return resultType;
        }
        return UNKOWN;
    }

    public static List<Class<?>> getInterfaceTrace(Class<?> base) {
        ArrayList interfaceTrace = new ArrayList();
        Class<?> currentClass = base;
        do {
            Class<?>[] interfaces = currentClass.getInterfaces();
            for (int i = 0; i < Array.getLength(interfaces); ++i) {
                if (interfaceTrace.contains(interfaces[i])) continue;
                interfaceTrace.add(interfaces[i]);
            }
            if (interfaceTrace.contains(currentClass)) continue;
            interfaceTrace.add(currentClass);
        } while ((currentClass = currentClass.getSuperclass()) != null);
        return interfaceTrace;
    }

    static {
        inspectionFactory = new InspectionFactory();
        inspectedClasses = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaArrayType {
        Class<?> arrayType;
        int dimension;

        public JavaArrayType(Class<?> arrayType) {
            this.arrayType = arrayType;
            this.dimension = 0;
            this.inspect();
        }

        public final void inspect() {
            if (this.arrayType != null && this.arrayType.isArray()) {
                Class<?> innerType = this.arrayType.getComponentType();
                this.dimension = 1;
                while (innerType.isArray() && (innerType = this.arrayType.getComponentType()) != null) {
                    ++this.dimension;
                }
            }
        }

        public String toString() {
            return "Array " + this.arrayType.getSimpleName() + "[" + this.dimension + "]";
        }
    }
}

