/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal.codec;

import cc.plural.jsonij.Value;
import cc.plural.jsonij.marshal.codec.JSONValueCodec;
import cc.plural.jsonij.reflect.ReflectType;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONValueCodecStore {
    public static final String ENCODE_METHOD_SIGNATURE = "encode";
    public static final String DECODE_METHOD_SIGNATURE = "decode";
    public static Map<String, JSONValueCodecHelper> codecs;

    public static void clearCodecs() {
        if (codecs != null) {
            codecs = null;
        }
    }

    public boolean hasCodec(Class<?> type) {
        String name = type.getName();
        if (codecs == null) {
            return false;
        }
        if (codecs.containsKey(name)) {
            return true;
        }
        List<Class<?>> interfaceTrace = ReflectType.getInterfaceTrace(type);
        for (Class<?> i : interfaceTrace) {
            String interfaceName = i.getName();
            if (!codecs.containsKey(interfaceName)) continue;
            return true;
        }
        return false;
    }

    public void registerCodec(Class<?> type, Class<? extends JSONValueCodec> codec) {
        Method[] methods;
        String name = type.getName();
        if (codecs != null && codecs.containsKey(name)) {
            return;
        }
        if (codecs == null) {
            codecs = new HashMap<String, JSONValueCodecHelper>();
        }
        JSONValueCodecHelper helper = new JSONValueCodecHelper();
        helper.type = type;
        helper.codec = codec;
        for (Method method : methods = codec.getMethods()) {
            if (method.getName().equals(ENCODE_METHOD_SIGNATURE)) {
                helper.encodeMethod = method;
                continue;
            }
            if (!method.getName().equals(DECODE_METHOD_SIGNATURE)) continue;
            helper.decodeMethod = method;
        }
        codecs.put(name, helper);
    }

    public JSONValueCodecHelper getCodecHelper(Class<?> type) {
        String name = type.getName();
        if (codecs.containsKey(name)) {
            return codecs.get(name);
        }
        List<Class<?>> interfaceTrace = ReflectType.getInterfaceTrace(type);
        for (Class<?> i : interfaceTrace) {
            String interfaceName = i.getName();
            if (!codecs.containsKey(interfaceName)) continue;
            return codecs.get(interfaceName);
        }
        return null;
    }

    public Class<? extends JSONValueCodec> getCodec(Class<?> type) {
        String name = type.getName();
        if (codecs.containsKey(name)) {
            return codecs.get(name).getCodec();
        }
        List<Class<?>> interfaceTrace = ReflectType.getInterfaceTrace(type);
        for (Class<?> i : interfaceTrace) {
            String interfaceName = i.getName();
            if (!codecs.containsKey(interfaceName)) continue;
            return codecs.get(interfaceName).getCodec();
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JSONValueCodecHelper {
        private Class<?> type;
        private Class<? extends JSONValueCodec> codec;
        private Method encodeMethod;
        private Method decodeMethod;

        public Class<? extends JSONValueCodec> getCodec() {
            return this.codec;
        }

        public void setCodec(Class<? extends JSONValueCodec> codec) {
            this.codec = codec;
        }

        public Method getEncodeMethod() {
            return this.encodeMethod;
        }

        public void setEncodeMethod(Method encodeMethod) {
            this.encodeMethod = encodeMethod;
        }

        public Method getDecodeMethod() {
            return this.decodeMethod;
        }

        public void setDecodeMethod(Method decodeMethod) {
            this.decodeMethod = decodeMethod;
        }

        public Value encode(Object object) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return (Value)this.encodeMethod.invoke(this.codec, object);
        }

        public Object decode(Value value, Class<?> clazz) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return this.decodeMethod.invoke(this.codec, value, clazz);
        }

        public String toString() {
            return "JSONValueCodecHelper[codec=" + this.codec + " encodeMethod=" + this.encodeMethod + " decodeMethod=" + this.decodeMethod + "]";
        }
    }
}

