/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij;

import cc.plural.jsonij.ConstantUtility;
import cc.plural.jsonij.JSONReader;
import cc.plural.jsonij.parser.Position;
import cc.plural.jsonij.parser.ReaderParser;
import java.io.IOException;
import java.io.Reader;

public class ReaderJSONReader
extends JSONReader {
    protected Reader reader;
    ReaderJSONStringReader stringReader;

    public ReaderJSONReader(Reader reader) {
        if (reader == null) {
            throw new NullPointerException("Null Reader Exception.");
        }
        this.reader = reader;
    }

    public Reader getReader() {
        return this.reader;
    }

    public void setReader(Reader reader) {
        this.reader = reader;
    }

    public int readNext() throws IOException {
        int r = -1;
        while (this.reader.ready() && (r = this.reader.read()) != -1) {
            this.getPosition().movePosition();
            do {
                if (ConstantUtility.isReturn(r)) {
                    this.handleNewLine();
                    r = this.reader.read();
                    if (r == -1 || !ConstantUtility.isNewLine(r)) continue;
                    continue;
                }
                if (!ConstantUtility.isNewLine(r)) continue;
                this.handleNewLine();
                r = this.reader.read();
                if (r != -1 && !ConstantUtility.isReturn(r)) continue;
            } while (ConstantUtility.isReturn(r) || ConstantUtility.isNewLine(r));
            if (ConstantUtility.isWhiteSpace(r)) continue;
            break;
        }
        return r;
    }

    public ReaderParser getStringReader() {
        if (this.stringReader == null) {
            this.stringReader = new ReaderJSONStringReader();
        } else if (this.stringReader.isActive()) {
            // empty if block
        }
        this.stringReader.setActive(true);
        return this.stringReader;
    }

    protected class ReaderJSONStringReader
    implements ReaderParser {
        protected boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        public int peek() throws IOException {
            if (!ReaderJSONReader.this.hasPeeked) {
                if (!this.active) {
                    return -1;
                }
                ReaderJSONReader.this.peekValue = this.readNext();
                ReaderJSONReader.this.hasPeeked = true;
            }
            return ReaderJSONReader.this.peekValue;
        }

        public int read() throws IOException {
            if (ReaderJSONReader.this.hasPeeked) {
                if (!this.active) {
                    return -1;
                }
                ReaderJSONReader.this.hasPeeked = false;
                return ReaderJSONReader.this.peekValue;
            }
            return this.readNext();
        }

        public void close() {
            this.active = false;
        }

        protected int readNext() throws IOException {
            int r = -1;
            if (ReaderJSONReader.this.reader.ready() && (r = ReaderJSONReader.this.reader.read()) != -1) {
                ReaderJSONReader.this.position.movePosition();
            }
            return r;
        }

        public Position getPosition() {
            return ReaderJSONReader.this.getPosition();
        }

        public boolean isHasPeeked() {
            return ReaderJSONReader.this.isHasPeeked();
        }

        public boolean hasPeeked() {
            return ReaderJSONReader.this.hasPeeked();
        }

        public void setHasPeeked(boolean hasPeeked) {
            ReaderJSONReader.this.setHasPeeked(hasPeeked);
        }

        public int getLineNumber() {
            return ReaderJSONReader.this.getLineNumber();
        }

        public int getPositionNumber() {
            return ReaderJSONReader.this.getPositionNumber();
        }
    }
}

