/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json.jpath;

import java.util.List;
import jsonij.json.Value;
import jsonij.json.jpath.PredicateComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SimpleIndexPredicate
extends PredicateComponent {
    public static final int LAST_INDEX = -1;
    int index;

    public SimpleIndexPredicate() {
        this.index = 0;
    }

    public SimpleIndexPredicate(int index) {
        this.index = index;
    }

    public boolean isLast() {
        return this.index == LAST_INDEX;
    }

    public void setLast() {
        this.index = LAST_INDEX;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public List<Value> evaluate(List<Value> values, List<Value> results) {
        if (this.isLast()) {
            int indexPredicate = -1;
            for (Value value : values) {
                indexPredicate = value.size() - 1;
                if (indexPredicate < 0) continue;
                results.add(value.get(indexPredicate));
            }
        } else {
            for (Value value : values) {
                if (this.getIndex() >= 0 && this.getIndex() < value.size()) {
                    results.add(value.get(this.getIndex()));
                    continue;
                }
                if (this.getIndex() >= 0 || value.size() + this.getIndex() < 0) continue;
                results.add(value.get(value.size() + this.getIndex()));
            }
        }
        return results;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SimpleIndexPredicate other = (SimpleIndexPredicate)obj;
        return this.index == other.index;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.index;
        return hash;
    }
}

