/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import jsonij.json.ConstantUtility;
import jsonij.json.JSONReader;
import jsonij.parser.ParserException;
import jsonij.parser.Position;
import jsonij.parser.ReaderParser;

public class StringJSONReader
extends JSONReader {
    protected final String jsonString;
    protected int index;
    protected int length;
    protected StringJSONStringReader stringReader;

    public StringJSONReader(String jsonString) {
        if (jsonString == null) {
            throw new NullPointerException("Null String Exception.");
        }
        this.jsonString = jsonString;
        this.length = jsonString.length();
        this.index = 0;
    }

    public int readNext() throws IOException, ParserException {
        int r = -1;
        while (this.index < this.length) {
            r = this.jsonString.charAt(this.index++);
            this.position.movePosition();
            if (ConstantUtility.isReturn(r)) {
                this.handleNewLine();
                r = this.jsonString.charAt(this.index++);
                if (this.index < this.length && ConstantUtility.isNewLine(r)) {
                    r = this.jsonString.charAt(this.index++);
                }
            } else if (ConstantUtility.isNewLine(r)) {
                this.handleNewLine();
                r = this.jsonString.charAt(this.index++);
                if (this.index < this.length && ConstantUtility.isReturn(r)) {
                    r = this.jsonString.charAt(this.index++);
                }
            }
            if (ConstantUtility.isWhiteSpace(r)) continue;
            break;
        }
        return r;
    }

    public ReaderParser getStringReader() {
        if (this.stringReader == null) {
            this.stringReader = new StringJSONStringReader();
        } else if (this.stringReader.isActive()) {
            // empty if block
        }
        this.stringReader.setActive(true);
        return this.stringReader;
    }

    protected class StringJSONStringReader
    implements ReaderParser {
        protected boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        public int peek() throws IOException {
            if (StringJSONReader.this.stringReader == null || !this.active) {
                // empty if block
            }
            if (!StringJSONReader.this.hasPeeked) {
                StringJSONReader.this.peekValue = this.readNext();
                StringJSONReader.this.hasPeeked = true;
            }
            return StringJSONReader.this.peekValue;
        }

        public int read() throws IOException {
            if (StringJSONReader.this.stringReader == null || !this.active) {
                // empty if block
            }
            if (StringJSONReader.this.hasPeeked) {
                StringJSONReader.this.hasPeeked = false;
                return StringJSONReader.this.peekValue;
            }
            return this.readNext();
        }

        public void close() {
            this.active = false;
        }

        protected int readNext() throws IOException {
            if (StringJSONReader.this.jsonString == null) {
                throw new NullPointerException("Null String Exception.");
            }
            int r = -1;
            if (StringJSONReader.this.index < StringJSONReader.this.length) {
                r = StringJSONReader.this.jsonString.charAt(StringJSONReader.this.index++);
                StringJSONReader.this.position.movePosition();
            }
            return r;
        }

        public Position getPosition() {
            return StringJSONReader.this.getPosition();
        }

        public boolean isHasPeeked() {
            return StringJSONReader.this.isHasPeeked();
        }

        public boolean hasPeeked() {
            return StringJSONReader.this.hasPeeked();
        }

        public void setHasPeeked(boolean hasPeeked) {
            StringJSONReader.this.setHasPeeked(hasPeeked);
        }

        public int getLineNumber() {
            return StringJSONReader.this.getLineNumber();
        }

        public int getPositionNumber() {
            return StringJSONReader.this.getPositionNumber();
        }
    }
}

