/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Locale;
import jsonij.json.ConstantUtility;
import jsonij.json.Constants;
import jsonij.json.JSON;
import jsonij.json.JSONParserException;
import jsonij.json.JSONReader;
import jsonij.json.ReaderJSONReader;
import jsonij.json.StringJSONReader;
import jsonij.json.Value;
import jsonij.parser.ParserException;
import jsonij.parser.ReaderParser;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONParser {
    protected Locale locale = Locale.ENGLISH;

    public final Locale getLocale() {
        return this.locale;
    }

    public final Locale setLocale(Locale locale) {
        this.locale = locale;
        return this.locale;
    }

    public final Value parse(String targetString) throws IOException, ParserException {
        if (targetString == null) {
            throw new NullPointerException();
        }
        StringJSONReader target = new StringJSONReader(targetString);
        int r = target.peek();
        if (r == -1) {
            throw new JSONParserException("invalidEmpty", new Object[0]);
        }
        Value value = null;
        if (r == 123) {
            value = this.parseObject(target);
        } else if (r == 91) {
            value = this.parseArray(target);
        } else {
            throw new JSONParserException("invalidExpecting2", 123, 91, new Object[]{Character.valueOf((char)r)});
        }
        if (target.peek() != -1) {
            // empty if block
        }
        return value;
    }

    public final Value parse(Reader targetReader) throws IOException, ParserException {
        if (targetReader == null) {
            throw new NullPointerException();
        }
        ReaderJSONReader target = new ReaderJSONReader(targetReader);
        int r = target.peek();
        if (r == -1) {
            throw new JSONParserException("invalidEmpty", new Object[0]);
        }
        Value value = null;
        if (r == 123) {
            value = this.parseObject(target);
        } else if (r == 91) {
            value = this.parseArray(target);
        } else {
            throw new JSONParserException("invalidExpecting2", 123, 91, new Object[]{Character.valueOf((char)r)});
        }
        if (target.peek() != -1) {
            // empty if block
        }
        return value;
    }

    public final Value parseValue(String targetString) throws IOException, ParserException {
        if (targetString == null) {
            throw new NullPointerException();
        }
        StringJSONReader target = new StringJSONReader(targetString);
        return this.parseValue(target);
    }

    public final Value parseValue(JSONReader target) throws IOException, ParserException {
        Value value = null;
        if (target.peek() == 123) {
            value = this.parseObject(target);
        } else if (target.peek() == 91) {
            value = this.parseArray(target);
        } else if (target.peek() == 34) {
            value = this.parseString(target);
        } else if (ConstantUtility.isNumeric(target.peek())) {
            value = this.parseNumeric(target);
        } else if (target.peek() == "true".charAt(0)) {
            value = this.parseTrue(target);
        } else if (target.peek() == "false".charAt(0)) {
            value = this.parseFalse(target);
        } else if (target.peek() == "null".charAt(0)) {
            value = this.parseNull(target);
        } else {
            throw new JSONParserException("invalidUnexpected", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
        }
        return value;
    }

    public final JSON.Object<JSON.String, Value> parseObject(JSONReader target) throws IOException, ParserException {
        if (target.peek() != 123) {
            throw new JSONParserException("invalidObjectExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('{'), Character.valueOf((char)target.peek())});
        }
        target.read();
        JSON.Object<JSON.String, Value> value = new JSON.Object<JSON.String, Value>();
        if (target.peek() != 125) {
            JSON.String attributeName = this.parseString(target);
            if (target.peek() != 58) {
                throw new JSONParserException("invalidObjectExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)target.peek())});
            }
            target.read();
            Value attributeValue = this.parseValue(target);
            value.put(attributeName, attributeValue);
            while (target.peek() == 44) {
                target.read();
                attributeName = this.parseString(target);
                if (value.containsKey(attributeName)) {
                    throw new JSONParserException("invalidKeyAlreadyUsed", target.getLineNumber(), target.getPositionNumber(), new Object[]{attributeName});
                }
                if (target.peek() != 58) {
                    throw new JSONParserException("invalidObjectExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(':'), Character.valueOf((char)target.peek())});
                }
                target.read();
                attributeValue = this.parseValue(target);
                value.put(attributeName, attributeValue);
            }
        }
        if (target.peek() != 125) {
            throw new JSONParserException("invalidArrayExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('}'), Character.valueOf((char)target.peek())});
        }
        target.read();
        return value;
    }

    public final JSON.Array<Value> parseArray(JSONReader target) throws IOException, ParserException {
        if (target.peek() != 91) {
            throw new JSONParserException("invalidArrayExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('['), Character.valueOf((char)target.peek())});
        }
        target.read();
        JSON.Array<Value> value = new JSON.Array<Value>();
        if (target.peek() != 93) {
            Value arrayValue = this.parseValue(target);
            value.add(arrayValue);
            while (target.peek() == 44) {
                target.read();
                arrayValue = this.parseValue(target);
                value.add(arrayValue);
            }
        }
        if (target.peek() != 93) {
            throw new JSONParserException("invalidArrayExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf(']'), Character.valueOf((char)target.peek())});
        }
        target.read();
        return value;
    }

    public final JSON.String parseString(JSONReader target) throws IOException, ParserException {
        JSON.String value = null;
        if (target.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)target.peek())});
        }
        StringBuilder valueStringBuilder = new StringBuilder();
        ReaderParser targetString = target.getStringReader();
        targetString.read();
        while (targetString.peek() != 34) {
            if (targetString.peek() == 92) {
                targetString.read();
                switch (targetString.peek()) {
                    case 34: {
                        valueStringBuilder.append('\"');
                        targetString.read();
                        break;
                    }
                    case 92: {
                        valueStringBuilder.append('\\');
                        targetString.read();
                        break;
                    }
                    case 47: {
                        valueStringBuilder.append('/');
                        targetString.read();
                        break;
                    }
                    case 98: {
                        valueStringBuilder.append('\b');
                        targetString.read();
                        break;
                    }
                    case 102: {
                        valueStringBuilder.append('\f');
                        targetString.read();
                        break;
                    }
                    case 110: {
                        valueStringBuilder.append('\n');
                        targetString.read();
                        break;
                    }
                    case 114: {
                        valueStringBuilder.append('\r');
                        targetString.read();
                        break;
                    }
                    case 116: {
                        valueStringBuilder.append('\t');
                        targetString.read();
                        break;
                    }
                    case 117: {
                        targetString.read();
                        StringBuilder unicodeStringBuilder = new StringBuilder();
                        for (int i = 0; i < 4; ++i) {
                            if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                throw new JSONParserException("invalidStringHex", target.getLineNumber(), target.getPositionNumber(), new Object[]{targetString.peek()});
                            }
                            unicodeStringBuilder.append((char)targetString.read());
                        }
                        int unicodeInt = Integer.parseInt(unicodeStringBuilder.toString().toUpperCase(), 16);
                        if (Character.isHighSurrogate((char)unicodeInt)) {
                            String highSurrogateString = unicodeStringBuilder.toString();
                            int highSurrogate = unicodeInt;
                            unicodeStringBuilder = new StringBuilder();
                            if (targetString.peek() != 92) {
                                throw new JSONParserException("invalidStringMissingSurrogate", target.getLineNumber(), target.getPositionNumber(), new Object[]{92, targetString.peek()});
                            }
                            targetString.read();
                            if (targetString.peek() != 117) {
                                throw new JSONParserException("invalidStringMissingSurrogate", target.getLineNumber(), target.getPositionNumber(), new Object[]{117, targetString.peek()});
                            }
                            targetString.read();
                            for (int i = 0; i < 4; ++i) {
                                if (!ConstantUtility.isHexDigit(targetString.peek())) {
                                    throw new JSONParserException("invalidStringHex", target.getLineNumber(), target.getPositionNumber(), new Object[]{targetString.peek()});
                                }
                                unicodeStringBuilder.append((char)targetString.read());
                            }
                            String lowSurrogateString = unicodeStringBuilder.toString();
                            int lowSurrogate = Integer.parseInt(lowSurrogateString.toUpperCase(), 16);
                            if (Character.isSurrogatePair((char)highSurrogate, (char)lowSurrogate)) {
                                valueStringBuilder.append(new String(Character.toChars(Character.toCodePoint((char)highSurrogate, (char)lowSurrogate))));
                                break;
                            }
                            throw new JSONParserException("invalidStringSurrogates", target.getLineNumber(), target.getPositionNumber(), new Object[]{highSurrogateString, lowSurrogateString});
                        }
                        valueStringBuilder.append((char)unicodeInt);
                        break;
                    }
                    default: {
                        throw new JSONParserException("invalidStringEscape", target.getLineNumber(), target.getPositionNumber(), new Object[]{targetString.peek()});
                    }
                }
                continue;
            }
            if (ConstantUtility.isValidStringChar(targetString.peek())) {
                valueStringBuilder.append((char)targetString.read());
                continue;
            }
            throw new JSONParserException("invalidStringValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)targetString.peek())});
        }
        if (targetString.peek() != 34) {
            throw new JSONParserException("invalidStringExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf('\"'), Character.valueOf((char)targetString.peek())});
        }
        targetString.read();
        targetString.close();
        value = new JSON.String(valueStringBuilder.toString());
        return value;
    }

    public final JSON.Numeric parseNumeric(JSONReader target) throws IOException, ParserException {
        JSON.Numeric value = null;
        StringBuilder numericStringBuilder = new StringBuilder();
        boolean minusFlag = false;
        boolean decimalFlag = false;
        boolean exponetFlag = false;
        int beforeDecimalCount = 0;
        int afterDecimalCount = 0;
        if (target.peek() == 45) {
            minusFlag = true;
            target.read();
            numericStringBuilder.append('-');
            if (target.peek() < Constants.DIGITS[0] || target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
            }
        }
        if (target.peek() == Constants.DIGITS[0]) {
            numericStringBuilder.append((char)target.read());
            ++beforeDecimalCount;
        } else if (target.peek() >= Constants.DIGITS[1] && target.peek() <= Constants.DIGITS[9]) {
            numericStringBuilder.append((char)target.read());
            ++beforeDecimalCount;
            while (ConstantUtility.isDigit(target.peek())) {
                numericStringBuilder.append((char)target.read());
                ++beforeDecimalCount;
            }
        } else {
            throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
        }
        if (target.peek() == 46) {
            target.read();
            decimalFlag = true;
            numericStringBuilder.append('.');
            if (target.peek() < Constants.DIGITS[0] || target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
            }
            while (ConstantUtility.isDigit(target.peek())) {
                numericStringBuilder.append((char)target.read());
                ++afterDecimalCount;
            }
        }
        if (target.peek() == Constants.EXPS[0] || target.peek() == Constants.EXPS[1]) {
            target.read();
            exponetFlag = true;
            numericStringBuilder.append(Constants.EXPS[1]);
            if (target.peek() == 45) {
                target.read();
                numericStringBuilder.append('-');
            } else if (target.peek() == 43) {
                target.read();
                numericStringBuilder.append('+');
            } else {
                numericStringBuilder.append('+');
            }
            if (target.peek() < Constants.DIGITS[0] || target.peek() > Constants.DIGITS[9]) {
                throw new JSONParserException("invalidNumericExpecting1", target.getLineNumber(), target.getPositionNumber(), new Object[]{Character.valueOf((char)target.peek())});
            }
            while (ConstantUtility.isDigit(target.peek())) {
                numericStringBuilder.append((char)target.read());
            }
        }
        value = !decimalFlag && !exponetFlag ? (beforeDecimalCount < 18 ? new JSON.Numeric(Long.parseLong(numericStringBuilder.toString())) : new JSON.Numeric(new BigInteger(numericStringBuilder.toString()))) : (beforeDecimalCount + afterDecimalCount < 18 ? new JSON.Numeric(Double.parseDouble(numericStringBuilder.toString())) : new JSON.Numeric(new BigDecimal(numericStringBuilder.toString())));
        return value;
    }

    public final JSON.True parseTrue(JSONReader target) throws IOException, ParserException {
        JSON.True value = null;
        for (int i = 0; i < "true".length(); ++i) {
            if (target.peek() != "true".charAt(i)) {
                throw new JSONParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"true", Character.valueOf((char)target.peek())});
            }
            target.read();
        }
        value = JSON.TRUE;
        return value;
    }

    public final JSON.False parseFalse(JSONReader target) throws IOException, ParserException {
        JSON.False value = null;
        for (int i = 0; i < "false".length(); ++i) {
            if (target.peek() != "false".charAt(i)) {
                throw new JSONParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"false", Character.valueOf((char)target.peek())});
            }
            target.read();
        }
        value = JSON.FALSE;
        return value;
    }

    public final JSON.Null parseNull(JSONReader target) throws IOException, ParserException {
        JSON.Null value = null;
        for (int i = 0; i < "null".length(); ++i) {
            if (target.peek() != "null".charAt(i)) {
                throw new JSONParserException("invalidValue", target.getLineNumber(), target.getPositionNumber(), new Object[]{"null", Character.valueOf((char)target.peek())});
            }
            target.read();
        }
        value = JSON.NULL;
        return value;
    }
}

