/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsonij.json.JSONCodec;
import jsonij.json.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONCodecStore {
    public static final String CREATE_INSTANCE_METHOD_SIGNATURE = "createInstance";
    public static final String ENCODE_METHOD_SIGNATURE = "encode";
    public static final String DECODE_METHOD_SIGNATURE = "decode";
    List<Class<?>> codecList = new ArrayList();
    Map<Class<?>, JSONCodec<?>> codecInstanceMap = new HashMap();

    public int size() {
        return this.codecList.size();
    }

    public boolean isEmpty() {
        return this.codecList.isEmpty();
    }

    public void printSuperClasses(Class<?> c) {
        String pad = "";
        do {
            TypeVariable<Class<?>>[] types;
            String typeString = "";
            for (TypeVariable<Class<?>> type : types = c.getTypeParameters()) {
                typeString = typeString + type.getBounds()[0];
            }
            System.out.println(String.format("%s%s<%s>", pad, c, typeString));
            pad = pad + " ";
        } while ((c = c.getSuperclass()) != null);
    }

    public Class<?>[] getTypeParameterSet(Class<?> codec) {
        TypeVariable<Class<?>>[] types;
        Class[] typeParameterSet = null;
        Class typeParameter = null;
        for (TypeVariable<Class<?>> type : types = codec.getTypeParameters()) {
            typeParameter = (Class)type.getBounds()[0];
        }
        typeParameterSet = new Class[]{typeParameter};
        return typeParameterSet;
    }

    public void registerCodec(Class<?> codec) {
        Object codecInstance = null;
        Method genericCodecCreateMethod = null;
        Class<?> codecType = null;
        JSONCodec genericCodecInstance = null;
        try {
            codecInstance = codec.newInstance();
            genericCodecCreateMethod = codec.getMethod(CREATE_INSTANCE_METHOD_SIGNATURE, new Class[0]);
            genericCodecInstance = (JSONCodec)genericCodecCreateMethod.invoke(codecInstance, new Object[0]);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        genericCodecInstance.setCodecHash(codec.hashCode());
        if (genericCodecInstance != null) {
            // empty if block
        }
        Method encodeMethod = null;
        Method decodeMethod = null;
        Class<?>[] typeParameterSet = this.getTypeParameterSet(codec);
        if (typeParameterSet == null || Array.getLength(typeParameterSet) == 0) {
            typeParameterSet = new Class[]{Object.class};
        }
        for (Class<?> typeParameter : typeParameterSet) {
            try {
                encodeMethod = genericCodecInstance.getClass().getMethod(ENCODE_METHOD_SIGNATURE, typeParameter);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (encodeMethod == null) continue;
            codecType = typeParameter;
            break;
        }
        try {
            decodeMethod = genericCodecInstance.getClass().getMethod(DECODE_METHOD_SIGNATURE, Value.class);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (SecurityException ex) {
            Logger.getLogger(JSONCodecStore.class.getName()).log(Level.SEVERE, null, ex);
        }
        if (encodeMethod != null && decodeMethod != null) {
            genericCodecInstance.setEncodeMethod(encodeMethod);
            genericCodecInstance.setDecodeMethod(decodeMethod);
            this.codecList.add(codec);
            this.codecInstanceMap.put(codecType, genericCodecInstance);
        }
    }

    public void registerCodec(Class<?> type, Class<?> codec) {
    }

    public void deregisterCodec(Class<?> codec) {
        if (this.codecList.contains(codec)) {
            int codecHash = codec.hashCode();
            for (Class<?> codecType : this.codecInstanceMap.keySet()) {
                JSONCodec<?> codecInstance = this.codecInstanceMap.get(codecType);
                if (codecInstance.getCodecHash() != codecHash) continue;
                this.codecInstanceMap.remove(codecType);
                this.codecList.remove(codec);
                break;
            }
        }
    }

    public boolean hasCodec(Class<?> type) {
        if (this.codecInstanceMap.containsKey(type)) {
            return true;
        }
        Class<?> parent = type.getSuperclass();
        do {
            if (!this.codecInstanceMap.containsKey(parent)) continue;
            return true;
        } while ((parent = type.getSuperclass()) != null);
        return false;
    }

    public JSONCodec<?> getCodec(Class<?> type) {
        if (this.codecInstanceMap.containsKey(type)) {
            return this.codecInstanceMap.get(type);
        }
        Class<?> parent = type.getSuperclass();
        do {
            if (!this.codecInstanceMap.containsKey(parent)) continue;
            return this.codecInstanceMap.get(parent);
        } while ((parent = type.getSuperclass()) != null);
        return null;
    }
}

