/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json.jpath;

import java.lang.reflect.Array;
import java.util.ArrayList;
import jsonij.json.JSON;
import jsonij.json.Value;
import jsonij.json.jpath.Component;
import jsonij.json.jpath.JPathRuntimeException;
import jsonij.json.jpath.SearchComponent;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPathImp<C extends Component>
extends ArrayList<C> {
    boolean recordEvaluateTime = false;
    long lastEvaluateTime = -1L;

    public Value evaluate(JSON json) throws JPathRuntimeException {
        Value value = json.getRoot();
        return this.evaluate(value);
    }

    public Value[] evaluateAll(JSON json) throws JPathRuntimeException {
        Value value = json.getRoot();
        return this.evaluateAll(value);
    }

    public Value evaluate(Value value) throws JPathRuntimeException {
        Value[] returnValues = this.evaluateAll(value);
        if (Array.getLength(returnValues) > 0) {
            return returnValues[0];
        }
        return null;
    }

    public Value[] evaluateAll(Value value) throws JPathRuntimeException {
        long startTime = 0L;
        long finishTime = -1L;
        if (this.recordEvaluateTime) {
            startTime = System.nanoTime();
        }
        ArrayList<Value> currentValues = new ArrayList<Value>();
        ArrayList<Value> nextValues = null;
        currentValues.add(value);
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Component c = (Component)this.get(i);
            nextValues = new ArrayList<Value>();
            if (c.getClass() == SearchComponent.class) {
                throw new JPathRuntimeException("notSupported", SearchComponent.class);
            }
            c.evaluate(currentValues, nextValues);
            currentValues = nextValues;
            ++count;
        }
        if (this.recordEvaluateTime) {
            finishTime = System.nanoTime();
            this.lastEvaluateTime = finishTime - startTime;
        }
        int size = currentValues.size();
        Value[] returnValues = new Value[size];
        for (int i = 0; i < size; ++i) {
            returnValues[i] = currentValues.get(i);
        }
        return returnValues;
    }

    public boolean isRecordEvaluateTime() {
        return this.recordEvaluateTime;
    }

    public void setRecordEvaluateTime(boolean recordEvaluateTime) {
        this.recordEvaluateTime = recordEvaluateTime;
    }

    public long getLastEvaluateTime() {
        return this.lastEvaluateTime / 1000L;
    }
}

