/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.Serializable;
import jsonij.json.JSON;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Value
implements Serializable,
Comparable<Value> {
    protected TYPE valueType = this.type();

    public Value() {
        if (this.valueType == null) {
            throw new NullPointerException("type() method must be implemented and return a valid type.");
        }
    }

    protected abstract TYPE type();

    public TYPE getValueType() {
        return this.valueType;
    }

    public int size() {
        switch (this.valueType) {
            case STRING: {
                return ((JSON.String)this).length();
            }
            case ARRAY: {
                return ((JSON.Array)this).size();
            }
            case OBJECT: {
                return ((JSON.Object)this).size();
            }
        }
        return -1;
    }

    public abstract int nestedSize();

    public boolean isNull() {
        switch (this.valueType) {
            case NULL: {
                return true;
            }
        }
        return !this.getBoolean();
    }

    public boolean getBoolean() {
        boolean result = false;
        switch (this.valueType) {
            case TRUE: {
                result = true;
                break;
            }
            case FALSE: {
                result = false;
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).intValue() != 0;
                break;
            }
            case STRING: {
                result = ((JSON.String)this).length() != 0;
                break;
            }
            case ARRAY: {
                result = ((JSON.Array)this).size() != 0;
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).size() != 0;
            }
        }
        return result;
    }

    public int getInt() {
        int result = -1;
        switch (this.valueType) {
            case TRUE: {
                result = 1;
                break;
            }
            case FALSE: {
                result = 0;
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).intValue();
                break;
            }
            case STRING: {
                result = Integer.parseInt(this.toString());
            }
        }
        return result;
    }

    public double getDouble() {
        double result = -1.0;
        switch (this.valueType) {
            case TRUE: {
                result = 1.0;
                break;
            }
            case FALSE: {
                result = 0.0;
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).doubleValue();
                break;
            }
            case STRING: {
                result = Double.parseDouble(this.toString());
            }
        }
        return result;
    }

    public Number getNumber() {
        Number result = -1.0;
        switch (this.valueType) {
            case TRUE: {
                result = 1.0;
                break;
            }
            case FALSE: {
                result = 0.0;
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).getNumber();
                break;
            }
            case STRING: {
                result = Double.parseDouble(this.toString());
            }
        }
        return result;
    }

    public String getString() {
        String result = null;
        switch (this.valueType) {
            case TRUE: {
                result = "true";
                break;
            }
            case FALSE: {
                result = "false";
                break;
            }
            case NUMERIC: {
                result = ((JSON.Numeric)this).toString();
                break;
            }
            case STRING: {
                result = this.toString();
            }
        }
        return result;
    }

    public Value get(int i) {
        Object result = null;
        switch (this.valueType) {
            case ARRAY: {
                result = ((JSON.Array)this).get(i);
                break;
            }
            case OBJECT: {
                result = ((JSON.Object)this).get(i);
            }
        }
        return result;
    }

    public boolean has(String key) {
        boolean result = false;
        switch (this.valueType) {
            case OBJECT: {
                result = ((JSON.Object)this).containsKey(new JSON.String(key));
            }
        }
        return result;
    }

    public Value get(String key) {
        Object result = null;
        switch (this.valueType) {
            case OBJECT: {
                result = ((JSON.Object)this).get(new JSON.String(key));
            }
        }
        return result;
    }

    public abstract String toJSON();

    public String toString() {
        return this.toJSON();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Value o = (Value)obj;
        boolean equalsResult = false;
        if (this.type() == TYPE.OBJECT) {
            if (o.type() == TYPE.OBJECT) {
                if (o.size() == this.size()) {
                    equalsResult = true;
                    for (int i = 0; i < this.size(); ++i) {
                        if (this.get(i).equals(o.get(i))) continue;
                        equalsResult = false;
                        break;
                    }
                } else {
                    equalsResult = false;
                }
            } else {
                equalsResult = this.toString().equals(o.toString());
            }
        } else if (this.type() == TYPE.ARRAY) {
            if (o.type() == TYPE.ARRAY) {
                if (o.size() == this.size()) {
                    equalsResult = true;
                    for (int i = 0; i < this.size(); ++i) {
                        if (this.get(i).equals(o.get(i))) continue;
                        equalsResult = false;
                        break;
                    }
                } else {
                    equalsResult = false;
                }
            } else {
                equalsResult = this.toString().equals(o.toString());
            }
        } else if (this.type() == TYPE.NULL) {
            equalsResult = this.isNull() && o.isNull();
        } else if (this.type() == TYPE.TRUE || this.type() == TYPE.FALSE) {
            equalsResult = this.getBoolean() == o.getBoolean();
        } else if (this.type() == TYPE.NUMERIC) {
            equalsResult = this.getDouble() == o.getDouble();
        } else if (this.type() == TYPE.STRING) {
            equalsResult = this.getString().equals(o.getString());
        }
        return equalsResult;
    }

    public int hashCode() {
        int hash = 7;
        hash = 13 * hash + (this.valueType != null ? this.valueType.hashCode() : 0);
        if (this.type() == TYPE.OBJECT) {
            for (int i = 0; i < this.size(); ++i) {
                hash = 13 * hash + this.get(i).hashCode();
            }
        } else if (this.type() == TYPE.ARRAY) {
            for (int i = 0; i < this.size(); ++i) {
                hash = 13 * hash + this.get(i).hashCode();
            }
        } else if (this.type() == TYPE.NULL) {
            hash = 13 * hash + JSON.NULL.hashCode();
        } else if (this.type() == TYPE.TRUE) {
            hash = 13 * hash + JSON.TRUE.hashCode();
        } else if (this.type() == TYPE.FALSE) {
            hash = 13 * hash + JSON.FALSE.hashCode();
        } else if (this.type() == TYPE.NUMERIC) {
            hash = 13 * hash + this.getNumber().hashCode();
        } else if (this.type() == TYPE.STRING) {
            hash = 13 * hash + this.getString().hashCode();
        }
        return hash;
    }

    @Override
    public int compareTo(Value o) {
        int compare = 0;
        if (this.type() == TYPE.OBJECT) {
            compare = this.type() == TYPE.NULL || this.type() == TYPE.TRUE || this.type() == TYPE.FALSE ? 1 : this.toJSON().compareTo(o.toJSON());
        } else if (this.type() == TYPE.ARRAY) {
            compare = this.type() == TYPE.NULL || this.type() == TYPE.TRUE || this.type() == TYPE.FALSE || this.type() == TYPE.OBJECT ? 1 : this.toJSON().compareTo(o.toJSON());
        } else if (this.type() == TYPE.NULL) {
            compare = o.type() == TYPE.NULL ? 0 : -1;
        } else if (this.type() == TYPE.TRUE) {
            compare = o.type() == TYPE.NULL ? 1 : (o.type() == TYPE.TRUE ? 0 : -1);
        } else if (this.type() == TYPE.FALSE) {
            compare = o.type() == TYPE.NULL ? 1 : (o.type() == TYPE.TRUE ? 1 : (o.type() == TYPE.FALSE ? 0 : -1));
        } else if (this.type() == TYPE.NUMERIC) {
            double thatDouble;
            double thisDouble = this.getDouble();
            if (thisDouble < (thatDouble = o.getDouble())) {
                compare = -1;
            } else if (thisDouble == thatDouble) {
                compare = 0;
            } else if (thisDouble > thatDouble) {
                compare = 1;
            }
        } else if (this.type() == TYPE.STRING) {
            compare = this.getString().compareTo(o.getString());
        }
        return compare;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        OBJECT,
        ARRAY,
        STRING,
        NUMERIC,
        TRUE,
        FALSE,
        NULL;

    }
}

