/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsonij.json.ConstantUtility;
import jsonij.parser.ReaderParser;

public class JSONReader
extends ReaderParser {
    JSONStringReader stringReader = null;
    static final Logger logger = Logger.getLogger(JSONReader.class.getName());

    public JSONReader() {
        this(null);
    }

    public JSONReader(Reader reader) {
        super(reader);
    }

    protected int readNext() throws IOException {
        if (logger.isLoggable(Level.FINER)) {
            logger.entering(this.getClass().getName(), "readIgnoreWhiteSpace()");
        }
        if (this.reader == null) {
            throw new NullPointerException("Null Reader Exception.");
        }
        int r = -1;
        while (this.reader.ready() && (r = this.reader.read()) != -1) {
            this.getPosition().tickReadCount();
            this.getPosition().movePosition();
            if (ConstantUtility.isNewLine(r)) {
                this.handleNewLine();
                continue;
            }
            if (ConstantUtility.isWhiteSpace(r)) continue;
        }
        if (logger.isLoggable(Level.FINER)) {
            logger.exiting(this.getClass().getName(), "readIgnoreWhiteSpace()", r);
        }
        return r;
    }

    public JSONStringReader getStringReader() {
        if (this.stringReader == null) {
            this.stringReader = new JSONStringReader();
        }
        return this.stringReader;
    }

    protected class JSONStringReader {
        protected boolean active = true;

        public boolean isActive() {
            return this.active;
        }

        protected void setActive(boolean active) {
            this.active = active;
        }

        public int peek() throws IOException {
            if (JSONReader.this.stringReader == null || !this.active) {
                // empty if block
            }
            if (!JSONReader.this.hasPeeked) {
                JSONReader.this.peekValue = this.readNext();
                JSONReader.this.hasPeeked = true;
            }
            return JSONReader.this.peekValue;
        }

        public int read() throws IOException {
            if (JSONReader.this.stringReader == null || !this.active) {
                // empty if block
            }
            if (JSONReader.this.hasPeeked) {
                JSONReader.this.hasPeeked = false;
                return JSONReader.this.peekValue;
            }
            return this.readNext();
        }

        public void close() throws IOException {
            JSONReader.this.stringReader = null;
            this.active = false;
        }

        protected int readNext() throws IOException {
            String method = "readIgnoreWhiteSpace()";
            if (logger.isLoggable(Level.FINER)) {
                logger.entering(this.getClass().getName(), method);
            }
            if (JSONReader.this.reader == null) {
                throw new NullPointerException("Null Reader Exception.");
            }
            int r = -1;
            while (JSONReader.this.reader.ready() && (r = JSONReader.this.reader.read()) != -1) {
                JSONReader.this.getPosition().tickReadCount();
                JSONReader.this.getPosition().movePosition();
                if (!ConstantUtility.isNewLine(r)) break;
                JSONReader.this.handleNewLine();
            }
            if (logger.isLoggable(Level.FINER)) {
                logger.exiting(this.getClass().getName(), method, r);
            }
            return r;
        }
    }
}

