/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jsonij.json.Inspector;
import jsonij.json.JSON;
import jsonij.json.JSONCodec;
import jsonij.json.JSONCodecStore;
import jsonij.json.Value;
import jsonij.json.annotation.JSONEncoder;
import jsonij.parser.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONMarshaler {
    static JSONCodecStore codecStore;

    public static JSON marshalObject(Object o) {
        Value object = null;
        object = o instanceof List ? JSONMarshaler.marshalListType(o) : (o instanceof Map ? JSONMarshaler.marshalMapType(o) : JSONMarshaler.marshalObjectType(o));
        if (object == null) {
            object = new JSON.Object();
        }
        return new JSON(object);
    }

    public static JSON marshalObject(boolean[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Boolean> jsonArray = new JSON.Array<JSON.Boolean>();
        for (int i = 0; i < size; ++i) {
            if (a[i]) {
                jsonArray.add(JSON.TRUE);
                continue;
            }
            jsonArray.add(JSON.FALSE);
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Boolean[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Boolean> jsonArray = new JSON.Array<JSON.Boolean>();
        for (int i = 0; i < size; ++i) {
            if (a[i].booleanValue()) {
                jsonArray.add(JSON.TRUE);
                continue;
            }
            jsonArray.add(JSON.FALSE);
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(int[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Integer[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(char[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.String> jsonArray = new JSON.Array<JSON.String>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.String("" + a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Character[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.String> jsonArray = new JSON.Array<JSON.String>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.String("" + a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(double[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Double[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(float[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(Float.valueOf(a[i])));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Float[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(short[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Short[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(long[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Long[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Numeric> jsonArray = new JSON.Array<JSON.Numeric>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.Numeric(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(String[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.String> jsonArray = new JSON.Array<JSON.String>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add(new JSON.String(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static JSON marshalObject(Object[] a) {
        int size = 0;
        size = Array.getLength(a);
        if (size == 0) {
            return new JSON(new JSON.Array());
        }
        JSON.Array<JSON.Object> jsonArray = new JSON.Array<JSON.Object>();
        for (int i = 0; i < size; ++i) {
            jsonArray.add((JSON.Object)JSONMarshaler.marshalObjectType(a[i]));
        }
        return new JSON(jsonArray);
    }

    public static Value marshalAnyObject(Object o) {
        Value value = null;
        if (o == null) {
            return JSON.NULL;
        }
        Class<?> marshaledObjectClass = o.getClass();
        TYPE type = JSONMarshaler.isBooleanJSONType(marshaledObjectClass);
        if (type != TYPE.NA) {
            value = JSONMarshaler.marshalBooleanType(o);
        } else {
            type = JSONMarshaler.isNumericJSONType(marshaledObjectClass);
            if (type != TYPE.NA) {
                value = JSONMarshaler.marshalNumericType(o);
            } else {
                type = JSONMarshaler.isStringJSONType(marshaledObjectClass);
                if (type != TYPE.NA) {
                    value = JSONMarshaler.marshalStringType(o);
                } else {
                    type = JSONMarshaler.isArrayJSONType(marshaledObjectClass);
                    if (type != TYPE.NA) {
                        if (type == TYPE.ARRAY) {
                            value = JSONMarshaler.marshalArrayType(o);
                        } else if (type == TYPE.LIST) {
                            value = JSONMarshaler.marshalListType(o);
                        }
                    } else {
                        type = JSONMarshaler.isObjectJSONType(marshaledObjectClass);
                        if (type != TYPE.NA) {
                            if (type == TYPE.MAP) {
                                value = JSONMarshaler.marshalMapType(o);
                            } else if (type == TYPE.OBJECT) {
                                value = JSONMarshaler.marshalObjectType(o);
                            }
                        } else {
                            value = new JSON.String(o.getClass().getCanonicalName() + "@" + Integer.toHexString(o.hashCode()));
                        }
                    }
                }
            }
        }
        return value;
    }

    public static TYPE isBooleanJSONType(Class<?> c) {
        return c == Boolean.class || c == Boolean.TYPE ? TYPE.BOOLEAN : TYPE.NA;
    }

    public static TYPE isNumericJSONType(Class<?> c) {
        if (c == Integer.TYPE || c == Integer.class) {
            return TYPE.NUMERIC;
        }
        if (c == Double.TYPE || c == Double.class) {
            return TYPE.NUMERIC;
        }
        if (c == Float.TYPE || c == Float.class) {
            return TYPE.NUMERIC;
        }
        if (c == Long.TYPE || c == Long.class) {
            return TYPE.NUMERIC;
        }
        if (c == Short.TYPE || c == Short.class) {
            return TYPE.NUMERIC;
        }
        return TYPE.NA;
    }

    public static TYPE isStringJSONType(Class<?> c) {
        if (c == String.class) {
            return TYPE.STRING;
        }
        if (c == Character.TYPE || c == Character.class) {
            return TYPE.STRING;
        }
        return TYPE.NA;
    }

    public static TYPE isArrayJSONType(Class<?> c) {
        if (c.isArray()) {
            return TYPE.ARRAY;
        }
        Class<?>[] interfaces = c.getInterfaces();
        for (int i = 0; i < Array.getLength(interfaces); ++i) {
            if (interfaces[i] != List.class) continue;
            return TYPE.LIST;
        }
        return TYPE.NA;
    }

    public static TYPE isObjectJSONType(Class<?> c) {
        Inspector inspect = new Inspector(c);
        inspect.inspect();
        Inspector.InspectorProperty[] inspectProperties = inspect.getProperties();
        if (inspectProperties != null) {
            for (int i = 0; i < Array.getLength(inspectProperties); ++i) {
                if (!inspectProperties[i].isValid()) continue;
                return TYPE.OBJECT;
            }
        }
        return TYPE.NA;
    }

    public static Value marshalBooleanType(Object o) {
        JSON.Boolean value = null;
        boolean booleanValue = (Boolean)o;
        value = booleanValue ? JSON.TRUE : JSON.FALSE;
        return value;
    }

    public static Value marshalNumericType(Object o) {
        Value value = null;
        Number marshaledNumber = null;
        marshaledNumber = (Number)o;
        value = marshaledNumber != null ? new JSON.Numeric(marshaledNumber) : JSON.NULL;
        return value;
    }

    public static Value marshalStringType(Object o) {
        Value value = null;
        String marshaledString = null;
        marshaledString = (String)o;
        value = marshaledString != null ? new JSON.String(marshaledString) : JSON.NULL;
        return value;
    }

    public static Value marshalArrayType(Object o) {
        Value value = null;
        Object marshaledArray = o;
        if (marshaledArray != null) {
            JSON.Array<Value> jsonArray = new JSON.Array<Value>();
            int size = Array.getLength(marshaledArray);
            Class<?> type = marshaledArray.getClass();
            Class<?> componentType = type.getComponentType();
            if (componentType == Integer.TYPE || componentType == Integer.class) {
                for (int i = 0; i < size; ++i) {
                    jsonArray.add(new JSON.Numeric(Array.getInt(marshaledArray, i)));
                }
            } else if (componentType == Double.TYPE || componentType == Double.class) {
                for (int i = 0; i < size; ++i) {
                    jsonArray.add(new JSON.Numeric(Array.getDouble(marshaledArray, i)));
                }
            } else if (componentType == Float.TYPE || componentType == Float.class) {
                for (int i = 0; i < size; ++i) {
                    jsonArray.add(new JSON.Numeric(Float.valueOf(Array.getFloat(marshaledArray, i))));
                }
            } else if (componentType == Short.TYPE || componentType == Short.class) {
                for (int i = 0; i < size; ++i) {
                    jsonArray.add(new JSON.Numeric(Array.getShort(marshaledArray, i)));
                }
            } else if (componentType == Long.TYPE || componentType == Long.class) {
                for (int i = 0; i < size; ++i) {
                    jsonArray.add(new JSON.Numeric(Array.getLong(marshaledArray, i)));
                }
            } else {
                for (int i = 0; i < size; ++i) {
                    Object arrayValue = Array.get(marshaledArray, i);
                    jsonArray.add(JSONMarshaler.marshalAnyObject(arrayValue));
                }
            }
            value = jsonArray;
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    public static Value marshalListType(Object o) {
        Value value = null;
        List marshaledList = (List)o;
        if (marshaledList != null) {
            JSON.Array<Value> jsonArray = new JSON.Array<Value>();
            ListIterator marshaledListIterator = marshaledList.listIterator();
            Object listItem = null;
            while (marshaledListIterator.hasNext()) {
                listItem = marshaledListIterator.next();
                if (listItem == null) {
                    jsonArray.add(JSON.NULL);
                    continue;
                }
                jsonArray.add(JSONMarshaler.marshalAnyObject(listItem));
            }
            value = jsonArray;
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    public static Value marshalObjectType(Object o) {
        Method[] methods;
        Class<?> objectClass = o.getClass();
        for (Method method : methods = objectClass.getDeclaredMethods()) {
            if (method.getAnnotation(JSONEncoder.class) == null) continue;
        }
        if (codecStore != null && codecStore.hasCodec(objectClass)) {
            JSONCodec<?> codec = codecStore.getCodec(objectClass);
            Value value = codec.encode(o);
            return value;
        }
        JSON.Object<JSON.String, JSON.Null> jsonObject = new JSON.Object<JSON.String, JSON.Null>();
        Inspector inspector = new Inspector(o);
        inspector.inspect();
        Inspector.InspectorProperty[] properties = inspector.getProperties();
        String name = null;
        Value value = null;
        for (Inspector.InspectorProperty property : properties) {
            String accessorName;
            if (property.isIgnore() || !property.isValid()) continue;
            name = property.getName();
            if (property.getAccessType() == Inspector.InspectorProperty.TYPE.METHOD) {
                accessorName = property.getAccessName();
                try {
                    Method method = objectClass.getMethod(accessorName, new Class[0]);
                    value = JSONMarshaler.marshalObjectMethodValue(method, o);
                }
                catch (NoSuchMethodException ex) {
                    value = new JSON.String(ex.toString());
                }
                catch (SecurityException ex) {
                    value = new JSON.String(ex.toString());
                }
            } else if (property.getAccessType() == Inspector.InspectorProperty.TYPE.FIELD) {
                accessorName = property.getAccessName();
                try {
                    Field field = objectClass.getField(accessorName);
                    value = JSONMarshaler.marshalObjectFieldValue(field, o);
                }
                catch (NoSuchFieldException ex) {
                    value = new JSON.String(ex.toString());
                }
                catch (SecurityException ex) {
                    value = new JSON.String(ex.toString());
                }
            } else {
                value = JSON.NULL;
            }
            jsonObject.put(new JSON.String(name), (JSON.Null)value);
        }
        return jsonObject;
    }

    public static Value marshalMapType(Object o) {
        Value value = null;
        Map marshaledMap = (Map)o;
        if (marshaledMap != null) {
            JSON.Object<JSON.String, Value> jsonObject = new JSON.Object<JSON.String, Value>();
            for (Object keyObject : marshaledMap.keySet()) {
                Object valueObject = marshaledMap.get(keyObject);
                jsonObject.put(new JSON.String(keyObject.toString()), JSONMarshaler.marshalAnyObject(valueObject));
            }
            value = jsonObject;
        } else {
            value = JSON.NULL;
        }
        return value;
    }

    public static Value marshalObjectMethodValue(Method method, Object o) {
        Value value = null;
        Class<?> marshaledObjectClass = method.getReturnType();
        Object marshaledObject = null;
        try {
            marshaledObject = method.invoke(o, new Object[0]);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        TYPE type = JSONMarshaler.isBooleanJSONType(marshaledObjectClass);
        if (type != TYPE.NA) {
            value = JSONMarshaler.marshalBooleanType(marshaledObject);
        } else {
            type = JSONMarshaler.isNumericJSONType(marshaledObjectClass);
            if (type != TYPE.NA) {
                value = JSONMarshaler.marshalNumericType(marshaledObject);
            } else {
                type = JSONMarshaler.isStringJSONType(marshaledObjectClass);
                if (type != TYPE.NA) {
                    value = JSONMarshaler.marshalStringType(marshaledObject);
                } else {
                    type = JSONMarshaler.isArrayJSONType(marshaledObjectClass);
                    if (type != TYPE.NA) {
                        if (type == TYPE.ARRAY) {
                            value = JSONMarshaler.marshalArrayType(marshaledObject);
                        } else if (type == TYPE.LIST) {
                            value = JSONMarshaler.marshalListType(marshaledObject);
                        }
                    } else {
                        type = JSONMarshaler.isObjectJSONType(marshaledObjectClass);
                        if (type != TYPE.NA) {
                            if (type == TYPE.MAP) {
                                value = new JSON.String("Map!");
                            } else if (type == TYPE.OBJECT) {
                                value = JSONMarshaler.marshalObjectType(marshaledObject);
                            }
                        } else {
                            value = marshaledObject != null ? new JSON.String(marshaledObject.getClass().getCanonicalName() + "@" + Integer.toHexString(marshaledObject.hashCode())) : new JSON.String(String.format("UKNOWN Value for field %s", method.getName()));
                        }
                    }
                }
            }
        }
        return value;
    }

    public static Value marshalObjectFieldValue(Field field, Object o) {
        Value value = null;
        Class<?> marshaledObjectClass = field.getType();
        Object marshaledObject = null;
        try {
            marshaledObject = field.get(o);
        }
        catch (IllegalArgumentException ex) {
            Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            return null;
        }
        TYPE type = JSONMarshaler.isBooleanJSONType(marshaledObjectClass);
        if (type != TYPE.NA) {
            value = JSONMarshaler.marshalBooleanType(marshaledObject);
        } else {
            type = JSONMarshaler.isNumericJSONType(marshaledObjectClass);
            if (type != TYPE.NA) {
                value = JSONMarshaler.marshalNumericType(marshaledObject);
            } else {
                type = JSONMarshaler.isStringJSONType(marshaledObjectClass);
                if (type != TYPE.NA) {
                    value = JSONMarshaler.marshalStringType(marshaledObject);
                } else {
                    type = JSONMarshaler.isArrayJSONType(marshaledObjectClass);
                    if (type != TYPE.NA) {
                        if (type == TYPE.ARRAY) {
                            value = JSONMarshaler.marshalArrayType(marshaledObject);
                        } else if (type == TYPE.LIST) {
                            value = JSONMarshaler.marshalListType(marshaledObject);
                        }
                    } else {
                        type = JSONMarshaler.isObjectJSONType(marshaledObjectClass);
                        if (type != TYPE.NA) {
                            if (type == TYPE.MAP) {
                                value = JSONMarshaler.marshalMapType(marshaledObject);
                            } else if (type == TYPE.OBJECT) {
                                value = JSONMarshaler.marshalObjectType(marshaledObject);
                            }
                        } else {
                            value = marshaledObject != null ? new JSON.String(marshaledObject.getClass().getCanonicalName() + "@" + Integer.toHexString(marshaledObject.hashCode())) : new JSON.String(String.format("UKNOWN Value for field %s", field.getName()));
                        }
                    }
                }
            }
        }
        return value;
    }

    public static Object marshalJSON(String jsonString, Class<?> clazz) throws ParserException, IOException {
        JSON json = JSON.parse(jsonString);
        return JSONMarshaler.marshalJSON(json, clazz);
    }

    public static Object marshalJSON(Reader jsonReader, Class<?> clazz) throws ParserException, IOException {
        JSON json = JSON.parse(jsonReader);
        return JSONMarshaler.marshalJSON(json, clazz);
    }

    public static Object marshalJSON(JSON json, Class<?> clazz) {
        return JSONMarshaler.marshalJSON(json.getRoot(), clazz);
    }

    public static Object marshalJSON(Value value, Class<?> clazz) {
        Object objectInstance = null;
        Value.TYPE valueType = value.getValueType();
        if (valueType == Value.TYPE.ARRAY) {
            return 0;
        }
        if (valueType == Value.TYPE.OBJECT) {
            try {
                objectInstance = clazz.newInstance();
            }
            catch (InstantiationException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            if (objectInstance == null) {
                // empty if block
            }
            JSONMarshaler.marshalPropertyValues(clazz, objectInstance, value);
            return objectInstance;
        }
        throw new UnsupportedOperationException("Unknown Type. Have you made a new one?");
    }

    public static void marshalPropertyValues(Class<?> clazz, Object o, Value value) {
        Inspector.InspectorProperty[] properties;
        Inspector inspector = new Inspector(clazz);
        inspector.inspect();
        for (Inspector.InspectorProperty property : properties = inspector.getProperties()) {
            System.out.println("Prop: " + property);
            if (!property.isValid() || !value.has(property.getName())) continue;
            System.out.println("Found");
            Value sourceValue = value.get(property.getName());
            if (property.getAccessType() == Inspector.InspectorProperty.TYPE.FIELD || property.getAccessType() != Inspector.InspectorProperty.TYPE.METHOD) continue;
            Class parmType = null;
            Object parmValue = null;
            if (sourceValue.type() == Value.TYPE.NULL) continue;
            if (sourceValue.type() == Value.TYPE.TRUE) {
                parmType = Boolean.class;
                parmValue = true;
            } else if (sourceValue.type() == Value.TYPE.FALSE) {
                parmType = Boolean.class;
                parmValue = false;
            } else if (sourceValue.type() == Value.TYPE.NUMERIC) {
                parmType = Number.class;
                parmValue = sourceValue.getNumber();
            } else if (sourceValue.type() == Value.TYPE.STRING) {
                parmType = String.class;
                parmValue = sourceValue.getString();
            } else if (sourceValue.type() == Value.TYPE.ARRAY) {
                parmType = Array.class;
            } else if (sourceValue.type() == Value.TYPE.OBJECT) {
                parmType = Object.class;
            }
            try {
                Method method = clazz.getMethod(property.getMutateName(), parmType);
                method.invoke(o, parmValue);
            }
            catch (IllegalAccessException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (IllegalArgumentException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (InvocationTargetException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (NoSuchMethodException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
            catch (SecurityException ex) {
                Logger.getLogger(JSONMarshaler.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void setMethodValue(Method method, Value value) {
    }

    public static boolean hasCodec(Class codecType) {
        if (codecStore == null) {
            return false;
        }
        return codecStore.hasCodec(codecType);
    }

    public static void registerCodec(Class<?> codecClass) {
        if (codecStore == null) {
            codecStore = new JSONCodecStore();
        }
        codecStore.registerCodec(codecClass);
    }

    public static JSONCodec<?> getCodec(Class codecType) {
        if (codecStore == null) {
            return null;
        }
        return codecStore.getCodec(codecType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TYPE {
        BOOLEAN,
        NUMERIC,
        STRING,
        ARRAY,
        LIST,
        OBJECT,
        MAP,
        NA;

    }
}

