/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import jsonij.json.ArrayImp;
import jsonij.json.JSONParser;
import jsonij.json.NumericImp;
import jsonij.json.ObjectImp;
import jsonij.json.StringImp;
import jsonij.json.Value;
import jsonij.parser.ParserException;

public class JSON {
    Value root;
    public static final True TRUE = new True();
    public static final False FALSE = new False();
    public static final Null NULL = new Null();

    public JSON(Value root) {
        if (root == null) {
            throw new NullPointerException("JSON Root Cannot be Null.");
        }
        if (root.type() != Value.TYPE.ARRAY && root.type() != Value.TYPE.OBJECT) {
            throw new RuntimeException("JSON can only be constructed from Arrays and Objects.");
        }
        this.root = root;
    }

    public Value getRoot() {
        return this.root;
    }

    void setRoot(Value root) {
        if (root == null) {
            throw new NullPointerException("JSON Root Cannot be Null.");
        }
        if (root.type() != Value.TYPE.ARRAY && root.type() != Value.TYPE.OBJECT) {
            throw new RuntimeException("JSON can only be constructed from Arrays and Objects.");
        }
        this.root = root;
    }

    public int size() {
        return this.getRoot().size();
    }

    public boolean isNull() {
        return this.getRoot().isNull();
    }

    public boolean getBoolean() {
        return this.getRoot().getBoolean();
    }

    public int getInt() {
        return this.getRoot().getInt();
    }

    public double getDouble() {
        return this.getRoot().getDouble();
    }

    public java.lang.String getString() {
        return this.getRoot().getString();
    }

    public Value get(int i) {
        return this.getRoot().get(i);
    }

    public Value get(java.lang.String key) {
        return this.getRoot().get(key);
    }

    public java.lang.String toJSON() {
        return this.getRoot().toJSON();
    }

    public java.lang.String toString() {
        return java.lang.String.format("JSON@%s:%s", this.hashCode(), this.getRoot().toString());
    }

    public static JSON parse(java.lang.String document) throws ParserException, IOException {
        JSONParser parser = new JSONParser();
        return new JSON(parser.parse(document));
    }

    public static JSON parse(Reader documentReader) throws ParserException, IOException {
        JSONParser parser = new JSONParser();
        return new JSON(parser.parse(documentReader));
    }

    public static class Null
    extends Value {
        public static final java.lang.String VALUE = "null";

        private Null() {
        }

        protected Value.TYPE type() {
            return Value.TYPE.NULL;
        }

        public int nestedSize() {
            return 0;
        }

        public java.lang.String toJSON() {
            return VALUE;
        }

        public int hashCode() {
            int hash = 7 + this.toJSON().hashCode();
            return hash;
        }

        public boolean equals(java.lang.Object obj) {
            return obj instanceof Null;
        }
    }

    public static class False
    extends Boolean {
        public static final java.lang.String VALUE = "false";

        private False() {
        }

        protected Value.TYPE type() {
            return Value.TYPE.FALSE;
        }

        public boolean getBoolean() {
            return false;
        }

        public int nestedSize() {
            return 0;
        }

        public java.lang.String toJSON() {
            return VALUE;
        }

        public int hashCode() {
            int hash = 3 + this.toJSON().hashCode();
            return hash;
        }

        public boolean equals(java.lang.Object obj) {
            return obj instanceof False;
        }
    }

    public static class True
    extends Boolean {
        public static final java.lang.String VALUE = "true";

        private True() {
        }

        protected Value.TYPE type() {
            return Value.TYPE.TRUE;
        }

        public boolean getBoolean() {
            return true;
        }

        public int nestedSize() {
            return 0;
        }

        public java.lang.String toJSON() {
            return VALUE;
        }

        public int hashCode() {
            int hash = 5 + this.toJSON().hashCode();
            return hash;
        }

        public boolean equals(java.lang.Object obj) {
            return obj instanceof True;
        }
    }

    public static abstract class Boolean
    extends Value {
    }

    public static class String
    extends StringImp {
        public String(java.lang.String s) {
            super(s);
        }
    }

    public static class Numeric
    extends NumericImp {
        public Numeric(Number n) {
            super(n);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Array<E extends Value>
    extends ArrayImp<E> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Object<K extends String, V extends Value>
    extends ObjectImp<K, V> {
    }
}

