/*
 * Decompiled with CFR 0.152.
 */
package jsonij.json;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Array;
import java.util.ArrayList;
import jsonij.json.JPathParser;
import jsonij.json.JPathRuntimeException;
import jsonij.json.JSON;
import jsonij.json.Value;
import jsonij.parser.ParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JPath<C extends Component>
extends ArrayList<C> {
    boolean recordEvaluateTime = false;
    long lastEvaluateTime = -1L;

    public Value evaluate(JSON json) throws JPathRuntimeException {
        Value value = json.getRoot();
        return this.evaluate(value);
    }

    public Value[] evaluateAll(JSON json) throws JPathRuntimeException {
        Value value = json.getRoot();
        return this.evaluateAll(value);
    }

    public Value evaluate(Value value) throws JPathRuntimeException {
        Value[] returnValues = this.evaluateAll(value);
        if (Array.getLength(returnValues) > 0) {
            return returnValues[0];
        }
        return null;
    }

    public Value[] evaluateAll(Value value) throws JPathRuntimeException {
        long startTime = 0L;
        long finishTime = -1L;
        if (this.recordEvaluateTime) {
            startTime = System.nanoTime();
        }
        ArrayList<Value> currentValues = new ArrayList<Value>();
        ArrayList<Value> nextValues = null;
        currentValues.add(value);
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            Predicate predicate;
            Component c = (Component)this.get(i);
            nextValues = new ArrayList<Value>();
            if (c.getClass() == Key.class) {
                Key key = (Key)c;
                for (Value currentValue : currentValues) {
                    Value valueStore = currentValue.get(key.getValue());
                    if (valueStore == null) continue;
                    nextValues.add(valueStore);
                }
            } else if (c.getClass() == SimpleIndex.class) {
                predicate = (SimpleIndex)c;
                if (((SimpleIndex)predicate).isLast()) {
                    int indexPredicate = -1;
                    for (Value currentValue : currentValues) {
                        indexPredicate = currentValue.size() - 1;
                        if (indexPredicate < 0) continue;
                        nextValues.add(currentValue.get(indexPredicate));
                    }
                } else {
                    for (Value currentValue : currentValues) {
                        if (((SimpleIndex)predicate).getIndex() >= currentValue.size()) continue;
                        nextValues.add(currentValue.get(((SimpleIndex)predicate).getIndex()));
                    }
                }
            } else if (c.getClass() == LastIndex.class) {
                int indexPredicate;
                predicate = (LastIndex)c;
                if (!((LastIndex)predicate).hasOffset()) {
                    indexPredicate = -1;
                    for (Value currentValue : currentValues) {
                        indexPredicate = currentValue.size() - 1;
                        if (indexPredicate < 0) continue;
                        nextValues.add(currentValue.get(indexPredicate));
                    }
                } else {
                    indexPredicate = -1;
                    for (Value currentValue : currentValues) {
                        indexPredicate = currentValue.size() - ((LastIndex)predicate).getOffset();
                        if (indexPredicate < 0) continue;
                        nextValues.add(currentValue.get(indexPredicate));
                    }
                }
            } else if (c.getClass() == ExpressionPredicate.class) {
                predicate = (ExpressionPredicate)c;
                ArrayList<ExpressionPredicateCondition> conditions = ((ExpressionPredicate)predicate).conditions();
                for (Value currentValue : currentValues) {
                    if (currentValue.type() != Value.TYPE.ARRAY) continue;
                    for (int j = 0; j < currentValue.size(); ++j) {
                        Value checkElement = currentValue.get(j);
                        if (checkElement.type() != Value.TYPE.OBJECT) continue;
                        boolean expressionValid = true;
                        for (ExpressionPredicateCondition condition : conditions) {
                            Value checkValue = checkElement.get(condition.getAttribute());
                            if (checkValue == null) {
                                expressionValid = false;
                                break;
                            }
                            ExpressionPredicateOperator expressionConditionOperator = condition.getOperator();
                            if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.NOT_NULL)) {
                                if (!checkValue.isNull()) continue;
                                expressionValid = false;
                                break;
                            }
                            if (expressionConditionOperator.equals((Object)ExpressionPredicateOperator.EQUAL)) {
                                if (checkValue.equals(condition.value)) continue;
                                expressionValid = false;
                                break;
                            }
                            if (!expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.LESS_EQUAL) && !expressionConditionOperator.equals((Object)ExpressionPredicateOperator.GREATER_EQUAL)) continue;
                        }
                        if (!expressionValid) continue;
                        nextValues.add(checkElement);
                    }
                }
            }
            currentValues = nextValues;
            ++count;
        }
        if (this.recordEvaluateTime) {
            finishTime = System.nanoTime();
            this.lastEvaluateTime = finishTime - startTime;
        }
        int size = currentValues.size();
        Value[] returnValues = new Value[size];
        for (int i = 0; i < size; ++i) {
            returnValues[i] = (Value)currentValues.get(i);
        }
        return returnValues;
    }

    public boolean isRecordEvaluateTime() {
        return this.recordEvaluateTime;
    }

    public void setRecordEvaluateTime(boolean recordEvaluateTime) {
        this.recordEvaluateTime = recordEvaluateTime;
    }

    public long getLastEvaluateTime() {
        return this.lastEvaluateTime / 1000L;
    }

    public static JPath<Component> parse(String path) throws IOException, ParserException {
        JPathParser parser = new JPathParser();
        JPath<Component> jPath = parser.parse(path);
        return jPath;
    }

    public static Value evaluate(String document, String jPath) throws ParserException, IOException {
        JSON jsonDocument = JSON.parse(document);
        JPath<Component> jPathInstance = JPath.parse(jPath);
        return jPathInstance.evaluate(jsonDocument);
    }

    public static Value evaluate(Reader documentReader, String jPath) throws ParserException, IOException {
        JSON jsonDocument = JSON.parse(documentReader);
        JPath<Component> jPathInstance = JPath.parse(jPath);
        return jPathInstance.evaluate(jsonDocument);
    }

    public static class ExpressionPredicateCondition {
        ExpressionPredicateCombineOperator combine;
        String attribute;
        ExpressionPredicateOperator operator;
        Value value;

        public ExpressionPredicateCondition() {
            this.combine = null;
            this.attribute = null;
            this.operator = null;
            this.value = null;
        }

        public ExpressionPredicateCondition(String attribute, ExpressionPredicateOperator operator) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = null;
        }

        public ExpressionPredicateCondition(String attribute, ExpressionPredicateOperator operator, Value value) {
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        public ExpressionPredicateCondition(ExpressionPredicateCombineOperator combine, String attribute, ExpressionPredicateOperator operator, Value value) {
            this.combine = combine;
            this.attribute = attribute;
            this.operator = operator;
            this.value = value;
        }

        public ExpressionPredicateCombineOperator getCombine() {
            return this.combine;
        }

        public void setCombine(ExpressionPredicateCombineOperator combine) {
            this.combine = combine;
        }

        public String getAttribute() {
            return this.attribute;
        }

        public void setAttribute(String attribute) {
            this.attribute = attribute;
        }

        public ExpressionPredicateOperator getOperator() {
            return this.operator;
        }

        public void setOperator(ExpressionPredicateOperator operator) {
            this.operator = operator;
        }

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public String toString() {
            return String.format("ExpressionPredicateCondition (%s%s %s %s)", new Object[]{this.combine != null ? String.format("%s ", new Object[]{this.combine}) : "", this.attribute, this.operator, this.value.toJSON()});
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionPredicateCombineOperator {
        AND,
        OR;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ExpressionPredicateOperator {
        NOT_NULL,
        EQUAL,
        LESS,
        GREATER,
        LESS_EQUAL,
        GREATER_EQUAL;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExpressionPredicate
    extends Predicate {
        String expression = null;
        ArrayList<ExpressionPredicateCondition> conditions = new ArrayList();

        public ArrayList<ExpressionPredicateCondition> getConditions() {
            return this.conditions;
        }

        public void setConditions(ArrayList<ExpressionPredicateCondition> conditions) {
            this.conditions = conditions;
        }

        public String getExpression() {
            return this.expression;
        }

        public void setExpression(String expression) {
            this.expression = expression;
        }

        public ArrayList<ExpressionPredicateCondition> conditions() {
            return this.conditions;
        }

        public String toString() {
            StringBuilder conditionString = new StringBuilder();
            for (ExpressionPredicateCondition epc : this.conditions()) {
                conditionString.append(epc);
                conditionString.append(" ");
            }
            String output = String.format("ExpressionPredicate (\"%s\" -> %s)", this.getExpression(), conditionString);
            return output;
        }
    }

    public static class LastIndex
    extends Predicate {
        int offset;
        public static final LastIndex LAST = new LastIndex();

        public LastIndex() {
            this(0);
        }

        public LastIndex(int offset) {
            this.offset = Math.abs(offset);
        }

        public boolean hasOffset() {
            return this.offset != 0;
        }

        public int getOffset() {
            return this.offset;
        }

        public void setOffset(int offset) {
            this.offset = offset;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            LastIndex other = (LastIndex)obj;
            return this.offset == other.offset;
        }

        public int hashCode() {
            int hash = 7;
            hash = 71 * hash + this.offset;
            return hash;
        }
    }

    public static class SimpleIndex
    extends Predicate {
        public static final int LAST_INDEX = -1;
        int index;

        public SimpleIndex() {
            this.index = 0;
        }

        public SimpleIndex(int index) {
            this.index = index;
        }

        public boolean isLast() {
            return this.index <= LAST_INDEX;
        }

        public void setLast() {
            this.index = LAST_INDEX;
        }

        public int getIndex() {
            return this.index;
        }

        public void setIndex(int index) {
            this.index = index;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            SimpleIndex other = (SimpleIndex)obj;
            return this.index == other.index;
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + this.index;
            return hash;
        }
    }

    public static abstract class Predicate
    extends Component {
    }

    public static class Key
    extends Component {
        String value;

        public Key(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }

        public String toString() {
            return "Key{value=" + this.value + '}';
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Key other = (Key)obj;
            return this.value.equals(other.value);
        }

        public int hashCode() {
            int hash = 5;
            hash = 53 * hash + (this.value != null ? this.value.hashCode() : 0);
            return hash;
        }
    }

    public static abstract class Component {
    }
}

