/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal;

import cc.plural.jsonij.marshal.Inspector;
import cc.plural.jsonij.marshal.InspectorProperty;
import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum JavaType {
    BOOLEAN,
    BYTE,
    SHORT,
    INTEGER,
    FLOAT,
    DOUBLE,
    LONG,
    STRING,
    LIST,
    OBJECT,
    MAP,
    ENUM,
    ARRAY,
    ARRAY_BOOLEAN,
    ARRAY_BYTE,
    ARRAY_SHORT,
    ARRAY_INTEGER,
    ARRAY_FLOAT,
    ARRAY_DOUBLE,
    ARRAY_LONG,
    ARRAY_STRING,
    ARRAY_ENUM,
    ARRAY_LIST,
    ARRAY_MAP,
    ARRAY_ARRAY,
    UNKOWN;

    boolean primitive = true;
    JavaArrayType arrayType;
    protected static final Map<Class<?>, Inspector> inspectedClasses;

    public void setPrimitive(boolean primitive) {
        this.primitive = primitive;
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    public static JavaType inspectObjectType(Class<?> c) {
        int i;
        Class<?>[] interfaces;
        JavaType type = null;
        if (c == Boolean.TYPE) {
            type = BOOLEAN;
            type.setPrimitive(true);
        } else if (c == Boolean.class) {
            type = BOOLEAN;
            type.setPrimitive(false);
        } else if (c == Integer.TYPE) {
            type = INTEGER;
            type.setPrimitive(true);
        } else if (c == Integer.class) {
            type = INTEGER;
            type.setPrimitive(false);
        } else if (c == Double.TYPE) {
            type = DOUBLE;
            type.setPrimitive(true);
        } else if (c == Double.class) {
            type = DOUBLE;
            type.setPrimitive(false);
        } else if (c == Float.TYPE) {
            type = FLOAT;
            type.setPrimitive(true);
        } else if (c == Float.class) {
            type = FLOAT;
            type.setPrimitive(false);
        } else if (c == Long.TYPE) {
            type = LONG;
            type.setPrimitive(true);
        } else if (c == Long.class) {
            type = LONG;
            type.setPrimitive(false);
        } else if (c == Short.TYPE) {
            type = SHORT;
            type.setPrimitive(true);
        } else if (c == Short.class) {
            type = SHORT;
            type.setPrimitive(false);
        } else if (c == Byte.TYPE) {
            type = BYTE;
            type.setPrimitive(true);
        } else if (c == Byte.class) {
            type = BYTE;
            type.setPrimitive(false);
        } else if (c.isEnum()) {
            type = ENUM;
            type.setPrimitive(false);
        } else if (c == String.class || c == Character.TYPE || c == Character.class) {
            type = STRING;
            type.setPrimitive(false);
        } else if (c.isArray()) {
            type = JavaType.getArrayType(c);
        }
        if (type == null) {
            if (c == List.class) {
                type = LIST;
                type.setPrimitive(false);
            } else {
                interfaces = c.getInterfaces();
                for (int i2 = 0; i2 < Array.getLength(interfaces); ++i2) {
                    if (interfaces[i2] != List.class) continue;
                    type = LIST;
                    type.setPrimitive(false);
                }
            }
            interfaces = c.getInterfaces();
            Class<?> parent = c.getSuperclass();
            if (parent != null) {
                do {
                    interfaces = parent.getInterfaces();
                    for (i = 0; i < Array.getLength(interfaces); ++i) {
                        if (interfaces[i] != List.class) continue;
                        type = LIST;
                    }
                } while ((parent = parent.getSuperclass()) != null);
            }
        }
        if (type == null) {
            if (c == Map.class) {
                type = MAP;
                type.setPrimitive(false);
            } else {
                interfaces = c.getInterfaces();
                for (int i3 = 0; i3 < Array.getLength(interfaces); ++i3) {
                    if (interfaces[i3] != Map.class) continue;
                    type = MAP;
                    type.setPrimitive(false);
                }
            }
            interfaces = c.getInterfaces();
            Class<?> parent = c.getSuperclass();
            if (parent != null) {
                do {
                    interfaces = parent.getInterfaces();
                    for (i = 0; i < Array.getLength(interfaces); ++i) {
                        if (interfaces[i] != Map.class) continue;
                        type = MAP;
                    }
                } while ((parent = parent.getSuperclass()) != null);
            }
        }
        if (type == null && JavaType.isObjectType(c)) {
            type = OBJECT;
            type.setPrimitive(false);
        }
        if (type != null) {
            return type;
        }
        return UNKOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Inspector getInstpector(Class<?> objectClass) {
        Inspector inspector = null;
        Map<Class<?>, Inspector> map = inspectedClasses;
        synchronized (map) {
            if (inspectedClasses.containsKey(objectClass)) {
                inspector = inspectedClasses.get(objectClass);
            } else {
                inspector = new Inspector(objectClass);
                inspector.inspect();
                inspectedClasses.put(objectClass, inspector);
            }
        }
        return inspector;
    }

    public static boolean isObjectType(Class<?> objectClass) {
        Inspector inspector = JavaType.getInstpector(objectClass);
        InspectorProperty[] properties = inspector.getProperties();
        return properties != null && Array.getLength(properties) > 0 || inspector.hasInnerArray() || inspector.hasInnerObject();
    }

    public static JavaType getArrayType(Class<?> objectClass) {
        JavaType resultType = null;
        Class<?> objectComponentType = objectClass.getComponentType();
        if (!objectComponentType.isArray()) {
            JavaType componentType = JavaType.inspectObjectType(objectComponentType);
            switch (componentType) {
                case BOOLEAN: {
                    resultType = ARRAY_BOOLEAN;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case BYTE: {
                    resultType = ARRAY_BYTE;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case INTEGER: {
                    resultType = ARRAY_INTEGER;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case SHORT: {
                    resultType = ARRAY_SHORT;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case FLOAT: {
                    resultType = ARRAY_FLOAT;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case LONG: {
                    resultType = ARRAY_LONG;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case DOUBLE: {
                    resultType = ARRAY_DOUBLE;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case STRING: {
                    resultType = ARRAY_STRING;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case ENUM: {
                    resultType = ARRAY_ENUM;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case MAP: {
                    resultType = ARRAY_MAP;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case LIST: {
                    resultType = ARRAY_LIST;
                    resultType.setPrimitive(componentType.isPrimitive());
                    break;
                }
                case OBJECT: {
                    resultType = ARRAY;
                    resultType.setPrimitive(componentType.isPrimitive());
                }
            }
        } else {
            resultType = ARRAY_ARRAY;
            resultType.setPrimitive(false);
        }
        if (resultType != null) {
            return resultType;
        }
        return UNKOWN;
    }

    static {
        inspectedClasses = new HashMap();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class JavaArrayType {
        Class<?> arrayType;
        int dimension;

        public JavaArrayType(Class<?> arrayType) {
            this.arrayType = arrayType;
            this.dimension = 0;
            this.inspect();
        }

        public final void inspect() {
            if (this.arrayType != null && this.arrayType.isArray()) {
                Class<?> innerType = this.arrayType.getComponentType();
                this.dimension = 1;
                while (innerType.isArray() && (innerType = this.arrayType.getComponentType()) != null) {
                    ++this.dimension;
                }
            }
        }

        public String toString() {
            return "Array " + this.arrayType.getSimpleName() + "[" + this.dimension + "]";
        }
    }
}

