/*
 * Decompiled with CFR 0.152.
 */
package cc.plural.jsonij.marshal;

import cc.plural.jsonij.JSON;
import cc.plural.jsonij.Value;
import cc.plural.jsonij.marshal.Inspector;
import cc.plural.jsonij.marshal.InspectorProperty;
import cc.plural.jsonij.marshal.JSONMarshalerException;
import cc.plural.jsonij.marshal.JavaType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSONDocumentMarshaler {
    public static String innerArrayAttribute = "_innerArray";
    public static String innerObjectAttribute = "_innerObject";

    public Object marshalJSONDocument(JSON json, Class<?> objectClass) throws JSONMarshalerException {
        Object resultObject = null;
        Value jsonRoot = json.getRoot();
        if (jsonRoot.type() == Value.TYPE.OBJECT) {
            JSON.Object jsonObjectRoot = (JSON.Object)jsonRoot;
            resultObject = this.marshalJSONDocumentObject(jsonObjectRoot, objectClass);
        } else if (jsonRoot.type() == Value.TYPE.ARRAY) {
            JSON.Array jsonArrayRoot = (JSON.Array)jsonRoot;
            resultObject = this.marshalJSONDocumentArray(jsonArrayRoot, objectClass);
        }
        return resultObject;
    }

    public Object marshalJSONDocument(Value value, Class<?> objectClass) throws JSONMarshalerException {
        Object resultObject = null;
        if (value.type() == Value.TYPE.OBJECT) {
            JSON.Object jsonObjectRoot = (JSON.Object)value;
            resultObject = this.marshalJSONDocumentObject(jsonObjectRoot, objectClass);
        } else if (value.type() == Value.TYPE.ARRAY) {
            JSON.Array jsonArrayRoot = (JSON.Array)value;
            resultObject = this.marshalJSONDocumentArray(jsonArrayRoot, objectClass);
        }
        return resultObject;
    }

    public Object marshalJSONDocumentObject(JSON.Object<CharSequence, Value> jsonObject, Class<?> objectClass) throws JSONMarshalerException {
        Object resultObject = null;
        Set entrySet = jsonObject.entrySet();
        Iterator entrySetIterator = entrySet.iterator();
        Map.Entry entry = null;
        Inspector inspector = new Inspector(objectClass);
        inspector.inspect();
        ArrayList<MarshalerPropertyValue> marshalPropertyValues = new ArrayList<MarshalerPropertyValue>();
        while (entrySetIterator.hasNext()) {
            String propertyName;
            entry = entrySetIterator.next();
            if (!((Object)((CharSequence)entry.getKey())).toString().equals(innerObjectAttribute) || inspector.hasInnerObject()) {
                // empty if block
            }
            if (!inspector.hasProperty(propertyName = ((Object)((CharSequence)entry.getKey())).toString())) continue;
            MarshalerPropertyValue propertyValue = new MarshalerPropertyValue(propertyName, inspector.getProperty(propertyName), (Value)entry.getValue());
            marshalPropertyValues.add(propertyValue);
        }
        try {
            resultObject = objectClass.newInstance();
            for (MarshalerPropertyValue propertyValue : marshalPropertyValues) {
                JSON.Object objectJSON;
                JSON.Array arrayJSON;
                JavaType mutateType;
                InspectorProperty property;
                if (propertyValue.getValue().isNull()) {
                    // empty if block
                }
                if ((property = propertyValue.getProperty()).getAccessPropertyType() == InspectorProperty.TYPE.METHOD) {
                    Method method = objectClass.getMethod(property.getMutateName(), property.getMutateInputType());
                    mutateType = JavaType.inspectObjectType(property.getMutateInputType());
                    arrayJSON = null;
                    switch (mutateType) {
                        case BOOLEAN: {
                            method.invoke(resultObject, propertyValue.getValue().getBoolean());
                            break;
                        }
                        case BYTE: {
                            method.invoke(resultObject, propertyValue.getValue().getNumber().byteValue());
                            break;
                        }
                        case INTEGER: {
                            method.invoke(resultObject, propertyValue.getValue().getNumber().intValue());
                            break;
                        }
                        case SHORT: {
                            method.invoke(resultObject, propertyValue.getValue().getNumber().shortValue());
                            break;
                        }
                        case FLOAT: {
                            method.invoke(resultObject, Float.valueOf(propertyValue.getValue().getNumber().floatValue()));
                            break;
                        }
                        case LONG: {
                            method.invoke(resultObject, propertyValue.getValue().getNumber().longValue());
                            break;
                        }
                        case DOUBLE: {
                            method.invoke(resultObject, propertyValue.getValue().getNumber().doubleValue());
                            break;
                        }
                        case STRING: {
                            method.invoke(resultObject, propertyValue.getValue().getString());
                            break;
                        }
                        case ENUM: {
                            method.invoke(resultObject, propertyValue.getValue().getString());
                            break;
                        }
                        case MAP: {
                            break;
                        }
                        case LIST: {
                            break;
                        }
                        case OBJECT: {
                            objectJSON = (JSON.Object)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentObject(objectJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY: {
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_BYTE: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_SHORT: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_INTEGER: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_FLOAT: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_DOUBLE: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_LONG: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_STRING: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_ENUM: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_LIST: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                        case ARRAY_MAP: {
                            arrayJSON = (JSON.Array)propertyValue.getValue();
                            method.invoke(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                            break;
                        }
                    }
                    continue;
                }
                if (property.getAccessPropertyType() != InspectorProperty.TYPE.FIELD) continue;
                Field field = objectClass.getField(propertyValue.getProperty().getMutateName());
                mutateType = JavaType.inspectObjectType(property.getMutateInputType());
                arrayJSON = null;
                switch (mutateType) {
                    case BOOLEAN: {
                        field.set(resultObject, propertyValue.getValue().getBoolean());
                        break;
                    }
                    case BYTE: {
                        field.set(resultObject, propertyValue.getValue().getNumber().byteValue());
                        break;
                    }
                    case INTEGER: {
                        field.set(resultObject, propertyValue.getValue().getNumber().intValue());
                        break;
                    }
                    case SHORT: {
                        field.set(resultObject, propertyValue.getValue().getNumber().shortValue());
                        break;
                    }
                    case FLOAT: {
                        field.set(resultObject, Float.valueOf(propertyValue.getValue().getNumber().floatValue()));
                        break;
                    }
                    case LONG: {
                        field.set(resultObject, propertyValue.getValue().getNumber().longValue());
                        break;
                    }
                    case DOUBLE: {
                        field.set(resultObject, propertyValue.getValue().getNumber().doubleValue());
                        break;
                    }
                    case STRING: {
                        field.set(resultObject, propertyValue.getValue().getString());
                        break;
                    }
                    case ENUM: {
                        break;
                    }
                    case MAP: {
                        break;
                    }
                    case LIST: {
                        break;
                    }
                    case OBJECT: {
                        objectJSON = (JSON.Object)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentObject(objectJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_BYTE: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_SHORT: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_INTEGER: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_FLOAT: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_DOUBLE: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_LONG: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_STRING: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_ENUM: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_LIST: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_MAP: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                    case ARRAY_ARRAY: {
                        arrayJSON = (JSON.Array)propertyValue.getValue();
                        field.set(resultObject, this.marshalJSONDocumentArray(arrayJSON, property.getMutateInputType()));
                        break;
                    }
                }
            }
        }
        catch (InstantiationException ex) {
            Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchFieldException ex) {
            Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (NoSuchMethodException ex) {
            Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InvocationTargetException ex) {
            Logger.getLogger(JSONDocumentMarshaler.class.getName()).log(Level.SEVERE, null, ex);
        }
        return resultObject;
    }

    public Object marshalJSONDocumentArray(JSON.Array<Value> jsonArray, Class<?> objectClass) {
        int size = jsonArray.size();
        Object array = Array.newInstance(objectClass.getComponentType(), size);
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, ((Value)jsonArray.get(i)).getNumber().intValue());
        }
        return array;
    }

    public static class MarshalerPropertyValue {
        String name;
        InspectorProperty property;
        Value value;

        public MarshalerPropertyValue() {
            this.name = null;
            this.property = null;
            this.value = null;
        }

        public MarshalerPropertyValue(String name, InspectorProperty property, Value value) {
            this.name = name;
            this.property = property;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public InspectorProperty getProperty() {
            return this.property;
        }

        public void setProperty(InspectorProperty property) {
            this.property = property;
        }

        public Value getValue() {
            return this.value;
        }

        public void setValue(Value value) {
            this.value = value;
        }

        public String toString() {
            StringBuilder resultBuilder = new StringBuilder();
            resultBuilder.append("MarshalerPropertyValue [Name:").append(this.name).append('|');
            resultBuilder.append("Property:").append(this.property);
            resultBuilder.append("->");
            resultBuilder.append("Value:").append(this.value).append(']');
            return resultBuilder.toString();
        }
    }
}

