/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary.components;

import android.graphics.Color;
import cc.cloudist.acplibrary.components.PetalCoordinate;
import java.util.ArrayList;
import java.util.List;

public class FlowerDataCalc {
    private double[] mCosValues;
    private double[] mSinValues;

    public FlowerDataCalc(int segmentCount) {
        this.mCosValues = new double[segmentCount];
        this.mSinValues = new double[segmentCount];
        double angleUnit = Math.PI * 2 / (double)segmentCount;
        for (int i = 0; i < segmentCount; ++i) {
            double currentAngle = angleUnit * (double)i;
            this.mCosValues[i] = Math.cos(currentAngle);
            this.mSinValues[i] = Math.sin(currentAngle);
        }
    }

    public List<PetalCoordinate> getSegmentsCoordinates(int rectSize, int outPadding, int inPadding, int segmentCount, int finalWidth) {
        ArrayList<PetalCoordinate> coordinates = new ArrayList<PetalCoordinate>(segmentCount);
        double centerY = (double)rectSize / 2.0;
        double centerX = (double)finalWidth / 2.0;
        double outRadius = (double)(rectSize - outPadding) / 2.0;
        double inRadius = (double)inPadding / 2.0;
        for (int i = 0; i < segmentCount; ++i) {
            double xOutOffset = outRadius * this.mCosValues[i];
            double yOutOffset = outRadius * this.mSinValues[i];
            int startX = (int)(centerX - xOutOffset);
            int startY = (int)(centerY + yOutOffset);
            double xInOffset = inRadius * this.mCosValues[i];
            double yInOffset = inRadius * this.mSinValues[i];
            int endX = (int)(centerX - xInOffset);
            int endY = (int)(centerY + yInOffset);
            PetalCoordinate coordinate = new PetalCoordinate(startX, startY, endX, endY);
            coordinates.add(coordinate);
        }
        return coordinates;
    }

    public int[] getSegmentsColors(int themeColor, int fadeColor, int petalCount, int petalAlpha) {
        int[] colors = new int[petalCount];
        int themeRed = Color.red((int)themeColor);
        int themeGreen = Color.green((int)themeColor);
        int themeBlue = Color.blue((int)themeColor);
        int fadeRed = Color.red((int)fadeColor);
        int fadeGreen = Color.green((int)fadeColor);
        int fadeBlue = Color.blue((int)fadeColor);
        double redDelta = (double)(fadeRed - themeRed) / (double)(petalCount - 1);
        double greenDelta = (double)(fadeGreen - themeGreen) / (double)(petalCount - 1);
        double blueDelta = (double)(fadeBlue - themeBlue) / (double)(petalCount - 1);
        for (int i = 0; i < petalCount; ++i) {
            int color;
            colors[i] = color = Color.argb((int)petalAlpha, (int)((int)((double)themeRed + redDelta * (double)i)), (int)((int)((double)themeGreen + greenDelta * (double)i)), (int)((int)((double)themeBlue + blueDelta * (double)i)));
        }
        return colors;
    }
}

