/*
 * Decompiled with CFR 0.152.
 */
package cc.cloudist.acplibrary;

import android.content.Context;
import android.graphics.Point;
import android.os.Build;
import android.os.Handler;
import android.os.Message;
import android.support.annotation.NonNull;
import android.view.Display;
import android.view.KeyEvent;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import cc.cloudist.acplibrary.components.RemoveACPLException;
import java.lang.ref.WeakReference;

public abstract class ACProgressBase
extends View {
    protected WindowManager mWindowManager;
    protected int mSize;
    protected Handler mHandler = new UpdateHandler(this);
    private float mDimAmount = 0.3f;
    private boolean mCancelable = false;

    public ACProgressBase(Context context, float sizeRatio) {
        super(context);
        int screenHeight;
        int screenWidth;
        this.mWindowManager = (WindowManager)context.getSystemService("window");
        Display display = this.mWindowManager.getDefaultDisplay();
        if (Build.VERSION.SDK_INT >= 13) {
            Point size = new Point();
            display.getSize(size);
            screenWidth = size.x;
            screenHeight = size.y;
        } else {
            screenWidth = display.getWidth();
            screenHeight = display.getHeight();
        }
        this.mSize = screenHeight > screenWidth ? (int)((float)screenWidth * sizeRatio) : (int)((float)screenHeight * sizeRatio);
    }

    public void setBackgroundAlpha(float alpha) {
        this.mDimAmount = alpha;
    }

    public void setCancelable(boolean mCancelable) {
        this.mCancelable = mCancelable;
    }

    public void show() {
        WindowManager.LayoutParams params = new WindowManager.LayoutParams(-2, -2, 1003, 262146, -3);
        params.gravity = 17;
        params.dimAmount = this.mDimAmount;
        this.mWindowManager.addView((View)this, (ViewGroup.LayoutParams)params);
    }

    public boolean dispatchKeyEvent(@NonNull KeyEvent event) {
        if (event.getKeyCode() == 4) {
            this.mWindowManager.removeView((View)this);
            return true;
        }
        return super.dispatchKeyEvent(event);
    }

    public boolean dispatchTouchEvent(@NonNull MotionEvent event) {
        if (this.mCancelable) {
            int[] location = new int[2];
            this.getLocationInWindow(location);
            int endX = location[0] + this.getWidth();
            int endY = location[1] + this.getHeight();
            float x = event.getX();
            float y = event.getY();
            if (x < (float)location[0] || x > (float)endX || y < (float)location[1] || y > (float)endY) {
                this.mWindowManager.removeView((View)this);
            }
            return true;
        }
        return true;
    }

    public void dismiss() {
        try {
            this.mWindowManager.removeView((View)this);
        }
        catch (IllegalArgumentException e) {
            throw new RemoveACPLException();
        }
    }

    private static class UpdateHandler
    extends Handler {
        WeakReference<ACProgressBase> mReference;

        public UpdateHandler(ACProgressBase base) {
            this.mReference = new WeakReference<ACProgressBase>(base);
        }

        public void handleMessage(Message message) {
            ACProgressBase base = (ACProgressBase)((Object)this.mReference.get());
            if (base != null) {
                base.invalidate();
            }
        }
    }
}

