/*
 * Decompiled with CFR 0.152.
 */
package cayte.starter;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;
import cayte.starter.CayteStarter;
import cayte.starter.StarterAlarmReceiver;
import cayte.starter.StarterJobService;

public class StarterUtil {
    private static final int CODE_ALARM = 0x7FFFFF67;
    private static final int CODE_JOB = 0x7FFFFF66;

    public static void start(Context con) {
        StarterUtil.startAlarm(con);
        StarterUtil.startJob(con);
    }

    public static void end(Context con) {
        StarterUtil.endAlarm(con);
        StarterUtil.endJob(con);
    }

    private static void startAlarm(Context con) {
        Log.i((String)CayteStarter.TAG, (String)"Starter Alarm Start");
        Intent intent = new Intent(con, StarterAlarmReceiver.class);
        PendingIntent sender = PendingIntent.getBroadcast((Context)con, (int)0x7FFFFF67, (Intent)intent, (int)0x8000000);
        AlarmManager alarmManager = (AlarmManager)con.getApplicationContext().getSystemService("alarm");
        long interval = (long)CayteStarter.getTimeInterval(con) * 1000L;
        long time = System.currentTimeMillis() + interval;
        if (Build.VERSION.SDK_INT >= 23) {
            alarmManager.setExactAndAllowWhileIdle(0, time, sender);
        } else if (Build.VERSION.SDK_INT >= 19) {
            alarmManager.setExact(0, time, sender);
        } else {
            alarmManager.set(0, time, sender);
        }
    }

    private static void startJob(Context con) {
        if (Build.VERSION.SDK_INT >= 21) {
            long interval = (long)CayteStarter.getTimeInterval(con) * 1000L;
            JobScheduler jobScheduler = (JobScheduler)con.getApplicationContext().getSystemService("jobscheduler");
            JobInfo.Builder builder = new JobInfo.Builder(0x7FFFFF66, new ComponentName(con.getApplicationContext().getPackageName(), StarterJobService.class.getName()));
            builder.setPeriodic(interval);
            builder.setRequiresCharging(true);
            builder.setPersisted(true);
            builder.setRequiresDeviceIdle(true);
            jobScheduler.schedule(builder.build());
        }
    }

    private static void endAlarm(Context con) {
        Intent intent = new Intent(con, StarterAlarmReceiver.class);
        PendingIntent sender = PendingIntent.getBroadcast((Context)con, (int)0x7FFFFF67, (Intent)intent, (int)0x10000000);
        AlarmManager alarmManager = (AlarmManager)con.getApplicationContext().getSystemService("alarm");
        alarmManager.cancel(sender);
    }

    private static void endJob(Context con) {
        if (Build.VERSION.SDK_INT >= 21) {
            JobScheduler jobScheduler = (JobScheduler)con.getApplicationContext().getSystemService("jobscheduler");
            jobScheduler.cancel(0x7FFFFF66);
        }
    }
}

