/*
 * Decompiled with CFR 0.152.
 */
package cayte.starter;

import android.content.Context;
import android.content.Intent;
import android.util.Log;
import cayte.starter.StarterService;

public class CayteStarter {
    public static final String TAG = CayteStarter.class.getSimpleName();

    public static int getTimeInterval(Context context) {
        return context.getApplicationContext().getSharedPreferences("CayteStarter", 0).getInt("timeInterval", 60);
    }

    public static boolean isStarer(Context context) {
        return context.getApplicationContext().getSharedPreferences("CayteStarter", 0).getBoolean("isStarer", false);
    }

    public static boolean isBootStarer(Context context) {
        return context.getApplicationContext().getSharedPreferences("CayteStarter", 0).getBoolean("isBootStarer", false);
    }

    public static String getServiceName(Context context) {
        String serviceName = context.getApplicationContext().getSharedPreferences("CayteStarter", 0).getString("serviceName", null);
        return serviceName;
    }

    public static void registService(Context context, String serviceName) {
        Log.i((String)TAG, (String)("Starter registService : " + serviceName));
        context.getApplicationContext().getSharedPreferences("CayteStarter", 0).edit().putString("serviceName", serviceName).apply();
    }

    public static void openStarer(Context context, int timeInterval) {
        Log.i((String)TAG, (String)"Starter open");
        context.getApplicationContext().getSharedPreferences("CayteStarter", 0).edit().putBoolean("isStarer", true).putInt("timeInterval", timeInterval).apply();
    }

    public static void closeStarer(Context context) {
        Log.i((String)TAG, (String)"Starter close");
        context.getApplicationContext().getSharedPreferences("CayteStarter", 0).edit().putBoolean("isStarer", false).putInt("timeInterval", 60).apply();
    }

    public static void openBootStarer(Context context) {
        Log.i((String)TAG, (String)"Starter open Boot");
        context.getApplicationContext().getSharedPreferences("CayteStarter", 0).edit().putBoolean("isBootStarer", true).apply();
    }

    public static void closeBootStarer(Context context) {
        Log.i((String)TAG, (String)"Starter close Boot");
        context.getApplicationContext().getSharedPreferences("CayteStarter", 0).edit().putBoolean("isBootStarer", false).apply();
    }

    public static void start(Context context) {
        Log.i((String)TAG, (String)"Starter start...");
        Intent in = new Intent(context.getApplicationContext(), StarterService.class);
        in.setFlags(0x10000000);
        context.getApplicationContext().startService(in);
    }
}

