package cayte.starter;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.app.job.JobInfo;
import android.app.job.JobScheduler;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.util.Log;

public class StarterUtil {
    private static final int CODE_ALARM = Integer.MAX_VALUE - 0x98;
    private static final int CODE_JOB = Integer.MAX_VALUE - 0x99;

    public static void start(Context con) {
        startAlarm(con);
        startJob(con);
    }

    public static void end(Context con) {
        endAlarm(con);
        endJob(con);
    }

    private static void startAlarm(Context con) {
        Log.i(CayteStarter.TAG, "Starter Alarm Start");
        Intent intent = new Intent(con, StarterAlarmReceiver.class);
        PendingIntent sender = PendingIntent.getBroadcast(con, CODE_ALARM, intent, PendingIntent.FLAG_UPDATE_CURRENT);
        AlarmManager alarmManager = (AlarmManager) con.getApplicationContext().getSystemService(Context.ALARM_SERVICE);
        long interval = CayteStarter.getTimeInterval(con) * 1000l;
        long time = System.currentTimeMillis() + interval;

        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M)
            alarmManager.setExactAndAllowWhileIdle(AlarmManager.RTC_WAKEUP, time, sender);
        else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.KITKAT) {
            alarmManager.setExact(AlarmManager.RTC_WAKEUP, time, sender);
        } else {
            alarmManager.set(AlarmManager.RTC_WAKEUP, time, sender);
        }
    }

    private static void startJob(Context con) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            long interval = CayteStarter.getTimeInterval(con) * 1000l;
            JobScheduler jobScheduler = (JobScheduler) con.getApplicationContext().getSystemService(Context.JOB_SCHEDULER_SERVICE);
            JobInfo.Builder builder = new JobInfo.Builder(CODE_JOB, new ComponentName(con.getApplicationContext().getPackageName(), StarterJobService.class.getName()));
            builder.setPeriodic(interval);
            builder.setRequiresCharging(true);
            builder.setPersisted(true);
            builder.setRequiresDeviceIdle(true);
            jobScheduler.schedule(builder.build());
        }
    }

    private static void endAlarm(Context con) {
        Intent intent = new Intent(con, StarterAlarmReceiver.class);
        PendingIntent sender = PendingIntent.getBroadcast(con, CODE_ALARM, intent, PendingIntent.FLAG_CANCEL_CURRENT);
        AlarmManager alarmManager = (AlarmManager) con.getApplicationContext().getSystemService(Context.ALARM_SERVICE);
        alarmManager.cancel(sender);
    }

    private static void endJob(Context con) {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.LOLLIPOP) {
            JobScheduler jobScheduler = (JobScheduler) con.getApplicationContext().getSystemService(Context.JOB_SCHEDULER_SERVICE);
            jobScheduler.cancel(CODE_JOB);
        }
    }

}
