package cayte.starter;

import android.app.job.JobParameters;
import android.app.job.JobService;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.util.Log;

@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
public class StarterJobService extends JobService {

    @Override
    public boolean onStartJob(JobParameters params) {
        if (CayteStarter.isStarer(this)) {
            StarterUtil.end(this);
            StarterUtil.start(this);
        }
        doStart(getApplicationContext());
        return false;
    }

    public void doStart(Context context) {
        try {
            Log.i(CayteStarter.TAG, "Starter JobService Real Start");
            Intent intent = new Intent(CayteStarter.getServiceName(context));
            intent.setPackage(context.getPackageName());
            intent.putExtra(context.getPackageName(), true);
            context.startService(intent);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public boolean onStopJob(JobParameters params) {
        return false;
    }

}
