package cayte.starter;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class CayteStarter {

    public static final String TAG = CayteStarter.class.getSimpleName();

    public static int getTimeInterval(Context context) {
        return context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).getInt("timeInterval", 60);
    }

    public static boolean isStarer(Context context) {
        return context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).getBoolean("isStarer", false);
    }

    public static boolean isBootStarer(Context context) {
        return context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).getBoolean("isBootStarer", false);
    }

    public static String getServiceName(Context context) {
        String serviceName = context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).getString("serviceName", null);
        return serviceName;
    }

    public static void registService(Context context, String serviceName) {
        Log.i(CayteStarter.TAG, "Starter registService : " + serviceName);
        context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).edit().putString("serviceName", serviceName).apply();
    }

    public static void openStarer(Context context, int timeInterval) {
        Log.i(CayteStarter.TAG, "Starter open");
        context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).edit().putBoolean("isStarer", true).putInt("timeInterval", timeInterval).apply();
    }

    public static void closeStarer(Context context) {
        Log.i(CayteStarter.TAG, "Starter close");
        context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).edit().putBoolean("isStarer", false).putInt("timeInterval", 60).apply();
    }

    public static void openBootStarer(Context context) {
        Log.i(CayteStarter.TAG, "Starter open Boot");
        context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).edit().putBoolean("isBootStarer", true).apply();
    }

    public static void closeBootStarer(Context context) {
        Log.i(CayteStarter.TAG, "Starter close Boot");
        context.getApplicationContext().getSharedPreferences("CayteStarter", Activity.MODE_PRIVATE).edit().putBoolean("isBootStarer", false).apply();
    }

    public static void start(Context context) {
        Log.i(CayteStarter.TAG, "Starter start...");
        Intent in = new Intent(context.getApplicationContext(), StarterService.class);
        in.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
        context.getApplicationContext().startService(in);
    }


}
