package cayte.starter;

import android.app.AlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class StarterAlarmUtil {
	private static final int CODE = Integer.MAX_VALUE - 0x98;

	public static void start(Context con) {
		Log.i(CayteStarter.TAG, "Starter Alarm Start");
		Intent intent = new Intent(con, StarterAlarmReceiver.class);
		PendingIntent sender = PendingIntent.getBroadcast(con, CODE, intent, PendingIntent.FLAG_CANCEL_CURRENT);
		AlarmManager alarmManager = (AlarmManager) con.getApplicationContext().getSystemService(Context.ALARM_SERVICE);
		long interval = CayteStarter.getTimeInterval(con) * 1000l;
		long time = System.currentTimeMillis() + interval;
		alarmManager.setRepeating(AlarmManager.RTC_WAKEUP, time, interval, sender);
	}

	public static void end(Context con) {
		Intent intent = new Intent(con, StarterAlarmReceiver.class);
		PendingIntent sender = PendingIntent.getBroadcast(con, CODE, intent, PendingIntent.FLAG_CANCEL_CURRENT);
		AlarmManager alarmManager = (AlarmManager) con.getApplicationContext().getSystemService(Context.ALARM_SERVICE);
		alarmManager.cancel(sender);
	}

}
