package cayte.starter;

import android.content.Context;
import android.content.Intent;
import android.util.Log;

public class CayteStarter {

	public static final String TAG = CayteStarter.class.getSimpleName();

	public static boolean isAlarmStarer(Context context) {
		return context.getApplicationContext().getSharedPreferences("CayteStarter", 4).getBoolean("isAlarmStarer",
				false);
	}

	public static int getTimeInterval(Context context) {
		return context.getApplicationContext().getSharedPreferences("CayteStarter", 4).getInt("timeInterval", 60);
	}

	public static boolean isBootStarer(Context context) {
		return context.getApplicationContext().getSharedPreferences("CayteStarter", 4).getBoolean("isBootStarer", true);
	}

	public static String getServiceName(Context context) {
		String serviceName = context.getApplicationContext().getSharedPreferences("CayteStarter", 4)
				.getString("serviceName", null);
		return serviceName;
	}

	public static void registService(Context context, String serviceName) {
		Log.i(CayteStarter.TAG, "Starter registService : " + serviceName);
		context.getApplicationContext().getSharedPreferences("CayteStarter", 4).edit()
				.putString("serviceName", serviceName).commit();
	}

	public static void openAlarmStarer(Context context, int timeInterval) {
		Log.i(CayteStarter.TAG, "Starter open Alarm");
		context.getApplicationContext().getSharedPreferences("CayteStarter", 4).edit().putBoolean("isAlarmStarer", true)
				.putInt("timeInterval", timeInterval).commit();
	}

	public static void closeAlarmStarer(Context context) {
		Log.i(CayteStarter.TAG, "Starter close Alarm");
		context.getApplicationContext().getSharedPreferences("CayteStarter", 4).edit()
				.putBoolean("isAlarmStarer", false).putInt("timeInterval", 60).commit();
	}

	public static void openBootStarer(Context context) {
		Log.i(CayteStarter.TAG, "Starter open Boot");
		context.getApplicationContext().getSharedPreferences("CayteStarter", 4).edit().putBoolean("isBootStarer", true)
				.commit();
	}

	public static void closeBootStarer(Context context) {
		Log.i(CayteStarter.TAG, "Starter close Boot");
		context.getApplicationContext().getSharedPreferences("CayteStarter", 4).edit().putBoolean("isBootStarer", false)
				.commit();
	}

	public static void start(Context context) {
		Log.i(CayteStarter.TAG, "Starter start...");
		Intent in = new Intent(context.getApplicationContext(), StarterService.class);
		in.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK);
		context.getApplicationContext().startService(in);
	}

}
