/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model.v25.group;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.model.AbstractGroup;
import ca.uhn.hl7v2.model.Group;
import ca.uhn.hl7v2.model.Structure;
import ca.uhn.hl7v2.model.v25.group.OMS_O05_OBSERVATION;
import ca.uhn.hl7v2.model.v25.group.OMS_O05_TIMING;
import ca.uhn.hl7v2.model.v25.segment.BLG;
import ca.uhn.hl7v2.model.v25.segment.NTE;
import ca.uhn.hl7v2.model.v25.segment.ORC;
import ca.uhn.hl7v2.model.v25.segment.RQ1;
import ca.uhn.hl7v2.model.v25.segment.RQD;
import ca.uhn.hl7v2.parser.ModelClassFactory;
import java.util.List;

public class OMS_O05_ORDER
extends AbstractGroup {
    public OMS_O05_ORDER(Group parent, ModelClassFactory factory) {
        super(parent, factory);
        this.init(factory);
    }

    private void init(ModelClassFactory factory) {
        try {
            this.add(ORC.class, true, false, false);
            this.add(OMS_O05_TIMING.class, false, true, false);
            this.add(RQD.class, true, false, false);
            this.add(RQ1.class, false, false, false);
            this.add(NTE.class, false, true, false);
            this.add(OMS_O05_OBSERVATION.class, false, true, false);
            this.add(BLG.class, false, false, false);
        }
        catch (HL7Exception e) {
            log.error("Unexpected error creating OMS_O05_ORDER - this is probably a bug in the source code generator.", (Throwable)e);
        }
    }

    public String getVersion() {
        return "2.5";
    }

    public ORC getORC() {
        ORC retVal = (ORC)this.getTyped("ORC", ORC.class);
        return retVal;
    }

    public OMS_O05_TIMING getTIMING() {
        OMS_O05_TIMING retVal = (OMS_O05_TIMING)this.getTyped("TIMING", OMS_O05_TIMING.class);
        return retVal;
    }

    public OMS_O05_TIMING getTIMING(int rep) {
        OMS_O05_TIMING retVal = (OMS_O05_TIMING)this.getTyped("TIMING", rep, OMS_O05_TIMING.class);
        return retVal;
    }

    public int getTIMINGReps() {
        return this.getReps("TIMING");
    }

    public List<OMS_O05_TIMING> getTIMINGAll() throws HL7Exception {
        return this.getAllAsList("TIMING", OMS_O05_TIMING.class);
    }

    public void insertTIMING(OMS_O05_TIMING structure, int rep) throws HL7Exception {
        super.insertRepetition("TIMING", (Structure)structure, rep);
    }

    public OMS_O05_TIMING insertTIMING(int rep) throws HL7Exception {
        return (OMS_O05_TIMING)super.insertRepetition("TIMING", rep);
    }

    public OMS_O05_TIMING removeTIMING(int rep) throws HL7Exception {
        return (OMS_O05_TIMING)super.removeRepetition("TIMING", rep);
    }

    public RQD getRQD() {
        RQD retVal = (RQD)this.getTyped("RQD", RQD.class);
        return retVal;
    }

    public RQ1 getRQ1() {
        RQ1 retVal = (RQ1)this.getTyped("RQ1", RQ1.class);
        return retVal;
    }

    public NTE getNTE() {
        NTE retVal = (NTE)this.getTyped("NTE", NTE.class);
        return retVal;
    }

    public NTE getNTE(int rep) {
        NTE retVal = (NTE)this.getTyped("NTE", rep, NTE.class);
        return retVal;
    }

    public int getNTEReps() {
        return this.getReps("NTE");
    }

    public List<NTE> getNTEAll() throws HL7Exception {
        return this.getAllAsList("NTE", NTE.class);
    }

    public void insertNTE(NTE structure, int rep) throws HL7Exception {
        super.insertRepetition("NTE", (Structure)structure, rep);
    }

    public NTE insertNTE(int rep) throws HL7Exception {
        return (NTE)super.insertRepetition("NTE", rep);
    }

    public NTE removeNTE(int rep) throws HL7Exception {
        return (NTE)super.removeRepetition("NTE", rep);
    }

    public OMS_O05_OBSERVATION getOBSERVATION() {
        OMS_O05_OBSERVATION retVal = (OMS_O05_OBSERVATION)this.getTyped("OBSERVATION", OMS_O05_OBSERVATION.class);
        return retVal;
    }

    public OMS_O05_OBSERVATION getOBSERVATION(int rep) {
        OMS_O05_OBSERVATION retVal = (OMS_O05_OBSERVATION)this.getTyped("OBSERVATION", rep, OMS_O05_OBSERVATION.class);
        return retVal;
    }

    public int getOBSERVATIONReps() {
        return this.getReps("OBSERVATION");
    }

    public List<OMS_O05_OBSERVATION> getOBSERVATIONAll() throws HL7Exception {
        return this.getAllAsList("OBSERVATION", OMS_O05_OBSERVATION.class);
    }

    public void insertOBSERVATION(OMS_O05_OBSERVATION structure, int rep) throws HL7Exception {
        super.insertRepetition("OBSERVATION", (Structure)structure, rep);
    }

    public OMS_O05_OBSERVATION insertOBSERVATION(int rep) throws HL7Exception {
        return (OMS_O05_OBSERVATION)super.insertRepetition("OBSERVATION", rep);
    }

    public OMS_O05_OBSERVATION removeOBSERVATION(int rep) throws HL7Exception {
        return (OMS_O05_OBSERVATION)super.removeRepetition("OBSERVATION", rep);
    }

    public BLG getBLG() {
        BLG retVal = (BLG)this.getTyped("BLG", BLG.class);
        return retVal;
    }
}

