/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.impl;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.HapiContext;
import ca.uhn.hl7v2.conf.ProfileException;
import ca.uhn.hl7v2.conf.check.Validator;
import ca.uhn.hl7v2.conf.parser.ProfileParser;
import ca.uhn.hl7v2.conf.spec.RuntimeProfile;
import ca.uhn.hl7v2.conf.store.ProfileStore;
import ca.uhn.hl7v2.model.Message;
import ca.uhn.hl7v2.util.Terser;
import ca.uhn.hl7v2.validation.ValidationException;
import ca.uhn.hl7v2.validation.impl.AbstractMessageRule;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConformanceProfileRule
extends AbstractMessageRule {
    private static final Logger log = LoggerFactory.getLogger(ConformanceProfileRule.class);
    private static final ProfileParser PARSER = new ProfileParser(true);
    private String myProfileID;
    private boolean enableCaching = true;
    private static final LinkedHashMap<String, RuntimeProfile> PROFILE_CACHE = new LinkedHashMap<String, RuntimeProfile>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, RuntimeProfile> eldest) {
            return this.size() > 100;
        }
    };

    public ConformanceProfileRule() {
        this.setDescription("Unknown segments found in message");
        this.setSectionReference("HL7 2.5 section 2.12");
    }

    public ConformanceProfileRule(String theProfileID) {
        this();
        this.myProfileID = theProfileID;
    }

    @Override
    public ValidationException[] apply(Message msg) {
        ArrayList<ValidationException> problems = new ArrayList<ValidationException>();
        String[] ids = new String[]{this.myProfileID};
        try {
            if (this.myProfileID == null) {
                ids = this.getDeclaredProfileIDs(msg);
            }
            for (String id : ids) {
                log.debug("Testing message against profile: {}", (Object)id);
                try {
                    ValidationException[] shortList = this.testAgainstProfile(msg, id);
                    log.debug("{} non-conformances", (Object)shortList.length);
                    problems.addAll(Arrays.asList(shortList));
                }
                catch (ProfileException e) {
                    problems.add(new ValidationException("Can't validate against profile: " + e.getMessage(), e));
                }
            }
        }
        catch (HL7Exception e) {
            problems.add(new ValidationException("Can't validate against profile: " + e.getMessage(), e));
        }
        return problems.toArray(new ValidationException[0]);
    }

    private String[] getDeclaredProfileIDs(Message theMessage) throws HL7Exception {
        Terser t = new Terser(theMessage);
        boolean noMore = false;
        int c = 0;
        ArrayList<String> declaredProfiles = new ArrayList<String>(8);
        while (!noMore) {
            String path;
            String idRep;
            if ((idRep = t.get(path = "MSH-21(" + c++ + ")")) == null || idRep.equals("")) {
                noMore = true;
                continue;
            }
            declaredProfiles.add(idRep);
        }
        return declaredProfiles.toArray(new String[0]);
    }

    private synchronized RuntimeProfile getProfile(String profileString) throws ProfileException {
        RuntimeProfile profile = PROFILE_CACHE.get(profileString);
        if (profile == null) {
            profile = PARSER.parse(profileString);
            if (this.enableCaching) {
                PROFILE_CACHE.put(profileString, profile);
            }
        }
        return profile;
    }

    private ValidationException[] testAgainstProfile(Message message, String id) throws ProfileException, HL7Exception {
        HL7Exception[] exceptions;
        HapiContext context = message.getParser().getHapiContext();
        Validator validator = context.getConformanceValidator();
        try {
            ProfileStore profileStore = context.getProfileStore();
            String profileString = profileStore.getProfile(id);
            if (profileString == null) {
                throw new ProfileException("Unable to find the profile " + id);
            }
            RuntimeProfile profile = this.getProfile(profileString);
            exceptions = validator.validate(message, profile.getMessage());
        }
        catch (IOException e) {
            throw new ProfileException("Error retreiving profile " + id, e);
        }
        ValidationException[] result = new ValidationException[exceptions.length];
        for (int i = 0; i < exceptions.length; ++i) {
            result[i] = ValidationException.fromHL7Exception(exceptions[i]);
        }
        return result;
    }

    @Override
    public String getDescription() {
        return "expected conformance to declared or predefined message profiles";
    }

    @Override
    public String getSectionReference() {
        return "HL7 2.5 section 2.12";
    }

    public String getProfileID() {
        return this.myProfileID;
    }

    public void setEnableCaching(boolean enableCaching) {
        this.enableCaching = enableCaching;
    }
}

