/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.validation.builder;

import ca.uhn.hl7v2.Version;
import ca.uhn.hl7v2.model.MessageVisitorFactory;
import ca.uhn.hl7v2.validation.MessageRule;
import ca.uhn.hl7v2.validation.Rule;
import ca.uhn.hl7v2.validation.builder.Predicate;
import ca.uhn.hl7v2.validation.builder.RuleTypeBuilder;
import ca.uhn.hl7v2.validation.builder.support.ChoiceElementsRespectedRule;
import ca.uhn.hl7v2.validation.builder.support.OnlyAllowableSegmentsInSuperstructureRule;
import ca.uhn.hl7v2.validation.builder.support.OnlyKnownSegmentsRule;
import ca.uhn.hl7v2.validation.builder.support.TerserMessageRule;
import ca.uhn.hl7v2.validation.builder.support.ValidatingMessageVisitor;
import ca.uhn.hl7v2.validation.builder.support.VisitorMessageRule;
import ca.uhn.hl7v2.validation.builder.support.WrongVersionRule;
import ca.uhn.hl7v2.validation.impl.ConformanceProfileRule;
import ca.uhn.hl7v2.validation.impl.MessageRuleBinding;
import ca.uhn.hl7v2.validation.impl.RuleBinding;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class MessageRuleBuilder
extends RuleTypeBuilder<MessageRuleBuilder, MessageRule> {
    private final String messageType;
    private final String[] triggerEvents;

    protected MessageRuleBuilder(List<RuleBinding<? extends Rule<?>>> rules, Set<Version> versions, String messageType, String ... triggerEvents) {
        super(rules, versions);
        this.messageType = messageType;
        this.triggerEvents = triggerEvents;
    }

    public MessageRuleBuilder terser(String spec, Predicate predicate) {
        return (MessageRuleBuilder)this.test((MessageRule)this.prepareRule(new TerserMessageRule(spec, predicate)));
    }

    public MessageRuleBuilder inspect(MessageVisitorFactory<? extends ValidatingMessageVisitor> visitorFactory) {
        return (MessageRuleBuilder)this.test((MessageRule)this.prepareRule(new VisitorMessageRule(visitorFactory)));
    }

    public MessageRuleBuilder onlyKnownSegments() {
        return (MessageRuleBuilder)this.test(this.prepareRule(OnlyKnownSegmentsRule.ONLY_KNOWN_SEGMENTS));
    }

    public MessageRuleBuilder onlyAllowableSegmentsInSuperStructure() {
        return (MessageRuleBuilder)this.test(this.prepareRule(OnlyAllowableSegmentsInSuperstructureRule.ONLY_ALLOWABLE_SEGMENTS));
    }

    public MessageRuleBuilder choiceElementsRespected() {
        return (MessageRuleBuilder)this.test(this.prepareRule(ChoiceElementsRespectedRule.CHOICE_ELEMENTS_RESPECTED));
    }

    public MessageRuleBuilder wrongVersion() {
        return (MessageRuleBuilder)this.test(this.prepareRule(WrongVersionRule.WRONG_VERSION));
    }

    public MessageRuleBuilder conformance() {
        return this.conformance(null);
    }

    public MessageRuleBuilder conformance(String profileId) {
        return (MessageRuleBuilder)this.test((MessageRule)this.prepareRule(new ConformanceProfileRule(profileId)));
    }

    String getMessageType() {
        return this.messageType;
    }

    String[] getTriggerEvents() {
        return this.triggerEvents;
    }

    @Override
    protected Collection<RuleBinding<MessageRule>> getRuleBindings(MessageRule rule, String version) {
        ArrayList bindings = new ArrayList();
        for (String triggerEvent : this.triggerEvents) {
            bindings.add(new MessageRuleBinding(version, this.messageType, triggerEvent, rule));
        }
        return this.activate(bindings);
    }
}

