/*
 * Decompiled with CFR 0.152.
 */
package ca.uhn.hl7v2.model;

import ca.uhn.hl7v2.HL7Exception;
import ca.uhn.hl7v2.Location;
import ca.uhn.hl7v2.model.MessageVisitor;
import ca.uhn.hl7v2.model.Type;
import ca.uhn.hl7v2.model.Visitable;

public class Field
implements Visitable {
    private final Type[] reps;
    private final int maxCardinality;

    public Field(Type[] reps, int maxCardinality) {
        this.reps = reps;
        this.maxCardinality = maxCardinality;
    }

    @Override
    public boolean accept(MessageVisitor visitor, Location currentLocation) throws HL7Exception {
        if (visitor.start(this, currentLocation)) {
            for (int i = 0; i < this.reps.length; ++i) {
                Type t = this.reps[i];
                Location nextLocation = currentLocation;
                if (this.reps.length > 1) {
                    nextLocation = this.provideLocation(currentLocation, currentLocation.getField(), i);
                }
                if (!t.accept(visitor, nextLocation)) break;
            }
        }
        return visitor.end(this, currentLocation);
    }

    @Override
    public Location provideLocation(Location parentLocation, int index, int repetition) {
        return new Location(parentLocation).withField(index).withFieldRepetition(repetition);
    }

    @Override
    public boolean isEmpty() {
        return this.reps.length == 0;
    }
}

