/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.r5.fhirpath.ExpressionNode;
import org.hl7.fhir.r5.fhirpath.FHIRPathEngine;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.codegen.Analysis;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.EnumInfo;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;
import org.hl7.fhir.validation.codegen.TypeInfo;

public class JavaParserJsonGenerator
extends JavaBaseGenerator {
    private StringBuilder register = new StringBuilder();
    private StringBuilder parser = new StringBuilder();
    private StringBuilder pregt = new StringBuilder();
    private StringBuilder pregt2 = new StringBuilder();
    private StringBuilder pregf = new StringBuilder();
    private StringBuilder pregn = new StringBuilder();
    private StringBuilder composer = new StringBuilder();
    private StringBuilder creg = new StringBuilder();
    private StringBuilder cregn = new StringBuilder();
    private StringBuilder cregtn = new StringBuilder();
    private StringBuilder cregtp = new StringBuilder();
    private StringBuilder cregti = new StringBuilder();
    private List<TypeSpecifier> typeSpecifiers = new ArrayList<TypeSpecifier>();
    FHIRPathEngine fpe;
    private String jname;

    public JavaParserJsonGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName, String jname) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
        this.fpe = new FHIRPathEngine(definitions.getContext());
        this.jname = jname;
    }

    public void seeClass(Analysis analysis) throws Exception {
        this.generateParser(analysis);
        this.generateComposer(analysis);
        if (!analysis.isAbstract()) {
            if (analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.COMPLEXTYPE) {
                this.pregt.append("    } else if (json.has(prefix+\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getRootType().getName() + "(getJObject(json, prefix+\"" + analysis.getName() + "\"));\r\n");
                this.pregt2.append("   } else if (type.equals(\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getName() + "(json);\r\n");
                this.cregtn.append("    } else if (type instanceof " + analysis.getName() + ") {\r\n       compose" + analysis.getName() + "(prefix+\"" + analysis.getName() + "\", (" + analysis.getClassName() + ") type);\r\n");
                this.cregti.append("    } else if (type instanceof " + analysis.getName() + ") {\r\n       compose" + analysis.getName() + "Properties((" + analysis.getName() + ") type);\r\n");
            }
            this.pregn.append("    if (json.has(prefix+\"" + analysis.getName() + "\")) {\r\n      return true;\r\n    };\r\n");
            if (analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE) {
                this.pregf.append("    } else if (t.equals(\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getClassName() + "(json);\r\n");
                this.creg.append("    } else if (resource instanceof " + analysis.getClassName() + ") {\r\n      compose" + analysis.getClassName() + "(\"" + analysis.getName() + "\", (" + analysis.getClassName() + ")resource);\r\n");
                this.cregn.append("    } else if (resource instanceof " + analysis.getClassName() + ") {\r\n      compose" + analysis.getClassName() + "(name, (" + analysis.getClassName() + ")resource);\r\n");
            }
        }
    }

    public void generate() throws Exception {
        String template = this.config.getAdornments().get("JsonParser");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{jname}}", this.jname);
        template = template.replace("{{parser}}", this.parser.toString());
        template = template.replace("{{register}}", this.register.toString());
        template = template.replace("{{parse-resource}}", this.pregf.toString());
        template = template.replace("{{parse-type-pfx}}", this.pregt.toString());
        template = template.replace("{{parse-type}}", this.pregt2.toString());
        template = template.replace("{{parse-has-type}}", this.pregn.toString());
        template = template.replace("{{composer}}", this.composer.toString());
        template = template.replace("{{compose-resource}}", this.creg.toString());
        template = template.replace("{{compose-resource-named}}", this.cregn.toString());
        template = template.replace("{{compose-type}}", this.cregtp.toString() + this.cregtn.toString());
        template = template.replace("{{compose-type-inner}}", this.cregti.toString());
        this.write(template);
        this.flush();
        this.close();
    }

    private String getAsJsonPrimitive(String code, boolean shrt) {
        if ("boolean".equals(code)) {
            return shrt ? "Boolean" : "java.lang.Boolean";
        }
        if ("decimal".equals(code)) {
            return shrt ? "BigDecimal" : "java.math.BigDecimal";
        }
        if ("integer".equals(code) || "integer64".equals(code)) {
            return shrt ? "Long" : "java.lang.Long";
        }
        return "String";
    }

    private void generateParser(Analysis analysis) throws Exception {
        if (analysis.getAncestor().getName().equals("Resource")) {
            this.register.append("    org.hl7.fhir.r5.formats.JsonParser.customResourceHandlers.put(\"" + analysis.getName() + "\", new " + this.jname + "JsonParserFactory());\r\n");
            this.pregf.append("    } else if (t.equals(\"" + analysis.getName() + "\")) {\r\n      return parse" + analysis.getClassName() + "(json);\r\n");
            this.creg.append("    } else if (resource instanceof " + analysis.getClassName() + ") {\r\n      compose" + analysis.getClassName() + "(\"" + analysis.getName() + "\", (" + analysis.getClassName() + ")resource);\r\n");
            this.cregn.append("    } else if (resource instanceof " + analysis.getClassName() + ") {\r\n      compose" + analysis.getClassName() + "(name, (" + analysis.getClassName() + ")resource);\r\n");
        }
        if (analysis.isAbstract()) {
            this.genInnerAbstract(analysis, analysis.getRootType());
        } else {
            this.genInner(analysis, analysis.getRootType());
        }
        for (TypeInfo ti : analysis.getTypeList()) {
            this.genInner(analysis, ti);
        }
    }

    private void genInner(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String tn = ti.getName();
        String stn = ti == analysis.getRootType() ? tn : analysis.getClassName() + "." + tn;
        String pn = "parse" + tn;
        if (stn.contains(".") && !pn.startsWith("parse" + analysis.getClassName())) {
            pn = "parse" + analysis.getClassName() + tn;
        }
        boolean bUseOwner = false;
        this.parser.append("  protected " + stn + " " + pn + "(JsonObject json) throws IOException, FHIRFormatError {\r\n");
        this.parser.append("    " + stn + " res = new " + stn + "();\r\n");
        this.parser.append("    " + pn + "Properties(json, res);\r\n");
        this.parser.append("    return res;\r\n");
        this.parser.append("  }\r\n\r\n");
        this.parser.append("  protected void " + pn + "Properties(JsonObject json, " + stn + " res) throws IOException, FHIRFormatError {\r\n");
        this.parser.append("    parse" + ti.getAncestorName() + "Properties(json, res);\r\n");
        for (ElementDefinition e : ti.getChildren()) {
            this.genElementParser(analysis, ti, e, bUseOwner, this.matchingInheritedElement(ti.getInheritedChildren(), e, analysis.getName()));
        }
        this.parser.append("  }\r\n\r\n");
        for (TypeSpecifier ts : this.typeSpecifiers) {
            this.genTypeSpecifierParser(ts);
        }
        this.typeSpecifiers.clear();
    }

    private void genTypeSpecifierParser(TypeSpecifier ts) {
        this.parser.append("  protected " + ts.resName + " " + ts.fnName + "(JsonObject resource, JsonObject json) throws IOException, FHIRFormatError {\r\n");
        for (Extension ex : ts.ed.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            ExpressionNode cond = this.fpe.parse(ex.getExtensionString("condition"));
            this.parser.append("    if (" + this.renderNode(cond) + ") {\r\n");
            this.parser.append("      return parse" + Utilities.urlTail((String)ex.getExtensionString("type")) + "(json);\r\n");
            this.parser.append("    }\r\n");
        }
        this.parser.append("    throw new FHIRFormatError(\"Unable to parse " + ts.resName + ": The content does not meet any of the type specifiers\");\r\n");
        this.parser.append("  }\r\n\r\n");
    }

    private String renderNode(ExpressionNode node) {
        StringBuilder b = new StringBuilder();
        switch (node.getKind()) {
            case Constant: {
                if ("%resource".equals(node.getConstant().primitiveValue())) {
                    b.append("resource");
                    break;
                }
                b.append("\"" + node.getConstant().primitiveValue() + "\"");
                break;
            }
            case Function: {
                throw new Error("Not done yet");
            }
            case Group: {
                throw new Error("Not done yet");
            }
            case Name: {
                b.append("get(\"" + node.getName() + "\").getAsString()");
                break;
            }
            case Unary: {
                throw new Error("Not done yet");
            }
            default: {
                throw new Error("Not done yet");
            }
        }
        if (node.getInner() != null) {
            b.append(".");
            b.append(this.renderNode(node.getInner()));
        }
        if (node.getOpNext() != null) {
            if (node.getOperation() == ExpressionNode.Operation.Equals) {
                b.append(".equals(");
                b.append(this.renderNode(node.getOpNext()));
                b.append(")");
            } else {
                throw new Error("Not done yet");
            }
        }
        return b.toString();
    }

    private void genInnerAbstract(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String tn = analysis.getRootType().getName();
        String stn = ti == analysis.getRootType() ? tn : analysis.getClassName() + "." + tn;
        String pn = "parse" + tn;
        if (stn.contains(".") && !pn.startsWith("parse" + analysis.getClassName())) {
            pn = "parse" + analysis.getClassName() + tn;
        }
        boolean bUseOwner = false;
        this.parser.append("  protected " + stn + " " + pn + "(JsonObject json) throws IOException, FHIRFormatError {\r\n");
        this.parser.append("    if (json.has(\"_type\")) { throw new FHIRException(\"'_type' property not found\"); }\r\n");
        this.parser.append("    String type = json.get(\"_type\").getAsString();\r\n");
        this.parser.append("    switch (type) {\r\n");
        for (Map.Entry<String, String> entry : this.getConcreteDescendents(analysis, ti).entrySet()) {
            this.parser.append("    case \"" + entry.getKey() + "\": return parse" + entry.getValue() + "(json);\r\n");
        }
        this.parser.append("    default: throw new FHIRException(\"Unsupported type '\"+type+\"'\");\r\n");
        this.parser.append("    }\r\n");
        this.parser.append("  }\r\n\r\n");
        this.parser.append("  protected void parse" + this.upFirst(tn).replace(".", "") + "Properties(JsonObject json, " + tn + " res) throws IOException, FHIRFormatError {\r\n");
        if (!"Element".equals(tn) && analysis.getAncestor() != null) {
            this.parser.append("    parse" + analysis.getAncestor().getName() + "Properties(json, res);\r\n");
        }
        if (!analysis.isInterface()) {
            for (ElementDefinition elementDefinition : analysis.getRootType().getChildren()) {
                this.genElementParser(analysis, analysis.getRootType(), elementDefinition, bUseOwner, null);
            }
        }
        this.parser.append("  }\r\n\r\n");
    }

    private void genElementParser(Analysis analysis, TypeInfo ti, ElementDefinition ed, boolean bUseOwner, ElementDefinition inh) throws Exception {
        String name = ed.getName();
        String tn = ed.getUserString("java.type");
        if (this.isNamedElementExtensions(ed)) {
            this.parser.append("    // todo: Named Element Extensions\r\n");
        } else if (name.endsWith("[x]") || name.equals("[type]")) {
            String en = name.endsWith("[x]") && !name.equals("[x]") ? name.replace("[x]", "") : "value";
            String pfx = name.endsWith("[x]") ? name.replace("[x]", "") : "";
            this.parser.append("    DataType " + this.getElementName(en, false) + " = parseType(\"" + en + "\", json);\r\n");
            this.parser.append("    if (" + this.getElementName(en, false) + " != null)\r\n");
            this.parser.append("      res.set" + this.upFirst(this.getElementName(en, false)) + "(" + this.getElementName(en, false) + ");\r\n");
        } else {
            String prsr = null;
            Object aprsr = null;
            Object anprsr = null;
            EnumInfo ei = null;
            String en = null;
            if (ed.hasUserData("java.enum")) {
                ei = (EnumInfo)ed.getUserData("java.enum");
                ValueSet vs = ei.getValueSet();
                en = vs.hasUserData("shared") ? "Enumerations." + ei.getName() : analysis.getClassName() + "." + ei.getName();
                prsr = "parseEnumeration(json.get(\"" + name + "\").getAsString(), " + en + ".NULL, new " + en.substring(0, en.indexOf(".")) + "." + en.substring(en.indexOf(".") + 1) + "EnumFactory())";
                aprsr = "parseEnumeration(array.get(i).getAsString(), " + en + ".NULL, new " + en.substring(0, en.indexOf(".")) + "." + en.substring(en.indexOf(".") + 1) + "EnumFactory())";
                anprsr = "parseEnumeration(null, " + en + ".NULL, new " + en.substring(0, en.indexOf(".")) + "." + en.substring(en.indexOf(".") + 1) + "EnumFactory())";
            } else if (ed.hasUserData("JGEN_ALL_PRIMITIVE")) {
                prsr = "parseNativePrimitive(json, \"" + name + "\")";
            } else if (ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
                prsr = "parse" + tn + "(json, getJObject(json, \"" + name + "\"))";
                aprsr = "parse" + tn + "(json, array.get(i).getAsJsonObject())";
                anprsr = "parse" + tn + "(null, null)";
                this.typeSpecifiers.add(new TypeSpecifier("parse" + tn, tn, ed));
            } else if (tn.equals("XhtmlNode")) {
                prsr = "parseXhtml(json.get(\"" + name + "\").getAsString())";
            } else if (tn.contains("Reference(")) {
                prsr = "parseReference(getJObject(json, \"" + name + "\"))";
                aprsr = "parseReference(array.get(i).getAsJsonObject())";
                anprsr = "parseReference(null)";
            } else if (tn.contains("canonical(")) {
                prsr = "parseCanonical(json.get(\"" + name + "\").getAsString())";
                aprsr = "parseCanonical(array.get(i).getAsString())";
                anprsr = "parseCanonical(null)";
            } else if (this.isPrimitive(ed.typeSummary())) {
                if (tn.endsWith("Type")) {
                    tn = tn.substring(0, tn.length() - 4);
                }
                prsr = "parse" + this.upFirst(tn) + "(json.get(\"" + name + "\").getAs" + this.getAsJsonPrimitive(ed.typeSummary(), true) + "())";
                aprsr = "parse" + this.upFirst(tn) + "(array.get(i).getAs" + this.getAsJsonPrimitive(ed.typeSummary(), true) + "())";
                anprsr = "parse" + this.upFirst(tn) + "(null)";
            } else {
                Object pn = tn;
                if ((ed.isInlineType() || ed.hasContentReference()) && !((String)pn).startsWith(analysis.getClassName())) {
                    pn = analysis.getClassName() + (String)pn;
                }
                prsr = "parse" + (String)pn + "(getJObject(json, \"" + name + "\"))";
                aprsr = "parse" + (String)pn + "(array.get(i).getAsJsonObject())";
                anprsr = "parse" + (String)pn + "(null)";
            }
            if (ed.unbounded()) {
                if (this.isPrimitive(ed.typeSummary()) || ed.typeSummary().startsWith("canonical(")) {
                    this.parser.append("    if (json.has(\"" + name + "\")) {\r\n");
                    this.parser.append("      JsonArray array = getJArray(json, \"" + name + "\");\r\n");
                    this.parser.append("      for (int i = 0; i < array.size(); i++) {\r\n");
                    this.parser.append("        if (array.get(i).isJsonNull()) {\r\n");
                    if (en == null) {
                        this.parser.append("          res.get" + this.upFirst(name) + "List().add(new " + tn + "Type());\r\n");
                    } else {
                        this.parser.append("          res.get" + this.upFirst(name) + "List().add(new Enumeration<" + en + ">(new " + en + "EnumFactory(), " + en + ".NULL));\r\n");
                    }
                    this.parser.append("        } else {;\r\n");
                    this.parser.append("          res.get" + this.upFirst(name) + "List().add(" + (String)aprsr + ");\r\n");
                    this.parser.append("        }\r\n");
                    this.parser.append("      }\r\n");
                    this.parser.append("    };\r\n");
                    this.parser.append("    if (json.has(\"_" + name + "\")) {\r\n");
                    this.parser.append("      JsonArray array = getJArray(json, \"_" + name + "\");\r\n");
                    this.parser.append("      for (int i = 0; i < array.size(); i++) {\r\n");
                    this.parser.append("        if (i == res.get" + this.upFirst(name) + "List().size())\r\n");
                    this.parser.append("          res.get" + this.upFirst(name) + "List().add(" + (String)anprsr + ");\r\n");
                    this.parser.append("        if (array.get(i) instanceof JsonObject) \r\n");
                    this.parser.append("          parseElementProperties(array.get(i).getAsJsonObject(), res.get" + this.upFirst(name) + "List().get(i));\r\n");
                    this.parser.append("      }\r\n");
                    this.parser.append("    };\r\n");
                } else {
                    this.parser.append("    if (json.has(\"" + name + "\")) {\r\n");
                    this.parser.append("      JsonArray array = getJArray(json, \"" + name + "\");\r\n");
                    this.parser.append("      for (int i = 0; i < array.size(); i++) {\r\n");
                    this.parser.append("        res.get" + this.upFirst(this.getElementName(name, false)) + "List().add(" + (String)aprsr + ");\r\n");
                    this.parser.append("      }\r\n");
                    this.parser.append("    };\r\n");
                }
            } else if (inh != null && inh.unbounded()) {
                this.parser.append("    if (json.has(\"" + name + "\"))\r\n");
                if ((this.isPrimitive(ed.typeSummary()) || ed.typeSummary().startsWith("canonical(")) && !tn.equals("XhtmlNode")) {
                    this.parser.append("      res.add" + this.upFirst(this.getElementName(name, false)) + "Element(" + prsr + ");\r\n");
                    this.parser.append("    if (json.has(\"_" + name + "\"))\r\n");
                    this.parser.append("      parseElementProperties(getJObject(json, \"_" + name + "\"), res.get" + this.upFirst(this.getElementName(name, false)) + "ElementFirstRep());\r\n");
                } else {
                    this.parser.append("      res.add" + this.upFirst(this.getElementName(name, false)) + "(" + prsr + ");\r\n");
                }
            } else {
                this.parser.append("    if (json.has(\"" + name + "\"))\r\n");
                if ((this.isPrimitive(ed.typeSummary()) || ed.typeSummary().startsWith("canonical(")) && !tn.equals("XhtmlNode")) {
                    this.parser.append("      res.set" + this.upFirst(this.getElementName(name, false)) + "Element(" + prsr + ");\r\n");
                    this.parser.append("    if (json.has(\"_" + name + "\"))\r\n");
                    this.parser.append("      parseElementProperties(getJObject(json, \"_" + name + "\"), res.get" + this.upFirst(this.getElementName(name, false)) + "Element());\r\n");
                } else {
                    this.parser.append("      res.set" + this.upFirst(this.getElementName(name, false)) + "(" + prsr + ");\r\n");
                }
            }
        }
    }

    private String upFirst(String n) {
        return n.substring(0, 1).toUpperCase() + n.substring(1);
    }

    private void generateComposer(Analysis analysis) throws Exception {
        if (analysis.isAbstract()) {
            this.genInnerAbstractComposer(analysis, analysis.getRootType());
        } else {
            this.genInnerComposer(analysis, analysis.getRootType());
        }
        for (TypeInfo ti : analysis.getTypeList()) {
            this.genInnerComposer(analysis, ti);
        }
    }

    private void genInnerAbstractComposer(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        String tn = analysis.getRootType().getName();
        String stn = ti == analysis.getRootType() ? tn : analysis.getClassName() + "." + tn;
        this.composer.append("  protected void compose" + tn + "(String name, " + stn + " element) throws IOException {\r\n");
        this.composer.append("    if (element != null) {\r\n");
        this.composer.append("      open(name);\r\n");
        this.composer.append("      prop(\"_type\", element.fhirType());\r\n");
        this.composer.append("      switch (element.fhirType()) {\r\n");
        for (Map.Entry<String, String> entry : this.getConcreteDescendents(analysis, ti).entrySet()) {
            this.composer.append("      case \"" + entry.getKey() + "\":\r\n");
            this.composer.append("        compose" + entry.getValue() + "Properties((" + entry.getValue() + ") element);\r\n");
            this.composer.append("        close();\r\n");
            this.composer.append("        break;\r\n");
        }
        this.composer.append("      default: throw new FHIRException(\"Unsupported type '\"+element.fhirType()+\"'\");\r\n");
        this.composer.append("      }\r\n");
        this.composer.append("    }\r\n");
        this.composer.append("  }\r\n\r\n");
        this.composer.append("  protected void compose" + tn + "Properties(" + tn + " element) throws IOException {\r\n");
        if (!"Element".equals(tn) && analysis.getAncestor() != null) {
            this.composer.append("      compose" + analysis.getAncestor().getName() + "Properties(element);\r\n");
        }
        if (!analysis.isInterface()) {
            for (ElementDefinition elementDefinition : analysis.getRootType().getChildren()) {
                this.genElementComposer(analysis, analysis.getRootType(), elementDefinition, null);
            }
        }
        this.composer.append("  }\r\n\r\n");
    }

    private void genInnerComposer(Analysis analysis, TypeInfo ti) throws IOException, Exception {
        boolean isResource;
        String tn = ti.getName();
        String stn = ti == analysis.getRootType() ? tn : analysis.getClassName() + "." + tn;
        this.composer.append("  protected void compose" + tn + "(String name, " + stn + " element) throws IOException {\r\n");
        this.composer.append("    if (element != null) {\r\n");
        boolean bl = isResource = ti == analysis.getRootType() && analysis.getStructure().getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE;
        if (ti.getAncestorName().equals("Resource")) {
            this.composer.append("      prop(\"resourceType\", \"" + analysis.getName() + "\");\r\n");
        } else {
            this.composer.append("      open(name);\r\n");
        }
        this.composer.append("      compose" + this.upFirst(tn).replace(".", "") + "Properties(element);\r\n");
        if (!ti.getAncestorName().equals("Resource")) {
            this.composer.append("      close();\r\n");
        }
        this.composer.append("    }\r\n");
        this.composer.append("  }\r\n\r\n");
        this.composer.append("  protected void compose" + tn + "Properties(" + stn + " element) throws IOException {\r\n");
        this.composer.append("    compose" + ti.getAncestorName() + "Properties(element);\r\n");
        for (ElementDefinition e : ti.getChildren()) {
            this.genElementComposer(analysis, analysis.getRootType(), e, this.matchingInheritedElement(ti.getInheritedChildren(), e, analysis.getName()));
        }
        this.composer.append("  }\r\n\r\n");
        for (TypeSpecifier ts : this.typeSpecifiers) {
            this.genTypeSpecifierCompose(ts);
        }
        this.typeSpecifiers.clear();
    }

    private void genTypeSpecifierCompose(TypeSpecifier ts) {
        this.composer.append("  protected void " + ts.fnName + "(String name, " + ts.resName + " element) throws IOException {\r\n");
        boolean first = true;
        for (Extension ex : ts.ed.getExtensionsByUrl("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
            String tn = Utilities.urlTail((String)ex.getExtensionString("type"));
            this.composer.append("    " + (first ? "" : "} else ") + "if (element instanceof " + tn + ") {\r\n");
            this.composer.append("      compose" + tn + "(name, (" + tn + ") element);\r\n");
            first = false;
        }
        this.composer.append("    } else {\r\n");
        this.composer.append("      throw new FHIRFormatError(\"Unable to compose " + ts.resName + ": Unexpected type \"+element.getClass().getName());\r\n");
        this.composer.append("    }\r\n");
        this.composer.append("  }\r\n");
        this.composer.append("\r\n");
    }

    private String pathClass(String tn) {
        return tn.substring(0, tn.indexOf(46));
    }

    private String pathNode(String tn) {
        return tn.substring(tn.indexOf(46) + 1);
    }

    private void genElementComposer(Analysis analysis, TypeInfo ti, ElementDefinition ed, ElementDefinition inh) throws Exception {
        String name = ed.getName();
        if (this.isNamedElementExtensions(ed)) {
            this.composer.append("     // todo: Named Element Extensions\r\n");
        } else if (name.endsWith("[x]") || name.equals("[type]")) {
            String en = name.endsWith("[x]") && !name.equals("[x]") ? name.replace("[x]", "") : "value";
            String pfx = name.endsWith("[x]") ? name.replace("[x]", "") : "";
            this.composer.append("      if (element.has" + this.upFirst(en) + "()) {\r\n");
            this.composer.append("        composeType(\"" + pfx + "\", element.get" + this.upFirst(en) + "());\r\n");
            this.composer.append("      }\r\n");
        } else {
            Object tn = ed.getUserString("java.type");
            Object comp = null;
            String en = null;
            boolean enShared = false;
            if (ed.hasUserData("java.enum")) {
                EnumInfo ei = (EnumInfo)ed.getUserData("java.enum");
                ValueSet vs = ei.getValueSet();
                enShared = vs.hasUserData("shared");
                en = enShared ? "Enumerations." + ei.getName() : analysis.getClassName() + "." + ei.getName();
            } else if (ed.hasUserData("JGEN_ALL_PRIMITIVE")) {
                tn = ed.getUserString("java.type");
                comp = "composeNativePrimitive";
            } else if (((String)tn).equals("XhtmlNode")) {
                tn = "xhtml";
                comp = "composeXhtml";
            } else if (((String)tn).equals("code")) {
                tn = "Code";
                comp = "composeCode";
            } else if (((String)tn).equals("instant")) {
                tn = "Instant";
            } else if (((String)tn).contains("Reference(")) {
                comp = "composeReference";
                tn = "Reference";
            } else if (((String)tn).contains("canonical(")) {
                comp = "composeCanonical";
                tn = "CanonicalType";
            } else if (((String)tn).contains("(")) {
                comp = "compose" + (String)tn;
            } else if (((String)tn).startsWith(analysis.getName()) && !((String)tn).equals(analysis.getClassName())) {
                comp = "compose" + this.leaf((String)tn);
            } else if (this.isPrimitive(ed)) {
                comp = "compose" + this.leaf((String)tn);
                comp = ((String)comp).substring(0, ((String)comp).length() - 4);
            } else {
                comp = "compose" + this.leaf((String)tn);
            }
            if (ed.unbounded()) {
                tn = ed.getUserString("java.type");
                if (((String)tn).contains("Reference(")) {
                    comp = "composeReference";
                    tn = "Reference";
                } else if (((String)tn).contains("canonical(")) {
                    comp = "composeCanonical";
                    tn = "CanonicalType";
                }
                Object stn = tn;
                if (ed.isInlineType() || ed.hasContentReference()) {
                    stn = analysis.getClassName() + "." + (String)tn;
                }
                this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                if (en == null) {
                    if (((String)tn).equals("String")) {
                        tn = "StringType";
                    }
                    if (this.definitions.hasPrimitiveType((String)tn)) {
                        tn = this.upFirst((String)tn) + "Type";
                    }
                    if (this.isPrimitive(ed) || ed.typeSummary().startsWith("canonical(")) {
                        this.composer.append("        if (anyHasValue(element.get" + this.upFirst(this.getElementName(name, false)) + "List())) {\r\n");
                        this.composer.append("          openArray(\"" + name + "\");\r\n");
                        this.composer.append("          for (" + (String)(((String)tn).contains("(") ? stn : this.upFirst((String)tn)) + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) \r\n");
                        this.composer.append("            " + (String)comp + "Core(null, e, e != element.get" + this.upFirst(this.getElementName(name, false)) + "List().get(element.get" + this.upFirst(this.getElementName(name, false)) + "List().size()-1));\r\n");
                        this.composer.append("          closeArray();\r\n");
                        this.composer.append("        }\r\n");
                        this.composer.append("        if (anyHasExtras(element.get" + this.upFirst(this.getElementName(name, false)) + "List())) {\r\n");
                        this.composer.append("          openArray(\"_" + name + "\");\r\n");
                        this.composer.append("          for (" + (String)(((String)stn).contains("(") ? stn : this.upFirst((String)stn)) + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) \r\n");
                        this.composer.append("            " + (String)comp + "Extras(null, e, true);\r\n");
                        this.composer.append("          closeArray();\r\n");
                        this.composer.append("        }\r\n");
                    } else if (ed.typeSummary().equals("Resource")) {
                        this.composer.append("        openArray(\"" + name + "\");\r\n");
                        this.composer.append("        for (" + (String)(((String)stn).contains("(") ? tn : this.upFirst((String)tn)) + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) {\r\n");
                        this.composer.append("          open(null);\r\n");
                        this.composer.append("          " + (String)comp + "(e);\r\n");
                        this.composer.append("          close();\r\n");
                        this.composer.append("        }\r\n");
                        this.composer.append("        closeArray();\r\n");
                    } else {
                        this.composer.append("        openArray(\"" + name + "\");\r\n");
                        if (((String)stn).contains(".") || !((String)stn).contains("Component")) {
                            this.composer.append("        for (" + (String)(((String)stn).contains("(") ? stn : this.upFirst((String)stn)) + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) \r\n");
                        } else {
                            this.composer.append("        for (" + ti.getName() + "." + (String)(((String)stn).contains("(") ? stn : this.upFirst((String)stn)) + " e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) \r\n");
                        }
                        this.composer.append("          " + (String)comp + "(null, e);\r\n");
                        this.composer.append("        closeArray();\r\n");
                    }
                } else {
                    this.composer.append("        openArray(\"" + name + "\");\r\n");
                    this.composer.append("        for (Enumeration<" + this.prepEnumName(en) + "> e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) \r\n");
                    this.composer.append("          composeEnumerationCore(null, e, new " + this.prepEnumName(en) + "EnumFactory(), true);\r\n");
                    this.composer.append("        closeArray();\r\n");
                    this.composer.append("        if (anyHasExtras(element.get" + this.upFirst(this.getElementName(name, false)) + "())) {\r\n");
                    this.composer.append("          openArray(\"_" + name + "\");\r\n");
                    this.composer.append("          for (Enumeration<" + this.prepEnumName(en) + "> e : element.get" + this.upFirst(this.getElementName(name, false)) + "List()) \r\n");
                    this.composer.append("            composeEnumerationExtras(null, e, new " + this.prepEnumName(en) + "EnumFactory(), true);\r\n");
                    this.composer.append("          closeArray();\r\n");
                    this.composer.append("        }\r\n");
                }
                this.composer.append("      };\r\n");
            } else if (en != null) {
                this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "Element()) {\r\n");
                if (enShared) {
                    this.composer.append("        composeEnumerationCore(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), new " + this.prepEnumName(en) + "EnumFactory(), false);\r\n");
                    this.composer.append("        composeEnumerationExtras(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), new " + this.prepEnumName(en) + "EnumFactory(), false);\r\n");
                } else {
                    this.composer.append("        composeEnumerationCore(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), new " + this.prepEnumName(en) + "EnumFactory(), false);\r\n");
                    this.composer.append("        composeEnumerationExtras(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), new " + this.prepEnumName(en) + "EnumFactory(), false);\r\n");
                }
                this.composer.append("      }\r\n");
            } else if (ed.typeSummary().equals("Resource")) {
                this.composer.append("        if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("          open(\"" + name + "\");\r\n");
                this.composer.append("          " + (String)comp + "(element.get" + this.upFirst(this.getElementName(name, false)) + "());\r\n");
                this.composer.append("          close();\r\n");
                this.composer.append("        }\r\n");
            } else if (!"xhtml".equals(ed.typeSummary()) && (this.isPrimitive(ed) || ed.typeSummary().startsWith("canonical("))) {
                this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "Element()) {\r\n");
                this.composer.append("        " + (String)comp + "Core(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), false);\r\n");
                this.composer.append("        " + (String)comp + "Extras(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "Element(), false);\r\n");
                this.composer.append("      }\r\n");
            } else if (((String)tn).equals("xhtml")) {
                this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("        XhtmlNode node = element.getDiv();\r\n");
                this.composer.append("        if (node.getNsDecl() == null) {\r\n");
                this.composer.append("          node.attribute(\"xmlns\", XHTML_NS);\r\n");
                this.composer.append("        }\r\n");
                this.composer.append("        " + (String)comp + "(\"" + name + "\", node);\r\n");
                this.composer.append("      }\r\n");
            } else if (inh != null && inh.unbounded()) {
                this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("        " + (String)comp + "(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "FirstRep());\r\n");
                this.composer.append("      }\r\n");
            } else {
                if (ed.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/type-specifier")) {
                    this.typeSpecifiers.add(new TypeSpecifier((String)comp, (String)tn, ed));
                }
                this.composer.append("      if (element.has" + this.upFirst(this.getElementName(name, false)) + "()) {\r\n");
                this.composer.append("        " + (String)comp + "(\"" + name + "\", element.get" + this.upFirst(this.getElementName(name, false)) + "());\r\n");
                this.composer.append("      }\r\n");
            }
        }
    }

    private boolean isPrimitive(ElementDefinition e) {
        return this.definitions.hasPrimitiveType(e.typeSummary());
    }

    private String prepEnumName(String en) {
        String[] parts = en.split("\\.");
        if (parts.length == 1) {
            return this.upFirst(parts[0]);
        }
        return this.upFirst(parts[0]) + "." + this.upFirst(parts[1]);
    }

    private String leaf(String tn) {
        return tn.startsWith("java.lang.") ? tn.substring(10) : tn;
    }

    public static class TypeSpecifier {
        private String fnName;
        private String resName;
        private ElementDefinition ed;

        public TypeSpecifier(String fnName, String resName, ElementDefinition ed) {
            this.fnName = fnName;
            this.resName = resName;
            this.ed = ed;
        }

        public String getFnName() {
            return this.fnName;
        }

        public String getResName() {
            return this.resName;
        }

        public ElementDefinition getEd() {
            return this.ed;
        }
    }
}

