/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.service;

import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import org.apache.commons.collections4.map.PassiveExpiringMap;
import org.hl7.fhir.validation.ValidationEngine;
import org.hl7.fhir.validation.service.SessionCache;

public class PassiveExpiringSessionCache
implements SessionCache {
    protected static final long TIME_TO_LIVE = 60L;
    protected static final TimeUnit TIME_UNIT = TimeUnit.MINUTES;
    protected boolean resetExpirationAfterFetch = false;
    private final PassiveExpiringMap<String, ValidationEngine> cachedSessions;

    public PassiveExpiringSessionCache() {
        this.cachedSessions = new PassiveExpiringMap(60L, TIME_UNIT);
    }

    public PassiveExpiringSessionCache(long sessionLength, TimeUnit sessionLengthUnit) {
        this.cachedSessions = new PassiveExpiringMap(sessionLength, sessionLengthUnit);
    }

    @Override
    public String cacheSession(ValidationEngine validationEngine) {
        String generatedId = this.generateID();
        this.cachedSessions.put((Object)generatedId, (Object)validationEngine);
        return generatedId;
    }

    @Override
    public String cacheSession(String sessionId, ValidationEngine validationEngine) {
        if (sessionId == null) {
            sessionId = this.cacheSession(validationEngine);
        } else {
            this.cachedSessions.put((Object)sessionId, (Object)validationEngine);
        }
        return sessionId;
    }

    public PassiveExpiringSessionCache setResetExpirationAfterFetch(boolean resetExpirationAfterFetch) {
        this.resetExpirationAfterFetch = resetExpirationAfterFetch;
        return this;
    }

    protected void removeExpiredSessions() {
        this.cachedSessions.keySet();
    }

    @Override
    public boolean sessionExists(String sessionId) {
        this.removeExpiredSessions();
        return this.cachedSessions.containsKey((Object)sessionId);
    }

    @Override
    public ValidationEngine fetchSessionValidatorEngine(String sessionId) {
        ValidationEngine engine = (ValidationEngine)this.cachedSessions.get((Object)sessionId);
        if (this.resetExpirationAfterFetch) {
            this.cachedSessions.put((Object)sessionId, (Object)engine);
        }
        return engine;
    }

    @Override
    public Set<String> getSessionIds() {
        return this.cachedSessions.keySet();
    }

    @Override
    public void cleanUp() {
        this.removeExpiredSessions();
    }

    private String generateID() {
        return UUID.randomUUID().toString();
    }
}

