/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.hl7.fhir.convertors.context.ContextResourceLoaderFactory;
import org.hl7.fhir.convertors.loaders.loaderR5.ILoaderKnowledgeProviderR5;
import org.hl7.fhir.convertors.loaders.loaderR5.NullLoaderKnowledgeProviderR5;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IContextResourceLoader;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.SimpleWorkerContext;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.CapabilityStatement;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.CompartmentDefinition;
import org.hl7.fhir.r5.model.ConceptMap;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationDefinition;
import org.hl7.fhir.r5.model.Parameters;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.SearchParameter;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.TerminologyClientManager;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.filesystem.ManagedFileAccess;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.codegen.Analyser;
import org.hl7.fhir.validation.codegen.Analysis;
import org.hl7.fhir.validation.codegen.AnalysisElementInfo;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaConstantsGenerator;
import org.hl7.fhir.validation.codegen.JavaEnumerationsGenerator;
import org.hl7.fhir.validation.codegen.JavaExtensionsGenerator;
import org.hl7.fhir.validation.codegen.JavaFactoryGenerator;
import org.hl7.fhir.validation.codegen.JavaParserGenerator;
import org.hl7.fhir.validation.codegen.JavaParserJsonGenerator;
import org.hl7.fhir.validation.codegen.JavaParserXmlGenerator;
import org.hl7.fhir.validation.codegen.JavaResourceGenerator;

public class LogicalModelCodeGenerator {
    public static void main(String[] args) throws Exception {
        String folder = args[0];
        String packageName = args[1];
        String cfgPath = args[2];
        ArrayList<String> packages = new ArrayList<String>();
        for (int i = 3; i < args.length; ++i) {
            packages.add(args[i]);
        }
        new LogicalModelCodeGenerator().generate(folder, packageName, cfgPath, packages);
    }

    private void generate(String packageName, String folder, String cfgPath, List<String> packages) throws Exception {
        long start = System.currentTimeMillis();
        HashMap<String, AnalysisElementInfo> elementInfo = new HashMap<String, AnalysisElementInfo>();
        HashSet<String> genClassList = new HashSet<String>();
        System.out.println("Load Configuration from " + cfgPath);
        Configuration config = new Configuration(cfgPath);
        Date ddate = new Date();
        String date = config.DATE_FORMAT().format(ddate);
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        System.out.println("Load R5");
        NpmPackage npm = pcm.loadPackage("hl7.fhir.r5.core");
        IContextResourceLoader loader = ContextResourceLoaderFactory.makeLoader((String)npm.fhirVersion(), (ILoaderKnowledgeProviderR5)new NullLoaderKnowledgeProviderR5());
        SimpleWorkerContext context = new SimpleWorkerContext.SimpleWorkerContextBuilder().withAllowLoadingDuplicates(true).fromPackage(npm, loader, true);
        String version = context.getVersion();
        context.connectToTSServer((TerminologyClientManager.ITerminologyClientFactory)new TerminologyClientFactory(FhirPublication.R5), "http://tx.fhir.org", "CodeGenerator", null, true);
        context.setExpansionParameters(new Parameters());
        Definitions master = new Definitions((IWorkerContext)context);
        for (String pid : packages) {
            System.out.println("Load " + pid);
            npm = pcm.loadPackage(pid);
            loader = ContextResourceLoaderFactory.makeLoader((String)npm.fhirVersion(), (ILoaderKnowledgeProviderR5)new NullLoaderKnowledgeProviderR5());
            this.load(master, npm, loader);
            context.loadFromPackage(npm, loader);
        }
        master.fix();
        this.markValueSets(master, config);
        System.out.println("Generate Model in " + folder);
        System.out.println(" .. Constants");
        JavaConstantsGenerator cgen = new JavaConstantsGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{folder, "Constants.java"})), master, config, date, npm.version(), packageName);
        cgen.generate();
        cgen.close();
        System.out.println(" .. Enumerations");
        JavaEnumerationsGenerator egen = new JavaEnumerationsGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{folder, "Enumerations.java"})), master, config, date, npm.version(), packageName);
        egen.generate();
        egen.close();
        JavaFactoryGenerator fgen = new JavaFactoryGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{folder, "TypeFactory.java"})), master, config, date, npm.version(), packageName);
        String jname = Utilities.capitalize((String)this.tail(packageName));
        JavaParserGenerator pgen = new JavaParserGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{folder, jname + "Parser.java"})), master, config, date, npm.version(), packageName, jname);
        JavaParserJsonGenerator jgen = new JavaParserJsonGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{folder, jname + "JsonParser.java"})), master, config, date, npm.version(), packageName, jname);
        JavaParserXmlGenerator xgen = new JavaParserXmlGenerator(ManagedFileAccess.outStream((String)Utilities.path((String[])new String[]{folder, jname + "XmlParser.java"})), master, config, date, npm.version(), packageName, jname);
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE) continue;
            genClassList.add(Utilities.capitalize((String)sd.getType()) + "Type");
        }
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.COMPLEXTYPE || Utilities.existsInList((String)sd.getName(), (String[])new String[]{"Base", "PrimitiveType"}) || sd.getName().contains(".") || !sd.getAbstract()) continue;
            genClassList.add(this.genClass(version, folder, date, config, packageName, npm, master, pgen, jgen, xgen, (StructureDefinition)sd, elementInfo, (IWorkerContext)context));
        }
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.COMPLEXTYPE || Utilities.existsInList((String)sd.getName(), (String[])new String[]{"Base", "PrimitiveType"}) || sd.getName().contains(".") || sd.getAbstract()) continue;
            genClassList.add(this.genClass(version, folder, date, config, packageName, npm, master, pgen, jgen, xgen, (StructureDefinition)sd, elementInfo, (IWorkerContext)context));
        }
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || Utilities.existsInList((String)sd.getName(), (String[])new String[]{"Base", "PrimitiveType"}) || sd.getName().contains(".") || !sd.getAbstract()) continue;
            genClassList.add(this.genClass(version, folder, date, config, packageName, npm, master, pgen, jgen, xgen, (StructureDefinition)sd, elementInfo, (IWorkerContext)context));
        }
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.RESOURCE || Utilities.existsInList((String)sd.getName(), (String[])new String[]{"Base", "PrimitiveType"}) || sd.getName().contains(".") || sd.getAbstract()) continue;
            genClassList.add(this.genClass(version, folder, date, config, packageName, npm, master, pgen, jgen, xgen, (StructureDefinition)sd, elementInfo, (IWorkerContext)context));
        }
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL || Utilities.existsInList((String)sd.getName(), (String[])new String[]{"Base", "PrimitiveType"}) || sd.getName().contains(".") || !sd.getAbstract()) continue;
            genClassList.add(this.genClass(version, folder, date, config, packageName, npm, master, pgen, jgen, xgen, (StructureDefinition)sd, elementInfo, (IWorkerContext)context));
        }
        for (Object sd : master.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() != StructureDefinition.StructureDefinitionKind.LOGICAL || Utilities.existsInList((String)sd.getName(), (String[])new String[]{"Base", "PrimitiveType"}) || sd.getName().contains(".") || sd.getAbstract()) continue;
            genClassList.add(this.genClass(version, folder, date, config, packageName, npm, master, pgen, jgen, xgen, (StructureDefinition)sd, elementInfo, (IWorkerContext)context));
        }
        System.out.println(" .. Factory");
        fgen.generate();
        fgen.close();
        System.out.println(" .. Parser");
        pgen.generate();
        pgen.close();
        System.out.println(" .. JsonParser");
        jgen.generate();
        jgen.close();
        System.out.println(" .. XmlParser");
        xgen.generate();
        xgen.close();
        HashMap<String, StructureDefinition> extensions = new HashMap<String, StructureDefinition>();
        for (StructureDefinition sd : master.getStructures().getList()) {
            if (!ProfileUtilities.isExtensionDefinition((StructureDefinition)sd)) continue;
            sd.setUserData("source", (Object)"core");
            extensions.put(sd.getUrl(), sd);
        }
        JavaExtensionsGenerator exgen = new JavaExtensionsGenerator(folder, master, config, date, npm.version(), packageName, elementInfo, genClassList);
        exgen.generate(extensions);
        System.out.println("Done (" + Long.toString(System.currentTimeMillis() - start) + "ms)");
    }

    private String tail(String packageName) {
        return packageName.substring(packageName.lastIndexOf(".") + 1);
    }

    private Definitions load(Definitions res, NpmPackage npm, IContextResourceLoader loader) throws IOException {
        for (String t : npm.listResources(new String[]{"CodeSystem"})) {
            res.getCodeSystems().see((CanonicalResource)((CodeSystem)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"ValueSet"})) {
            res.getValuesets().see((CanonicalResource)((ValueSet)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"ConceptMap"})) {
            res.getConceptMaps().see((CanonicalResource)((ConceptMap)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"CapabilityStatement"})) {
            res.getStatements().see((CanonicalResource)((CapabilityStatement)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"StructureDefinition"})) {
            res.getStructures().see((CanonicalResource)((StructureDefinition)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"OperationDefinition"})) {
            res.getOperations().see((CanonicalResource)((OperationDefinition)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"SearchParameter"})) {
            res.getSearchParams().see((CanonicalResource)((SearchParameter)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        for (String t : npm.listResources(new String[]{"CompartmentDefinition"})) {
            res.getCompartments().see((CanonicalResource)((CompartmentDefinition)LogicalModelCodeGenerator.load(npm, t, loader)), null);
        }
        return res;
    }

    public static Resource load(NpmPackage npm, String t, IContextResourceLoader loader) {
        try {
            return loader.loadResource(npm.loadResource(t), true);
        }
        catch (Exception e) {
            System.out.println("Error reading " + t + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private void markValueSets(Definitions defns, Configuration config) {
        for (StructureDefinition sd : defns.getStructures().getList()) {
            if (sd.getDerivation() != StructureDefinition.TypeDerivationRule.SPECIALIZATION || sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE || sd.getName().contains(".")) continue;
            for (ElementDefinition ed : sd.getSnapshot().getElement()) {
                List list;
                ValueSet vs;
                if (!ed.hasBinding() || !ed.getBinding().hasValueSet() || ed.getBinding().getStrength() != Enumerations.BindingStrength.REQUIRED || (vs = (ValueSet)defns.getValuesets().get(ed.getBinding().getValueSet())) == null) continue;
                if (!vs.hasUserData("usages")) {
                    vs.setUserData("usages", new ArrayList());
                }
                if ((list = (List)vs.getUserData("usages")).contains(sd.getName())) continue;
                list.add(sd.getName());
            }
        }
        for (ValueSet vs : defns.getValuesets().getList()) {
            List list = (List)vs.getUserData("usages");
            boolean shared = false;
            if (list != null && list.size() > 1) {
                shared = true;
            }
            if (config.getIni().hasProperty("shared", vs.getUrl())) {
                shared = config.getIni().getBooleanProperty("shared", vs.getUrl());
            }
            if (!shared) continue;
            vs.setUserData("shared", (Object)true);
        }
    }

    public String genClass(String version, String dest, String date, Configuration config, String jid, NpmPackage npm, Definitions master, JavaParserGenerator pgen, JavaParserJsonGenerator jgen, JavaParserXmlGenerator xgen, StructureDefinition sd, Map<String, AnalysisElementInfo> elementInfo, IWorkerContext context) throws Exception, IOException, UnsupportedEncodingException, FileNotFoundException {
        String name = this.javaName(sd.getName());
        System.out.println(" .. " + name);
        Analyser jca = new Analyser(master, config, version, context);
        Analysis analysis = jca.analyse(sd, elementInfo);
        String fn = Utilities.path((String[])new String[]{dest, name + ".java"});
        JavaResourceGenerator gen = new JavaResourceGenerator(ManagedFileAccess.outStream((String)fn), master, config, date, npm.version(), jid);
        gen.generate(analysis);
        gen.close();
        jgen.seeClass(analysis);
        xgen.seeClass(analysis);
        pgen.seeClass(analysis);
        return name;
    }

    private String javaName(String name) {
        return "List".equals(name) ? "ListResource" : name;
    }
}

