/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.validation.codegen.AnalysisElementInfo;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;
import org.hl7.fhir.validation.codegen.JavaBaseGenerator;

public class JavaExtensionsFactoryGenerator
extends JavaBaseGenerator {
    private StringBuilder src;
    private Map<String, AnalysisElementInfo> elementInfo;
    private Set<String> genClassList;

    public JavaExtensionsFactoryGenerator(OutputStream out, Definitions definitions, Configuration configuration, String genDate, String version, String packageName, Map<String, AnalysisElementInfo> elementInfo, Set<String> genClassList) throws UnsupportedEncodingException {
        super(out, definitions, configuration, version, genDate, packageName);
        this.elementInfo = elementInfo;
        this.genClassList = genClassList;
    }

    public void start() throws Exception {
        this.src = new StringBuilder();
    }

    public void generateSimple(StructureDefinition sd, String name, String constName) throws Exception {
        this.src.append("// -- " + name + " -------------------------------------\r\n");
        this.src.append("// " + sd.getVersionedUrl() + "\r\n");
        this.src.append("// " + sd.getTitle() + "\r\n");
        this.src.append("\r\n");
        HashSet<String> contexts = new HashSet<String>();
        for (StructureDefinition.StructureDefinitionContextComponent c : sd.getContext()) {
            this.processContext(c, contexts);
        }
        ElementDefinition edRoot = sd.getSnapshot().getElementFirstRep();
        boolean repeats = !edRoot.getMax().equals("1");
        String verb = repeats ? "add" : "set";
        ElementDefinition edValue = sd.getSnapshot().getElementByPath("Extension.value[x]");
        List<TypeTuple> types = this.analyseTypes(edValue);
        if (types.size() > 5) {
            this.src.append("  public static Extension make" + name + "(DataType value) {\r\n");
            this.src.append("    return new Extension(ExtensionConstants.EXT_" + constName + ").setValue(value);\r\n");
            this.src.append("  }\r\n");
            this.src.append("\r\n");
            for (String ctxt : Utilities.sorted(contexts)) {
                this.src.append("  public static " + ctxt + " " + verb + name + "(" + ctxt + " context, DataType value) {\r\n");
                this.src.append("    ExtensionsUtils." + verb + "Extension(context, ExtensionConstants.EXT_" + constName + ", value);\r\n");
                this.src.append("    return context;\r\n");
                this.src.append("  }\r\n");
                this.src.append("\r\n");
                if (repeats) {
                    this.src.append("  public static List<DataType> get" + name + "List(" + ctxt + " context) {\r\n");
                    this.src.append("    return ExtensionsUtils.getExtensionList(DataType.class, context, ExtensionConstants.EXT_" + constName + ");\r\n");
                    this.src.append("  }\r\n");
                    this.src.append("\r\n");
                    continue;
                }
                this.src.append("  public static DataType get" + name + "(" + ctxt + " context) {\r\n");
                this.src.append("    return ExtensionsUtils.getExtension(DataType.class, context, ExtensionConstants.EXT_" + constName + ");\r\n");
                this.src.append("  }\r\n");
                this.src.append("\r\n");
            }
        } else {
            for (TypeTuple t : types) {
                String sfx = this.typeCount(t.getJavaType(), types) > 1 ? Utilities.capitalize((String)t.getFhirType()) : "";
                this.src.append("  public static Extension make" + name + sfx + "(" + t.getJavaType() + " value) {\r\n");
                this.src.append("    return new Extension(ExtensionConstants.EXT_" + constName + ").setValue(" + t.adapt("value") + ");\r\n");
                this.src.append("  }\r\n");
                this.src.append("\r\n");
            }
            for (String ctxt : Utilities.sorted(contexts)) {
                HashSet<String> td = new HashSet<String>();
                for (TypeTuple t : types) {
                    String sfx = this.typeCount(t.getJavaType(), types) > 1 ? Utilities.capitalize((String)t.getFhirType()) : "";
                    this.src.append("  public static " + ctxt + " " + verb + name + sfx + "(" + ctxt + " context, " + t.getJavaType() + " value) {\r\n");
                    this.src.append("    ExtensionsUtils." + verb + "Extension(context, ExtensionConstants.EXT_" + constName + ", " + t.adapt("value") + ");\r\n");
                    this.src.append("    return context;\r\n");
                    this.src.append("  }\r\n");
                    this.src.append("\r\n");
                    sfx = types.size() > 1 ? Utilities.capitalize((String)t.getJavaType()) : "";
                    if (td.contains(sfx)) continue;
                    td.add(sfx);
                    if (repeats) {
                        this.src.append("  public static List<" + t.getJavaRType() + "> get" + name + sfx + "List(" + ctxt + " context) {\r\n");
                        if (t.getFhirType() == null) {
                            this.src.append("    return ExtensionsUtils.getExtensionList(" + t.getJavaType() + ".class, context, ExtensionConstants.EXT_" + constName + ");\r\n");
                        } else {
                            this.src.append("    return ExtensionsUtils.getExtension" + t.suffix() + "List(context, ExtensionConstants.EXT_" + constName + ");\r\n");
                        }
                        this.src.append("  }\r\n");
                        this.src.append("\r\n");
                        continue;
                    }
                    this.src.append("  public static " + t.getJavaRType() + " get" + name + sfx + "(" + ctxt + " context) {\r\n");
                    if (t.getFhirType() == null) {
                        this.src.append("    return ExtensionsUtils.getExtension(" + t.getJavaType() + ".class, context, ExtensionConstants.EXT_" + constName + ");\r\n");
                    } else {
                        this.src.append("    return ExtensionsUtils.getExtension" + t.suffix() + "(context, ExtensionConstants.EXT_" + constName + ");\r\n");
                    }
                    this.src.append("  }\r\n");
                    this.src.append("\r\n");
                }
            }
        }
    }

    private void processContext(StructureDefinition.StructureDefinitionContextComponent c, Set<String> contexts) {
        switch (c.getType()) {
            case ELEMENT: {
                if (c.getExpression().contains(".")) {
                    AnalysisElementInfo info = this.elementInfo.get(c.getExpression());
                    if (info == null) break;
                    if (this.genClassList.contains(info.getJavaType())) {
                        contexts.add(info.getJavaType());
                        break;
                    }
                    contexts.add("org.hl7.fhir.r5.model." + info.getClassFile() + "." + info.getJavaType());
                    break;
                }
                if (Character.isLowerCase(c.getExpression().charAt(0))) {
                    contexts.add(Utilities.capitalize((String)c.getExpression()) + "Type");
                    break;
                }
                if ("List".equals(c.getExpression())) {
                    contexts.add("ListResource");
                    break;
                }
                contexts.add(c.getExpression());
                break;
            }
            case EXTENSION: {
                contexts.add("Extension");
                break;
            }
            case FHIRPATH: {
                contexts.add("Element");
                contexts.add("Resource");
                break;
            }
        }
    }

    private int typeCount(String n, List<TypeTuple> types) {
        int i = 0;
        for (TypeTuple t : types) {
            if (!n.equals(t.javaType)) continue;
            ++i;
        }
        return i;
    }

    private List<TypeTuple> analyseTypes(ElementDefinition edValue) {
        ArrayList<TypeTuple> ret = new ArrayList<TypeTuple>();
        for (ElementDefinition.TypeRefComponent tr : edValue.getType()) {
            if (Character.isLowerCase(tr.getWorkingCode().charAt(0))) {
                TypeTuple pt = this.javaPrimitive(tr.getWorkingCode());
                if (pt == null) continue;
                ret.add(pt);
                continue;
            }
            ret.add(new TypeTuple(tr.getWorkingCode(), tr.getWorkingCode(), null, null));
        }
        return ret;
    }

    private TypeTuple javaPrimitive(String type) {
        switch (type) {
            case "string": {
                return new TypeTuple("String", "String", type, "StringType");
            }
            case "markdown": {
                return new TypeTuple("String", "String", type, "MarkdownType");
            }
            case "canonical": {
                return new TypeTuple("String", "String", type, "CanonicalType");
            }
            case "oid": {
                return new TypeTuple("String", "String", type, "OidType");
            }
            case "uuid": {
                return new TypeTuple("String", "String", type, "UuidType");
            }
            case "id": {
                return new TypeTuple("String", "String", type, "IdType");
            }
            case "uri": {
                return new TypeTuple("String", "String", type, "UriType");
            }
            case "url": {
                return new TypeTuple("String", "String", type, "UrlType");
            }
            case "dateTime": {
                return new TypeTuple("String", "String", type, "DateTimeType");
            }
            case "instant": {
                return new TypeTuple("String", "String", type, "InstantType");
            }
            case "time": {
                return new TypeTuple("String", "String", type, "TimeType");
            }
            case "date": {
                return new TypeTuple("String", "String", type, "DateType");
            }
            case "code": {
                return new TypeTuple("String", "String", type, "CodeType");
            }
            case "boolean": {
                return new TypeTuple("boolean", "Boolean", type, "BooleanType");
            }
            case "integer": {
                return new TypeTuple("int", "Integer", type, "IntegerType");
            }
            case "positiveInt": {
                return new TypeTuple("int", "Integer", type, "PositiveIntType");
            }
            case "unsignedInt": {
                return new TypeTuple("int", "Integer", type, "UnsignedType");
            }
            case "integer64": {
                return new TypeTuple("long", "UInteger", type, "Integer64Type");
            }
            case "base64Binary": {
                return new TypeTuple("byte[]", "byte[]", type, "Base64BinaryType");
            }
            case "decimal": {
                return new TypeTuple("float", "BigDecimal", type, "DecimalType");
            }
        }
        return null;
    }

    public void finish() throws Exception {
        String template = this.config.getAdornments().get("Extensions");
        template = template.replace("{{pid}}", this.packageName);
        template = template.replace("{{license}}", this.config.getLicense());
        template = template.replace("{{startMark}}", this.startVMarkValue());
        template = template.replace("{{code}}", this.src.toString());
        this.write(template);
        this.flush();
        this.close();
    }

    public class TypeTuple {
        private String javaType;
        private String fhirType;
        private String hapiType;
        private String javaRType;

        public TypeTuple(String javaType, String javaRType, String fhirType, String hapiType) {
            this.javaType = javaType;
            this.javaRType = javaRType == null ? javaType : javaRType;
            this.fhirType = fhirType;
            this.hapiType = hapiType;
        }

        public String getJavaType() {
            return this.javaType;
        }

        public String getJavaRType() {
            return this.javaRType;
        }

        public String getFhirType() {
            return this.fhirType;
        }

        public String adapt(String vn) {
            return this.hapiType == null ? vn : "new " + this.hapiType + "(" + vn + ")";
        }

        public String suffix() {
            return this.fhirType == null ? "" : Utilities.capitalize((String)this.javaType);
        }

        public String cast() {
            return this.fhirType == null ? "(" + this.javaType + ")" : "";
        }

        public String castList() {
            return this.fhirType == null ? "(List<" + this.javaType + ">)" : "";
        }
    }
}

