/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.codegen;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.utilities.OIDUtilities;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.validation.codegen.Configuration;
import org.hl7.fhir.validation.codegen.Definitions;

public class JavaBaseGenerator
extends OutputStreamWriter {
    protected Definitions definitions;
    protected Configuration config;
    protected String version;
    protected String genDate;
    protected String packageName;

    public JavaBaseGenerator(OutputStream arg0, Definitions definitions, Configuration config, String version, String genDate, String packageName) throws UnsupportedEncodingException {
        super(arg0, "UTF-8");
        this.definitions = definitions;
        this.config = config;
        this.version = version;
        this.genDate = genDate;
        this.packageName = packageName;
    }

    public void startMark(String version, String genDate) throws IOException {
        this.write(this.startLicenseValue());
        this.write(this.startVMarkValue());
    }

    public String startLicenseValue() {
        return "\r\n\r\n" + this.config.getLicense() + "\r\n\r\n";
    }

    public String startVMarkValue() {
        return "// Generated on Thu, Mar 23, 2023 19:59+1100 for FHIR v5.0.0\r\n\r\n";
    }

    public static boolean isJavaReservedWord(String word) {
        if (word.equals("abstract")) {
            return true;
        }
        if (word.equals("assert")) {
            return true;
        }
        if (word.equals("boolean")) {
            return true;
        }
        if (word.equals("break")) {
            return true;
        }
        if (word.equals("byte")) {
            return true;
        }
        if (word.equals("case")) {
            return true;
        }
        if (word.equals("catch")) {
            return true;
        }
        if (word.equals("char")) {
            return true;
        }
        if (word.equals("class")) {
            return true;
        }
        if (word.equals("const")) {
            return true;
        }
        if (word.equals("continue")) {
            return true;
        }
        if (word.equals("default")) {
            return true;
        }
        if (word.equals("double")) {
            return true;
        }
        if (word.equals("do")) {
            return true;
        }
        if (word.equals("else")) {
            return true;
        }
        if (word.equals("enum")) {
            return true;
        }
        if (word.equals("extends")) {
            return true;
        }
        if (word.equals("false")) {
            return true;
        }
        if (word.equals("final")) {
            return true;
        }
        if (word.equals("finally")) {
            return true;
        }
        if (word.equals("float")) {
            return true;
        }
        if (word.equals("for")) {
            return true;
        }
        if (word.equals("goto")) {
            return true;
        }
        if (word.equals("if")) {
            return true;
        }
        if (word.equals("implements")) {
            return true;
        }
        if (word.equals("import")) {
            return true;
        }
        if (word.equals("instanceof")) {
            return true;
        }
        if (word.equals("int")) {
            return true;
        }
        if (word.equals("interface")) {
            return true;
        }
        if (word.equals("long")) {
            return true;
        }
        if (word.equals("native")) {
            return true;
        }
        if (word.equals("new")) {
            return true;
        }
        if (word.equals("null")) {
            return true;
        }
        if (word.equals("package")) {
            return true;
        }
        if (word.equals("private")) {
            return true;
        }
        if (word.equals("protected")) {
            return true;
        }
        if (word.equals("public")) {
            return true;
        }
        if (word.equals("return")) {
            return true;
        }
        if (word.equals("short")) {
            return true;
        }
        if (word.equals("static")) {
            return true;
        }
        if (word.equals("strictfp")) {
            return true;
        }
        if (word.equals("super")) {
            return true;
        }
        if (word.equals("switch")) {
            return true;
        }
        if (word.equals("synchronized")) {
            return true;
        }
        if (word.equals("this")) {
            return true;
        }
        if (word.equals("throw")) {
            return true;
        }
        if (word.equals("throws")) {
            return true;
        }
        if (word.equals("transient")) {
            return true;
        }
        if (word.equals("true")) {
            return true;
        }
        if (word.equals("try")) {
            return true;
        }
        if (word.equals("void")) {
            return true;
        }
        if (word.equals("volatile")) {
            return true;
        }
        if (word.equals("while")) {
            return true;
        }
        return word.equals("Exception");
    }

    protected boolean isJavaPrimitive(ElementDefinition e) {
        return e.getType().size() == 1 && this.isPrimitive(((ElementDefinition.TypeRefComponent)e.getType().get(0)).getWorkingCode());
    }

    protected boolean isPrimitive(String name) {
        return this.definitions.isPrimitive(name);
    }

    protected String getElementName(String name, boolean alone) {
        if (name.equals("[type]")) {
            return "value";
        }
        if (alone && JavaBaseGenerator.isJavaReservedWord(name) || !alone && name.equals("class")) {
            return name + "_";
        }
        if (name.equals("[x]")) {
            return "value";
        }
        return name.replace("[x]", "");
    }

    protected String getTypeName(ElementDefinition e) throws Exception {
        if (e.getType().size() > 1) {
            return "DataType";
        }
        if (e.getType().size() == 0) {
            throw new Exception("not supported");
        }
        return this.getTypename((ElementDefinition.TypeRefComponent)e.getType().get(0));
    }

    protected String getTypename(ElementDefinition.TypeRefComponent type) throws Exception {
        if (type.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type")) {
            return type.getExtensionString("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type");
        }
        String code = type.getCode();
        if (Utilities.isAbsoluteUrl((String)code)) {
            code = Utilities.urlTail((String)code);
        }
        return this.getTypeName(code);
    }

    protected String getTypeName(String tn) {
        if (tn.equals("string")) {
            return "StringType";
        }
        if (tn.equals("Any")) {
            return "Reference";
        }
        if (tn.equals("SimpleQuantity")) {
            return "Quantity";
        }
        if (this.isPrimitive(tn)) {
            return this.getTitle(tn) + "Type";
        }
        return this.getTitle(tn);
    }

    protected String getTitle(String name) {
        return Utilities.noString((String)name) ? "Value" : name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected List<CodeSystem.ConceptDefinitionComponent> listAllCodes(CodeSystem cs) {
        ArrayList<CodeSystem.ConceptDefinitionComponent> result = new ArrayList<CodeSystem.ConceptDefinitionComponent>();
        this.addAllCodes(result, cs.getConcept());
        return result;
    }

    private void addAllCodes(List<CodeSystem.ConceptDefinitionComponent> result, List<CodeSystem.ConceptDefinitionComponent> concept) {
        for (CodeSystem.ConceptDefinitionComponent c : concept) {
            result.add(c);
            this.addAllCodes(result, c.getConcept());
        }
    }

    protected String makeConst(String cc) {
        if (((String)cc).equals("*")) {
            cc = "ASTERISK";
        }
        if (OIDUtilities.isValidOID((String)cc) && Utilities.charCount((String)cc, (char)'.') > 2) {
            cc = "OID_" + (String)cc;
        }
        cc = ((String)cc).equals("%") ? "pct" : (((String)cc).equals("<") ? "less_Than" : (((String)cc).equals("<=") ? "less_Or_Equal" : (((String)cc).equals(">") ? "greater_Than" : (((String)cc).equals(">=") ? "greater_Or_Equal" : (((String)cc).equals("=") ? "equal" : (((String)cc).equals("!=") ? "not_equal" : (this.allPlusMinus((String)cc) ? ((String)cc).replace("-", "Minus").replace("+", "Plus") : ((String)cc).replace("-", "").replace("+", ""))))))));
        cc = ((String)cc).replace("(", "_").replace(")", "_");
        cc = ((String)cc).replace("{", "_").replace("}", "_");
        cc = ((String)cc).replace("<", "_").replace(">", "_");
        cc = ((String)cc).replace(".", "_").replace("/", "_");
        cc = ((String)cc).replace(":", "_");
        if (Utilities.isInteger((String)((String)(cc = ((String)cc).replace("%", "pct"))).substring(0, 1))) {
            cc = "_" + (String)cc;
        }
        if (JavaBaseGenerator.isJavaReservedWord((String)(cc = ((String)cc).toUpperCase()))) {
            cc = (String)cc + "_";
        }
        return cc;
    }

    private boolean allPlusMinus(String cc) {
        for (char c : cc.toCharArray()) {
            if (c == '-' || c == '+') continue;
            return false;
        }
        return true;
    }

    protected boolean isEnum(ElementDefinition.ElementDefinitionBindingComponent cd) {
        ValueSet.ConceptSetComponent inc;
        ValueSet vs;
        boolean ok;
        boolean bl = ok = cd != null && cd.getStrength() == Enumerations.BindingStrength.REQUIRED;
        if (ok && cd.getValueSet() != null && (vs = (ValueSet)this.definitions.getValuesets().get(cd.getValueSet())) != null && vs.hasCompose() && vs.getCompose().getInclude().size() == 1 && (inc = vs.getCompose().getIncludeFirstRep()).hasSystem() && !inc.hasFilter() && !inc.hasConcept() && !inc.getSystem().startsWith("http://hl7.org/fhir") && !inc.getSystem().startsWith("http://terminology.hl7.org")) {
            ok = false;
        }
        return ok;
    }

    protected String getCodeListType(String binding) {
        StringBuilder b = new StringBuilder();
        boolean up = true;
        for (char ch : binding.toCharArray()) {
            if (ch == '-' || ch == ' ' || ch == '.') {
                up = true;
                continue;
            }
            if (up) {
                b.append(Character.toUpperCase(ch));
                up = false;
                continue;
            }
            b.append(ch);
        }
        return "ResourceType".equals(b.toString()) ? "ResourceTypeEnum" : b.toString();
    }

    protected ElementDefinition matchingInheritedElement(List<ElementDefinition> children, ElementDefinition m, String name) {
        if (VersionUtilities.isR4BVer((String)this.version) && m.getPath().endsWith(".identifier") && Utilities.charCount((String)m.getPath(), (char)'.') == 1 && !Utilities.noString((String)this.config.getIni().getStringProperty("R4B.CanonicalResources", name))) {
            ElementDefinition inh = new ElementDefinition();
            inh.setMax("*");
            return inh;
        }
        if (children == null) {
            return null;
        }
        String mtail = m.getPath().substring(m.getPath().indexOf("."));
        for (ElementDefinition t : children) {
            String ttail = t.getPath().substring(t.getPath().indexOf("."));
            if (!ttail.equals(mtail)) continue;
            return t;
        }
        return null;
    }

    protected boolean isCoreType(StructureDefinition sd) {
        return sd != null && sd.hasUrl() && sd.getUrl().startsWith("http://hl7.org/fhir/StructureDefinition");
    }
}

