/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.special;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.hl7.fhir.utilities.TextFile;
import org.hl7.fhir.utilities.json.JsonException;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.special.TxTestSetup;

public class TxTestData {
    private final JsonObject manifest;
    private final JsonObject externals;
    private final List<Object[]> testData;
    private final NpmPackage npm;

    private TxTestData(List<Object[]> testData, JsonObject manifest, JsonObject externals, NpmPackage npm) throws IOException {
        this.testData = testData;
        this.manifest = manifest;
        this.externals = externals;
        this.npm = npm;
    }

    public static TxTestData loadTestDataFromPackage(String version) throws IOException {
        FilesystemPackageCacheManager pcm = new FilesystemPackageCacheManager.Builder().build();
        NpmPackage npm = pcm.loadPackage("hl7.fhir.uv.tx-ecosystem", version);
        String contents = TextFile.streamToString((InputStream)npm.load("tests", "test-cases.json"));
        String externalSource = TextFile.streamToString((InputStream)npm.load("tests", "messages-tx.fhir.org.json"));
        JsonObject externals = JsonParser.parseObject((String)externalSource);
        HashMap<CallSite, TxTestSetup> examples = new HashMap<CallSite, TxTestSetup>();
        JsonObject manifest = JsonParser.parseObject((String)contents);
        for (JsonObject suite : manifest.getJsonObjects("suites")) {
            if ("tx.fhir.org".equals(suite.asString("mode"))) continue;
            String sn = suite.asString("name");
            for (JsonObject test : suite.getJsonObjects("tests")) {
                String tn = test.asString("name");
                examples.put((CallSite)((Object)(sn + "." + tn)), new TxTestSetup(suite, test));
            }
        }
        ArrayList names = new ArrayList(examples.size());
        names.addAll(examples.keySet());
        Collections.sort(names);
        ArrayList<Object[]> testData = new ArrayList<Object[]>(examples.size());
        for (String id : names) {
            testData.add(new Object[]{id, examples.get(id)});
        }
        return new TxTestData(testData, manifest, externals, npm);
    }

    public String load(String fn) throws IOException {
        return TextFile.streamToString((InputStream)this.npm.load("tests", fn));
    }

    public byte[] loadBytes(String fn) throws IOException {
        return TextFile.streamToBytes((InputStream)this.npm.load("tests", fn));
    }

    public boolean hasFile(String filename) throws IOException {
        return this.npm.hasFile("tests", filename);
    }

    public String loadVersion() throws JsonException, IOException {
        return this.readHistory(this.loadBytes("history.json"));
    }

    private String readHistory(byte[] content) throws JsonException, IOException {
        JsonObject json = JsonParser.parseObject((byte[])content);
        return ((JsonObject)json.getJsonObjects("versions").get(0)).asString("version");
    }

    public String describe() {
        return this.npm.name() + "#" + this.npm.version();
    }

    public JsonObject getManifest() {
        return this.manifest;
    }

    public JsonObject getExternals() {
        return this.externals;
    }

    public List<Object[]> getTestData() {
        return this.testData;
    }
}

