/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.ContextUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.OperationOutcome;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.UsageContext;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.ValueSetUtilities;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.r5.utils.validation.IMessagingServices;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.ValidationContextCarrier;
import org.hl7.fhir.r5.utils.validation.ValidatorSession;
import org.hl7.fhir.r5.utils.validation.constants.BestPracticeWarningLevel;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.FhirPublication;
import org.hl7.fhir.utilities.StandardsStatus;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.utilities.xhtml.XhtmlNode;
import org.hl7.fhir.validation.ValidationTimeTracker;
import org.hl7.fhir.validation.cli.utils.ValidationLevel;
import org.hl7.fhir.validation.instance.advisor.BasePolicyAdvisorForFullValidation;
import org.hl7.fhir.validation.instance.utils.IndexedElement;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class BaseValidator
implements ValidationContextCarrier.IValidationContextResourceLoader,
IMessagingServices {
    public static final String NO_RULE_DATE = ValidationMessage.NO_RULE_DATE;
    protected final String META = "meta";
    protected final String ENTRY = "entry";
    protected final String LINK = "link";
    protected final String DOCUMENT = "document";
    protected final String RESOURCE = "resource";
    protected final String MESSAGE = "message";
    protected final String SEARCHSET = "searchset";
    protected final String ID = "id";
    protected final String FULL_URL = "fullUrl";
    protected final String PATH_ARG = ":0";
    protected final String TYPE = "type";
    protected final String BUNDLE = "Bundle";
    protected final String LAST_UPDATED = "lastUpdated";
    protected BaseValidator parent;
    protected IWorkerContext context;
    protected ValidationTimeTracker timeTracker = new ValidationTimeTracker();
    protected XVerExtensionManager xverManager;
    protected IValidatorResourceFetcher fetcher;
    protected IValidationPolicyAdvisor policyAdvisor;
    protected boolean noTerminologyChecks;
    protected List<TrackedLocationRelatedMessage> trackedMessages = new ArrayList<TrackedLocationRelatedMessage>();
    protected List<ValidationMessage> messagesToRemove = new ArrayList<ValidationMessage>();
    protected Set<String> statusWarnings = new HashSet<String>();
    protected ValidatorSession session;
    protected ValidationMessage.Source source;
    protected ValidationLevel level = ValidationLevel.HINTS;
    protected Coding jurisdiction;
    protected boolean allowExamples;
    protected boolean forPublication;
    protected boolean debug;
    protected boolean warnOnDraftOrExperimental;
    protected BestPracticeWarningLevel bpWarnings = BestPracticeWarningLevel.Warning;
    protected List<UsageContext> usageContexts = new ArrayList<UsageContext>();
    protected ValidationOptions baseOptions = new ValidationOptions(FhirPublication.R5);
    private Map<String, ValidationControl> validationControl = new HashMap<String, ValidationControl>();
    protected String urlRegex;

    public BaseValidator(IWorkerContext context, XVerExtensionManager xverManager, boolean debug, ValidatorSession session) {
        this.context = context;
        this.session = session;
        if (this.session == null) {
            this.session = new ValidatorSession();
        }
        this.xverManager = xverManager;
        if (this.xverManager == null) {
            this.xverManager = new XVerExtensionManager(context);
        }
        this.debug = debug;
        this.policyAdvisor = new BasePolicyAdvisorForFullValidation(ReferenceValidationPolicy.CHECK_VALID);
        this.urlRegex = "((http|https):\\/\\/([A-Za-z0-9\\\\\\.\\:\\%\\$\\-]*\\/)*?)?($$)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?".replace("$$", CommaSeparatedStringBuilder.join((String)"|", (Collection)context.getResourceNames()));
    }

    public BaseValidator(BaseValidator parent) {
        this.parent = parent;
        this.session = parent.session;
        this.context = parent.context;
        this.xverManager = parent.xverManager;
        this.debug = parent.debug;
        this.source = parent.source;
        this.timeTracker = parent.timeTracker;
        this.trackedMessages = parent.trackedMessages;
        this.messagesToRemove = parent.messagesToRemove;
        this.level = parent.level;
        this.allowExamples = parent.allowExamples;
        this.forPublication = parent.forPublication;
        this.debug = parent.debug;
        this.warnOnDraftOrExperimental = parent.warnOnDraftOrExperimental;
        this.statusWarnings = parent.statusWarnings;
        this.bpWarnings = parent.bpWarnings;
        this.urlRegex = parent.urlRegex;
        this.usageContexts.addAll(parent.usageContexts);
        this.baseOptions = parent.baseOptions;
        this.fetcher = parent.fetcher;
        this.policyAdvisor = parent.policyAdvisor;
        this.noTerminologyChecks = parent.noTerminologyChecks;
    }

    private boolean doingLevel(ValidationMessage.IssueSeverity error) {
        switch (error) {
            case ERROR: {
                return this.level == null || this.level == ValidationLevel.ERRORS || this.level == ValidationLevel.WARNINGS || this.level == ValidationLevel.HINTS;
            }
            case FATAL: {
                return this.level == null || this.level == ValidationLevel.ERRORS || this.level == ValidationLevel.WARNINGS || this.level == ValidationLevel.HINTS;
            }
            case WARNING: {
                return this.level == null || this.level == ValidationLevel.WARNINGS || this.level == ValidationLevel.HINTS;
            }
            case INFORMATION: {
                return this.level == null || this.level == ValidationLevel.HINTS;
            }
            case NULL: {
                return true;
            }
        }
        return true;
    }

    private boolean doingErrors() {
        return this.doingLevel(ValidationMessage.IssueSeverity.ERROR);
    }

    private boolean doingWarnings() {
        return this.doingLevel(ValidationMessage.IssueSeverity.WARNING);
    }

    private boolean doingHints() {
        return this.doingLevel(ValidationMessage.IssueSeverity.INFORMATION);
    }

    private boolean suppressMsg(String path, String theMessage) {
        if (this.policyAdvisor == null) {
            return false;
        }
        return this.policyAdvisor.isSuppressMessageId(path, theMessage);
    }

    protected boolean fail(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String msg = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, msg, ValidationMessage.IssueSeverity.FATAL, theMessage);
        }
        return thePass;
    }

    protected boolean grammarWord(String w) {
        return w.equals("and") || w.equals("or") || w.equals("a") || w.equals("the") || w.equals("for") || w.equals("this") || w.equals("that") || w.equals("of");
    }

    protected boolean hint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg) {
        if (!thePass && this.doingHints() && !this.suppressMsg(path, msg)) {
            String message = this.context.formatMessage(msg, new Object[0]);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected boolean hintInv(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, String invId) {
        if (!thePass && this.doingHints() && !this.suppressMsg(path, invId)) {
            String message = this.context.formatMessage(msg, new Object[0]);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, msg).setInvId(invId);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack stack, boolean thePass, String msg, Object ... theMessageArguments) {
        return this.hint(errors, ruleDate, type, stack.line(), stack.col(), stack.getLiteralPath(), thePass, msg, theMessageArguments);
    }

    protected boolean slicingHint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, boolean isCritical, String msg, String html, String[] text) {
        if (!thePass && this.doingHints()) {
            this.addValidationMessage(errors, ruleDate, type, line, col, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null).setSlicingHint(true).setSliceHtml(html, text).setCriticalSignpost(isCritical);
        }
        return thePass;
    }

    protected boolean slicingHint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, boolean isCritical, String msg, String html, String[] text, List<ValidationMessage> sliceInfo, String id) {
        if (!thePass && this.doingHints()) {
            this.addValidationMessage(errors, ruleDate, type, line, col, path, msg, ValidationMessage.IssueSeverity.INFORMATION, id).setSlicingHint(true).setSliceHtml(html, text).setCriticalSignpost(isCritical).setSliceInfo(sliceInfo);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingHints() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean hintPlural(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, int num, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingHints() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessagePlural(Integer.valueOf(num), theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    public ValidationMessage signpost(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, String theMessage, Object ... theMessageArguments) {
        String message = this.context.formatMessage(theMessage, theMessageArguments);
        return this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage).setSignpost(true);
    }

    protected boolean txHint(List<ValidationMessage> errors, String ruleDate, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingHints() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.INFORMATION, ValidationMessage.Source.TerminologyEngine, theMessage).setTxLink(txLink);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingHints() && !this.suppressMsg(CommaSeparatedStringBuilder.join((String)".", pathParts), theMessage)) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean hint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingHints() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean ruleInv(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, String invId, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR, invId).setInvId(invId);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack stack, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(stack.getLiteralPath(), theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, stack.line(), stack.col(), stack.getLiteralPath(), message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean rulePlural(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack node, boolean thePass, int num, String theMessage, Object ... theMessageArguments) {
        return this.rulePlural(errors, ruleDate, type, node.line(), node.col(), node.getLiteralPath(), thePass, num, theMessage, theMessageArguments);
    }

    protected boolean rulePlural(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, int num, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessagePlural(Integer.valueOf(num), theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean txRule(List<ValidationMessage> errors, String ruleDate, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            ValidationMessage vm = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, message, ValidationMessage.IssueSeverity.ERROR).setMessageId(this.idForMessage(theMessage, message));
            vm.setRuleDate(ruleDate);
            if (this.checkMsgId(theMessage, vm)) {
                errors.add(vm.setTxLink(txLink));
            }
        }
        return thePass;
    }

    private String idForMessage(String theMessage, String message) {
        return theMessage.equals(message) ? null : theMessage;
    }

    protected boolean rule(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String msg) {
        if (!thePass && this.doingErrors()) {
            String path = this.toPath(pathParts);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(CommaSeparatedStringBuilder.join((String)".", pathParts), theMessage)) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean rule(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    protected boolean rulePlural(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, int num, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingErrors() && !this.suppressMsg(path, theMessage)) {
            String message = this.context.formatMessagePlural(Integer.valueOf(num), theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.ERROR, theMessage);
        }
        return thePass;
    }

    public boolean rule(List<ValidationMessage> errors, String ruleDate, ValidationMessage.Source source, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass && this.doingErrors()) {
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.ERROR, source, null);
        }
        return thePass;
    }

    protected boolean ruleHtml(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass && this.doingErrors()) {
            msg = this.context.formatMessage(msg, new Object[0]);
            html = this.context.formatMessage(html, new Object[0]);
            this.addValidationMessage(errors, ruleDate, type, path, msg, html, ValidationMessage.IssueSeverity.ERROR, null);
        }
        return thePass;
    }

    protected String splitByCamelCase(String s) {
        StringBuilder b = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isUpperCase(c) && i != 0 && !Character.isUpperCase(s.charAt(i - 1))) {
                b.append(' ');
            }
            b.append(c);
        }
        return b.toString();
    }

    protected String stripPunctuation(String s, boolean numbers) {
        StringBuilder b = new StringBuilder();
        for (char c : s.toCharArray()) {
            int t = Character.getType(c);
            if (!(t == 1 || t == 2 || t == 3 || t == 4 || t == 5 || t == 9 && numbers || t == 10 && numbers) && c != ' ') continue;
            b.append(c);
        }
        return b.toString();
    }

    private String toPath(List<String> pathParts) {
        if (pathParts == null || pathParts.isEmpty()) {
            return "";
        }
        return "//" + StringUtils.join(pathParts, (char)'/');
    }

    protected boolean warning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.WARNING;
            this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, severity, msg);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, String id, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.WARNING;
            this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, severity, id);
        }
        return thePass;
    }

    protected boolean warningInv(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, String invId, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, invId)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.WARNING;
            String id = this.idForMessage(msg, nmsg);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, severity, id).setMessageId(id).setInvId(invId);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack stack, boolean thePass, String msg, Object ... theMessageArguments) {
        return this.warning(errors, ruleDate, type, stack, null, thePass, msg, theMessageArguments);
    }

    protected boolean warning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack stack, String id, boolean thePass, String msg, Object ... theMessageArguments) {
        return this.warning(errors, ruleDate, type, stack.line(), stack.col(), stack.getLiteralPath(), id, thePass, msg, theMessageArguments);
    }

    protected boolean warningPlural(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, int num, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessagePlural(Integer.valueOf(num), msg, theMessageArguments);
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.WARNING;
            this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, severity, msg);
        }
        return thePass;
    }

    protected ValidationMessage addValidationMessage(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, String msg, ValidationMessage.IssueSeverity theSeverity, String id) {
        ValidationMessage.Source source = this.source;
        return this.addValidationMessage(errors, ruleDate, type, line, col, path, msg, theSeverity, source, id);
    }

    protected ValidationMessage addValidationMessage(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, String msg, ValidationMessage.IssueSeverity theSeverity, ValidationMessage.Source theSource, String id) {
        ValidationMessage validationMessage = new ValidationMessage(theSource, type, line, col, path, msg, theSeverity).setMessageId(id);
        validationMessage.setRuleDate(ruleDate);
        if (this.doingLevel(theSeverity) && this.checkMsgId(id, validationMessage)) {
            errors.add(validationMessage);
        }
        return validationMessage;
    }

    public boolean checkMsgId(String id, ValidationMessage vm) {
        if (id != null && this.validationControl.containsKey(id)) {
            ValidationControl control = this.validationControl.get(id);
            if (control.level != null) {
                vm.setLevel(control.level);
            }
            return control.isAllowed();
        }
        return true;
    }

    protected boolean txWarning(List<ValidationMessage> errors, String ruleDate, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage vmsg = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.WARNING).setTxLink(txLink).setMessageId(this.idForMessage(msg, nmsg));
            vmsg.setRuleDate(ruleDate);
            if (this.checkMsgId(msg, vmsg)) {
                errors.add(vmsg);
            }
        }
        return thePass;
    }

    protected ValidationMessage txIssue(List<ValidationMessage> errors, String ruleDate, String txLink, int line, int col, String path, OperationOutcome.OperationOutcomeIssueComponent issue) {
        if (issue.hasLocation() && ((String)((StringType)issue.getExpressionOrLocation().get(0)).getValue()).contains(".")) {
            path = (String)path + this.dropHead((String)((StringType)issue.getExpressionOrLocation().get(0)).getValue());
        }
        ValidationMessage.IssueType code = ValidationMessage.IssueType.fromCode((String)issue.getCode().toCode());
        ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.fromCode((String)issue.getSeverity().toCode());
        ValidationMessage vmsg = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, code, line, col, (String)path, issue.getDetails().getText(), severity).setTxLink(txLink);
        if (issue.getExtensionString("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-server") != null) {
            vmsg.setServer(issue.getExtensionString("http://hl7.org/fhir/StructureDefinition/operationoutcome-issue-server").replace("local.fhir.org", "tx-dev.fhir.org"));
        }
        if (issue.getExtensionString("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id") != null) {
            vmsg.setMessageId(issue.getExtensionString("http://hl7.org/fhir/StructureDefinition/operationoutcome-message-id"));
        }
        if (!this.suppressMsg((String)path, vmsg.getMessageId())) {
            errors.add(vmsg);
        }
        return vmsg;
    }

    private String dropHead(String value) {
        return value.contains(".") ? value.substring(value.indexOf(".")) : "";
    }

    protected boolean txWarningForLaterRemoval(Object location, List<ValidationMessage> errors, String ruleDate, String txLink, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage vmsg = new ValidationMessage(ValidationMessage.Source.TerminologyEngine, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.WARNING).setTxLink(txLink).setMessageId(msg);
            vmsg.setRuleDate(ruleDate);
            if (this.checkMsgId(msg, vmsg)) {
                errors.add(vmsg);
            }
            this.trackedMessages.add(new TrackedLocationRelatedMessage(location, vmsg));
        }
        return thePass;
    }

    protected void removeTrackedMessagesForLocation(List<ValidationMessage> errors, Object location, String path) {
        ArrayList<TrackedLocationRelatedMessage> messages = new ArrayList<TrackedLocationRelatedMessage>();
        for (TrackedLocationRelatedMessage m : this.trackedMessages) {
            if (m.getLocation() != location) continue;
            messages.add(m);
            this.messagesToRemove.add(m.getVmsg());
        }
        this.trackedMessages.removeAll(messages);
    }

    protected boolean warningOrError(boolean isError, List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack stack, boolean thePass, String msg, Object ... theMessageArguments) {
        return this.warningOrError(isError, errors, ruleDate, type, stack.line(), stack.col(), stack.getLiteralPath(), thePass, msg, theMessageArguments);
    }

    protected boolean warningOrError(boolean isError, List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && !this.suppressMsg(path, msg)) {
            ValidationMessage.IssueSeverity lvl;
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity issueSeverity = lvl = isError ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.WARNING;
            if (this.doingLevel(lvl)) {
                this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, lvl, msg);
            }
        }
        return thePass;
    }

    protected boolean hintOrError(boolean isError, List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, NodeStack stack, boolean thePass, String msg, Object ... theMessageArguments) {
        return this.hintOrError(isError, errors, ruleDate, type, stack.line(), stack.col(), stack.getLiteralPath(), thePass, msg, theMessageArguments);
    }

    protected boolean hintOrError(boolean isError, List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && !this.suppressMsg(path, msg)) {
            ValidationMessage.IssueSeverity lvl;
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity issueSeverity = lvl = isError ? ValidationMessage.IssueSeverity.ERROR : ValidationMessage.IssueSeverity.INFORMATION;
            if (this.doingLevel(lvl)) {
                this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, lvl, msg);
            }
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(CommaSeparatedStringBuilder.join((String)".", pathParts), theMessage)) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.WARNING, theMessage);
        }
        return thePass;
    }

    protected boolean warning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String message = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.WARNING, null);
        }
        return thePass;
    }

    protected boolean warningOrHint(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, boolean warning, String msg, Object ... theMessageArguments) {
        if (!thePass && !this.suppressMsg(path, msg)) {
            ValidationMessage.IssueSeverity lvl;
            String message = this.context.formatMessage(msg, theMessageArguments);
            ValidationMessage.IssueSeverity issueSeverity = lvl = warning ? ValidationMessage.IssueSeverity.WARNING : ValidationMessage.IssueSeverity.INFORMATION;
            if (this.doingLevel(lvl)) {
                this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, lvl, null);
            }
        }
        return thePass;
    }

    protected boolean warningHtml(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            this.addValidationMessage(errors, ruleDate, type, path, msg, html, ValidationMessage.IssueSeverity.WARNING, null);
        }
        return thePass;
    }

    protected boolean warningHtml(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, path, nmsg, html, ValidationMessage.IssueSeverity.WARNING, msg);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, int line, int col, String path, boolean thePass, String msg, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, line, col, path, nmsg, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, List<String> pathParts, boolean thePass, String theMessage, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(CommaSeparatedStringBuilder.join((String)".", pathParts), theMessage)) {
            String path = this.toPath(pathParts);
            String message = this.context.formatMessage(theMessage, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, message, ValidationMessage.IssueSeverity.INFORMATION, theMessage);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg) {
        if (!thePass && this.doingWarnings()) {
            this.addValidationMessage(errors, ruleDate, type, -1, -1, path, msg, ValidationMessage.IssueSeverity.INFORMATION, null);
        }
        return thePass;
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html) {
        if (!thePass && this.doingWarnings()) {
            ValidationMessage.IssueSeverity severity = ValidationMessage.IssueSeverity.INFORMATION;
            this.addValidationMessage(errors, ruleDate, type, path, msg, html, severity, null);
        }
        return thePass;
    }

    protected void addValidationMessage(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, String msg, String html, ValidationMessage.IssueSeverity theSeverity, String id) {
        ValidationMessage vm = new ValidationMessage(this.source, type, -1, -1, path, msg, html, theSeverity);
        vm.setRuleDate(ruleDate);
        if (this.checkMsgId(id, vm) && this.doingLevel(theSeverity)) {
            errors.add(vm.setMessageId(id));
        }
    }

    protected boolean suppressedwarning(List<ValidationMessage> errors, String ruleDate, ValidationMessage.IssueType type, String path, boolean thePass, String msg, String html, Object ... theMessageArguments) {
        if (!thePass && this.doingWarnings() && !this.suppressMsg(path, msg)) {
            String nmsg = this.context.formatMessage(msg, theMessageArguments);
            this.addValidationMessage(errors, ruleDate, type, path, nmsg, html, ValidationMessage.IssueSeverity.INFORMATION, msg);
        }
        return thePass;
    }

    protected ValueSet resolveBindingReference(DomainResource ctxt, String reference, String uri, Resource src) {
        if (reference != null) {
            if (reference.equals("http://www.rfc-editor.org/bcp/bcp13.txt")) {
                reference = "http://hl7.org/fhir/ValueSet/mimetypes";
            }
            if (reference.startsWith("#")) {
                for (Resource c : ctxt.getContained()) {
                    if (!c.getId().equals(reference.substring(1)) || !(c instanceof ValueSet)) continue;
                    return (ValueSet)c;
                }
                return null;
            }
            long t = System.nanoTime();
            ValueSet fr = (ValueSet)this.context.findTxResource(ValueSet.class, reference, src);
            if (fr == null && !Utilities.isAbsoluteUrl((String)reference)) {
                reference = this.resolve(uri, reference);
                fr = (ValueSet)this.context.findTxResource(ValueSet.class, reference, src);
            }
            if (fr == null) {
                fr = ValueSetUtilities.generateImplicitValueSet((String)reference);
            }
            this.timeTracker.tx(t, "vs " + uri);
            return fr;
        }
        return null;
    }

    private String resolve(String uri, String ref) {
        if (StringUtils.isBlank((CharSequence)uri)) {
            return ref;
        }
        String[] up = uri.split("\\/");
        String[] rp = ref.split("\\/");
        if (this.context.getResourceNames().contains(up[up.length - 2]) && this.context.getResourceNames().contains(rp[0])) {
            StringBuilder b = new StringBuilder();
            for (int i = 0; i < up.length - 2; ++i) {
                b.append(up[i]);
                b.append("/");
            }
            b.append(ref);
            return b.toString();
        }
        return ref;
    }

    protected String describeReference(String reference) {
        if (reference == null) {
            return "null";
        }
        return reference;
    }

    protected Base resolveInBundle(String url, Element bnd) {
        if (bnd == null) {
            return null;
        }
        if (bnd.fhirType().equals("Bundle")) {
            for (Element be : bnd.getChildrenByName("entry")) {
                Element res = be.getNamedChild("resource", false);
                if (res == null) continue;
                String fullUrl = be.getChildValue("fullUrl");
                String rt = res.fhirType();
                String id = res.getChildValue("id");
                if (url.equals(fullUrl)) {
                    return res;
                }
                if (!url.equals(rt + "/" + id)) continue;
                return res;
            }
        }
        return null;
    }

    protected Element resolveInBundle(Element bundle, List<Element> entries, String ref, String fullUrl, String type, String id, NodeStack stack, List<ValidationMessage> errors, String name, Element source, boolean isWarning, boolean isNLLink) {
        List el;
        HashMap<String, ArrayList<Element>> map = (HashMap<String, ArrayList<Element>>)bundle.getUserData("validator.entrymap");
        HashMap relMap = (HashMap)bundle.getUserData("validator.entrymapR");
        List<Element> list = null;
        if (map == null) {
            map = new HashMap<String, ArrayList<Element>>();
            bundle.setUserData("validator.entrymap", map);
            relMap = new HashMap();
            bundle.setUserData("validator.entrymapR", relMap);
            for (Element entry : entries) {
                String fu = entry.getNamedChildValue("fullUrl", false);
                list = (ArrayList<Element>)map.get(fu);
                if (list == null) {
                    list = new ArrayList<Element>();
                    map.put(fu, (ArrayList<Element>)list);
                }
                list.add(entry);
                Element resource = entry.getNamedChild("resource", false);
                if (resource == null) continue;
                String et = resource.getType();
                String eid = resource.getNamedChildValue("id", false);
                if (eid == null) continue;
                String rl = et + "/" + eid;
                list = (List)relMap.get(rl);
                if (list == null) {
                    list = new ArrayList();
                    relMap.put((CallSite)((Object)rl), list);
                }
                list.add(entry);
            }
        }
        String fragment = null;
        if (ref != null && ref.contains("#")) {
            fragment = ref.substring(ref.indexOf("#") + 1);
            ref = ref.substring(0, ref.indexOf("#"));
        }
        if (Utilities.isAbsoluteUrl((String)ref)) {
            List el2 = (List)map.get(ref);
            if (el2 == null) {
                boolean ok = this.context.hasResource(Resource.class, ref);
                if (!ok && ref.matches(this.urlRegex)) {
                    String tt = this.extractResourceType(ref);
                    ok = VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(tt);
                }
                if (!ok && stack != null && !this.session.getSessionId().equals(source.getUserString("bundle.error.noted"))) {
                    source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                    this.hintOrError(!isWarning, errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack, false, "Bundle_BUNDLE_Entry_NotFound", ref, name);
                }
                return null;
            }
            if (el2.size() == 1) {
                if (fragment != null) {
                    int i = this.countFragmentMatches((Element)el2.get(0), fragment);
                    if (i == 0) {
                        source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                        this.hintOrError(isNLLink, errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack, false, "BUNDLE_BUNDLE_ENTRY_NOTFOUND_FRAGMENT", ref, fragment, name);
                    } else if (i > 1) {
                        source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                        this.rule(errors, "2023-11-15", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_BUNDLE_ENTRY_FOUND_MULTIPLE_FRAGMENT", i, ref, fragment, name);
                    }
                }
                return (Element)el2.get(0);
            }
            if (stack != null && !this.session.getSessionId().equals(source.getUserString("bundle.error.noted"))) {
                source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                this.rule(errors, "2023-11-15", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_BUNDLE_ENTRY_FOUND_MULTIPLE", el2.size(), ref, name);
            }
            return null;
        }
        String u = null;
        if (fullUrl != null && fullUrl.matches(this.urlRegex) && fullUrl.endsWith(type + "/" + id)) {
            u = fullUrl.substring(0, fullUrl.length() - (type + "/" + id).length()) + ref;
        }
        if ((el = (List)map.get(u)) != null && el.size() > 0) {
            if (el.size() == 1) {
                return (Element)el.get(0);
            }
            if (stack != null && !this.session.getSessionId().equals(source.getUserString("bundle.error.noted"))) {
                source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                this.rule(errors, "2023-11-15", ValidationMessage.IssueType.INVALID, stack, false, "BUNDLE_BUNDLE_ENTRY_FOUND_MULTIPLE", el.size(), ref, name);
            }
            return null;
        }
        String[] parts = ref.split("\\/");
        if (parts.length >= 2) {
            String t = parts[0];
            if (this.context.getResourceNamesAsSet().contains(t)) {
                String i = parts[1];
                el = (List)relMap.get(t + "/" + i);
                if (el != null) {
                    HashSet<String> tl = new HashSet<String>();
                    for (Element e : el) {
                        String fu = e.getNamedChildValue("fullUrl", false);
                        tl.add(fu == null ? "<missing>" : fu);
                    }
                    if (!VersionUtilities.isR4Plus((String)this.context.getVersion())) {
                        if (el.size() == 1) {
                            return (Element)el.get(0);
                        }
                        if (stack != null && !this.session.getSessionId().equals(source.getUserString("bundle.error.noted"))) {
                            source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                            this.rulePlural(errors, "2023-11-15", ValidationMessage.IssueType.INVALID, stack, false, el.size(), "BUNDLE_BUNDLE_ENTRY_NOTFOUND_APPARENT", ref, name, CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(tl)));
                        }
                    } else if (stack != null && !this.session.getSessionId().equals(source.getUserString("bundle.error.noted"))) {
                        source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                        this.rulePlural(errors, "2023-11-15", ValidationMessage.IssueType.INVALID, stack, false, el.size(), "BUNDLE_BUNDLE_ENTRY_NOTFOUND_APPARENT", ref, name, CommaSeparatedStringBuilder.join((String)",", (Collection)Utilities.sorted(tl)));
                    }
                } else if (stack != null && !this.session.getSessionId().equals(source.getUserString("bundle.error.noted"))) {
                    source.setUserData("bundle.error.noted", (Object)this.session.getSessionId());
                    this.hintOrError(!isWarning, errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack, false, "Bundle_BUNDLE_Entry_NotFound", ref, name);
                }
            }
        }
        return null;
    }

    protected int countFragmentMatches(Element element, String fragment, NodeStack stack) {
        Element bnd;
        int count = this.countFragmentMatches(element, fragment);
        if (count == 0 && element.isResource() && element.hasParentForValidator() && (bnd = this.getElementBundle(element)) != null) {
            for (Element be : bnd.getChildrenByName("entry")) {
                String id = be.getIdBase();
                if (!fragment.equals(id)) continue;
                ++count;
            }
        }
        return count;
    }

    private Element getElementBundle(Element element) {
        Element b;
        Element p = element.getParentForValidator();
        if (p != null && (b = p.getParentForValidator()) != null && b.fhirType().equals("Bundle")) {
            return b;
        }
        return null;
    }

    protected int countFragmentMatches(Element element, String fragment) {
        int count = 0;
        if (fragment.equals(element.getIdBase())) {
            ++count;
        }
        if (element.getXhtml() != null) {
            count += this.countFragmentMatches(element.getXhtml(), fragment);
        }
        if (element.hasChildren()) {
            for (Element child : element.getChildren()) {
                count += this.countFragmentMatches(child, fragment);
            }
        }
        return count;
    }

    private int countFragmentMatches(XhtmlNode node, String fragment) {
        int count = 0;
        if (fragment.equals(node.getAttribute("id"))) {
            ++count;
        }
        if (node.hasChildren()) {
            for (XhtmlNode child : node.getChildNodes()) {
                count += this.countFragmentMatches(child, fragment);
            }
        }
        return count;
    }

    private String extractResourceType(String ref) {
        String[] p = ref.split("\\/");
        return p[p.length - 2];
    }

    protected IndexedElement getFromBundle(Element bundle, String ref, String fullUrl, List<ValidationMessage> errors, String path, String type, boolean isTransaction, BooleanHolder bh) {
        Object targetUrl = null;
        String version = "";
        String resourceType = null;
        if (ref.startsWith("http:") || ref.startsWith("urn:") || Utilities.isAbsoluteUrl((String)ref)) {
            if (ref.contains("/_history/")) {
                targetUrl = ref.substring(0, ref.indexOf("/_history/") - 1);
                version = ref.substring(ref.indexOf("/_history/") + 10);
            } else {
                targetUrl = ref;
            }
        } else {
            int i;
            String[] parts;
            if (fullUrl == null) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, Utilities.existsInList((String)type, (String[])new String[]{"batch-response", "transaction-response"}) || path.startsWith("Bundle.signature"), "Bundle_BUNDLE_FullUrl_Missing", new Object[0]);
                return null;
            }
            if (ref.split("/").length != 2 && ref.split("/").length != 4) {
                if (isTransaction) {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, -1, -1, path, this.isSearchUrl(ref), "Reference_REF_Format1", ref);
                } else {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, -1, -1, path, false, "Reference_REF_Format2", ref);
                }
                return null;
            }
            Object base = "";
            if (fullUrl.startsWith("urn")) {
                parts = fullUrl.split("\\:");
                for (i = 0; i < parts.length - 1; ++i) {
                    base = (String)base + parts[i] + ":";
                }
            } else {
                parts = fullUrl.split("/");
                for (i = 0; i < parts.length - 2; ++i) {
                    base = (String)base + parts[i] + "/";
                }
            }
            String id = null;
            if (ref.contains("/_history/")) {
                version = ref.substring(ref.indexOf("/_history/") + 10);
                String[] refBaseParts = ref.substring(0, ref.indexOf("/_history/")).split("/");
                resourceType = refBaseParts[0];
                id = refBaseParts[1];
                targetUrl = (String)base + resourceType + "/" + id;
            } else if (((String)base).startsWith("urn")) {
                resourceType = ref.split("/")[0];
                id = ref.split("/")[1];
                targetUrl = (String)base + id;
            } else {
                id = ref;
                targetUrl = (String)base + id;
            }
        }
        ArrayList entries = new ArrayList();
        bundle.getNamedChildren("entry", entries);
        Element match = null;
        int matchIndex = -1;
        for (int i = 0; i < entries.size(); ++i) {
            Element we = (Element)entries.get(i);
            if (!((String)targetUrl).equals(we.getChildValue("fullUrl"))) continue;
            Element r = we.getNamedChild("resource", false);
            if (version.isEmpty()) {
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Bundle_BUNDLE_MultipleMatches", ref);
                match = r;
                matchIndex = i;
                continue;
            }
            try {
                if (!version.equals(((Element)r.getChildren("meta").get(0)).getChildValue("versionId"))) continue;
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.FORBIDDEN, -1, -1, path, match == null, "Bundle_BUNDLE_MultipleMatches", ref);
                match = r;
                matchIndex = i;
                continue;
            }
            catch (Exception e) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, r.getChildren("meta").size() == 1 && ((Element)r.getChildren("meta").get(0)).getChildValue("versionId") != null, "Bundle_BUNDLE_FullUrl_NeedVersion", targetUrl);
            }
        }
        if (match != null && resourceType != null) {
            bh.see(this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, match.getType().equals(resourceType), "Reference_REF_ResourceType", ref, match.getType()));
        }
        if (match == null) {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, !ref.startsWith("urn"), "Bundle_BUNDLE_Not_Local", ref);
            if (!Utilities.isAbsoluteUrl((String)ref)) {
                String[] p = ref.split("\\/");
                ArrayList<Element> ml = new ArrayList<Element>();
                if (p.length >= 2 && this.context.getResourceNamesAsSet().contains(p[0]) && Utilities.isValidId((String)p[1])) {
                    for (int i = 0; i < entries.size(); ++i) {
                        Element we = (Element)entries.get(i);
                        Element r = we.getNamedChild("resource", false);
                        if (r == null || !p[0].equals(r.fhirType()) || !p[1].equals(r.getNamedChildValue("id", false))) continue;
                        ml.add(we);
                    }
                }
                if (ml.size() > 1) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, false, "BUNDLE_POSSSIBLE_MATCHES", ref, targetUrl);
                }
                for (Element e : ml) {
                    String fu = e.getChildValue("fullUrl");
                    int i = entries.indexOf(e);
                    if (fu == null) {
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, false, "BUNDLE_BUNDLE_POSSIBLE_MATCH_NO_FU", i, ref, targetUrl);
                        continue;
                    }
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, -1, -1, path, false, "BUNDLE_BUNDLE_POSSIBLE_MATCH_WRONG_FU", i, ref, fu, targetUrl);
                }
            }
        }
        return match == null ? null : new IndexedElement(matchIndex, match, (Element)entries.get(matchIndex));
    }

    private boolean isSearchUrl(String ref) {
        if (Utilities.noString((String)ref) || !ref.contains("?")) {
            return false;
        }
        String tn = ref.substring(0, ref.indexOf("?"));
        String q = ref.substring(ref.indexOf("?") + 1);
        if (!this.context.getResourceNames().contains(tn)) {
            return false;
        }
        return q.matches("([_a-zA-Z][_a-zA-Z0-9]*=[^=&]*)(&([_a-zA-Z][_a-zA-Z0-9]*=[^=&]*))*");
    }

    public Map<String, ValidationControl> getValidationControl() {
        return this.validationControl;
    }

    public XVerExtensionManager.XVerExtensionStatus xverStatus(String url) {
        return this.xverManager.status(url);
    }

    public boolean isXverUrl(String url) {
        return this.xverManager.matchingUrl(url);
    }

    public StructureDefinition xverDefn(String url) {
        return this.xverManager.makeDefinition(url);
    }

    public String xverVersion(String url) {
        return this.xverManager.getVersion(url);
    }

    public String xverElementId(String url) {
        return this.xverManager.getElementId(url);
    }

    public StructureDefinition getXverExt(StructureDefinition profile, List<ValidationMessage> errors, String url) {
        if (this.isXverUrl(url)) {
            switch (this.xverStatus(url)) {
                case BadVersion: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), false, "Extension_EXT_Version_Invalid", url, this.xverVersion(url));
                    return null;
                }
                case Unknown: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), false, "Extension_EXT_Version_InvalidId", url, this.xverElementId(url));
                    return null;
                }
                case Invalid: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), false, "Extension_EXT_Version_NoChange", url, this.xverElementId(url));
                    return null;
                }
                case Valid: {
                    StructureDefinition defn = this.xverDefn(url);
                    new ContextUtilities(this.context).generateSnapshot(defn);
                    this.context.cacheResource((Resource)defn);
                    return defn;
                }
            }
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, profile.getId(), false, "Extension_EXT_Version_Internal", url);
            return null;
        }
        return null;
    }

    public StructureDefinition getXverExt(List<ValidationMessage> errors, String path, Element element, String url) {
        if (this.isXverUrl(url)) {
            switch (this.xverStatus(url)) {
                case BadVersion: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_Invalid", url, this.xverVersion(url));
                    break;
                }
                case Unknown: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_InvalidId", url, this.xverElementId(url));
                    break;
                }
                case Invalid: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_NoChange", url, this.xverElementId(url));
                    break;
                }
                case Valid: {
                    StructureDefinition ex = this.xverDefn(url);
                    new ContextUtilities(this.context).generateSnapshot(ex);
                    this.context.cacheResource((Resource)ex);
                    return ex;
                }
                default: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, element.line(), element.col(), path + "[url='" + url + "']", false, "Extension_EXT_Version_Internal", url);
                }
            }
        }
        return null;
    }

    public Resource loadContainedResource(List<ValidationMessage> errors, String path, Element resource, String id, Class<? extends Resource> class1) throws FHIRException {
        for (Element contained : resource.getChildren("contained")) {
            if (!contained.getIdBase().equals(id)) continue;
            return this.loadFoundResource(errors, path, contained, class1);
        }
        return null;
    }

    protected Resource loadFoundResource(List<ValidationMessage> errors, String path, Element resource, Class<? extends Resource> class1) throws FHIRException {
        try {
            FhirPublication v = FhirPublication.fromCode((String)this.context.getVersion());
            ByteArrayOutputStream bs = new ByteArrayOutputStream();
            new org.hl7.fhir.r5.elementmodel.JsonParser(this.context).compose(resource, (OutputStream)bs, IParser.OutputStyle.NORMAL, resource.getIdBase());
            byte[] json = bs.toByteArray();
            Resource r5 = null;
            switch (v) {
                case DSTU1: {
                    this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, resource.line(), resource.col(), path, false, "Unsupported_version_R1", resource.getIdBase());
                    return null;
                }
                case DSTU2: {
                    org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
                    break;
                }
                case DSTU2016May: {
                    org.hl7.fhir.dstu2016may.model.Resource r2a = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2a);
                    break;
                }
                case STU3: {
                    org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
                    break;
                }
                case R4: {
                    org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(json);
                    r5 = VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
                    break;
                }
                case R5: {
                    r5 = new JsonParser().parse(json);
                    break;
                }
                default: {
                    return null;
                }
            }
            if (class1.isInstance(r5)) {
                return r5;
            }
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, resource.line(), resource.col(), path, false, "REFERENCE_REF_WRONGTARGET_LOAD", resource.getIdBase(), class1.toString(), r5.fhirType());
            return null;
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    public void setLevel(ValidationLevel level) {
        this.level = level;
    }

    public ValidationLevel getLevel() {
        return this.level;
    }

    protected boolean isHL7(Element cr) {
        String url = cr.getChildValue("url");
        return url != null && url.contains("hl7");
    }

    protected boolean isHL7Core(Element cr) {
        String url = cr.getChildValue("url");
        return url != null && url.startsWith("http://hl7.org/fhir/") && !url.startsWith("http://hl7.org/fhir/test");
    }

    public boolean isAllowExamples() {
        return this.allowExamples;
    }

    public void setAllowExamples(boolean value) {
        this.allowExamples = value;
    }

    protected boolean isExampleUrl(String url) {
        return Utilities.containsInList((String)url, (String[])new String[]{"example.org", "acme.com", "acme.org"});
    }

    public boolean isForPublication() {
        return this.forPublication;
    }

    public BaseValidator setForPublication(boolean forPublication) {
        this.forPublication = forPublication;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    protected boolean checkDefinitionStatus(List<ValidationMessage> errors, Element element, String path, StructureDefinition ex, CanonicalResource source, String type) {
        boolean ok = true;
        String vurl = ex.getVersionedUrl();
        StandardsStatus standardsStatus = ToolingExtensions.getStandardsStatus((DomainResource)ex);
        if (standardsStatus == StandardsStatus.DEPRECATED) {
            if (!this.statusWarnings.contains(vurl + ":DEPRECATED")) {
                this.statusWarnings.add(vurl + ":DEPRECATED");
                this.hint(errors, "2023-08-10", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, false, "MSG_DEPENDS_ON_DEPRECATED", type, vurl);
            }
        } else if (standardsStatus == StandardsStatus.WITHDRAWN) {
            if (!this.statusWarnings.contains(vurl + ":WITHDRAWN")) {
                this.statusWarnings.add(vurl + ":WITHDRAWN");
                this.hint(errors, "2023-08-10", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, false, "MSG_DEPENDS_ON_WITHDRAWN", type, vurl);
            }
        } else if (ex.getStatus() == Enumerations.PublicationStatus.RETIRED && !this.statusWarnings.contains(vurl + ":RETIRED")) {
            this.statusWarnings.add(vurl + ":RETIRED");
            this.hint(errors, "2023-08-10", ValidationMessage.IssueType.BUSINESSRULE, element.line(), element.col(), path, false, "MSG_DEPENDS_ON_RETIRED", type, vurl);
        }
        return ok;
    }

    public BestPracticeWarningLevel getBestPracticeWarningLevel() {
        return this.bpWarnings;
    }

    protected boolean bpCheck(List<ValidationMessage> errors, ValidationMessage.IssueType invalid, int line, int col, String literalPath, boolean test, String message, Object ... theMessageArguments) {
        if (this.bpWarnings != null) {
            switch (this.bpWarnings) {
                case Error: {
                    this.rule(errors, NO_RULE_DATE, invalid, line, col, literalPath, test, message, theMessageArguments);
                    return test;
                }
                case Warning: {
                    this.warning(errors, NO_RULE_DATE, invalid, line, col, literalPath, test, message, theMessageArguments);
                    return true;
                }
                case Hint: {
                    this.hint(errors, NO_RULE_DATE, invalid, line, col, literalPath, test, message, theMessageArguments);
                    return true;
                }
            }
        }
        return true;
    }

    public List<UsageContext> getUsageContexts() {
        return this.usageContexts;
    }

    protected boolean hasUseContext(Coding use, Coding value) {
        for (UsageContext usage : this.usageContexts) {
            if (!this.isContext(use, value, usage)) continue;
            return true;
        }
        return false;
    }

    private boolean isContext(Coding use, Coding value, UsageContext usage) {
        return usage.getValue() instanceof Coding && this.context.subsumes(this.baseOptions, usage.getCode(), use) != false && this.context.subsumes(this.baseOptions, (Coding)usage.getValue(), value) != false;
    }

    protected boolean isKnownUsage(UsageContext usage) {
        for (UsageContext t : this.usageContexts) {
            if (!this.usagesMatch(usage, t)) continue;
            return true;
        }
        return false;
    }

    private boolean usagesMatch(UsageContext usage, UsageContext t) {
        if (usage.hasCode() && t.hasCode() && usage.hasValue() && t.hasValue() && usage.getCode().matches(t.getCode()) && usage.getValue().fhirType().equals(t.getValue().fhirType())) {
            switch (usage.getValue().fhirType()) {
                case "CodeableConcept": {
                    for (Coding uc : usage.getValueCodeableConcept().getCoding()) {
                        for (Coding tc : t.getValueCodeableConcept().getCoding()) {
                            if (!uc.matches(tc)) continue;
                            return true;
                        }
                    }
                }
                case "Quantity": {
                    return false;
                }
                case "Range": {
                    return false;
                }
                case "Reference": {
                    return false;
                }
            }
        }
        return false;
    }

    public IValidationPolicyAdvisor getPolicyAdvisor() {
        return this.policyAdvisor;
    }

    public void setPolicyAdvisor(IValidationPolicyAdvisor advisor) {
        if (advisor == null) {
            throw new Error("Cannot set advisor to null");
        }
        this.policyAdvisor = advisor;
    }

    public class ValidationControl {
        private boolean allowed;
        private ValidationMessage.IssueSeverity level;

        public ValidationControl(boolean allowed, ValidationMessage.IssueSeverity level) {
            this.allowed = allowed;
            this.level = level;
        }

        public boolean isAllowed() {
            return this.allowed;
        }

        public ValidationMessage.IssueSeverity getLevel() {
            return this.level;
        }
    }

    public class TrackedLocationRelatedMessage {
        private Object location;
        private ValidationMessage vmsg;

        public TrackedLocationRelatedMessage(Object location, ValidationMessage vmsg) {
            this.location = location;
            this.vmsg = vmsg;
        }

        public Object getLocation() {
            return this.location;
        }

        public ValidationMessage getVmsg() {
            return this.vmsg;
        }
    }

    public static class BooleanHolder {
        private boolean value = true;

        public BooleanHolder() {
            this.value = true;
        }

        public BooleanHolder(boolean value) {
            this.value = value;
        }

        public void fail() {
            this.value = false;
        }

        public boolean ok() {
            return this.value;
        }

        public void see(boolean ok) {
            this.value = this.value && ok;
        }

        public void set(boolean value) {
            this.value = value;
        }
    }
}

