/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.validation.BundleValidationRule;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.instance.InstanceValidator;
import org.hl7.fhir.validation.instance.PercentageTracker;
import org.hl7.fhir.validation.instance.utils.EntrySummary;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidationContext;

public class BundleValidator
extends BaseValidator {
    public static final String URI_REGEX3 = "((http|https)://([A-Za-z0-9\\\\\\.\\:\\%\\$]*\\/)*)?(Account|ActivityDefinition|AllergyIntolerance|AdverseEvent|Appointment|AppointmentResponse|AuditEvent|Basic|Binary|BodySite|Bundle|CapabilityStatement|CarePlan|CareTeam|ChargeItem|Claim|ClaimResponse|ClinicalImpression|CodeSystem|Communication|CommunicationRequest|CompartmentDefinition|Composition|ConceptMap|Condition (aka Problem)|Consent|Contract|Coverage|DataElement|DetectedIssue|Device|DeviceComponent|DeviceMetric|DeviceRequest|DeviceUseStatement|DiagnosticReport|DocumentManifest|DocumentReference|EligibilityRequest|EligibilityResponse|Encounter|Endpoint|EnrollmentRequest|EnrollmentResponse|EpisodeOfCare|ExpansionProfile|ExplanationOfBenefit|FamilyMemberHistory|Flag|Goal|GraphDefinition|Group|GuidanceResponse|HealthcareService|ImagingManifest|ImagingStudy|Immunization|ImmunizationRecommendation|ImplementationGuide|Library|Linkage|List|Location|Measure|MeasureReport|Media|Medication|MedicationAdministration|MedicationDispense|MedicationRequest|MedicationStatement|MessageDefinition|MessageHeader|NamingSystem|NutritionOrder|Observation|OperationDefinition|OperationOutcome|Organization|Parameters|Patient|PaymentNotice|PaymentReconciliation|Person|PlanDefinition|Practitioner|PractitionerRole|Procedure|ProcedureRequest|ProcessRequest|ProcessResponse|Provenance|Questionnaire|QuestionnaireResponse|ReferralRequest|RelatedPerson|RequestGroup|ResearchStudy|ResearchSubject|RiskAssessment|Schedule|SearchParameter|Sequence|ServiceDefinition|Slot|Specimen|StructureDefinition|StructureMap|Subscription|Substance|SupplyDelivery|SupplyRequest|Task|TestScript|TestReport|ValueSet|VisionPrescription)\\/[A-Za-z0-9\\-\\.]{1,64}(\\/_history\\/[A-Za-z0-9\\-\\.]{1,64})?";
    private String serverBase;

    public BundleValidator(BaseValidator parent, String serverBase) {
        super(parent);
        this.serverBase = serverBase;
    }

    public boolean validateBundle(List<ValidationMessage> errors, Element bundle, NodeStack stack, boolean checkSpecials, ValidationContext hostContext, PercentageTracker pct, Base.ValidationMode mode) {
        boolean ok = true;
        this.sessionId = Utilities.makeUuidLC();
        String type = bundle.getNamedChildValue("type", false);
        type = StringUtils.defaultString((String)type);
        ArrayList<Element> entries = new ArrayList<Element>();
        bundle.getNamedChildren("entry", entries);
        ArrayList<Element> links = new ArrayList<Element>();
        bundle.getNamedChildren("link", links);
        if (links.size() > 0) {
            int i = 0;
            for (Element l : links) {
                ok = this.validateLink(errors, bundle, links, l, stack.push(l, i++, null, null), type, entries) && ok;
            }
        }
        if (entries.size() == 0) {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !type.equals("document") && !type.equals("message"), "Bundle_BUNDLE_Entry_NoFirst", new Object[0]) && ok;
        } else {
            String id;
            Element resource;
            Element firstEntry = (Element)entries.get(0);
            NodeStack firstStack = stack.push(firstEntry, 1, null, null);
            String fullUrl = firstEntry.getNamedChildValue("fullUrl", false);
            if (type.equals("document")) {
                resource = firstEntry.getNamedChild("resource", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    id = resource.getNamedChildValue("id", false);
                    boolean bl = ok = this.validateDocument(errors, bundle, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id) && ok;
                }
                if (!VersionUtilities.isThisOrLater((String)Enumerations.FHIRVersion._4_0_1.getDisplay(), (String)bundle.getProperty().getStructure().getFhirVersion().getDisplay())) {
                    ok = this.handleSpecialCaseForLastUpdated(bundle, errors, stack) && ok;
                }
                ok = this.checkAllInterlinked(errors, entries, stack, bundle, false) && ok;
            } else if (type.equals("message")) {
                resource = firstEntry.getNamedChild("resource", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, firstEntry.line(), firstEntry.col(), stack.addToLiteralPath("entry", ":0"), resource != null, "Bundle_BUNDLE_Entry_NoFirstResource", new Object[0])) {
                    id = resource.getNamedChildValue("id", false);
                    ok = this.validateMessage(errors, entries, resource, firstStack.push(resource, -1, null, null), fullUrl, id) && ok;
                    ok = this.checkAllInterlinked(errors, entries, stack, bundle, true) && ok;
                }
            } else if (type.equals("searchset")) {
                ok = this.checkSearchSet(errors, bundle, entries, stack) && ok;
            }
        }
        int count = 0;
        HashMap<String, Integer> counter = new HashMap<String, Integer>();
        boolean fullUrlOptional = Utilities.existsInList((String)type, (String[])new String[]{"transaction", "transaction-response", "batch", "batch-response"});
        for (Element entry : entries) {
            NodeStack estack = stack.push(entry, count, null, null);
            String fullUrl = entry.getNamedChildValue("fullUrl", false);
            String url = this.getCanonicalURLForEntry(entry);
            String id = this.getIdForEntry(entry);
            String rtype = this.getTypeForEntry(entry);
            if (!Utilities.noString((String)fullUrl)) {
                if (Utilities.isAbsoluteUrl((String)fullUrl)) {
                    if (rtype != null && fullUrl.matches(this.urlRegex)) {
                        ok = this.rule(errors, "2023-11-13", ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), id != null, "BUNDLE_ENTRY_URL_MATCHES_NO_ID", fullUrl) ? this.rule(errors, "2023-11-13", ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), fullUrl.endsWith("/" + rtype + "/" + id), "BUNDLE_ENTRY_URL_MATCHES_TYPE_ID", fullUrl, rtype, id) && ok : false;
                    }
                } else {
                    ok = false;
                    this.rule(errors, "2023-11-13", ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "BUNDLE_ENTRY_URL_ABSOLUTE", fullUrl);
                }
            }
            if (url != null) {
                if (!(!url.equals(fullUrl) || url.matches(this.urlRegex) && url.endsWith("/" + id) || this.isV3orV2Url(url))) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), false, "Bundle_BUNDLE_Entry_MismatchIdUrl", url, fullUrl, id) && ok;
                }
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry", ":0"), !url.equals(fullUrl) || this.serverBase == null || url.equals(Utilities.pathURL((String[])new String[]{this.serverBase, entry.getNamedChild("resource", false).fhirType(), id})), "Bundle_BUNDLE_Entry_Canonical", url, fullUrl) && ok;
            }
            if (!VersionUtilities.isR2Ver((String)this.context.getVersion())) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), estack.getLiteralPath(), fullUrlOptional || fullUrl != null, "BUNDLE_BUNDLE_ENTRY_FULLURL_REQUIRED", new Object[0]) && ok;
            }
            if (rtype != null) {
                int rcount = counter.containsKey(rtype) ? (Integer)counter.get(rtype) + 1 : 0;
                counter.put(rtype, rcount);
                Element res = entry.getNamedChild("resource", false);
                NodeStack rstack = estack.push(res, -1, null, null);
                for (BundleValidationRule bvr : this.validator().getBundleValidationRules()) {
                    if (!this.meetsRule(bvr, rtype, rcount, count)) continue;
                    StructureDefinition defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, bvr.getProfile());
                    if (defn == null) {
                        throw new Error(this.context.formatMessage("BUNDLE_RULE_PROFILE_UNKNOWN", new Object[]{bvr.getRule(), bvr.getProfile()}));
                    }
                    if (this.validator().isCrumbTrails()) {
                        res.addMessage(this.signpost(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, res.line(), res.col(), stack.getLiteralPath(), "VALIDATION_VAL_PROFILE_SIGNPOST_BUNDLE_PARAM", defn.getUrl()));
                    }
                    stack.resetIds();
                    ok = this.validator().startInner(hostContext, errors, res, res, defn, rstack, false, pct, mode, false) && ok;
                }
                ((InstanceValidator)this.parent).checkSpecials(hostContext, errors, res, rstack, true, pct, mode, true);
            }
            ++count;
        }
        return ok;
    }

    private InstanceValidator validator() {
        return (InstanceValidator)this.parent;
    }

    private boolean validateLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack, String type, List<Element> entries) {
        switch (type) {
            case "document": {
                return this.validateDocumentLink(errors, bundle, links, link, stack, entries);
            }
            case "message": {
                return this.validateMessageLink(errors, bundle, links, link, stack, entries);
            }
            case "history": 
            case "searchset": {
                return this.validateSearchLink(errors, bundle, links, link, stack);
            }
            case "collection": {
                return this.validateCollectionLink(errors, bundle, links, link, stack);
            }
            case "subscription-notification": {
                return this.validateSubscriptionLink(errors, bundle, links, link, stack);
            }
            case "transaction": 
            case "transaction-response": 
            case "batch": 
            case "batch-response": {
                return this.validateTransactionOrBatchLink(errors, bundle, links, link, stack);
            }
        }
        return true;
    }

    private boolean validateDocumentLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack, List<Element> entries) {
        boolean ok = true;
        Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            Element urlE;
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                boolean bl = ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
            if ("stylesheet".equals(rel) && (urlE = link.getNamedChild("url", false)) != null) {
                NodeStack urlStack = stack.push(urlE, -1, null, null);
                String url = urlE.getValue();
                if (url != null) {
                    if (Utilities.isAbsoluteUrl((String)url)) {
                        if (!url.equals("https://hl7.org/fhir/fhir.css")) {
                            this.warning(errors, "2022-12-09", ValidationMessage.IssueType.BUSINESSRULE, urlE.line(), urlE.col(), urlStack.getLiteralPath(), false, "BUNDLE_LINK_STYELSHEET_EXTERNAL", new Object[0]);
                            if (url.startsWith("http://")) {
                                this.warning(errors, "2022-12-09", ValidationMessage.IssueType.BUSINESSRULE, urlE.line(), urlE.col(), urlStack.getLiteralPath(), false, "BUNDLE_LINK_STYELSHEET_INSECURE", new Object[0]);
                            }
                            if (!Utilities.isAbsoluteUrlLinkable((String)url)) {
                                this.warning(errors, "2022-12-09", ValidationMessage.IssueType.BUSINESSRULE, urlE.line(), urlE.col(), urlStack.getLiteralPath(), false, "BUNDLE_LINK_STYELSHEET_LINKABLE", new Object[0]);
                            }
                        }
                    } else {
                        boolean found = false;
                        for (Element e : entries) {
                            Element res = e.getNamedChild("resource", false);
                            if (res == null || !(res.fhirType() + "/" + res.getIdBase()).equals(url)) continue;
                            found = true;
                            break;
                        }
                        ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.NOTFOUND, urlE.line(), urlE.col(), urlStack.getLiteralPath(), found, "BUNDLE_LINK_STYELSHEET_NOT_FOUND", new Object[0]) && ok;
                    }
                }
            }
        }
        return ok;
    }

    private boolean validateMessageLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack, List<Element> entries) {
        boolean ok = true;
        Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean validateSearchLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack) {
        String rel = StringUtils.defaultString((String)link.getNamedChildValue("relation", false));
        if (Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last", "self"})) {
            return this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, link.line(), link.col(), stack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel);
        }
        return true;
    }

    private boolean relationshipUnique(String rel, Element link, List<Element> links) {
        for (Element l : links) {
            if (l != link && rel.equals(l.getNamedChildValue("relation", false))) {
                return false;
            }
            if (l != link) continue;
            return true;
        }
        return true;
    }

    private boolean validateCollectionLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack) {
        boolean ok = true;
        Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean validateSubscriptionLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack) {
        boolean ok = true;
        Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean validateTransactionOrBatchLink(List<ValidationMessage> errors, Element bundle, List<Element> links, Element link, NodeStack stack) {
        boolean ok = true;
        Element relE = link.getNamedChild("relation", false);
        if (relE != null) {
            NodeStack relStack = stack.push(relE, -1, null, null);
            String rel = relE.getValue();
            ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), !Utilities.existsInList((String)rel, (String[])new String[]{"first", "previous", "next", "last"}), "BUNDLE_LINK_SEARCH_PROHIBITED", rel);
            if ("self".equals(rel)) {
                ok = this.rule(errors, "2022-12-09", ValidationMessage.IssueType.INVALID, relE.line(), relE.col(), relStack.getLiteralPath(), this.relationshipUnique(rel, link, links), "BUNDLE_LINK_SEARCH_NO_DUPLICATES", rel) && ok;
            }
        }
        return ok;
    }

    private boolean checkSearchSet(List<ValidationMessage> errors, Element bundle, List<Element> entries, NodeStack stack) {
        boolean ok = true;
        ArrayList<Element> links = new ArrayList<Element>();
        bundle.getNamedChildren("link", links);
        Element selfLink = this.getSelfLink(links);
        ArrayList<String> types = new ArrayList<String>();
        if (selfLink == null) {
            this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), false, "BUNDLE_SEARCH_NOSELF", new Object[0]);
        } else {
            this.readSearchResourceTypes(selfLink.getNamedChildValue("url", false), types);
            if (types.size() == 0) {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), false, "BUNDLE_SEARCH_SELF_NOT_UNDERSTOOD");
            }
        }
        Boolean searchMode = this.readHasSearchMode(entries);
        if (searchMode != null && !searchMode.booleanValue()) {
            boolean typeProblem = false;
            String rtype = null;
            int count = 0;
            for (Element entry : entries) {
                NodeStack estack = stack.push(entry, count, null, null);
                ++count;
                Element res = entry.getNamedChild("resource", false);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), res != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE", new Object[0])) {
                    String id;
                    NodeStack rstack = estack.push(res, -1, null, null);
                    String rt = res.fhirType();
                    Boolean bok = this.checkSearchType(types, rt);
                    if (bok == null) {
                        typeProblem = true;
                        this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), selfLink == null, "BUNDLE_SEARCH_ENTRY_TYPE_NOT_SURE");
                        id = res.getNamedChildValue("id", false);
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null || "OperationOutcome".equals(rt), "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]);
                        continue;
                    }
                    if (bok.booleanValue()) {
                        if ("OperationOutcome".equals(rt)) continue;
                        id = res.getNamedChildValue("id", false);
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]);
                        if (rtype != null && !rt.equals(rtype)) {
                            typeProblem = true;
                            continue;
                        }
                        if (rtype != null) continue;
                        rtype = rt;
                        continue;
                    }
                    typeProblem = true;
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), false, "BUNDLE_SEARCH_ENTRY_WRONG_RESOURCE_TYPE_NO_MODE", rt, types);
                    continue;
                }
                ok = false;
            }
            if (typeProblem) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), !typeProblem, "BUNDLE_SEARCH_NO_MODE", new Object[0]);
            } else {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), stack.getLiteralPath(), !typeProblem, "BUNDLE_SEARCH_NO_MODE");
            }
        } else {
            int count = 0;
            for (Element entry : entries) {
                NodeStack estack = stack.push(entry, count, null, null);
                ++count;
                Element res = entry.getNamedChild("resource", false);
                String sm = null;
                Element s = entry.getNamedChild("search", false);
                if (s != null) {
                    sm = s.getNamedChildValue("mode", false);
                }
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), sm != null, "BUNDLE_SEARCH_NO_MODE", new Object[0]);
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), estack.getLiteralPath(), res != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE", new Object[0])) {
                    NodeStack rstack = estack.push(res, -1, null, null);
                    String rt = res.fhirType();
                    String id = res.getNamedChildValue("id", false);
                    if (sm == null) continue;
                    if ("match".equals(sm)) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]) && ok;
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), types.size() == 0 || this.checkSearchType(types, rt) != false, "BUNDLE_SEARCH_ENTRY_WRONG_RESOURCE_TYPE_MODE", rt, types) && ok;
                        continue;
                    }
                    if ("include".equals(sm)) {
                        ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), id != null, "BUNDLE_SEARCH_ENTRY_NO_RESOURCE_ID", new Object[0]) && ok;
                        continue;
                    }
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, bundle.line(), bundle.col(), rstack.getLiteralPath(), "OperationOutcome".equals(rt), "BUNDLE_SEARCH_ENTRY_WRONG_RESOURCE_TYPE_OUTCOME", rt) && ok;
                    continue;
                }
                ok = false;
            }
        }
        return ok;
    }

    private Boolean checkSearchType(List<String> types, String rt) {
        if (types.size() == 0) {
            return null;
        }
        return Utilities.existsInList((String)rt, types);
    }

    private Boolean readHasSearchMode(List<Element> entries) {
        boolean all = true;
        boolean any = false;
        for (Element entry : entries) {
            String sm = null;
            Element s = entry.getNamedChild("search", false);
            if (s != null) {
                sm = s.getNamedChildValue("mode", false);
            }
            if (sm != null) {
                any = true;
                continue;
            }
            all = false;
        }
        if (all) {
            return true;
        }
        if (any) {
            return null;
        }
        return false;
    }

    private void readSearchResourceTypes(String ref, List<String> types) {
        if (ref == null) {
            return;
        }
        String[] head = null;
        String[] tail = null;
        if (ref.contains("?")) {
            head = ref.substring(0, ref.indexOf("?")).split("\\/");
            tail = ref.substring(ref.indexOf("?") + 1).split("\\&");
        } else {
            head = ref.split("\\/");
        }
        if (head == null || head.length == 0) {
            return;
        }
        if (this.context.getResourceNames().contains(head[head.length - 1])) {
            types.add(head[head.length - 1]);
        } else if (tail != null) {
            for (String s : tail) {
                if (!s.startsWith("_type=")) continue;
                for (String t : s.substring(6).split("\\,")) {
                    types.add(t);
                }
            }
        }
    }

    private Element getSelfLink(List<Element> links) {
        for (Element link : links) {
            if (!"self".equals(link.getNamedChildValue("relation", false))) continue;
            return link;
        }
        return null;
    }

    private boolean validateDocument(List<ValidationMessage> errors, Element bundle, List<Element> entries, Element composition, NodeStack stack, String fullUrl, String id) {
        boolean ok = true;
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, composition.line(), composition.col(), stack.getLiteralPath(), composition.getType().equals("Composition"), "Bundle_BUNDLE_Entry_Document", new Object[0])) {
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, false, "subject", "Composition") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, true, "author", "Composition") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, false, "encounter", "Composition") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, composition, stack, fullUrl, id, false, "custodian", "Composition") && ok;
            ok = this.validateDocumentSubReference(errors, bundle, entries, composition, stack, fullUrl, id, "Composition", "attester", false, "party") && ok;
            ok = this.validateDocumentSubReference(errors, bundle, entries, composition, stack, fullUrl, id, "Composition", "event", true, "detail") && ok;
            ok = this.validateSections(errors, bundle, entries, composition, stack, fullUrl, id) && ok;
        } else {
            ok = false;
        }
        return ok;
    }

    private boolean validateSections(List<ValidationMessage> errors, Element bundle, List<Element> entries, Element focus, NodeStack stack, String fullUrl, String id) {
        boolean ok = true;
        ArrayList sections = new ArrayList();
        focus.getNamedChildren("section", sections);
        int i = 1;
        for (Element section : sections) {
            NodeStack localStack = stack.push(section, i, null, null);
            ok = this.validateDocumentReference(errors, bundle, entries, section, stack, fullUrl, id, true, "author", "Section") && ok;
            ok = this.validateDocumentReference(errors, bundle, entries, section, stack, fullUrl, id, false, "focus", "Section") && ok;
            ArrayList sectionEntries = new ArrayList();
            section.getNamedChildren("entry", sectionEntries);
            int j = 1;
            for (Element sectionEntry : sectionEntries) {
                NodeStack localStack2;
                ok = this.validateBundleReference(errors, bundle, entries, sectionEntry, "Section Entry", localStack2 = localStack.push(sectionEntry, j, null, null), fullUrl, "Composition", id) && ok;
                ++j;
            }
            ok = this.validateSections(errors, bundle, entries, section, localStack, fullUrl, id) && ok;
            ++i;
        }
        return ok;
    }

    public boolean validateDocumentSubReference(List<ValidationMessage> errors, Element bundle, List<Element> entries, Element composition, NodeStack stack, String fullUrl, String id, String title, String parent, boolean repeats, String propName) {
        boolean ok = true;
        ArrayList list = new ArrayList();
        composition.getNamedChildren(parent, list);
        int i = 1;
        for (Element elem : list) {
            ok = this.validateDocumentReference(errors, bundle, entries, elem, stack.push(elem, i, null, null), fullUrl, id, repeats, propName, title + "." + parent) && ok;
            ++i;
        }
        return ok;
    }

    public boolean validateDocumentReference(List<ValidationMessage> errors, Element bundle, List<Element> entries, Element composition, NodeStack stack, String fullUrl, String id, boolean repeats, String propName, String title) {
        boolean ok = true;
        ArrayList list = new ArrayList();
        composition.getNamedChildren(propName, list);
        if (repeats) {
            int i = 1;
            for (Element elem : list) {
                ok = this.validateBundleReference(errors, bundle, entries, elem, title + "." + propName, stack.push(elem, i, null, null), fullUrl, "Composition", id) && ok;
                ++i;
            }
        } else if (list.size() > 0) {
            Element elem = (Element)list.get(0);
            ok = this.validateBundleReference(errors, bundle, entries, elem, title + "." + propName, stack.push(elem, -1, null, null), fullUrl, "Composition", id) && ok;
        }
        return ok;
    }

    private boolean validateMessage(List<ValidationMessage> errors, List<Element> entries, Element messageHeader, NodeStack stack, String fullUrl, String id) {
        boolean ok = true;
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, messageHeader.line(), messageHeader.col(), stack.getLiteralPath(), messageHeader.getType().equals("MessageHeader"), "Validation_BUNDLE_Message", new Object[0])) {
            List elements = messageHeader.getChildren("focus");
            for (Element elem : elements) {
                ok = this.validateBundleReference(errors, messageHeader, entries, elem, "MessageHeader Data", stack.push(elem, -1, null, null), fullUrl, "MessageHeader", id) && ok;
            }
        }
        return ok;
    }

    private boolean validateBundleReference(List<ValidationMessage> errors, Element bundle, List<Element> entries, Element ref, String name, NodeStack stack, String fullUrl, String type, String id) {
        Element target;
        String reference = null;
        try {
            reference = ref.getNamedChildValue("reference", false);
        }
        catch (Error error) {
            // empty catch block
        }
        return ref == null || Utilities.noString((String)reference) || reference.startsWith("#") || (target = this.resolveInBundle(bundle, entries, reference, fullUrl, type, id, stack, errors, name, ref, false, false)) != null;
    }

    private boolean handleSpecialCaseForLastUpdated(Element bundle, List<ValidationMessage> errors, NodeStack stack) {
        boolean ok = bundle.hasChild("meta", false) && bundle.getNamedChild("meta", false).hasChild("lastUpdated", false) && bundle.getNamedChild("meta", false).getNamedChild("lastUpdated", false).hasValue();
        this.ruleHtml(errors, NO_RULE_DATE, ValidationMessage.IssueType.REQUIRED, stack.getLiteralPath(), ok, "Bundle_Document_Date_Missing", "Bundle_Document_Date_Missing_html");
        return ok;
    }

    private boolean checkAllInterlinked(List<ValidationMessage> errors, List<Element> entries, NodeStack stack, Element bundle, boolean isMessage) {
        boolean foundRevLinks;
        boolean ok = true;
        ArrayList<EntrySummary> entryList = new ArrayList<EntrySummary>();
        int i = 0;
        for (Element entry : entries) {
            Element r = entry.getNamedChild("resource", false);
            if (r != null) {
                EntrySummary entrySummary = new EntrySummary(i, entry, r);
                entryList.add(entrySummary);
            }
            ++i;
        }
        for (EntrySummary e : entryList) {
            List<StringWithSource> references = this.findReferences(e.getEntry());
            for (StringWithSource ref : references) {
                EntrySummary t;
                Element tgt;
                String string = ref.getReference();
                String string2 = e.getEntry().getChildValue("fullUrl");
                String string3 = e.getResource().fhirType();
                String string4 = e.getResource().getIdBase();
                String string5 = ref.getSource().getPath();
                Element element = ref.getSource();
                if (!ref.isWarning()) {
                    // empty if block
                }
                if ((tgt = this.resolveInBundle(bundle, entries, string, string2, string3, string4, stack, errors, string5, element, true, ref.isNlLink())) == null || (t = this.entryForTarget(entryList, tgt)) == null || t == e) continue;
                e.getTargets().add(t);
            }
        }
        HashSet<EntrySummary> visited = new HashSet<EntrySummary>();
        if (entryList.size() > 0) {
            this.visitLinked(visited, (EntrySummary)entryList.get(0));
        }
        this.visitBundleLinks(visited, entryList, bundle);
        do {
            foundRevLinks = false;
            for (EntrySummary entrySummary : entryList) {
                if (visited.contains(entrySummary)) continue;
                boolean add = false;
                for (EntrySummary t : entrySummary.getTargets()) {
                    if (!visited.contains(t)) continue;
                    add = true;
                }
                if (!add) continue;
                if (isMessage) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entrySummary.getEntry().line(), entrySummary.getEntry().col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), this.isExpectedToBeReverse(entrySummary.getResource().fhirType()), "BUNDLE_BUNDLE_ENTRY_REVERSE_MSG", entrySummary.getEntry().getChildValue("fullUrl") != null ? "'" + entrySummary.getEntry().getChildValue("fullUrl") + "'" : "");
                } else if (VersionUtilities.isR5VerOrLater((String)this.context.getVersion())) {
                    this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entrySummary.getEntry().line(), entrySummary.getEntry().col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), this.isExpectedToBeReverse(entrySummary.getResource().fhirType()), "BUNDLE_BUNDLE_ENTRY_REVERSE_R5", entrySummary.getEntry().getChildValue("fullUrl") != null ? "'" + entrySummary.getEntry().getChildValue("fullUrl") + "'" : "");
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entrySummary.getEntry().line(), entrySummary.getEntry().col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), this.isExpectedToBeReverse(entrySummary.getResource().fhirType()), "BUNDLE_BUNDLE_ENTRY_REVERSE_R4", entrySummary.getEntry().getChildValue("fullUrl") != null ? "'" + entrySummary.getEntry().getChildValue("fullUrl") + "'" : "");
                }
                foundRevLinks = true;
                this.visitLinked(visited, entrySummary);
            }
        } while (foundRevLinks);
        i = 0;
        for (EntrySummary entrySummary : entryList) {
            Element entry = entrySummary.getEntry();
            if (isMessage) {
                this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), visited.contains(entrySummary), "Bundle_BUNDLE_Entry_Orphan_MESSAGE", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "");
            } else {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INFORMATIONAL, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + (i + 1) + "]"), visited.contains(entrySummary), "Bundle_BUNDLE_Entry_Orphan_DOCUMENT", entry.getChildValue("fullUrl") != null ? "'" + entry.getChildValue("fullUrl") + "'" : "") && ok;
            }
            ++i;
        }
        return ok;
    }

    private void visitBundleLinks(Set<EntrySummary> visited, List<EntrySummary> entryList, Element bundle) {
        List links = bundle.getChildrenByName("link");
        block0: for (Element link : links) {
            String rel = link.getNamedChildValue("relation", false);
            String url = link.getNamedChildValue("url", false);
            if (rel == null || url == null || !Utilities.existsInList((String)rel, (String[])new String[]{"stylesheet"})) continue;
            for (EntrySummary e : entryList) {
                if (e.getResource() == null || !url.equals(e.getResource().fhirType() + "/" + e.getResource().getIdBase())) continue;
                visited.add(e);
                continue block0;
            }
        }
    }

    private boolean isExpectedToBeReverse(String fhirType) {
        return Utilities.existsInList((String)fhirType, (String[])new String[]{"Provenance"});
    }

    private String getCanonicalURLForEntry(Element entry) {
        Element e = entry.getNamedChild("resource", false);
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("url", false);
    }

    private String getIdForEntry(Element entry) {
        Element e = entry.getNamedChild("resource", false);
        if (e == null) {
            return null;
        }
        return e.getNamedChildValue("id", false);
    }

    private String getTypeForEntry(Element entry) {
        Element e = entry.getNamedChild("resource", false);
        if (e == null) {
            return null;
        }
        return e.fhirType();
    }

    private void validateResourceIds(List<ValidationMessage> errors, List<Element> entries, NodeStack stack) {
        int i = 1;
        for (Element entry : entries) {
            String id;
            String fullUrl = entry.getNamedChildValue("fullUrl", false);
            Element resource = entry.getNamedChild("resource", false);
            String string = id = resource != null ? resource.getNamedChildValue("id", false) : null;
            if (id != null && fullUrl != null) {
                String urlId = null;
                if (fullUrl.startsWith("https://") || fullUrl.startsWith("http://")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(47) + 1);
                } else if (fullUrl.startsWith("urn:uuid") || fullUrl.startsWith("urn:oid")) {
                    urlId = fullUrl.substring(fullUrl.lastIndexOf(58) + 1);
                }
                this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.INVALID, entry.line(), entry.col(), stack.addToLiteralPath("entry[" + i + "]"), urlId.equals(id), "Bundle_BUNDLE_Entry_IdUrlMismatch", id, fullUrl);
            }
            ++i;
        }
    }

    private EntrySummary entryForTarget(List<EntrySummary> entryList, Element tgt) {
        for (EntrySummary e : entryList) {
            if (e.getEntry() != tgt) continue;
            return e;
        }
        return null;
    }

    private void visitLinked(Set<EntrySummary> visited, EntrySummary t) {
        if (!visited.contains(t)) {
            visited.add(t);
            for (EntrySummary e : t.getTargets()) {
                this.visitLinked(visited, e);
            }
        }
    }

    private List<StringWithSource> findReferences(Element start) {
        ArrayList<StringWithSource> references = new ArrayList<StringWithSource>();
        this.findReferences(start, references);
        return references;
    }

    private void findReferences(Element start, List<StringWithSource> references) {
        for (Element child : start.getChildren()) {
            String ref;
            if (child.getType().equals("Reference") && (ref = child.getChildValue("reference")) != null && !ref.startsWith("#") && !this.hasReference(ref, references)) {
                references.add(new StringWithSource(ref, child, false, false));
            }
            if (!(!Utilities.existsInList((String)child.getType(), (String[])new String[]{"url", "uri"}) || Utilities.existsInList((String)child.getName(), (String[])new String[]{"system"}) || Utilities.existsInList((String)child.getProperty().getDefinition().getPath(), (String[])new String[]{"Bundle.entry.fullUrl", "Coding.system", "Identifier.system", "Meta.profile", "Extension.url", "Quantity.system", "MessageHeader.source.endpoint", "MessageHeader.destination.endpoint", "Endpoint.address"}) || (ref = child.primitiveValue()) == null || ref.startsWith("#") || this.hasReference(ref, references))) {
                references.add(new StringWithSource(ref, child, true, this.isNLLink(start)));
            }
            this.findReferences(child, references);
        }
    }

    private boolean isNLLink(Element parent) {
        return parent != null && "extension".equals(parent.getName()) && "http://hl7.org/fhir/StructureDefinition/narrativeLink".equals(parent.getNamedChildValue("url", false));
    }

    private boolean hasReference(String ref, List<StringWithSource> references) {
        for (StringWithSource t : references) {
            if (!ref.equals(t.getReference())) continue;
            return true;
        }
        return false;
    }

    private boolean isV3orV2Url(String url) {
        return url.startsWith("http://hl7.org/fhir/v3/") || url.startsWith("http://hl7.org/fhir/v2/");
    }

    public boolean meetsRule(BundleValidationRule bvr, String rtype, int rcount, int count) {
        String index;
        String t;
        if (bvr.getRule() == null) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_NONE", new Object[0]));
        }
        String rule = bvr.getRule();
        String string = rule.contains(":") ? rule.substring(0, rule.indexOf(":")) : (t = Utilities.isInteger((String)rule) ? null : rule);
        String string2 = rule.contains(":") ? rule.substring(rule.indexOf(":") + 1) : (index = Utilities.isInteger((String)rule) ? rule : null);
        if (Utilities.noString((String)t) && Utilities.noString((String)index)) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_NONE", new Object[0]));
        }
        if (!Utilities.noString((String)t) && !this.context.getResourceNames().contains(t)) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_UNKNOWN", new Object[]{t}));
        }
        if (!Utilities.noString((String)index) && !Utilities.isInteger((String)index)) {
            throw new Error(this.context.formatMessage("BUNDLE_RULE_INVALID_INDEX", new Object[]{index}));
        }
        if (t == null) {
            return Integer.toString(count).equals(index);
        }
        if (index == null) {
            return t.equals(rtype);
        }
        return t.equals(rtype) && Integer.toString(rcount).equals(index);
    }

    public class StringWithSource {
        private String reference;
        private Element source;
        private boolean warning;
        private boolean nlLink;

        public StringWithSource(String reference, Element source, boolean warning, boolean nlLink) {
            this.reference = reference;
            this.source = source;
            this.warning = warning;
            this.nlLink = nlLink;
        }

        public String getReference() {
            return this.reference;
        }

        public Element getSource() {
            return this.source;
        }

        public boolean isWarning() {
            return this.warning;
        }

        public boolean isNlLink() {
            return this.nlLink;
        }
    }
}

