/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.services;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.annotation.Nonnull;
import org.hl7.fhir.convertors.txClient.TerminologyClientFactory;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.context.IWorkerContextManager;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.model.CanonicalResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.terminologies.client.ITerminologyClient;
import org.hl7.fhir.r5.utils.validation.IResourceValidator;
import org.hl7.fhir.r5.utils.validation.IValidationPolicyAdvisor;
import org.hl7.fhir.r5.utils.validation.IValidatorResourceFetcher;
import org.hl7.fhir.r5.utils.validation.constants.BindingKind;
import org.hl7.fhir.r5.utils.validation.constants.CodedContentValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ContainedReferenceValidationPolicy;
import org.hl7.fhir.r5.utils.validation.constants.ReferenceValidationPolicy;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.json.model.JsonObject;
import org.hl7.fhir.utilities.json.parser.JsonParser;
import org.hl7.fhir.utilities.npm.FilesystemPackageCacheManager;
import org.hl7.fhir.utilities.npm.NpmPackage;
import org.hl7.fhir.validation.cli.services.IPackageInstaller;
import org.hl7.fhir.validation.cli.utils.Common;

public class StandAloneValidatorFetcher
implements IValidatorResourceFetcher,
IValidationPolicyAdvisor,
IWorkerContextManager.ICanonicalResourceLocator {
    List<String> mappingsUris = new ArrayList<String>();
    private FilesystemPackageCacheManager pcm;
    private IWorkerContext context;
    private IPackageInstaller installer;
    private Map<String, Boolean> urlList = new HashMap<String, Boolean>();
    private Map<String, String> pidList = new HashMap<String, String>();
    private Map<String, NpmPackage> pidMap = new HashMap<String, NpmPackage>();

    public StandAloneValidatorFetcher(FilesystemPackageCacheManager pcm, IWorkerContext context, IPackageInstaller installer) {
        this.pcm = pcm;
        this.context = context;
        this.installer = installer;
    }

    public Element fetch(IResourceValidator validator, Object appContext, String url) throws FHIRException {
        throw new FHIRException("The URL '" + url + "' is not known to the FHIR validator, and has not been provided as part of the setup / parameters");
    }

    public ReferenceValidationPolicy policyForReference(IResourceValidator validator, Object appContext, String path, String url) {
        return ReferenceValidationPolicy.CHECK_TYPE_IF_EXISTS;
    }

    public ContainedReferenceValidationPolicy policyForContained(IResourceValidator validator, Object appContext, String containerType, String containerId, Element.SpecialElement containingResourceType, String path, String url) {
        return ContainedReferenceValidationPolicy.CHECK_VALID;
    }

    public boolean resolveURL(IResourceValidator validator, Object appContext, String path, String url, String type, boolean canonical) throws IOException, FHIRException {
        VersionUtilities.VersionURLInfo vu;
        if (!Utilities.isAbsoluteUrl((String)url)) {
            return false;
        }
        if (url.contains("|")) {
            url = url.substring(0, url.lastIndexOf("|"));
        }
        if (type != null && type.equals("uri") && this.isMappingUri(url)) {
            return true;
        }
        String pid = null;
        String ver = null;
        String base = this.findBaseUrl(url);
        if (base == null) {
            return !url.startsWith("http://hl7.org/fhir") && !type.equals("canonical");
        }
        if (this.urlList.containsKey(url)) {
            return this.urlList.get(url);
        }
        if (base.equals("http://terminology.hl7.org")) {
            pid = "hl7.terminology";
        } else {
            if (base.equals("http://hl7.org/fhir")) {
                return false;
            }
            if (url.startsWith("http://hl7.org/fhir")) {
                pid = this.pcm.getPackageId(base);
            } else if (this.pidList.containsKey(base)) {
                pid = this.pidList.get(base);
            } else {
                pid = this.pcm.findCanonicalInLocalCache(base);
                this.pidList.put(base, pid);
            }
        }
        String string = ver = url.contains("|") ? url.substring(url.indexOf("|") + 1) : null;
        if (pid == null && Utilities.startsWithInList((String)url, (String[])new String[]{"http://hl7.org/fhir", "http://terminology.hl7.org"})) {
            this.urlList.put(url, false);
            return false;
        }
        if (url.startsWith("http://hl7.org/fhir") && (vu = VersionUtilities.parseVersionUrl((String)url)) != null) {
            NpmPackage pi = this.pcm.loadPackage(VersionUtilities.packageForVersion((String)vu.getVersion()), VersionUtilities.getCurrentVersion((String)vu.getVersion()));
            boolean res = pi.hasCanonical(vu.getUrl());
            this.urlList.put(url, res);
            return res;
        }
        if (pid != null) {
            if ("sharedhealth.fhir.ca.common".equals(pid)) {
                return false;
            }
            NpmPackage pi = null;
            if (this.pidMap.containsKey(pid + "|" + ver)) {
                pi = this.pidMap.get(pid + "|" + ver);
            } else if (this.installer.packageExists(pid, ver)) {
                try {
                    this.installer.loadPackage(pid, ver);
                    pi = this.pcm.loadPackage(pid);
                    this.pidMap.put(pid + "|" + ver, pi);
                }
                catch (Exception e) {
                    this.pidMap.put(pid + "|" + ver, null);
                }
            } else {
                this.pidMap.put(pid + "|" + ver, null);
            }
            if (pi != null) {
                this.context.loadFromPackage(pi, null);
                return pi.hasCanonical(url) || this.context.fetchResource(Resource.class, url) != null;
            }
        }
        return !url.startsWith("http://hl7.org/fhir") && !type.equals("canonical");
    }

    private boolean isMappingUri(String url) {
        if (this.mappingsUris.isEmpty()) {
            try {
                JsonObject json = JsonParser.parseObjectFromUrl((String)"http://hl7.org/fhir/mappingspaces.json");
                for (JsonObject ms : json.getJsonObjects("spaces")) {
                    this.mappingsUris.add(ms.asString("url"));
                }
            }
            catch (IOException e) {
                this.mappingsUris.add("http://hl7.org/fhir/fivews");
                this.mappingsUris.add("http://hl7.org/fhir/workflow");
                this.mappingsUris.add("http://hl7.org/fhir/interface");
                this.mappingsUris.add("http://hl7.org/v2");
                this.mappingsUris.add("http://loinc.org");
                this.mappingsUris.add("http://snomed.org/attributebinding");
                this.mappingsUris.add("http://snomed.info/conceptdomain");
                this.mappingsUris.add("http://hl7.org/v3/cda");
                this.mappingsUris.add("http://hl7.org/v3");
                this.mappingsUris.add("http://nema.org/dicom");
                this.mappingsUris.add("http://w3.org/vcard");
                this.mappingsUris.add("http://ihe.net/xds");
                this.mappingsUris.add("http://www.w3.org/ns/prov");
                this.mappingsUris.add("http://ietf.org/rfc/2445");
                this.mappingsUris.add("http://www.omg.org/spec/ServD/1.0/");
                this.mappingsUris.add("http://metadata-standards.org/11179/");
                this.mappingsUris.add("http://ihe.net/data-element-exchange");
                this.mappingsUris.add("http://openehr.org");
                this.mappingsUris.add("http://siframework.org/ihe-sdc-profile");
                this.mappingsUris.add("http://siframework.org/cqf");
                this.mappingsUris.add("http://www.cdisc.org/define-xml");
                this.mappingsUris.add("http://www.cda-adc.ca/en/services/cdanet/");
                this.mappingsUris.add("http://www.pharmacists.ca/");
                this.mappingsUris.add("http://www.healthit.gov/quality-data-model");
                this.mappingsUris.add("http://hl7.org/orim");
                this.mappingsUris.add("http://hl7.org/fhir/w5");
                this.mappingsUris.add("http://hl7.org/fhir/logical");
                this.mappingsUris.add("http://hl7.org/fhir/auditevent");
                this.mappingsUris.add("http://hl7.org/fhir/provenance");
                this.mappingsUris.add("http://hl7.org/qidam");
                this.mappingsUris.add("http://cap.org/ecc");
                this.mappingsUris.add("http://fda.gov/UDI");
                this.mappingsUris.add("http://hl7.org/fhir/object-implementation");
                this.mappingsUris.add("http://github.com/MDMI/ReferentIndexContent");
                this.mappingsUris.add("http://ncpdp.org/SCRIPT10_6");
                this.mappingsUris.add("http://clinicaltrials.gov");
                this.mappingsUris.add("http://hl7.org/fhir/rr");
                this.mappingsUris.add("http://www.hl7.org/v3/PORX_RM020070UV");
                this.mappingsUris.add("https://bridgmodel.nci.nih.gov");
                this.mappingsUris.add("http://hl7.org/fhir/composition");
                this.mappingsUris.add("http://hl7.org/fhir/documentreference");
                this.mappingsUris.add("https://en.wikipedia.org/wiki/Identification_of_medicinal_products");
                this.mappingsUris.add("urn:iso:std:iso:11073:10201");
                this.mappingsUris.add("urn:iso:std:iso:11073:10207");
            }
        }
        return this.mappingsUris.contains(url);
    }

    private String findBaseUrl(String url) {
        String[] p = url.split("\\/");
        for (int i = 1; i < p.length; ++i) {
            if (!Utilities.existsInList((String)p[i], (List)this.context.getResourceNames())) continue;
            StringBuilder b = new StringBuilder(p[0]);
            for (int j = 1; j < i; ++j) {
                b.append("/");
                b.append(p[j]);
            }
            return b.toString();
        }
        return null;
    }

    public byte[] fetchRaw(IResourceValidator validator, String url) throws MalformedURLException, IOException {
        throw new FHIRException("The URL '" + url + "' is not known to the FHIR validator, and has not been provided as part of the setup / parameters");
    }

    public IValidatorResourceFetcher setLocale(Locale locale) {
        return null;
    }

    public CanonicalResource fetchCanonicalResource(IResourceValidator validator, String url) throws URISyntaxException {
        String[] p;
        String root;
        if (url.contains("|")) {
            url = url.substring(0, url.indexOf("|"));
        }
        if ((root = this.getRoot(p = url.split("\\/"), url)) != null) {
            ITerminologyClient terminologyClient = this.getTerminologyClient(root);
            return terminologyClient.read(p[p.length - 2], p[p.length - 1]);
        }
        throw new FHIRException("The URL '" + url + "' is not known to the FHIR validator, and has not been provided as part of the setup / parameters");
    }

    @Nonnull
    protected ITerminologyClient getTerminologyClient(String root) throws URISyntaxException {
        return TerminologyClientFactory.makeClient((String)"source", (String)root, (String)Common.getValidatorUserAgent(), (String)this.context.getVersion());
    }

    private String getRoot(String[] p, String url) {
        if (p.length > 3 && Utilities.isValidId((String)p[p.length - 1]) && this.context.getResourceNames().contains(p[p.length - 2])) {
            url = url.substring(0, url.lastIndexOf("/"));
            return url.substring(0, url.lastIndexOf("/"));
        }
        return null;
    }

    public boolean fetchesCanonicalResource(IResourceValidator validator, String url) {
        return true;
    }

    public void findResource(Object validator, String url) {
        try {
            this.resolveURL((IResourceValidator)validator, null, null, url, null, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public CodedContentValidationPolicy policyForCodedContent(IResourceValidator validator, Object appContext, String stackPath, ElementDefinition definition, StructureDefinition structure, BindingKind kind, ValueSet valueSet, List<String> systems) {
        return CodedContentValidationPolicy.VALUESET;
    }
}

