/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.profile;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.model.CanonicalType;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;

public class ProfileValidator
extends BaseValidator {
    private boolean checkAggregation = false;
    private boolean checkMustSupport = false;
    private FHIRPathEngine fpe;

    public ProfileValidator(IWorkerContext context, XVerExtensionManager xverManager) {
        super(context, xverManager);
        this.fpe = new FHIRPathEngine(context);
    }

    public boolean isCheckAggregation() {
        return this.checkAggregation;
    }

    public boolean isCheckMustSupport() {
        return this.checkMustSupport;
    }

    public void setCheckAggregation(boolean checkAggregation) {
        this.checkAggregation = checkAggregation;
    }

    public void setCheckMustSupport(boolean checkMustSupport) {
        this.checkMustSupport = checkMustSupport;
    }

    protected boolean rule(List<ValidationMessage> errors, ValidationMessage.IssueType type, String path, boolean b, String msg) {
        String rn = path.contains(".") ? path.substring(0, path.indexOf(".")) : path;
        return super.ruleHtml(errors, NO_RULE_DATE, type, path, b, msg, "<a href=\"" + rn.toLowerCase() + ".html\">" + rn + "</a>: " + Utilities.escapeXml((String)msg));
    }

    public List<ValidationMessage> validate(StructureDefinition profile, boolean forBuild) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        String s = profile.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL ? "Logical Models" : "Profiles";
        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, profile.getUrl(), profile.hasFhirVersion(), s + " SHOULD state the FHIR Version on which they are based", new Object[0]);
        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, profile.getUrl(), profile.hasVersion(), s + " SHOULD state their own version", new Object[0]);
        for (ElementDefinition ec : profile.getDifferential().getElement()) {
            this.checkExtensions(profile, errors, "differential", ec);
        }
        this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "missing Snapshot at " + profile.getName() + "." + profile.getName(), new Object[0]);
        for (ElementDefinition ec : profile.getSnapshot().getElement()) {
            this.checkExtensions(profile, errors, "snapshot", ec);
        }
        if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.STRUCTURE, profile.getId(), profile.hasSnapshot(), "A snapshot is required", new Object[0])) {
            Hashtable<String, ElementDefinition> snapshotElements = new Hashtable<String, ElementDefinition>();
            for (ElementDefinition ed : profile.getSnapshot().getElement()) {
                snapshotElements.put(ed.getId(), ed);
                for (ElementDefinition.ElementDefinitionConstraintComponent inv : ed.getConstraint()) {
                    if (forBuild && this.inExemptList(inv.getKey())) continue;
                }
            }
            if (snapshotElements != null) {
                for (ElementDefinition diffElement : profile.getDifferential().getElement()) {
                    if (diffElement == null) {
                        throw new Error("Diff Element is null - this is not an expected thing");
                    }
                    ElementDefinition snapElement = (ElementDefinition)snapshotElements.get(diffElement.getId());
                    if (snapElement == null) continue;
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, diffElement.getId(), !this.checkMustSupport || snapElement.hasMustSupport(), "Elements included in the differential should declare mustSupport", new Object[0]);
                    if (!this.checkAggregation) continue;
                    for (ElementDefinition.TypeRefComponent type : snapElement.getType()) {
                        if (!"http://hl7.org/fhir/Reference".equals(type.getWorkingCode()) && !"http://hl7.org/fhir/canonical".equals(type.getWorkingCode())) continue;
                        this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, diffElement.getId(), type.hasAggregation(), "Elements with type Reference or canonical should declare aggregation", new Object[0]);
                    }
                }
            }
        }
        return errors;
    }

    private boolean inExemptList(String key) {
        return key.startsWith("txt-");
    }

    private void checkExtensions(StructureDefinition profile, List<ValidationMessage> errors, String kind, ElementDefinition ec) {
        if (!ec.getType().isEmpty() && "Extension".equals(((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getWorkingCode()) && ((ElementDefinition.TypeRefComponent)ec.getType().get(0)).hasProfile()) {
            String url = (String)((CanonicalType)((ElementDefinition.TypeRefComponent)ec.getType().get(0)).getProfile().get(0)).getValue();
            StructureDefinition defn = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, url);
            if (defn == null) {
                defn = this.getXverExt(profile, errors, url);
            }
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, profile.getId(), defn != null, "Unable to find Extension '" + url + "' referenced at " + profile.getUrl() + " " + kind + " " + ec.getPath() + " (" + ec.getSliceName() + ")", new Object[0]);
        }
    }
}

