/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.profile.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Base;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Extension;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.ToolingExtensions;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class StructureDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;
    private boolean wantCheckSnapshotUnchanged;

    public StructureDefinitionValidator(IWorkerContext context, boolean debug, TimeTracker timeTracker, FHIRPathEngine fpe, boolean wantCheckSnapshotUnchanged, XVerExtensionManager xverManager, Coding jurisdiction, boolean forPublication) {
        super(context, xverManager, debug);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
        this.wantCheckSnapshotUnchanged = wantCheckSnapshotUnchanged;
        this.jurisdiction = jurisdiction;
        this.forPublication = forPublication;
    }

    public boolean validateStructureDefinition(List<ValidationMessage> errors, Element src, NodeStack stack) {
        boolean ok = true;
        StructureDefinition sd = null;
        String typeName = null;
        try {
            Element ext;
            Element value;
            sd = this.loadAsSD(src);
            this.checkExtensionContext(errors, src, stack);
            List snapshot = sd.getSnapshot().getElement();
            sd.setSnapshot(null);
            typeName = sd.getTypeName();
            StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "Unable_to_find_base__for_", sd.getBaseDefinition(), "StructureDefinition, so can't check the differential")) {
                if (this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasDerivation(), "SD_MUST_HAVE_DERIVATION", sd.getUrl())) {
                    boolean bok = base.getAbstract() || sd.hasKind() && sd.getKind() == base.getKind();
                    this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), bok, "SD_CONSTRAINED_KIND_NO_MATCH", sd.getKind().toCode(), base.getKind().toCode(), base.getType(), base.getUrl());
                    if (sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                        this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasType() && sd.getType().equals(base.getType()), "SD_CONSTRAINED_TYPE_NO_MATCH", sd.getType(), base.getType());
                        ArrayList msgs = new ArrayList();
                        ProfileUtilities pu = new ProfileUtilities(this.context, msgs, null);
                        pu.setForPublication(this.forPublication);
                        pu.setXver(this.xverManager);
                        pu.setNewSlicingProcessing(!sd.hasFhirVersion() || VersionUtilities.isR4Plus((String)sd.getFhirVersion().toCode()));
                        pu.generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir/R4/", sd.getName());
                        if (msgs.size() > 0) {
                            for (ValidationMessage msg : msgs) {
                                String loc = msg.getLocation();
                                if (loc.contains("#")) {
                                    msg.setLocation(stack.getLiteralPath() + ".differential.element.where(path = '" + loc.substring(loc.indexOf("#") + 1) + "')");
                                } else {
                                    msg.setLocation(stack.getLiteralPath());
                                }
                                errors.add(msg);
                                ok = false;
                            }
                        }
                        if (!snapshot.isEmpty() && this.wantCheckSnapshotUnchanged) {
                            int was = snapshot.size();
                            int is = sd.getSnapshot().getElement().size();
                            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), was == is, "SNAPSHOT_EXISTING_PROBLEM", was, is) && ok;
                        }
                    } else {
                        this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasType() && !sd.getType().equals(base.getType()), "SD_SPECIALIZED_TYPE_MATCHES", sd.getType(), base.getType());
                    }
                } else {
                    ok = false;
                }
                if ("constraint".equals(src.getChildValue("derivation"))) {
                    ok = this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base.getKindElement().primitiveValue().equals(src.getChildValue("kind")), "SD_DERIVATION_KIND_MISMATCH", base.getKindElement().primitiveValue(), src.getChildValue("kind")) && ok;
                }
            }
            List differentials = src.getChildrenByName("differential");
            List snapshots = src.getChildrenByName("snapshot");
            boolean logical = "logical".equals(src.getNamedChildValue("kind"));
            boolean constraint = "constraint".equals(src.getNamedChildValue("derivation"));
            for (Element differential : differentials) {
                ok = this.validateElementList(errors, differential, stack.push(differential, -1, null, null), false, snapshots.size() > 0, sd, typeName, logical, constraint, src.getNamedChildValue("type"), src.getNamedChildValue("url")) && ok;
            }
            for (Element snapshotE : snapshots) {
                ok = this.validateElementList(errors, snapshotE, stack.push(snapshotE, -1, null, null), true, true, sd, typeName, logical, constraint, src.getNamedChildValue("type"), src.getNamedChildValue("url")) && ok;
            }
            if (src.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/obligation-profile") && (value = (ext = src.getExtension("http://hl7.org/fhir/tools/StructureDefinition/obligation-profile")).getNamedChild("value")) != null && "true".equals(value.primitiveValue()) && this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), "constraint".equals(src.getNamedChildValue("derivation")), "SD_OBGLIGATION_PROFILE_DERIVATION", new Object[0]) && this.warning(errors, "2023-05-27", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "SD_OBGLIGATION_PROFILE_UKNOWN", src.getNamedChildValue("baseDefinition"))) {
                for (Element differential : differentials) {
                    ok = this.validateObligationProfile(errors, differential, stack.push(differential, -1, null, null), base) && ok;
                }
            }
            List extensions = src.getChildren("extension");
            int c = 0;
            for (Element extension : extensions) {
                if ("http://hl7.org/fhir/tools/StructureDefinition/inherit-obligations".equals(extension.getNamedChildValue("url"))) {
                    ok = this.validateInheritsObligationProfile(errors, extension, stack.push(extension, c, null, null), src) && ok;
                }
                ++c;
            }
        }
        catch (Exception e) {
            this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "ERROR_GENERATING_SNAPSHOT", e.getMessage());
            ok = false;
        }
        return ok;
    }

    private boolean validateInheritsObligationProfile(List<ValidationMessage> errors, Element extension, NodeStack stack, Element src) {
        String tgt = extension.getNamedChildValue("value");
        if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), tgt != null, "SD_OBGLIGATION_INHERITS_PROFILE_NO_TARGET", new Object[0])) {
            StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, tgt);
            if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), src != null, "SD_OBGLIGATION_INHERITS_PROFILE_TARGET_NOT_FOUND", tgt) && this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), ToolingExtensions.readBoolExtension((DomainResource)sd, (String)"http://hl7.org/fhir/tools/StructureDefinition/obligation-profile"), "SD_OBGLIGATION_INHERITS_PROFILE_NOT_RIGHT_TYPE", tgt)) {
                String base = src.getNamedChildValue("baseDefinition");
                if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), base != null && base.equals(sd.getBaseDefinition()), "SD_OBGLIGATION_INHERITS_PROFILE_NOT_RIGHT_BASE", tgt, sd.getBaseDefinition(), base)) {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean validateObligationProfile(List<ValidationMessage> errors, Element elementList, NodeStack stack, StructureDefinition base) {
        boolean ok = true;
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (Element element : elements) {
            ok = this.validateObligationProfileElement(errors, element, stack.push(element, cc, null, null), base) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean validateObligationProfileElement(List<ValidationMessage> errors, Element element, NodeStack push, StructureDefinition base) {
        String id = element.getNamedChildValue("id");
        ElementDefinition bd = base.getSnapshot().getElementById(id);
        if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, push.getLiteralPath(), bd != null, "SD_OBGLIGATION_PROFILE_UNMATCHED", id, base.getVersionedUrl())) {
            boolean ok = true;
            String name = null;
            int c = 0;
            for (Element child : element.getChildren()) {
                if (child.getName().equals(name)) {
                    ++c;
                } else {
                    name = child.getName();
                    c = 0;
                }
                NodeStack stack = push.push(child, c, null, null);
                if (child.getName().equals("extension")) {
                    String url = child.getNamedChildValue("url");
                    if ("http://hl7.org/fhir/tools/StructureDefinition/obligation".equals(url)) continue;
                    ok = false;
                    this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL", id, child.getName() + "#" + url);
                    continue;
                }
                if (child.getName().equals("mustSupport") || child.getName().equals("id")) continue;
                if (child.getName().equals("binding")) {
                    if (this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), bd.hasBinding(), "SD_OBGLIGATION_PROFILE_ILLEGAL_BINDING", id)) {
                        ok = this.validateObligationProfileElementBinding(errors, child, stack, id, bd) && ok;
                        continue;
                    }
                    ok = false;
                    continue;
                }
                if (child.getName().equals("path")) {
                    ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), child.primitiveValue().equals(bd.getPath()), "SD_OBGLIGATION_PROFILE_PATH_WRONG", id, child.primitiveValue(), bd.getPath()) && ok;
                    continue;
                }
                ok = false;
                this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL", id, child.getName());
            }
            return ok;
        }
        return false;
    }

    private boolean validateObligationProfileElementBinding(List<ValidationMessage> errors, Element element, NodeStack nstack, String id, ElementDefinition bd) {
        boolean ok = true;
        String name = null;
        int c = 0;
        for (Element child : element.getChildren()) {
            if (child.getName().equals(name)) {
                ++c;
            } else {
                name = child.getName();
                c = 0;
            }
            NodeStack stack = nstack.push(child, c, null, null);
            if (child.getName().equals("extension")) {
                String url = child.getNamedChildValue("url");
                if ("http://hl7.org/fhir/tools/StructureDefinition/additional-binding".equals(url) && !VersionUtilities.isR5Plus((String)this.context.getVersion())) {
                    Element purpose = child.getExtension("purpose");
                    if (purpose == null) continue;
                    String code = purpose.getNamedChildValue("value");
                    ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !Utilities.existsInList((String)code, (String[])new String[]{"maximum", "required", "extensible"}), "SD_OBGLIGATION_PROFILE_INVALID_BINDING_CODE", id, code) && ok;
                    continue;
                }
                ok = false;
                this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL", id, child.getName() + "#" + url);
                continue;
            }
            if (child.getName().equals("additional") && VersionUtilities.isR5Plus((String)this.context.getVersion())) {
                String code = child.getNamedChildValue("purpose");
                ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), !Utilities.existsInList((String)code, (String[])new String[]{"maximum", "required", "extensible"}), "SD_OBGLIGATION_PROFILE_INVALID_BINDING_CODE", id, code) && ok;
                continue;
            }
            if (child.getName().equals("strength")) {
                String strengthBase = bd.getBinding().getStrengthElement().asStringValue();
                String strengthDerived = child.primitiveValue();
                ok = this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), strengthBase != null && strengthBase.equals(strengthDerived), "SD_OBGLIGATION_PROFILE_INVALID_BINDING_STRENGTH", id, strengthDerived, strengthBase) && ok;
                continue;
            }
            ok = false;
            this.rule(errors, "2023-05-27", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_OBGLIGATION_PROFILE_ILLEGAL_ON_BINDING", id, child.getName());
        }
        return ok;
    }

    private void checkExtensionContext(List<ValidationMessage> errors, Element src, NodeStack stack) {
        NodeStack n;
        String type = src.getNamedChildValue("type");
        List eclist = src.getChildren("context");
        List cilist = src.getChildren("contextInvariant");
        int i = 0;
        for (Element ec : eclist) {
            n = stack.push(ec, i, null, null);
            if ("Extension".equals(type)) {
                String ct = null;
                String cv = null;
                if (VersionUtilities.isR4Plus((String)this.context.getVersion())) {
                    ct = ec.getNamedChildValue("type");
                    cv = ec.getNamedChildValue("expression");
                } else {
                    ct = src.getNamedChildValue("contextType");
                    cv = ec.primitiveValue();
                }
                if (!"element".equals(ct) || !"Element".equals(cv)) continue;
                this.warning(errors, "2023-04-23", ValidationMessage.IssueType.BUSINESSRULE, n.getLiteralPath(), false, "SD_CONTEXT_SHOULD_NOT_BE_ELEMENT", cv);
                continue;
            }
            this.rule(errors, "2023-04-23", ValidationMessage.IssueType.INVALID, n.getLiteralPath(), false, "SD_NO_CONTEXT_WHEN_NOT_EXTENSION", type);
        }
        i = 0;
        for (Element ci : cilist) {
            n = stack.push(ci, i, null, null);
            if ("Extension".equals(type)) continue;
            this.rule(errors, "2023-04-23", ValidationMessage.IssueType.INVALID, n.getLiteralPath(), false, "SD_NO_CONTEXT_INV_WHEN_NOT_EXTENSION", type);
        }
    }

    private boolean validateElementList(List<ValidationMessage> errors, Element elementList, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd, String typeName, boolean logical, boolean constraint, String rootPath, String profileUrl) {
        HashMap<String, String> invariantMap = new HashMap<String, String>();
        boolean ok = true;
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (Element element : elements) {
            ok = this.validateElementDefinition(errors, element, stack.push(element, cc, null, null), snapshot, hasSnapshot, sd, typeName, logical, constraint, invariantMap, rootPath, profileUrl) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean validateElementDefinition(List<ValidationMessage> errors, Element element, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd, String typeName, boolean logical, boolean constraint, Map<String, String> invariantMap, String rootPath, String profileUrl) {
        boolean ok = true;
        boolean typeMustSupport = false;
        String path = element.getNamedChildValue("path");
        this.rule(errors, "2022-11-02", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), typeName == null || path == null || path.equals(typeName) || path.startsWith(typeName + "."), "SD_PATH_TYPE_MISMATCH", typeName, path);
        if (!snapshot) {
            this.rule(errors, "2023-01-17", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), path.contains(".") || !element.hasChild("slicing"), "SD_NO_SLICING_ON_ROOT", path);
        }
        this.rule(errors, "2023-05-22", ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), snapshot || !constraint || !element.hasChild("meaningWhenMissing") || this.meaningWhenMissingAllowed(element), "SD_ELEMENT_NOT_IN_CONSTRAINT", "meaningWhenMissing", path);
        List types = element.getChildrenByName("type");
        HashSet<String> typeCodes = new HashSet<String>();
        HashSet<String> characteristics = new HashSet<String>();
        if (!path.contains(".")) {
            typeCodes.add(path);
            this.addCharacteristics(characteristics, path);
        }
        for (Element type : types) {
            Base tcv;
            if (this.hasMustSupportExtension(type)) {
                typeMustSupport = true;
            }
            String tc = type.getChildValue("code");
            if (type.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type") && (tcv = type.getExtensionValue("http://hl7.org/fhir/StructureDefinition/structuredefinition-fhir-type")) != null) {
                tc = tcv.primitiveValue();
            }
            if (Utilities.noString((String)tc) && type.hasChild("code") && VersionUtilities.isR4Plus((String)this.context.getVersion())) {
                this.rule(errors, "2023-03-16", ValidationMessage.IssueType.INVALID, stack.getLiteralPath(), false, "SD_NO_TYPE_CODE_ON_CODE", path, sd.getId());
            }
            if (Utilities.noString((String)tc)) continue;
            typeCodes.add(tc);
            HashSet<String> tcharacteristics = new HashSet<String>();
            StructureDefinition tsd = this.context.fetchTypeDefinition(tc);
            if (tsd != null && tsd.hasExtension("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
                for (Extension ext : tsd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
                    tcharacteristics.add(ext.getValue().primitiveValue());
                }
            } else {
                this.addCharacteristics(tcharacteristics, tc);
            }
            characteristics.addAll(tcharacteristics);
            if (type.hasChildren("targetProfile")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), tcharacteristics.contains("has-target"), "SD_ILLEGAL_CHARACTERISTICS", "targetProfile", tc) && ok;
            }
            if (!snapshot && sd == null) continue;
            ok = this.validateElementType(errors, type, stack.push(type, -1, null, null), sd, path, logical) && ok;
        }
        if (typeMustSupport) {
            if (snapshot) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_SNAPSHOT", path) && ok;
            } else {
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), hasSnapshot || "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_DIFF", path);
            }
        }
        if (element.hasChild("binding")) {
            Element binding;
            if (!typeCodes.isEmpty()) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("can-bind"), "SD_ILLEGAL_CHARACTERISTICS", "Binding", typeCodes) && ok;
            }
            boolean bl = ok = this.validateBinding(errors, binding = element.getNamedChild("binding"), stack.push(binding, -1, null, null), typeCodes, snapshot, path) && ok;
        }
        if (!typeCodes.isEmpty()) {
            if (element.hasChild("maxLength")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-length"), "SD_ILLEGAL_CHARACTERISTICS", "MaxLength", typeCodes) && ok;
            }
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/minLength")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-length"), "SD_ILLEGAL_CHARACTERISTICS", "MinLength Extension", typeCodes) && ok;
            }
            if (element.hasChild("minValue")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-range"), "SD_ILLEGAL_CHARACTERISTICS", "MinValue", typeCodes) && ok;
            }
            if (element.hasChild("maxValue")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-range"), "SD_ILLEGAL_CHARACTERISTICS", "MaxValue", typeCodes) && ok;
            }
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/maxDecimalPlaces")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("is-continuous"), "SD_ILLEGAL_CHARACTERISTICS", "Max Decimal Places Extension", typeCodes) && ok;
            }
            if (element.hasExtension("http://hl7.org/fhir/StructureDefinition/maxSize")) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), characteristics.contains("has-size"), "SD_ILLEGAL_CHARACTERISTICS", "Max Size", typeCodes) && ok;
            }
        }
        if (snapshot && element.getIdBase() != null && element.getIdBase().contains(".") && this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !typeCodes.isEmpty() || element.hasChild("contentReference"), "SD_NO_TYPES_OR_CONTENTREF", element.getIdBase())) {
            boolean repeating = !Utilities.existsInList((String)element.getChildValue("max"), (String[])new String[]{"0", "1"});
            Element v = element.getNamedChild("defaultValue");
            if (v != null) {
                boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "defaultValue", v.fhirType(), typeCodes) && ok;
            }
            if ((v = element.getNamedChild("fixed")) != null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "fixed", v.fhirType(), typeCodes) && ok;
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_HINT", element.getIdBase(), "fixed");
                if (this.isPrimitiveType(v.fhirType())) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_WARNING_DOTNET", element.getIdBase(), "fixed");
                } else {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), false, "SD_VALUE_COMPLEX_FIXED", v.fhirType());
                }
            }
            if ((v = element.getNamedChild("pattern")) != null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), typeCodes.contains(v.fhirType()), "SD_VALUE_TYPE_IILEGAL", element.getIdBase(), "pattern", v.fhirType(), typeCodes) && ok;
                this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_HINT", element.getIdBase(), "pattern");
                if (this.isPrimitiveType(v.fhirType())) {
                    this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.push(v, -1, null, null).getLiteralPath(), !repeating, "SD_VALUE_TYPE_REPEAT_WARNING_DOTNET", element.getIdBase(), "pattern");
                }
            }
        }
        List constraints = element.getChildrenByName("constraint");
        int cc = 0;
        for (Element invariant : constraints) {
            ok = this.validateElementDefinitionInvariant(errors, invariant, stack.push(invariant, cc, null, null), invariantMap, element.getNamedChildValue("path"), rootPath, profileUrl) && ok;
            ++cc;
        }
        return ok;
    }

    private boolean validateElementDefinitionInvariant(List<ValidationMessage> errors, Element invariant, NodeStack stack, Map<String, String> invariantMap, String path, String rootPath, String profileUrl) {
        boolean ok = true;
        String key = invariant.getNamedChildValue("key");
        String expression = invariant.getNamedChildValue("expression");
        String source = invariant.getNamedChildValue("source");
        if (this.warning(errors, "2023-06-19", ValidationMessage.IssueType.INFORMATIONAL, stack, !Utilities.noString((String)key), "ED_INVARIANT_NO_KEY", new Object[0]) && this.hint(errors, "2023-06-19", ValidationMessage.IssueType.INFORMATIONAL, stack, !Utilities.noString((String)expression) || VersionUtilities.isR5Plus((String)this.context.getVersion()), "ED_INVARIANT_NO_EXPRESSION", key)) {
            if (invariantMap.containsKey(key)) {
                ok = this.rule(errors, "2023-06-19", ValidationMessage.IssueType.INVALID, stack, expression.equals(invariantMap.get(key)) || "ele-1".equals(key), "ED_INVARIANT_EXPRESSION_CONFLICT", key, expression, invariantMap.get(key));
            } else {
                invariantMap.put(key, expression);
            }
            if (Utilities.noString((String)source) || source.equals(profileUrl)) {
                try {
                    this.fpe.check((Object)invariant, rootPath, path, this.fpe.parse(expression));
                }
                catch (Exception e) {
                    if (this.debug) {
                        e.printStackTrace();
                    }
                    ok = this.rule(errors, "2023-06-19", ValidationMessage.IssueType.INVALID, stack, false, "ED_INVARIANT_EXPRESSION_ERROR", key, expression, e.getMessage()) && ok;
                }
            }
        }
        return ok;
    }

    private boolean meaningWhenMissingAllowed(Element element) {
        String path = element.getNamedChildValue("path");
        return path != null && ("Extension".equals(path) || path.endsWith(".extension"));
    }

    private boolean addCharacteristics(Set<String> set, String tc) {
        switch (tc) {
            case "boolean": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "integer": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "integer64": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "decimal": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "base64Binary": {
                return this.addCharacteristicsForType(set, "has-size");
            }
            case "instant": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "string": {
                return this.addCharacteristicsForType(set, "has-length", "do-translations", "can-bind");
            }
            case "uri": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "date": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "dateTime": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "time": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "has-length");
            }
            case "canonical": {
                return this.addCharacteristicsForType(set, "has-target", "has-length");
            }
            case "code": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "id": {
                return this.addCharacteristicsForType(set, "has-length");
            }
            case "markdown": {
                return this.addCharacteristicsForType(set, "do-translations", "has-length");
            }
            case "oid": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "positiveInt": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "unsignedInt": {
                return this.addCharacteristicsForType(set, "has-range", "has-length");
            }
            case "url": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "uuid": {
                return this.addCharacteristicsForType(set, "has-length", "can-bind");
            }
            case "xhtml": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Address": {
                return this.addCharacteristicsForType(set, "do-translations");
            }
            case "Age": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Annotation": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Attachment": {
                return this.addCharacteristicsForType(set, "has-size", "do-translations");
            }
            case "CodeableConcept": {
                return this.addCharacteristicsForType(set, "can-bind", "do-translations");
            }
            case "CodeableReference": {
                return this.addCharacteristicsForType(set, "has-target", "can-bind", "do-translations");
            }
            case "Coding": {
                return this.addCharacteristicsForType(set, "can-bind", "do-translations");
            }
            case "ContactPoint": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Count": {
                return this.addCharacteristicsForType(set, "has-range");
            }
            case "Distance": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Duration": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "HumanName": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Identifier": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Money": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous");
            }
            case "Period": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Quantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "Range": {
                return this.addCharacteristicsForType(set, "has-units", "can-bind", "has-units");
            }
            case "Ratio": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "RatioRange": {
                return this.addCharacteristicsForType(set, "has-units");
            }
            case "Reference": {
                return this.addCharacteristicsForType(set, "has-target");
            }
            case "SampledData": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Signature": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Timing": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ContactDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Contributor": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "DataRequirement": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Expression": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ParameterDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "RelatedArtifact": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "TriggerDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "UsageContext": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Dosage": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Meta": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Resource": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Extension": {
                return this.addCharacteristicsForType(set, "can-bind");
            }
            case "Narrative": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "MoneyQuantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "SimpleQuantity": {
                return this.addCharacteristicsForType(set, "has-range", "is-continuous", "can-bind", "has-units");
            }
            case "MarketingStatus": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ExtendedContactDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "VirtualServiceDetail": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Availability": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "MonetaryComponent": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "ElementDefinition": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "BackboneElement": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Element": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
            case "Base": {
                return this.addCharacteristicsForType(set, new String[0]);
            }
        }
        return this.addCharacteristicsForType(set, new String[0]);
    }

    private boolean addCharacteristicsForType(Set<String> set, String ... cl) {
        for (String c : cl) {
            set.add(c);
        }
        return true;
    }

    private boolean isPrimitiveType(String fhirType) {
        StructureDefinition sd = this.context.fetchTypeDefinition(fhirType);
        return sd != null && sd.getKind() == StructureDefinition.StructureDefinitionKind.PRIMITIVETYPE;
    }

    private String boundType(Set<String> typeCodes) {
        for (String tc : typeCodes) {
            if (!Utilities.existsInList((String)tc, (String[])new String[]{"code", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            return tc;
        }
        return null;
    }

    private String bindableType(Set<String> typeCodes) {
        String ret = this.boundType(typeCodes);
        if (ret != null) {
            return ret;
        }
        for (String tc : typeCodes) {
            if (Utilities.existsInList((String)tc, (String[])new String[]{"string", "uri", "CodeableConcept", "Quantity", "CodeableReference"})) {
                return tc;
            }
            StructureDefinition sd = this.context.fetchTypeDefinition(tc);
            while (sd != null) {
                if (sd.hasExtension("http://hl7.org/fhir/tools/StructureDefinition/elementdefinition-binding-style")) {
                    return tc;
                }
                for (Extension ext : sd.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
                    if (!"can-bind".equals(ext.getValue().primitiveValue())) continue;
                    return tc;
                }
                if (Utilities.existsInList((String)sd.getType(), (String[])new String[]{"string", "uri", "CodeableConcept", "Quantity", "CodeableReference"})) {
                    return tc;
                }
                sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            }
        }
        return null;
    }

    private boolean validateBinding(List<ValidationMessage> errors, Element binding, NodeStack stack, Set<String> typeCodes, boolean snapshot, String path) {
        boolean ok = true;
        if (this.bindableType(typeCodes) == null) {
            boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot, "SD_ED_BIND_NO_BINDABLE", path, typeCodes.toString()) && ok;
        }
        if (!snapshot) {
            Set<String> bindables = this.getListofBindableTypes(typeCodes);
            this.hint(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), bindables.size() <= 1, "SD_ED_BIND_MULTIPLE_TYPES", path, typeCodes.toString());
        }
        if (binding.hasChild("valueSet")) {
            Element valueSet = binding.getNamedChild("valueSet");
            String ref = valueSet.hasPrimitiveValue() ? valueSet.primitiveValue() : valueSet.getNamedChildValue("reference");
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || ref != null, "SD_ED_SHOULD_BIND_WITH_VS", path)) {
                Resource vs = this.context.fetchResource(Resource.class, ref);
                if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs != null || this.serverSupportsValueSet(ref), "SD_ED_BIND_UNKNOWN_VS", path, ref) && vs != null) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs instanceof ValueSet, "SD_ED_BIND_NOT_VS", path, ref, vs.fhirType()) && ok;
                }
            }
        }
        return ok;
    }

    private Set<String> getListofBindableTypes(Set<String> types) {
        HashSet<String> res = new HashSet<String>();
        for (String s : types) {
            if (!Utilities.existsInList((String)s, (String[])new String[]{"code", "string", "url", "uri", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            res.add(s);
        }
        return res;
    }

    private boolean serverSupportsValueSet(String ref) {
        IWorkerContext.ValidationResult vr = this.context.validateCode(new ValidationOptions(new String[0]).withCheckValueSetOnly().withVsAsUrl().withNoClient(), new Coding("http://loinc.org", "5792-7", null), new ValueSet().setUrl(ref));
        return vr.getErrorClass() == null;
    }

    private boolean validateElementType(List<ValidationMessage> errors, Element type, NodeStack stack, StructureDefinition sd, String path, boolean logical) {
        block6: {
            boolean ok = true;
            String code = type.getNamedChildValue("code");
            if (code == null && path != null) {
                code = this.getTypeCodeFromSD(sd, path);
            }
            if (code == null) break block6;
            List profiles = type.getChildrenByName("profile");
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion())) {
                for (Element profile : profiles) {
                    ok = this.validateProfileTypeOrTarget(errors, profile, code, stack.push(profile, -1, null, null), path) && ok;
                }
            } else {
                for (Element profile : profiles) {
                    ok = this.validateTypeProfile(errors, profile, code, stack.push(profile, -1, null, null), path) && ok;
                }
                profiles = type.getChildrenByName("targetProfile");
                for (Element profile : profiles) {
                    ok = this.validateTargetProfile(errors, profile, code, stack.push(profile, -1, null, null), path, logical) && ok;
                }
            }
        }
        return true;
    }

    private boolean validateProfileTypeOrTarget(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        boolean ok = true;
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference")) {
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                ok = t == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path) && ok;
            }
        } else {
            if (sd == null) {
                sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
            }
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                if (t == null) {
                    ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok;
                } else {
                    boolean bl = ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), this.isInstanceOf(t, code), "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path) && ok;
                    if (t.getType().equals("Extension")) {
                        boolean isModifierDefinition = this.checkIsModifierExtension(sd);
                        boolean isModifierContext = path.endsWith(".modifierExtension");
                        ok = isModifierDefinition ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), isModifierContext, "SD_ED_TYPE_PROFILE_NOT_MODIFIER", p, t, code, path) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !isModifierContext, "SD_ED_TYPE_PROFILE_IS_MODIFIER", p, t, code, path) && ok;
                    }
                }
            }
        }
        return ok;
    }

    private String getTypeCodeFromSD(StructureDefinition sd, String path) {
        ElementDefinition ed = null;
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.hasPath() || !t.getPath().equals(path)) continue;
            if (ed == null) {
                ed = t;
                continue;
            }
            return null;
        }
        return ed != null && ed.getType().size() == 1 ? ed.getTypeFirstRep().getCode() : null;
    }

    private boolean validateTypeProfile(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        boolean ok = true;
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (sd == null) {
            sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
        }
        if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
            StructureDefinition t = this.determineBaseType(sd);
            if (t == null) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok;
            } else if (!this.isInstanceOf(t, code)) {
                ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path) && ok;
            } else if (t.getType().equals("Extension")) {
                boolean isModifierDefinition = this.checkIsModifierExtension(sd);
                boolean isModifierContext = path.endsWith(".modifierExtension");
                ok = isModifierDefinition ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), isModifierContext, "SD_ED_TYPE_PROFILE_NOT_MODIFIER", p, t, code, path) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), !isModifierContext, "SD_ED_TYPE_PROFILE_IS_MODIFIER", p, t, code, path) && ok;
            }
        }
        return ok;
    }

    private boolean checkIsModifierExtension(StructureDefinition t) {
        return t.getSnapshot().getElementFirstRep().getIsModifier();
    }

    private boolean validateTargetProfile(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path, boolean logical) {
        boolean ok = true;
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference") || code.equals("CodeableReference")) {
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                ok = t == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE || logical && this.isReferenceableTarget(t), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Resource") && ok;
            }
        } else if (code.equals("canonical")) {
            if (this.warning(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                StructureDefinition t = this.determineBaseType(sd);
                ok = t == null ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_PROFILE_NOTYPE", p) && ok : (!VersionUtilities.isR5Plus((String)this.context.getVersion()) ? this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t.getType()) || "Resource".equals(t.getType()), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource") && ok : this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), Utilities.existsInList((String)t.getType(), (String[])new String[]{"Resource", "CanonicalResource"}) || VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t.getType()), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource") && ok);
            }
        } else {
            ok = this.rule(errors, NO_RULE_DATE, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_NO_TARGET_PROFILE", code) && ok;
        }
        return ok;
    }

    private boolean isReferenceableTarget(StructureDefinition t) {
        for (Extension ext : t.getExtensionsByUrl("http://hl7.org/fhir/StructureDefinition/structuredefinition-type-characteristics")) {
            String c;
            if (!ext.hasValue() || !"can-be-target".equals(c = ext.getValue().primitiveValue())) continue;
            return true;
        }
        return ToolingExtensions.readBoolExtension((DomainResource)t, (String)"http://hl7.org/fhir/tools/StructureDefinition/logical-target");
    }

    private boolean isInstanceOf(StructureDefinition sd, String code) {
        while (sd != null) {
            if (sd.getType().equals(code)) {
                return true;
            }
            if (sd.getUrl().equals(code)) {
                return true;
            }
            StructureDefinition structureDefinition = sd = sd.hasBaseDefinition() ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition()) : null;
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion()) || sd == null || sd.getAbstract() || sd.getKind() == StructureDefinition.StructureDefinitionKind.LOGICAL) continue;
            sd = null;
        }
        return false;
    }

    private StructureDefinition determineBaseType(StructureDefinition sd) {
        while (sd != null && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return sd;
    }

    private boolean hasMustSupportExtension(Element type) {
        if ("true".equals(this.getExtensionValue(type, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        List profiles = type.getChildrenByName("profile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        profiles = type.getChildrenByName("targetProfile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        return false;
    }

    private String getExtensionValue(Element element, String url) {
        List extensions = element.getChildrenByName("extension");
        for (Element extension : extensions) {
            if (!url.equals(extension.getNamedChildValue("url"))) continue;
            return extension.getNamedChildValue("value");
        }
        return null;
    }

    private StructureDefinition loadAsSD(Element src) throws FHIRException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)src, (OutputStream)bs, (Manager.FhirFormat)Manager.FhirFormat.JSON, (IParser.OutputStyle)IParser.OutputStyle.NORMAL, null);
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
        }
        return (StructureDefinition)new JsonParser().parse(bs.toByteArray());
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

