/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.tasks;

import java.io.PrintStream;
import org.hl7.fhir.utilities.TimeTracker;
import org.hl7.fhir.validation.cli.model.CliContext;
import org.hl7.fhir.validation.cli.tasks.StandaloneTask;
import org.hl7.fhir.validation.cli.utils.Params;
import org.hl7.fhir.validation.special.TxTester;

public class TxTestsTask
extends StandaloneTask {
    @Override
    public String getName() {
        return "txTests";
    }

    @Override
    public String getDisplayName() {
        return "Terminology Tests";
    }

    @Override
    public boolean isHidden() {
        return true;
    }

    @Override
    public boolean shouldExecuteTask(CliContext cliContext, String[] args) {
        return Params.hasParam(args, "-txTests");
    }

    @Override
    public void printHelp(PrintStream out) {
    }

    @Override
    public void executeTask(CliContext cliContext, String[] args, TimeTracker tt, TimeTracker.Session tts) throws Exception {
        String source = Params.getParam(args, "-source");
        String output = Params.getParam(args, "-output");
        String version = Params.getParam(args, "-version");
        String tx = Params.getParam(args, "-tx");
        String filter = Params.getParam(args, "-filter");
        boolean ok = new TxTester(new TxTester.InternalTxLoader(source, output), tx, false).setOutput(output).execute(version, filter);
        System.exit(ok ? 1 : 0);
    }
}

