/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import ca.uhn.fhir.util.ObjectUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_10_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_14_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_30_50;
import org.hl7.fhir.convertors.factory.VersionConvertorFactory_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.ObjectConverter;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.Coding;
import org.hl7.fhir.r5.model.DateType;
import org.hl7.fhir.r5.model.DomainResource;
import org.hl7.fhir.r5.model.Enumerations;
import org.hl7.fhir.r5.model.FhirPublication;
import org.hl7.fhir.r5.model.IntegerType;
import org.hl7.fhir.r5.model.Questionnaire;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StringType;
import org.hl7.fhir.r5.model.TimeType;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.CommaSeparatedStringBuilder;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.utilities.validation.ValidationOptions;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.cli.utils.QuestionnaireMode;
import org.hl7.fhir.validation.instance.EnableWhenEvaluator;
import org.hl7.fhir.validation.instance.utils.NodeStack;
import org.hl7.fhir.validation.instance.utils.ValidatorHostContext;

public class QuestionnaireValidator
extends BaseValidator {
    private EnableWhenEvaluator myEnableWhenEvaluator;
    private FHIRPathEngine fpe;
    private QuestionnaireMode questionnaireMode;

    public QuestionnaireValidator(IWorkerContext context, EnableWhenEvaluator myEnableWhenEvaluator, FHIRPathEngine fpe, TimeTracker timeTracker, QuestionnaireMode questionnaireMode, XVerExtensionManager xverManager) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.myEnableWhenEvaluator = myEnableWhenEvaluator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
        this.questionnaireMode = questionnaireMode;
    }

    public void validateQuestionannaire(List<ValidationMessage> errors, Element element, Element element2, NodeStack stack) {
        ArrayList<Element> parents = new ArrayList<Element>();
        parents.add(element);
        this.validateQuestionannaireItem(errors, element, element, stack, parents);
    }

    private void validateQuestionannaireItem(List<ValidationMessage> errors, Element element, Element questionnaire, NodeStack stack, List<Element> parents) {
        List<Element> list = this.getItems(element);
        for (int i = 0; i < list.size(); ++i) {
            Element e = list.get(i);
            NodeStack ns = stack.push(e, i, e.getProperty().getDefinition(), e.getProperty().getDefinition());
            this.validateQuestionnaireElement(errors, ns, questionnaire, e, parents);
            ArrayList<Element> np = new ArrayList<Element>();
            np.add(e);
            np.addAll(parents);
            this.validateQuestionannaireItem(errors, e, questionnaire, ns, np);
        }
    }

    private void validateQuestionnaireElement(List<ValidationMessage> errors, NodeStack ns, Element questionnaire, Element item, List<Element> parents) {
        if (Enumerations.FHIRVersion.isR4Plus((String)this.context.getVersion()) && item.hasChildren("enableWhen")) {
            List ewl = item.getChildren("enableWhen");
            for (Element ew : ewl) {
                String ql = ew.getNamedChildValue("question");
                if (!this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), ql != null, "Questionnaire_Q_EnableWhen_NoLink", new Object[0])) continue;
                Element tgt = this.getQuestionById(item, ql);
                if (!this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), tgt == null, "Questionnaire_Q_EnableWhen_IsInner", new Object[0])) continue;
                tgt = this.getQuestionById(questionnaire, ql);
                if (!this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), tgt != null, "Questionnaire_Q_EnableWhen_NoTarget", ql, item.getChildValue("linkId")) || !this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), tgt != item, "Questionnaire_Q_EnableWhen_Self", new Object[0]) || this.isBefore(item, tgt, parents)) continue;
                this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, ns.getLiteralPath(), false, "Questionnaire_Q_EnableWhen_After", ql);
            }
        }
    }

    private boolean isBefore(Element item, Element tgt, List<Element> parents) {
        if (parents.contains(tgt)) {
            return true;
        }
        for (Element p : parents) {
            int i = this.findIndex(p, item);
            int t = this.findIndex(p, tgt);
            if (i <= -1 || t <= -1) continue;
            return i > t;
        }
        return false;
    }

    private int findIndex(Element parent, Element descendant) {
        for (int i = 0; i < parent.getChildren().size(); ++i) {
            if (parent.getChildren().get(i) != descendant && !this.isChild((Element)parent.getChildren().get(i), descendant)) continue;
            return i;
        }
        return -1;
    }

    private boolean isChild(Element element, Element descendant) {
        for (Element e : element.getChildren()) {
            if (e == descendant) {
                return true;
            }
            if (!this.isChild(e, descendant)) continue;
            return true;
        }
        return false;
    }

    private Element getQuestionById(Element focus, String ql) {
        List<Element> list = this.getItems(focus);
        for (Element item : list) {
            String v = item.getNamedChildValue("linkId");
            if (ql.equals(v)) {
                return item;
            }
            Element tgt = this.getQuestionById(item, ql);
            if (tgt == null) continue;
            return tgt;
        }
        return null;
    }

    private List<Element> getItems(Element element) {
        ArrayList<Element> list = new ArrayList<Element>();
        element.getNamedChildren("item", list);
        return list;
    }

    public void validateQuestionannaireResponse(ValidatorHostContext hostContext, List<ValidationMessage> errors, Element element, NodeStack stack) throws FHIRException {
        boolean ok;
        if (this.questionnaireMode == QuestionnaireMode.NONE) {
            return;
        }
        Element q = element.getNamedChild("questionnaire");
        String questionnaire = null;
        if (q != null) {
            if (StringUtils.isNotBlank((CharSequence)q.getValue())) {
                questionnaire = q.getValue();
            } else if (StringUtils.isNotBlank((CharSequence)q.getChildValue("reference"))) {
                questionnaire = q.getChildValue("reference");
            }
        }
        boolean bl = this.questionnaireMode == QuestionnaireMode.REQUIRED ? this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), questionnaire != null, "Questionnaire_QR_Q_None", new Object[0]) : (ok = this.hint(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), questionnaire != null, "Questionnaire_QR_Q_None"));
        if (ok) {
            Questionnaire qsrc;
            Questionnaire questionnaire2 = qsrc = questionnaire.startsWith("#") ? this.loadQuestionnaire(element, questionnaire.substring(1)) : (Questionnaire)this.context.fetchResource(Questionnaire.class, questionnaire);
            boolean bl2 = this.questionnaireMode == QuestionnaireMode.REQUIRED ? this.rule(errors, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "Questionnaire_QR_Q_NotFound", questionnaire) : (ok = this.warning(errors, ValidationMessage.IssueType.REQUIRED, q.line(), q.col(), stack.getLiteralPath(), qsrc != null, "Questionnaire_QR_Q_NotFound", questionnaire));
            if (ok) {
                boolean inProgress = "in-progress".equals(element.getNamedChildValue("status"));
                this.validateQuestionannaireResponseItems(hostContext, qsrc, qsrc.getItem(), errors, element, stack, inProgress, element, new EnableWhenEvaluator.QStack(qsrc, element));
            }
        }
    }

    private Questionnaire loadQuestionnaire(Element resource, String id) throws FHIRException {
        try {
            for (Element contained : resource.getChildren("contained")) {
                if (!contained.getIdBase().equals(id)) continue;
                FhirPublication v = FhirPublication.fromCode((String)this.context.getVersion());
                ByteArrayOutputStream bs = new ByteArrayOutputStream();
                new org.hl7.fhir.r5.elementmodel.JsonParser(this.context).compose(contained, (OutputStream)bs, IParser.OutputStyle.NORMAL, id);
                byte[] json = bs.toByteArray();
                switch (v) {
                    case DSTU1: {
                        throw new FHIRException(this.context.formatMessage("Unsupported_version_R1", new Object[0]));
                    }
                    case DSTU2: {
                        org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(json);
                        Resource r5 = VersionConvertorFactory_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
                        if (r5 instanceof Questionnaire) {
                            return (Questionnaire)r5;
                        }
                        return null;
                    }
                    case DSTU2016May: {
                        org.hl7.fhir.dstu2016may.model.Resource r2a = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(json);
                        Resource r5 = VersionConvertorFactory_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2a);
                        if (r5 instanceof Questionnaire) {
                            return (Questionnaire)r5;
                        }
                        return null;
                    }
                    case STU3: {
                        org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(json);
                        Resource r5 = VersionConvertorFactory_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3);
                        if (r5 instanceof Questionnaire) {
                            return (Questionnaire)r5;
                        }
                        return null;
                    }
                    case R4: {
                        org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(json);
                        Resource r5 = VersionConvertorFactory_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
                        if (r5 instanceof Questionnaire) {
                            return (Questionnaire)r5;
                        }
                        return null;
                    }
                    case R5: {
                        Resource r5 = new JsonParser().parse(json);
                        if (r5 instanceof Questionnaire) {
                            return (Questionnaire)r5;
                        }
                        return null;
                    }
                }
            }
            return null;
        }
        catch (IOException e) {
            throw new FHIRException((Throwable)e);
        }
    }

    private void validateQuestionnaireResponseItem(ValidatorHostContext hostContext, Questionnaire qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, Element element, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        ArrayList items;
        String text = element.getNamedChildValue("text");
        this.rule(errors, ValidationMessage.IssueType.INVALID, element.line(), element.col(), stack.getLiteralPath(), Utilities.noString((String)text) || text.equals(qItem.getText()), "Questionnaire_QR_Item_Text", qItem.getLinkId());
        ArrayList<Element> answers = new ArrayList<Element>();
        element.getNamedChildren("answer", answers);
        if (inProgress) {
            this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), this.isAnswerRequirementFulfilled(qItem, answers), "Questionnaire_QR_Item_Missing", qItem.getLinkId());
        } else if (this.myEnableWhenEvaluator.isQuestionEnabled(hostContext, qItem, qstack, this.fpe)) {
            this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), this.isAnswerRequirementFulfilled(qItem, answers), "Questionnaire_QR_Item_Missing", qItem.getLinkId());
        } else if (!answers.isEmpty()) {
            // empty if block
        }
        if (answers.size() > 1) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, ((Element)answers.get(1)).line(), ((Element)answers.get(1)).col(), stack.getLiteralPath(), qItem.getRepeats(), "Questionnaire_QR_Item_OnlyOneA", new Object[0]);
        }
        for (Element answer : answers) {
            NodeStack ns = stack.push(answer, -1, null, null);
            if (qItem.getType() != null) {
                switch (qItem.getType()) {
                    case GROUP: {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, answer.line(), answer.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_Group", new Object[0]);
                        break;
                    }
                    case DISPLAY: {
                        break;
                    }
                    case BOOLEAN: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "boolean");
                        break;
                    }
                    case DECIMAL: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "decimal");
                        break;
                    }
                    case INTEGER: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "integer");
                        break;
                    }
                    case DATE: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "date");
                        break;
                    }
                    case DATETIME: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "dateTime");
                        break;
                    }
                    case TIME: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "time");
                        break;
                    }
                    case STRING: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "string");
                        break;
                    }
                    case TEXT: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "text");
                        break;
                    }
                    case URL: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "uri");
                        break;
                    }
                    case ATTACHMENT: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "Attachment");
                        break;
                    }
                    case REFERENCE: {
                        this.validateQuestionnaireResponseItemType(errors, answer, ns, "Reference");
                        break;
                    }
                    case QUANTITY: {
                        if (!"Quantity".equals(this.validateQuestionnaireResponseItemType(errors, answer, ns, "Quantity")) || !qItem.hasExtension("???")) break;
                        this.validateQuestionnaireResponseItemQuantity(errors, answer, ns);
                        break;
                    }
                    case CODING: {
                        String itemType = this.validateQuestionnaireResponseItemType(errors, answer, ns, "Coding", "date", "time", "integer", "string");
                        if (itemType == null) break;
                        if (itemType.equals("Coding")) {
                            this.validateAnswerCode(errors, answer, ns, qsrc, qItem, false);
                            break;
                        }
                        if (itemType.equals("date")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "date");
                            break;
                        }
                        if (itemType.equals("time")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "time");
                            break;
                        }
                        if (itemType.equals("integer")) {
                            this.checkOption(errors, answer, ns, qsrc, qItem, "integer");
                            break;
                        }
                        if (!itemType.equals("string")) break;
                        this.checkOption(errors, answer, ns, qsrc, qItem, "string");
                        break;
                    }
                }
            }
            if (qItem.getType() == Questionnaire.QuestionnaireItemType.GROUP) continue;
            this.validateQuestionannaireResponseItems(hostContext, qsrc, qItem.getItem(), errors, answer, stack, inProgress, questionnaireResponseRoot, qstack);
        }
        if (qItem.getType() == null) {
            this.fail(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoType", qItem.getLinkId());
        } else if (qItem.getType() == Questionnaire.QuestionnaireItemType.DISPLAY) {
            items = new ArrayList();
            element.getNamedChildren("item", items);
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), items.isEmpty(), "Questionnaire_QR_Item_Display", qItem.getLinkId());
        } else if (qItem.getType() != Questionnaire.QuestionnaireItemType.GROUP) {
            items = new ArrayList();
            element.getNamedChildren("item", items);
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, element.line(), element.col(), stack.getLiteralPath(), items.isEmpty(), "Questionnaire_QR_Item_GroupAnswer", qItem.getLinkId());
        } else {
            this.validateQuestionannaireResponseItems(hostContext, qsrc, qItem.getItem(), errors, element, stack, inProgress, questionnaireResponseRoot, qstack);
        }
    }

    private boolean isAnswerRequirementFulfilled(Questionnaire.QuestionnaireItemComponent qItem, List<Element> answers) {
        return !answers.isEmpty() || !qItem.getRequired() || qItem.getType() == Questionnaire.QuestionnaireItemType.GROUP;
    }

    private void validateQuestionnaireResponseItem(ValidatorHostContext hostcontext, Questionnaire qsrc, Questionnaire.QuestionnaireItemComponent qItem, List<ValidationMessage> errors, List<Element> elements, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        if (elements.size() > 1) {
            this.rule(errors, ValidationMessage.IssueType.INVALID, elements.get(1).line(), elements.get(1).col(), stack.getLiteralPath(), qItem.getRepeats(), "Questionnaire_QR_Item_OnlyOneI", qItem.getLinkId());
        }
        int i = 0;
        for (Element element : elements) {
            NodeStack ns = stack.push(element, i, null, null);
            this.validateQuestionnaireResponseItem(hostcontext, qsrc, qItem, errors, element, ns, inProgress, questionnaireResponseRoot, qstack.push(qItem, element));
            ++i;
        }
    }

    private int getLinkIdIndex(List<Questionnaire.QuestionnaireItemComponent> qItems, String linkId) {
        for (int i = 0; i < qItems.size(); ++i) {
            if (!linkId.equals(qItems.get(i).getLinkId())) continue;
            return i;
        }
        return -1;
    }

    private void validateQuestionannaireResponseItems(ValidatorHostContext hostContext, Questionnaire qsrc, List<Questionnaire.QuestionnaireItemComponent> qItems, List<ValidationMessage> errors, Element element, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, EnableWhenEvaluator.QStack qstack) {
        ArrayList items = new ArrayList();
        element.getNamedChildren("item", items);
        HashMap<String, List> map = new HashMap<String, List>();
        int lastIndex = -1;
        for (Element item : items) {
            String linkId = item.getNamedChildValue("linkId");
            if (!this.rule(errors, ValidationMessage.IssueType.REQUIRED, item.line(), item.col(), stack.getLiteralPath(), !Utilities.noString((String)linkId), "Questionnaire_QR_Item_NoLinkId", new Object[0])) continue;
            int index = this.getLinkIdIndex(qItems, linkId);
            if (index == -1) {
                Questionnaire.QuestionnaireItemComponent qItem = this.findQuestionnaireItem(qsrc, linkId);
                if (qItem != null) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index > -1, this.misplacedItemError(qItem), new Object[0]);
                    NodeStack ns = stack.push(item, -1, null, null);
                    this.validateQuestionnaireResponseItem(hostContext, qsrc, qItem, errors, item, ns, inProgress, questionnaireResponseRoot, qstack.push(qItem, item));
                    continue;
                }
                this.rule(errors, ValidationMessage.IssueType.NOTFOUND, item.line(), item.col(), stack.getLiteralPath(), index > -1, "Questionnaire_QR_Item_NotFound", linkId);
                continue;
            }
            this.rule(errors, ValidationMessage.IssueType.STRUCTURE, item.line(), item.col(), stack.getLiteralPath(), index >= lastIndex, "Questionnaire_QR_Item_Order", new Object[0]);
            lastIndex = index;
            if (!item.hasChildren("answer") && !item.hasChildren("item")) continue;
            List mapItem = map.computeIfAbsent(linkId, key -> new ArrayList());
            mapItem.add(item);
        }
        for (Questionnaire.QuestionnaireItemComponent qItem : qItems) {
            List mapItem = (List)map.get(qItem.getLinkId());
            this.validateQuestionnaireResponseItem(hostContext, qsrc, errors, element, stack, inProgress, questionnaireResponseRoot, qItem, mapItem, qstack);
        }
    }

    public void validateQuestionnaireResponseItem(ValidatorHostContext hostContext, Questionnaire qsrc, List<ValidationMessage> errors, Element element, NodeStack stack, boolean inProgress, Element questionnaireResponseRoot, Questionnaire.QuestionnaireItemComponent qItem, List<Element> mapItem, EnableWhenEvaluator.QStack qstack) {
        boolean enabled = this.myEnableWhenEvaluator.isQuestionEnabled(hostContext, qItem, qstack, this.fpe);
        if (mapItem != null) {
            if (!enabled) {
                int i = 0;
                for (Element e : mapItem) {
                    NodeStack ns = stack.push(e, i, e.getProperty().getDefinition(), e.getProperty().getDefinition());
                    this.rule(errors, ValidationMessage.IssueType.INVALID, e.line(), e.col(), ns.getLiteralPath(), enabled, "Questionnaire_QR_Item_NotEnabled2", qItem.getLinkId());
                    ++i;
                }
            }
            this.validateQuestionnaireResponseItem(hostContext, qsrc, qItem, errors, mapItem, stack, inProgress, questionnaireResponseRoot, qstack);
        } else if (enabled && qItem.getRequired()) {
            String message = this.context.formatMessage("Questionnaire_QR_Item_Missing", new Object[]{qItem.getLinkId()});
            if (inProgress) {
                this.warning(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, message, new Object[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.REQUIRED, element.line(), element.col(), stack.getLiteralPath(), false, message, new Object[0]);
            }
        }
    }

    private String misplacedItemError(Questionnaire.QuestionnaireItemComponent qItem) {
        return qItem.hasLinkId() ? String.format("Structural Error: item with linkid %s is in the wrong place", qItem.getLinkId()) : "Structural Error: item is in the wrong place";
    }

    private void validateQuestionnaireResponseItemQuantity(List<ValidationMessage> errors, Element answer, NodeStack stack) {
    }

    private String validateQuestionnaireResponseItemType(List<ValidationMessage> errors, Element element, NodeStack stack, String ... types) {
        ArrayList values = new ArrayList();
        element.getNamedChildrenWithWildcard("value[x]", values);
        for (int i = 0; i < types.length; ++i) {
            if (!types[i].equals("text")) continue;
            types[i] = "string";
        }
        if (values.size() > 0) {
            NodeStack ns = stack.push((Element)values.get(0), -1, null, null);
            CommaSeparatedStringBuilder l = new CommaSeparatedStringBuilder();
            for (String s : types) {
                l.append(s);
                if (!((Element)values.get(0)).getName().equals("value" + Utilities.capitalize((String)s))) continue;
                return s;
            }
            if (types.length == 1) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((Element)values.get(0)).line(), ((Element)values.get(0)).col(), ns.getLiteralPath(), false, "Questionnaire_QR_Item_WrongType", types[0]);
            } else {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, ((Element)values.get(0)).line(), ((Element)values.get(0)).col(), ns.getLiteralPath(), false, "Questionnaire_QR_Item_WrongType2", l.toString());
            }
        }
        return null;
    }

    private Questionnaire.QuestionnaireItemComponent findQuestionnaireItem(Questionnaire qSrc, String linkId) {
        return this.findItem(qSrc.getItem(), linkId);
    }

    private Questionnaire.QuestionnaireItemComponent findItem(List<Questionnaire.QuestionnaireItemComponent> list, String linkId) {
        for (Questionnaire.QuestionnaireItemComponent item : list) {
            if (linkId.equals(item.getLinkId())) {
                return item;
            }
            Questionnaire.QuestionnaireItemComponent result = this.findItem(item.getItem(), linkId);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private void validateAnswerCode(List<ValidationMessage> errors, Element value, NodeStack stack, Questionnaire qSrc, String ref, boolean theOpenChoice) {
        ValueSet vs = this.resolveBindingReference((DomainResource)qSrc, ref, qSrc.getUrl());
        if (this.warning(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), vs != null, "Terminology_TX_ValueSet_NotFound", this.describeReference(ref))) {
            try {
                Coding c = ObjectConverter.readAsCoding((Element)value);
                if (StringUtils.isBlank((CharSequence)c.getCode()) && StringUtils.isBlank((CharSequence)c.getSystem()) && StringUtils.isNotBlank((CharSequence)c.getDisplay()) && theOpenChoice) {
                    return;
                }
                long t = System.nanoTime();
                IWorkerContext.ValidationResult res = this.context.validateCode(new ValidationOptions(stack.getWorkingLang()), c, vs);
                this.timeTracker.tx(t, "vc " + c.getSystem() + "#" + c.getCode() + " '" + c.getDisplay() + "'");
                if (!res.isOk()) {
                    this.txRule(errors, res.getTxLink(), ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_BadOption", c.getSystem(), c.getCode());
                } else if (res.getSeverity() != null) {
                    super.addValidationMessage(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), res.getMessage(), res.getSeverity(), ValidationMessage.Source.TerminologyEngine, null);
                }
            }
            catch (Exception e) {
                this.warning(errors, ValidationMessage.IssueType.CODEINVALID, value.line(), value.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_Coding", e.getMessage());
            }
        }
    }

    private void validateAnswerCode(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean theOpenChoice) {
        Element v = answer.getNamedChild("valueCoding");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, theOpenChoice);
        } else if (qItem.hasAnswerValueSet()) {
            this.validateAnswerCode(errors, v, stack, qSrc, qItem.getAnswerValueSet(), theOpenChoice);
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptions");
        }
    }

    private void checkOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type) {
        this.checkOption(errors, answer, stack, qSrc, qItem, type, false);
    }

    private void checkOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, String type, boolean openChoice) {
        if (type.equals("integer")) {
            this.checkIntegerOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("date")) {
            this.checkDateOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("time")) {
            this.checkTimeOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("string")) {
            this.checkStringOption(errors, answer, stack, qSrc, qItem, openChoice);
        } else if (type.equals("Coding")) {
            this.checkCodingOption(errors, answer, stack, qSrc, qItem, openChoice);
        }
    }

    private void checkIntegerOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        Element v = answer.getNamedChild("valueInteger");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<IntegerType> list = new ArrayList<IntegerType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueIntegerType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsInteger", new Object[0]);
            } else {
                boolean found = false;
                for (IntegerType item : list) {
                    if ((Integer)item.getValue() != Integer.parseInt(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoInteger", v.primitiveValue());
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_IntNoOptions");
        }
    }

    private void checkDateOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        Element v = answer.getNamedChild("valueDate");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<DateType> list = new ArrayList<DateType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueDateType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsDate", new Object[0]);
            } else {
                boolean found = false;
                for (DateType item : list) {
                    if (!((Date)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoDate", v.primitiveValue());
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_DateNoOptions");
        }
    }

    private void checkTimeOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        Element v = answer.getNamedChild("valueTime");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<TimeType> list = new ArrayList<TimeType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    list.add(components.getValueTimeType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsTime", new Object[0]);
            } else {
                boolean found = false;
                for (TimeType item : list) {
                    if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoTime", v.primitiveValue());
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_TimeNoOptions");
        }
    }

    private void checkStringOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        Element v = answer.getNamedChild("valueString");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<StringType> list = new ArrayList<StringType>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueStringType());
                }
                catch (FHIRException fHIRException) {}
            }
            if (!openChoice) {
                if (list.isEmpty()) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsString", new Object[0]);
                } else {
                    boolean found = false;
                    for (StringType item : list) {
                        if (!((String)item.getValue()).equals(v.primitiveValue())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoString", v.primitiveValue());
                    }
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_StringNoOptions");
        }
    }

    private void checkCodingOption(List<ValidationMessage> errors, Element answer, NodeStack stack, Questionnaire qSrc, Questionnaire.QuestionnaireItemComponent qItem, boolean openChoice) {
        Element v = answer.getNamedChild("valueCoding");
        String system = v.getNamedChildValue("system");
        String code = v.getNamedChildValue("code");
        NodeStack ns = stack.push(v, -1, null, null);
        if (qItem.getAnswerOption().size() > 0) {
            ArrayList<Coding> list = new ArrayList<Coding>();
            for (Questionnaire.QuestionnaireItemAnswerOptionComponent components : qItem.getAnswerOption()) {
                try {
                    if (components.getValue() == null) continue;
                    list.add(components.getValueCoding());
                }
                catch (FHIRException fHIRException) {}
            }
            if (list.isEmpty() && !openChoice) {
                this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_NoOptionsCoding", new Object[0]);
            } else {
                boolean found = false;
                for (Coding item : list) {
                    if (!ObjectUtil.equals((Object)item.getSystem(), (Object)system) || !ObjectUtil.equals((Object)item.getCode(), (Object)code)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    this.rule(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), found, "Questionnaire_QR_Item_NoCoding", system, code);
                }
            }
        } else {
            this.hint(errors, ValidationMessage.IssueType.STRUCTURE, v.line(), v.col(), stack.getLiteralPath(), false, "Questionnaire_QR_Item_CodingNoOptions");
        }
    }
}

