/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.cli.utils;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;

public class AsteriskFilter
implements FilenameFilter {
    String dir;
    String regex;

    public AsteriskFilter(String filter) throws IOException {
        if (!filter.matches("(.*(\\\\|\\/))*(.*)\\*(.*)")) {
            throw new IOException("Filter names must have the following syntax: [directorypath][prefix]?*[suffix]?   I.e. The asterisk must be in the filename, not the directory path");
        }
        this.dir = filter.replaceAll("(.*(\\\\|\\/))*(.*)\\*(.*)", "$1");
        String expression = filter.replaceAll("(.*(\\\\|\\/))*(.*)", "$3");
        this.regex = "";
        for (int i = 0; i < expression.length(); ++i) {
            this.regex = Character.isAlphabetic(expression.codePointAt(i)) || Character.isDigit(expression.codePointAt(i)) ? this.regex + expression.charAt(i) : (expression.charAt(i) == '*' ? this.regex + ".*" : this.regex + "\\" + expression.charAt(i));
        }
        File f = new File(this.dir);
        if (!f.exists()) {
            throw new IOException("Directory " + this.dir + " does not exist");
        }
        if (!f.isDirectory()) {
            throw new IOException("Directory " + this.dir + " is not a directory");
        }
    }

    @Override
    public boolean accept(File dir, String s) {
        return s.matches(this.regex);
    }

    public String getDir() {
        return this.dir;
    }
}

