/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.validation.instance.type;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.convertors.VersionConvertor_10_50;
import org.hl7.fhir.convertors.VersionConvertor_14_50;
import org.hl7.fhir.convertors.VersionConvertor_30_50;
import org.hl7.fhir.convertors.VersionConvertor_40_50;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r5.conformance.ProfileUtilities;
import org.hl7.fhir.r5.context.IWorkerContext;
import org.hl7.fhir.r5.elementmodel.Element;
import org.hl7.fhir.r5.elementmodel.Manager;
import org.hl7.fhir.r5.formats.IParser;
import org.hl7.fhir.r5.formats.JsonParser;
import org.hl7.fhir.r5.model.ElementDefinition;
import org.hl7.fhir.r5.model.ExpressionNode;
import org.hl7.fhir.r5.model.Resource;
import org.hl7.fhir.r5.model.StructureDefinition;
import org.hl7.fhir.r5.model.ValueSet;
import org.hl7.fhir.r5.utils.FHIRPathEngine;
import org.hl7.fhir.r5.utils.XVerExtensionManager;
import org.hl7.fhir.utilities.Utilities;
import org.hl7.fhir.utilities.VersionUtilities;
import org.hl7.fhir.utilities.validation.ValidationMessage;
import org.hl7.fhir.validation.BaseValidator;
import org.hl7.fhir.validation.TimeTracker;
import org.hl7.fhir.validation.instance.utils.NodeStack;

public class StructureDefinitionValidator
extends BaseValidator {
    private FHIRPathEngine fpe;
    private boolean wantCheckSnapshotUnchanged;

    public StructureDefinitionValidator(IWorkerContext context, TimeTracker timeTracker, FHIRPathEngine fpe, boolean wantCheckSnapshotUnchanged, XVerExtensionManager xverManager) {
        super(context, xverManager);
        this.source = ValidationMessage.Source.InstanceValidator;
        this.fpe = fpe;
        this.timeTracker = timeTracker;
        this.wantCheckSnapshotUnchanged = wantCheckSnapshotUnchanged;
    }

    public void validateStructureDefinition(List<ValidationMessage> errors, Element src, NodeStack stack) {
        StructureDefinition sd = null;
        try {
            sd = this.loadAsSD(src);
            List snapshot = sd.getSnapshot().getElement();
            sd.setSnapshot(null);
            StructureDefinition base = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
            if (this.warning(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), base != null, "Unable_to_find_base__for_", sd.getBaseDefinition(), "StructureDefinition, so can't check the differential") && this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), sd.hasDerivation(), "SD_MUST_HAVE_DERIVATION", sd.getUrl()) && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
                ArrayList msgs = new ArrayList();
                ProfileUtilities pu = new ProfileUtilities(this.context, msgs, null);
                pu.setXver(this.xverManager);
                pu.generateSnapshot(base, sd, sd.getUrl(), "http://hl7.org/fhir", sd.getName());
                if (msgs.size() > 0) {
                    for (ValidationMessage msg : msgs) {
                        String loc = msg.getLocation();
                        if (loc.contains("#")) {
                            msg.setLocation(stack.getLiteralPath() + ".differential.element.where(path = '" + loc.substring(loc.indexOf("#") + 1) + "')");
                        } else {
                            msg.setLocation(stack.getLiteralPath());
                        }
                        errors.add(msg);
                    }
                }
                if (!snapshot.isEmpty() && this.wantCheckSnapshotUnchanged) {
                    int was = snapshot.size();
                    int is = sd.getSnapshot().getElement().size();
                    this.rule(errors, ValidationMessage.IssueType.NOTFOUND, stack.getLiteralPath(), was == is, "SNAPSHOT_EXISTING_PROBLEM", was, is);
                }
            }
        }
        catch (IOException | FHIRException e) {
            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "ERROR_GENERATING_SNAPSHOT", e.getMessage());
        }
        List differentials = src.getChildrenByName("differential");
        List snapshots = src.getChildrenByName("snapshot");
        for (Element differential : differentials) {
            this.validateElementList(errors, differential, stack.push(differential, -1, null, null), false, snapshots.size() > 0, sd);
        }
        for (Element snapshot : snapshots) {
            this.validateElementList(errors, snapshot, stack.push(snapshot, -1, null, null), true, true, sd);
        }
    }

    private void validateElementList(List<ValidationMessage> errors, Element elementList, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd) {
        List elements = elementList.getChildrenByName("element");
        int cc = 0;
        for (Element element : elements) {
            this.validateElementDefinition(errors, element, stack.push(element, cc, null, null), snapshot, hasSnapshot, sd);
            ++cc;
        }
    }

    private void validateElementDefinition(List<ValidationMessage> errors, Element element, NodeStack stack, boolean snapshot, boolean hasSnapshot, StructureDefinition sd) {
        boolean typeMustSupport = false;
        List types = element.getChildrenByName("type");
        HashSet<String> typeCodes = new HashSet<String>();
        for (Element type : types) {
            if (this.hasMustSupportExtension(type)) {
                typeMustSupport = true;
            }
            typeCodes.add(type.getChildValue("code"));
            if (!snapshot && sd == null) continue;
            this.validateElementType(errors, type, stack.push(type, -1, null, null), sd, element.getChildValue("path"));
        }
        if (typeMustSupport) {
            if (snapshot) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_SNAPSHOT", element.getNamedChildValue("path"));
            } else {
                this.hint(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), hasSnapshot || "true".equals(element.getChildValue("mustSupport")), "SD_NESTED_MUST_SUPPORT_DIFF", element.getNamedChildValue("path"));
            }
        }
        if (element.hasChild("binding")) {
            Element binding = element.getNamedChild("binding");
            this.validateBinding(errors, binding, stack.push(binding, -1, null, null), typeCodes, snapshot, element.getNamedChildValue("path"));
        }
    }

    private String boundType(Set<String> typeCodes) {
        for (String tc : typeCodes) {
            if (!Utilities.existsInList((String)tc, (String[])new String[]{"code", "Coding", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            return tc;
        }
        return null;
    }

    private String bindableType(Set<String> typeCodes) {
        String ret = this.boundType(typeCodes);
        if (ret != null) {
            return ret;
        }
        for (String tc : typeCodes) {
            if (!Utilities.existsInList((String)tc, (String[])new String[]{"string", "uri", "CodeableConcept", "Quantity", "CodeableReference"})) continue;
            return tc;
        }
        return null;
    }

    private void validateBinding(List<ValidationMessage> errors, Element binding, NodeStack stack, Set<String> typeCodes, boolean snapshot, String path) {
        this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || this.bindableType(typeCodes) != null, "SD_ED_BIND_NO_BINDABLE", path, typeCodes.toString());
        if (binding.hasChild("valueSet")) {
            Element valueSet = binding.getNamedChild("valueSet");
            String ref = valueSet.hasPrimitiveValue() ? valueSet.primitiveValue() : valueSet.getNamedChildValue("refernece");
            if (this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), !snapshot || ref != null, "SD_ED_SHOULD_BIND_WITH_VS", path)) {
                Resource vs = this.context.fetchResource(Resource.class, ref);
                if (this.warning(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs != null, "SD_ED_BIND_UNKNOWN_VS", path, ref)) {
                    this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, stack.getLiteralPath(), vs instanceof ValueSet, "SD_ED_BIND_NOT_VS", path, ref, vs.fhirType());
                }
            }
        }
    }

    private void validateElementType(List<ValidationMessage> errors, Element type, NodeStack stack, StructureDefinition sd, String path) {
        block6: {
            String code = type.getNamedChildValue("code");
            if (code == null && path != null) {
                code = this.getTypeCodeFromSD(sd, path);
            }
            if (code == null) break block6;
            List profiles = type.getChildrenByName("profile");
            if (VersionUtilities.isR2Ver((String)this.context.getVersion()) || VersionUtilities.isR2BVer((String)this.context.getVersion())) {
                for (Element profile : profiles) {
                    this.validateProfileTypeOrTarget(errors, profile, code, stack.push(profile, -1, null, null), path);
                }
            } else {
                for (Element profile : profiles) {
                    this.validateTypeProfile(errors, profile, code, stack.push(profile, -1, null, null), path);
                }
                profiles = type.getChildrenByName("targetProfile");
                for (Element profile : profiles) {
                    this.validateTargetProfile(errors, profile, code, stack.push(profile, -1, null, null), path);
                }
            }
        }
    }

    private void validateProfileTypeOrTarget(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference")) {
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                String t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), code.equals(t), "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE, "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path);
                }
            }
        } else {
            if (sd == null) {
                sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
            }
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                String t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), code.equals(t), "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), this.isInstanceOf(t, code), "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path);
                }
            }
        }
    }

    private String getTypeCodeFromSD(StructureDefinition sd, String path) {
        ElementDefinition ed = null;
        for (ElementDefinition t : sd.getSnapshot().getElement()) {
            if (!t.hasPath() || !t.getPath().equals(path)) continue;
            if (ed == null) {
                ed = t;
                continue;
            }
            return null;
        }
        return ed != null && ed.getType().size() == 1 ? ed.getTypeFirstRep().getCode() : null;
    }

    private void validateTypeProfile(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (sd == null) {
            sd = this.getXverExt(errors, stack.getLiteralPath(), profile, p);
        }
        if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
            String t = this.determineBaseType(sd);
            if (t == null) {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), code.equals(t), "SD_ED_TYPE_PROFILE_NOTYPE", p);
            } else {
                this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), this.isInstanceOf(t, code), "SD_ED_TYPE_PROFILE_WRONG", p, t, code, path);
            }
        }
    }

    private void validateTargetProfile(List<ValidationMessage> errors, Element profile, String code, NodeStack stack, String path) {
        String p = profile.primitiveValue();
        StructureDefinition sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, p);
        if (code.equals("Reference")) {
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                String t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), code.equals(t), "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd.getKind() == StructureDefinition.StructureDefinitionKind.RESOURCE, "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Resource");
                }
            }
        } else if (code.equals("canonical")) {
            if (this.warning(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), sd != null, "SD_ED_TYPE_PROFILE_UNKNOWN", p)) {
                String t = this.determineBaseType(sd);
                if (t == null) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), code.equals(t), "SD_ED_TYPE_PROFILE_NOTYPE", p);
                } else if (!VersionUtilities.isR5Ver((String)this.context.getVersion())) {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t) || "Resource".equals(t), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource");
                } else {
                    this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), VersionUtilities.getCanonicalResourceNames((String)this.context.getVersion()).contains(t), "SD_ED_TYPE_PROFILE_WRONG_TARGET", p, t, code, path, "Canonical Resource");
                }
            }
        } else {
            this.rule(errors, ValidationMessage.IssueType.EXCEPTION, stack.getLiteralPath(), false, "SD_ED_TYPE_NO_TARGET_PROFILE", code);
        }
    }

    private boolean isInstanceOf(String t, String code) {
        StructureDefinition sd = this.context.fetchTypeDefinition(t);
        while (sd != null) {
            if (sd.getType().equals(code)) {
                return true;
            }
            if ((sd = sd.hasBaseDefinition() ? (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition()) : null) == null || sd.getAbstract()) continue;
            sd = null;
        }
        return false;
    }

    private String determineBaseType(StructureDefinition sd) {
        while (sd != null && !sd.hasType() && sd.getDerivation() == StructureDefinition.TypeDerivationRule.CONSTRAINT) {
            sd = (StructureDefinition)this.context.fetchResource(StructureDefinition.class, sd.getBaseDefinition());
        }
        return sd == null ? null : sd.getType();
    }

    private boolean hasMustSupportExtension(Element type) {
        if ("true".equals(this.getExtensionValue(type, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) {
            return true;
        }
        List profiles = type.getChildrenByName("profile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        profiles = type.getChildrenByName("targetProfile");
        for (Element profile : profiles) {
            if (!"true".equals(this.getExtensionValue(profile, "http://hl7.org/fhir/StructureDefinition/elementdefinition-type-must-support"))) continue;
            return true;
        }
        return false;
    }

    private String getExtensionValue(Element element, String url) {
        List extensions = element.getChildrenByName("extension");
        for (Element extension : extensions) {
            if (!url.equals(extension.getNamedChildValue("url"))) continue;
            return extension.getNamedChildValue("value");
        }
        return null;
    }

    private StructureDefinition loadAsSD(Element src) throws FHIRException, IOException {
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        Manager.compose((IWorkerContext)this.context, (Element)src, (OutputStream)bs, (Manager.FhirFormat)Manager.FhirFormat.JSON, (IParser.OutputStyle)IParser.OutputStyle.NORMAL, null);
        if (VersionUtilities.isR2Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2.model.Resource r2 = new org.hl7.fhir.dstu2.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_10_50.convertResource((org.hl7.fhir.dstu2.model.Resource)r2);
        }
        if (VersionUtilities.isR2BVer((String)this.context.getVersion())) {
            org.hl7.fhir.dstu2016may.model.Resource r2b = new org.hl7.fhir.dstu2016may.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_14_50.convertResource((org.hl7.fhir.dstu2016may.model.Resource)r2b);
        }
        if (VersionUtilities.isR3Ver((String)this.context.getVersion())) {
            org.hl7.fhir.dstu3.model.Resource r3 = new org.hl7.fhir.dstu3.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_30_50.convertResource((org.hl7.fhir.dstu3.model.Resource)r3, (boolean)false);
        }
        if (VersionUtilities.isR4Ver((String)this.context.getVersion())) {
            org.hl7.fhir.r4.model.Resource r4 = new org.hl7.fhir.r4.formats.JsonParser().parse(bs.toByteArray());
            return (StructureDefinition)VersionConvertor_40_50.convertResource((org.hl7.fhir.r4.model.Resource)r4);
        }
        return (StructureDefinition)new JsonParser().parse(bs.toByteArray());
    }

    public class FhirPathSorter
    implements Comparator<ExpressionNode> {
        @Override
        public int compare(ExpressionNode arg0, ExpressionNode arg1) {
            return arg0.toString().compareTo(arg1.toString());
        }
    }
}

