/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r5.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hl7.fhir.r5.model.CodeSystem;
import org.hl7.fhir.r5.validation.BaseValidator;
import org.hl7.fhir.utilities.validation.ValidationMessage;

public class CodeSystemValidator
extends BaseValidator {
    public List<ValidationMessage> validate(CodeSystem cs, boolean forBuild) {
        ArrayList<ValidationMessage> errors = new ArrayList<ValidationMessage>();
        this.checkCodesUnique(cs, errors);
        return errors;
    }

    private void checkCodesUnique(CodeSystem cs, List<ValidationMessage> errors) {
        HashSet<String> codes = new HashSet<String>();
        this.checkCodes(codes, cs.getConcept(), "CodeSystem.where(id = '" + cs.getId() + "')", errors);
    }

    private void checkCodes(Set<String> codes, List<CodeSystem.ConceptDefinitionComponent> list, String path, List<ValidationMessage> errors) {
        for (CodeSystem.ConceptDefinitionComponent cc : list) {
            String npath = path + ".concept.descendents().where(code = '" + cc.getCode() + "')";
            this.rule(errors, ValidationMessage.IssueType.BUSINESSRULE, npath, !codes.contains(cc.getCode()), "Duplicate Code " + cc.getCode());
            codes.add(cc.getCode());
            this.checkCodes(codes, cc.getConcept(), npath, errors);
        }
    }
}

