/*
 * Decompiled with CFR 0.152.
 */
package org.hl7.fhir.r4.validation;

import ca.uhn.fhir.rest.server.exceptions.UnprocessableEntityException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hl7.fhir.exceptions.FHIRException;
import org.hl7.fhir.r4.elementmodel.Element;
import org.hl7.fhir.r4.model.Base;
import org.hl7.fhir.r4.model.BooleanType;
import org.hl7.fhir.r4.model.Coding;
import org.hl7.fhir.r4.model.Factory;
import org.hl7.fhir.r4.model.PrimitiveType;
import org.hl7.fhir.r4.model.Quantity;
import org.hl7.fhir.r4.model.Questionnaire;
import org.hl7.fhir.r4.model.Type;
import org.hl7.fhir.r4.validation.EnableWhenResult;
import org.hl7.fhir.r4.validation.IEnableWhenEvaluator;

public class DefaultEnableWhenEvaluator
implements IEnableWhenEvaluator {
    public static final String LINKID_ELEMENT = "linkId";
    public static final String ITEM_ELEMENT = "item";
    public static final String ANSWER_ELEMENT = "answer";

    @Override
    public boolean isQuestionEnabled(Questionnaire.QuestionnaireItemComponent questionnaireItem, Element questionnaireResponse) {
        if (!questionnaireItem.hasEnableWhen()) {
            return true;
        }
        List<EnableWhenResult> evaluationResults = questionnaireItem.getEnableWhen().stream().map(enableCondition -> this.evaluateCondition((Questionnaire.QuestionnaireItemEnableWhenComponent)enableCondition, questionnaireResponse, questionnaireItem.getLinkId())).collect(Collectors.toList());
        return this.checkConditionResults(evaluationResults, questionnaireItem);
    }

    public boolean checkConditionResults(List<EnableWhenResult> evaluationResults, Questionnaire.QuestionnaireItemComponent questionnaireItem) {
        if (questionnaireItem.hasEnableBehavior() && questionnaireItem.getEnableBehavior() == Questionnaire.EnableWhenBehavior.ANY) {
            return evaluationResults.stream().anyMatch(EnableWhenResult::isEnabled);
        }
        if (questionnaireItem.hasEnableBehavior() && questionnaireItem.getEnableBehavior() == Questionnaire.EnableWhenBehavior.ALL) {
            return evaluationResults.stream().allMatch(EnableWhenResult::isEnabled);
        }
        return true;
    }

    protected EnableWhenResult evaluateCondition(Questionnaire.QuestionnaireItemEnableWhenComponent enableCondition, Element questionnaireResponse, String linkId) {
        List<Element> answerItems = this.findQuestionAnswers(questionnaireResponse, enableCondition.getQuestion());
        Questionnaire.QuestionnaireItemOperator operator = enableCondition.getOperator();
        if (operator == Questionnaire.QuestionnaireItemOperator.EXISTS) {
            Type answer2 = enableCondition.getAnswer();
            if (!(answer2 instanceof BooleanType)) {
                throw new UnprocessableEntityException("Exists-operator requires answerBoolean");
            }
            return new EnableWhenResult(((BooleanType)answer2).booleanValue() != answerItems.isEmpty(), linkId, enableCondition, questionnaireResponse);
        }
        boolean result = answerItems.stream().anyMatch(answer -> this.evaluateAnswer((Element)answer, enableCondition.getAnswer(), enableCondition.getOperator()));
        return new EnableWhenResult(result, linkId, enableCondition, questionnaireResponse);
    }

    private Type convertToType(Element element) throws FHIRException {
        if (element.fhirType().equals("BackboneElement")) {
            return null;
        }
        Type b = new Factory().create(element.fhirType());
        if (b instanceof PrimitiveType) {
            ((PrimitiveType)b).setValueAsString(element.primitiveValue());
        } else {
            for (Element child : element.getChildren()) {
                if (this.isExtension(child)) continue;
                b.setProperty(child.getName(), (Base)this.convertToType(child));
            }
        }
        return b;
    }

    private boolean isExtension(Element element) {
        return "Extension".equals(element.fhirType());
    }

    protected boolean evaluateAnswer(Element answer, Type expectedAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        Type actualAnswer;
        if (this.isExtension(answer)) {
            return false;
        }
        try {
            actualAnswer = this.convertToType(answer);
            if (actualAnswer == null) {
                return false;
            }
        }
        catch (FHIRException e) {
            throw new UnprocessableEntityException("Unexpected answer type", (Throwable)e);
        }
        if (!actualAnswer.getClass().equals(expectedAnswer.getClass())) {
            throw new UnprocessableEntityException("Expected answer and actual answer have incompatible types");
        }
        if (expectedAnswer instanceof Coding) {
            return this.compareCodingAnswer((Coding)expectedAnswer, (Coding)actualAnswer, questionnaireItemOperator);
        }
        if (expectedAnswer instanceof PrimitiveType) {
            return this.comparePrimitiveAnswer((PrimitiveType)actualAnswer, (PrimitiveType)expectedAnswer, questionnaireItemOperator);
        }
        if (expectedAnswer instanceof Quantity) {
            return this.compareQuantityAnswer((Quantity)actualAnswer, (Quantity)expectedAnswer, questionnaireItemOperator);
        }
        throw new UnprocessableEntityException("Unimplemented answer type: " + expectedAnswer.getClass());
    }

    private boolean compareQuantityAnswer(Quantity actualAnswer, Quantity expectedAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        return this.compareComparable(actualAnswer.getValue(), expectedAnswer.getValue(), questionnaireItemOperator);
    }

    private boolean comparePrimitiveAnswer(PrimitiveType<?> actualAnswer, PrimitiveType<?> expectedAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        if (actualAnswer.getValue() instanceof Comparable) {
            return this.compareComparable((Comparable)actualAnswer.getValue(), (Comparable)expectedAnswer.getValue(), questionnaireItemOperator);
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.EQUAL) {
            return actualAnswer.equalsShallow(expectedAnswer);
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.NOT_EQUAL) {
            return !actualAnswer.equalsShallow(expectedAnswer);
        }
        throw new UnprocessableEntityException("Bad operator for PrimitiveType comparison");
    }

    private boolean compareComparable(Comparable actual, Comparable expected, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        int result = actual.compareTo(expected);
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.EQUAL) {
            return result == 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.NOT_EQUAL) {
            return result != 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.GREATER_OR_EQUAL) {
            return result >= 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.LESS_OR_EQUAL) {
            return result <= 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.LESS_THAN) {
            return result < 0;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.GREATER_THAN) {
            return result > 0;
        }
        throw new UnprocessableEntityException("Bad operator for PrimitiveType comparison");
    }

    private List<Element> findQuestionAnswers(Element questionnaireResponse, String question) {
        ArrayList<Element> retVal = new ArrayList<Element>();
        List items = questionnaireResponse.getChildren(ITEM_ELEMENT);
        for (Element next : items) {
            if (this.hasLinkId(next, question)) {
                List<Element> answers = this.extractAnswer(next);
                retVal.addAll(answers);
            }
            retVal.addAll(this.findQuestionAnswers(next, question));
        }
        return retVal;
    }

    private List<Element> extractAnswer(Element item) {
        return item.getChildrenByName(ANSWER_ELEMENT).stream().flatMap(c -> c.getChildren().stream()).collect(Collectors.toList());
    }

    private boolean compareCodingAnswer(Coding expectedAnswer, Coding actualAnswer, Questionnaire.QuestionnaireItemOperator questionnaireItemOperator) {
        boolean result;
        boolean bl = result = this.compareSystems(expectedAnswer, actualAnswer) && this.compareCodes(expectedAnswer, actualAnswer);
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.EQUAL) {
            return result;
        }
        if (questionnaireItemOperator == Questionnaire.QuestionnaireItemOperator.NOT_EQUAL) {
            return !result;
        }
        throw new UnprocessableEntityException("Bad operator for Coding comparison");
    }

    private boolean compareCodes(Coding expectedCoding, Coding value) {
        if (expectedCoding.hasCode() != value.hasCode()) {
            return false;
        }
        if (expectedCoding.hasCode()) {
            return expectedCoding.getCode().equals(value.getCode());
        }
        return true;
    }

    private boolean compareSystems(Coding expectedCoding, Coding value) {
        if (expectedCoding.hasSystem() && !value.hasSystem()) {
            return false;
        }
        if (expectedCoding.hasSystem()) {
            return expectedCoding.getSystem().equals(value.getSystem());
        }
        return true;
    }

    private boolean hasLinkId(Element item, String linkId) {
        Element linkIdChild = item.getNamedChild(LINKID_ELEMENT);
        return linkIdChild != null && linkIdChild.getValue().equals(linkId);
    }
}

